#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGE_H
#define BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGE_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <vector>

/**
 * todo
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace masteraudioservice {
namespace AudioSourceChange {

// method IDs
static const uint16 ID_activateSource = 0;
static const uint16 ID_deactivateSource = 1;
static const uint16 ID_getSourceList = 2;

// signal IDs
static const uint16 ID_sourceActivated = 3;
static const uint16 ID_sourceListChanged = 4;
static const uint16 ID_sourceAvailabilityChanged = 5;

// property IDs
static const uint16 ID_activeSource = 6;
static const uint16 ID_activeSourceList = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class sourceData;

class sourceDetails;

class ActivateSourceRequest;

class DeactivateSourceRequest;

class GetSourceListRequest;

class GetSourceListResponse;

class ActiveSourceUpdate;

class ActiveSourceRegister;

class ActiveSourceListUpdate;

class ActiveSourceListRegister;

class SourceActivatedSignal;

class SourceListChangedSignal;

class SourceAvailabilityChangedSignal;

// type definitions
/**
 * Method for Source change request
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ActivateSourceResponse;

/**
 * If the meaning of "ActivateSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateSourceError;

/**
 * Method for Source change deactivation
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DeactivateSourceResponse;

/**
 * If the meaning of "DeactivateSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeactivateSourceError;

/**
 * If the meaning of "GetSourceListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetSourceListError;

/**
 * Property to state the current active source
 */
typedef ActiveSourceUpdate ActiveSourceSet;

/**
 * Property to state the current active source
 */
typedef ActiveSourceUpdate ActiveSourceGet;

/**
 * If the meaning of "ActiveSourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveSourceError;

/**
 * Property to state the current active sources
 */
typedef ActiveSourceListUpdate ActiveSourceListSet;

/**
 * Property to state the current active sources
 */
typedef ActiveSourceListUpdate ActiveSourceListGet;

/**
 * If the meaning of "ActiveSourceListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveSourceListError;

/**
 * If the meaning of "SourceActivatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceActivatedError;

/**
 * If the meaning of "SourceListChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceListChangedError;

/**
 * If the meaning of "SourceAvailabilityChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceAvailabilityChangedError;


/**
 * todo
 */
class sourceData {
public:

    /**
     * Default constructor
     */
    inline  sourceData ();

    /**
     * Copy constructor
     */
    inline  sourceData (const sourceData &rhs);

    /**
     * All fields constructor
     */
    inline  sourceData (int32 srcId_, int32 subSrcId_, uint16 sinkId_, uint32 connectionState_);

    /**
     * Destructor
     */
    inline  ~sourceData();

    /**
     * Assignment operator
     */
    inline sourceData& operator = (const sourceData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const sourceData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const sourceData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const sourceData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const sourceData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "srcId"

    static const int kSrcId = 0;

    /**
     * Clears the field "srcId".
     *
     * The field will be set to its default value. The hasSrcId()
     * method will return false.
     */
    inline void clearSrcId();

    /**
     * Checks whether the field "srcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcId()). Otherwise it will return false.
     */
    inline bool hasSrcId () const;

    /**
     * Returns the value of the member "srcId".
     *
     * If the meaning of "srcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "srcId"
     */
    inline int32 getSrcId () const;

    /**
     * Sets the value of the member "srcId".
     *
     * If the meaning of "srcId" isn't clear, then there should be a description here.
     *
     * @param srcId The value which will be set
     */
    inline void setSrcId (int32 srcId_);

    // API of field "subSrcId"

    static const int kSubSrcId = 1;

    /**
     * Clears the field "subSrcId".
     *
     * The field will be set to its default value. The hasSubSrcId()
     * method will return false.
     */
    inline void clearSubSrcId();

    /**
     * Checks whether the field "subSrcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubSrcId()). Otherwise it will return false.
     */
    inline bool hasSubSrcId () const;

    /**
     * Returns the value of the member "subSrcId".
     *
     * If the meaning of "subSrcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subSrcId"
     */
    inline int32 getSubSrcId () const;

    /**
     * Sets the value of the member "subSrcId".
     *
     * If the meaning of "subSrcId" isn't clear, then there should be a description here.
     *
     * @param subSrcId The value which will be set
     */
    inline void setSubSrcId (int32 subSrcId_);

    // API of field "sinkId"

    static const int kSinkId = 2;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    // API of field "connectionState"

    static const int kConnectionState = 3;

    /**
     * Clears the field "connectionState".
     *
     * The field will be set to its default value. The hasConnectionState()
     * method will return false.
     */
    inline void clearConnectionState();

    /**
     * Checks whether the field "connectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionState()). Otherwise it will return false.
     */
    inline bool hasConnectionState () const;

    /**
     * Returns the value of the member "connectionState".
     *
     * If the meaning of "connectionState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "connectionState"
     */
    inline uint32 getConnectionState () const;

    /**
     * Sets the value of the member "connectionState".
     *
     * If the meaning of "connectionState" isn't clear, then there should be a description here.
     *
     * @param connectionState The value which will be set
     */
    inline void setConnectionState (uint32 connectionState_);

    static const sourceData &getDefaultInstance();

private:

    inline void set_has_srcId ();

    inline void clear_has_srcId ();

    inline void set_has_subSrcId ();

    inline void clear_has_subSrcId ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    inline void set_has_connectionState ();

    inline void clear_has_connectionState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _srcId;

    int32 _subSrcId;

    uint16 _sinkId;

    uint32 _connectionState;

};

/**
 * todo
 */
class sourceDetails {
public:

    /**
     * Default constructor
     */
    inline  sourceDetails ();

    /**
     * Copy constructor
     */
    inline  sourceDetails (const sourceDetails &rhs);

    /**
     * All fields constructor
     */
    inline  sourceDetails (int32 srcId_, int32 subSrcId_, int32 availability_, int32 availabilityReason_);

    /**
     * Destructor
     */
    inline  ~sourceDetails();

    /**
     * Assignment operator
     */
    inline sourceDetails& operator = (const sourceDetails& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const sourceDetails& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const sourceDetails& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const sourceDetails& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const sourceDetails& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "srcId"

    static const int kSrcId = 0;

    /**
     * Clears the field "srcId".
     *
     * The field will be set to its default value. The hasSrcId()
     * method will return false.
     */
    inline void clearSrcId();

    /**
     * Checks whether the field "srcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcId()). Otherwise it will return false.
     */
    inline bool hasSrcId () const;

    /**
     * Returns the value of the member "srcId".
     *
     * If the meaning of "srcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "srcId"
     */
    inline int32 getSrcId () const;

    /**
     * Sets the value of the member "srcId".
     *
     * If the meaning of "srcId" isn't clear, then there should be a description here.
     *
     * @param srcId The value which will be set
     */
    inline void setSrcId (int32 srcId_);

    // API of field "subSrcId"

    static const int kSubSrcId = 1;

    /**
     * Clears the field "subSrcId".
     *
     * The field will be set to its default value. The hasSubSrcId()
     * method will return false.
     */
    inline void clearSubSrcId();

    /**
     * Checks whether the field "subSrcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubSrcId()). Otherwise it will return false.
     */
    inline bool hasSubSrcId () const;

    /**
     * Returns the value of the member "subSrcId".
     *
     * If the meaning of "subSrcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "subSrcId"
     */
    inline int32 getSubSrcId () const;

    /**
     * Sets the value of the member "subSrcId".
     *
     * If the meaning of "subSrcId" isn't clear, then there should be a description here.
     *
     * @param subSrcId The value which will be set
     */
    inline void setSubSrcId (int32 subSrcId_);

    // API of field "availability"

    static const int kAvailability = 2;

    /**
     * Clears the field "availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availability"
     */
    inline int32 getAvailability () const;

    /**
     * Sets the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @param availability The value which will be set
     */
    inline void setAvailability (int32 availability_);

    // API of field "availabilityReason"

    static const int kAvailabilityReason = 3;

    /**
     * Clears the field "availabilityReason".
     *
     * The field will be set to its default value. The hasAvailabilityReason()
     * method will return false.
     */
    inline void clearAvailabilityReason();

    /**
     * Checks whether the field "availabilityReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailabilityReason()). Otherwise it will return false.
     */
    inline bool hasAvailabilityReason () const;

    /**
     * Returns the value of the member "availabilityReason".
     *
     * If the meaning of "availabilityReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availabilityReason"
     */
    inline int32 getAvailabilityReason () const;

    /**
     * Sets the value of the member "availabilityReason".
     *
     * If the meaning of "availabilityReason" isn't clear, then there should be a description here.
     *
     * @param availabilityReason The value which will be set
     */
    inline void setAvailabilityReason (int32 availabilityReason_);

    static const sourceDetails &getDefaultInstance();

private:

    inline void set_has_srcId ();

    inline void clear_has_srcId ();

    inline void set_has_subSrcId ();

    inline void clear_has_subSrcId ();

    inline void set_has_availability ();

    inline void clear_has_availability ();

    inline void set_has_availabilityReason ();

    inline void clear_has_availabilityReason ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _srcId;

    int32 _subSrcId;

    int32 _availability;

    int32 _availabilityReason;

};

/**
 * Method for Source change request
 */
class ActivateSourceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateSourceRequest ();

    /**
     * Copy constructor
     */
    inline  ActivateSourceRequest (const ActivateSourceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateSourceRequest (const sourceData& sourceInfo_, bool forceViewChange_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateSourceRequest();

    /**
     * Assignment operator
     */
    inline ActivateSourceRequest& operator = (const ActivateSourceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateSourceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateSourceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateSourceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateSourceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceInfo"

    static const int kSourceInfo = 0;

    /**
     * Clears the field "sourceInfo".
     *
     * The field will be set to its default value. The hasSourceInfo()
     * method will return false.
     */
    inline void clearSourceInfo();

    /**
     * Checks whether the field "sourceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceInfo()). Otherwise it will return false.
     */
    inline bool hasSourceInfo () const;

    /**
     * Returns the value of the member "sourceInfo".
     *
     * If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceInfo"
     */
    inline const sourceData& getSourceInfo () const;

    /**
     * Retrieves the value of the field "sourceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourceInfo".
     */
    inline sourceData& getSourceInfoMutable ();

    /**
     * Sets the value of the member "sourceInfo".
     *
     * If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @param sourceInfo The value which will be set
     */
    inline void setSourceInfo (const sourceData& sourceInfo_);

    // API of field "forceViewChange"

    static const int kForceViewChange = 1;

    /**
     * Clears the field "forceViewChange".
     *
     * The field will be set to its default value. The hasForceViewChange()
     * method will return false.
     */
    inline void clearForceViewChange();

    /**
     * Checks whether the field "forceViewChange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setForceViewChange()). Otherwise it will return false.
     */
    inline bool hasForceViewChange () const;

    /**
     * Returns the value of the member "forceViewChange".
     *
     * If the meaning of "forceViewChange" isn't clear, then there should be a description here.
     *
     * @return The value of the field "forceViewChange"
     */
    inline bool getForceViewChange () const;

    /**
     * Sets the value of the member "forceViewChange".
     *
     * If the meaning of "forceViewChange" isn't clear, then there should be a description here.
     *
     * @param forceViewChange The value which will be set
     */
    inline void setForceViewChange (bool forceViewChange_);

    static const ActivateSourceRequest &getDefaultInstance();

private:

    inline void set_has_sourceInfo ();

    inline void clear_has_sourceInfo ();

    inline void set_has_forceViewChange ();

    inline void clear_has_forceViewChange ();

    uint32 _has_bits_[ (2 + 31) / 32];

    sourceData _sourceInfo;

    bool _forceViewChange;

};

/**
 * Method for Source change deactivation
 */
class DeactivateSourceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeactivateSourceRequest ();

    /**
     * Copy constructor
     */
    inline  DeactivateSourceRequest (const DeactivateSourceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DeactivateSourceRequest (const sourceData& sourceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DeactivateSourceRequest();

    /**
     * Assignment operator
     */
    inline DeactivateSourceRequest& operator = (const DeactivateSourceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeactivateSourceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeactivateSourceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeactivateSourceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeactivateSourceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceInfo"

    static const int kSourceInfo = 0;

    /**
     * Clears the field "sourceInfo".
     *
     * The field will be set to its default value. The hasSourceInfo()
     * method will return false.
     */
    inline void clearSourceInfo();

    /**
     * Checks whether the field "sourceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceInfo()). Otherwise it will return false.
     */
    inline bool hasSourceInfo () const;

    /**
     * Returns the value of the member "sourceInfo".
     *
     * If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceInfo"
     */
    inline const sourceData& getSourceInfo () const;

    /**
     * Retrieves the value of the field "sourceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourceInfo".
     */
    inline sourceData& getSourceInfoMutable ();

    /**
     * Sets the value of the member "sourceInfo".
     *
     * If the meaning of "sourceInfo" isn't clear, then there should be a description here.
     *
     * @param sourceInfo The value which will be set
     */
    inline void setSourceInfo (const sourceData& sourceInfo_);

    static const DeactivateSourceRequest &getDefaultInstance();

private:

    inline void set_has_sourceInfo ();

    inline void clear_has_sourceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    sourceData _sourceInfo;

};

/**
 * Method to get the list of available sources for activation
 */
class GetSourceListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSourceListRequest ();

    /**
     * Copy constructor
     */
    inline  GetSourceListRequest (const GetSourceListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetSourceListRequest (int32 srcGroupId_);

    /**
     * Destructor
     */
    inline virtual  ~GetSourceListRequest();

    /**
     * Assignment operator
     */
    inline GetSourceListRequest& operator = (const GetSourceListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSourceListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSourceListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSourceListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSourceListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "srcGroupId"

    static const int kSrcGroupId = 0;

    /**
     * Clears the field "srcGroupId".
     *
     * The field will be set to its default value. The hasSrcGroupId()
     * method will return false.
     */
    inline void clearSrcGroupId();

    /**
     * Checks whether the field "srcGroupId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSrcGroupId()). Otherwise it will return false.
     */
    inline bool hasSrcGroupId () const;

    /**
     * Returns the value of the member "srcGroupId".
     *
     * If the meaning of "srcGroupId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "srcGroupId"
     */
    inline int32 getSrcGroupId () const;

    /**
     * Sets the value of the member "srcGroupId".
     *
     * If the meaning of "srcGroupId" isn't clear, then there should be a description here.
     *
     * @param srcGroupId The value which will be set
     */
    inline void setSrcGroupId (int32 srcGroupId_);

    static const GetSourceListRequest &getDefaultInstance();

private:

    inline void set_has_srcGroupId ();

    inline void clear_has_srcGroupId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _srcGroupId;

};

/**
 * Method to get the list of available sources for activation
 */
class GetSourceListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSourceListResponse ();

    /**
     * Copy constructor
     */
    inline  GetSourceListResponse (const GetSourceListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetSourceListResponse (const ::std::vector< sourceDetails >& sources_);

    /**
     * Destructor
     */
    inline virtual  ~GetSourceListResponse();

    /**
     * Assignment operator
     */
    inline GetSourceListResponse& operator = (const GetSourceListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSourceListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSourceListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSourceListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSourceListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sources"

    static const int kSources = 0;

    /**
     * Clears the field "sources".
     *
     * The field will be set to its default value. The hasSources()
     * method will return false.
     */
    inline void clearSources();

    /**
     * Checks whether the field "sources" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSources()). Otherwise it will return false.
     */
    inline bool hasSources () const;

    /**
     * Returns the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sources"
     */
    inline const ::std::vector< sourceDetails >& getSources () const;

    /**
     * Retrieves the value of the field "sources" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sources".
     */
    inline ::std::vector< sourceDetails >& getSourcesMutable ();

    /**
     * Sets the value of the member "sources".
     *
     * If the meaning of "sources" isn't clear, then there should be a description here.
     *
     * @param sources The value which will be set
     */
    inline void setSources (const ::std::vector< sourceDetails >& sources_);

    static const GetSourceListResponse &getDefaultInstance();

private:

    static const ::std::vector< sourceDetails >& getSourceDetailsList_DefaultInstance ();

    inline void set_has_sources ();

    inline void clear_has_sources ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< sourceDetails > _sources;

};

/**
 * Property to state the current active source
 */
class ActiveSourceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveSourceUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveSourceUpdate (const ActiveSourceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveSourceUpdate (const sourceData& activeSource_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveSourceUpdate();

    /**
     * Assignment operator
     */
    inline ActiveSourceUpdate& operator = (const ActiveSourceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveSourceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveSourceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveSourceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveSourceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeSource"

    static const int kActiveSource = 0;

    /**
     * Clears the field "activeSource".
     *
     * The field will be set to its default value. The hasActiveSource()
     * method will return false.
     */
    inline void clearActiveSource();

    /**
     * Checks whether the field "activeSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveSource()). Otherwise it will return false.
     */
    inline bool hasActiveSource () const;

    /**
     * Returns the value of the member "activeSource".
     *
     * Property to state the current active source
     *
     * @return The value of the field "activeSource"
     */
    inline const sourceData& getActiveSource () const;

    /**
     * Retrieves the value of the field "activeSource" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeSource".
     */
    inline sourceData& getActiveSourceMutable ();

    /**
     * Sets the value of the member "activeSource".
     *
     * Property to state the current active source
     *
     * @param activeSource The value which will be set
     */
    inline void setActiveSource (const sourceData& activeSource_);

    static const ActiveSourceUpdate &getDefaultInstance();

private:

    inline void set_has_activeSource ();

    inline void clear_has_activeSource ();

    uint32 _has_bits_[ (1 + 31) / 32];

    sourceData _activeSource;

};

/**
 * Property to state the current active source
 */
class ActiveSourceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveSourceRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveSourceRegister (const ActiveSourceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveSourceRegister();

    /**
     * Assignment operator
     */
    inline ActiveSourceRegister& operator = (const ActiveSourceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveSourceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveSourceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveSourceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveSourceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveSourceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the current active sources
 */
class ActiveSourceListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveSourceListUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveSourceListUpdate (const ActiveSourceListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveSourceListUpdate (const ::std::vector< sourceData >& activeSourceList_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveSourceListUpdate();

    /**
     * Assignment operator
     */
    inline ActiveSourceListUpdate& operator = (const ActiveSourceListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveSourceListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveSourceListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveSourceListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveSourceListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeSourceList"

    static const int kActiveSourceList = 0;

    /**
     * Clears the field "activeSourceList".
     *
     * The field will be set to its default value. The hasActiveSourceList()
     * method will return false.
     */
    inline void clearActiveSourceList();

    /**
     * Checks whether the field "activeSourceList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveSourceList()). Otherwise it will return false.
     */
    inline bool hasActiveSourceList () const;

    /**
     * Returns the value of the member "activeSourceList".
     *
     * Property to state the current active sources
     *
     * @return The value of the field "activeSourceList"
     */
    inline const ::std::vector< sourceData >& getActiveSourceList () const;

    /**
     * Retrieves the value of the field "activeSourceList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeSourceList".
     */
    inline ::std::vector< sourceData >& getActiveSourceListMutable ();

    /**
     * Sets the value of the member "activeSourceList".
     *
     * Property to state the current active sources
     *
     * @param activeSourceList The value which will be set
     */
    inline void setActiveSourceList (const ::std::vector< sourceData >& activeSourceList_);

    static const ActiveSourceListUpdate &getDefaultInstance();

private:

    static const ::std::vector< sourceData >& getSourceDataList_DefaultInstance ();

    inline void set_has_activeSourceList ();

    inline void clear_has_activeSourceList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< sourceData > _activeSourceList;

};

/**
 * Property to state the current active sources
 */
class ActiveSourceListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveSourceListRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveSourceListRegister (const ActiveSourceListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveSourceListRegister();

    /**
     * Assignment operator
     */
    inline ActiveSourceListRegister& operator = (const ActiveSourceListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveSourceListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveSourceListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveSourceListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveSourceListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveSourceListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Signal to indicate that there is a change in the Source List under a particular group
 */
class SourceActivatedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivatedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceActivatedSignal (const SourceActivatedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivatedSignal (int32 sourceId_, uint16 sinkId_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivatedSignal();

    /**
     * Assignment operator
     */
    inline SourceActivatedSignal& operator = (const SourceActivatedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivatedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivatedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivatedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivatedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceId"

    static const int kSourceId = 0;

    /**
     * Clears the field "sourceId".
     *
     * The field will be set to its default value. The hasSourceId()
     * method will return false.
     */
    inline void clearSourceId();

    /**
     * Checks whether the field "sourceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceId()). Otherwise it will return false.
     */
    inline bool hasSourceId () const;

    /**
     * Returns the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceId"
     */
    inline int32 getSourceId () const;

    /**
     * Sets the value of the member "sourceId".
     *
     * If the meaning of "sourceId" isn't clear, then there should be a description here.
     *
     * @param sourceId The value which will be set
     */
    inline void setSourceId (int32 sourceId_);

    // API of field "sinkId"

    static const int kSinkId = 1;

    /**
     * Clears the field "sinkId".
     *
     * The field will be set to its default value. The hasSinkId()
     * method will return false.
     */
    inline void clearSinkId();

    /**
     * Checks whether the field "sinkId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSinkId()). Otherwise it will return false.
     */
    inline bool hasSinkId () const;

    /**
     * Returns the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sinkId"
     */
    inline uint16 getSinkId () const;

    /**
     * Sets the value of the member "sinkId".
     *
     * If the meaning of "sinkId" isn't clear, then there should be a description here.
     *
     * @param sinkId The value which will be set
     */
    inline void setSinkId (uint16 sinkId_);

    static const SourceActivatedSignal &getDefaultInstance();

private:

    inline void set_has_sourceId ();

    inline void clear_has_sourceId ();

    inline void set_has_sinkId ();

    inline void clear_has_sinkId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _sourceId;

    uint16 _sinkId;

};

/**
 * Signal to indicate that there is a change in the Source List under a particular group
 */
class SourceListChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceListChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceListChangedSignal (const SourceListChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceListChangedSignal (int32 groupId_);

    /**
     * Destructor
     */
    inline virtual  ~SourceListChangedSignal();

    /**
     * Assignment operator
     */
    inline SourceListChangedSignal& operator = (const SourceListChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceListChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceListChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceListChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceListChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "groupId"

    static const int kGroupId = 0;

    /**
     * Clears the field "groupId".
     *
     * The field will be set to its default value. The hasGroupId()
     * method will return false.
     */
    inline void clearGroupId();

    /**
     * Checks whether the field "groupId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroupId()). Otherwise it will return false.
     */
    inline bool hasGroupId () const;

    /**
     * Returns the value of the member "groupId".
     *
     * If the meaning of "groupId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "groupId"
     */
    inline int32 getGroupId () const;

    /**
     * Sets the value of the member "groupId".
     *
     * If the meaning of "groupId" isn't clear, then there should be a description here.
     *
     * @param groupId The value which will be set
     */
    inline void setGroupId (int32 groupId_);

    static const SourceListChangedSignal &getDefaultInstance();

private:

    inline void set_has_groupId ();

    inline void clear_has_groupId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _groupId;

};

/**
 * Signal to indicate that there is a change in the Source Availability for a particular source
 */
class SourceAvailabilityChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailabilityChangedSignal ();

    /**
     * Copy constructor
     */
    inline  SourceAvailabilityChangedSignal (const SourceAvailabilityChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailabilityChangedSignal (const sourceDetails& sourceAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailabilityChangedSignal();

    /**
     * Assignment operator
     */
    inline SourceAvailabilityChangedSignal& operator = (const SourceAvailabilityChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailabilityChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceAvailability"

    static const int kSourceAvailability = 0;

    /**
     * Clears the field "sourceAvailability".
     *
     * The field will be set to its default value. The hasSourceAvailability()
     * method will return false.
     */
    inline void clearSourceAvailability();

    /**
     * Checks whether the field "sourceAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceAvailability()). Otherwise it will return false.
     */
    inline bool hasSourceAvailability () const;

    /**
     * Returns the value of the member "sourceAvailability".
     *
     * If the meaning of "sourceAvailability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceAvailability"
     */
    inline const sourceDetails& getSourceAvailability () const;

    /**
     * Retrieves the value of the field "sourceAvailability" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourceAvailability".
     */
    inline sourceDetails& getSourceAvailabilityMutable ();

    /**
     * Sets the value of the member "sourceAvailability".
     *
     * If the meaning of "sourceAvailability" isn't clear, then there should be a description here.
     *
     * @param sourceAvailability The value which will be set
     */
    inline void setSourceAvailability (const sourceDetails& sourceAvailability_);

    static const SourceAvailabilityChangedSignal &getDefaultInstance();

private:

    inline void set_has_sourceAvailability ();

    inline void clear_has_sourceAvailability ();

    uint32 _has_bits_[ (1 + 31) / 32];

    sourceDetails _sourceAvailability;

};

inline  sourceData::sourceData ()  :
    _srcId (0),
    _subSrcId (0),
    _sinkId (0u),
    _connectionState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  sourceData::sourceData (const sourceData &rhs)  :
    _srcId (0),
    _subSrcId (0),
    _sinkId (0u),
    _connectionState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  sourceData::sourceData (int32 srcId_, int32 subSrcId_, uint16 sinkId_, uint32 connectionState_)  :
    _srcId (srcId_),
    _subSrcId (subSrcId_),
    _sinkId (sinkId_),
    _connectionState (connectionState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  sourceData::~sourceData() {
}

inline sourceData& sourceData::operator = (const sourceData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSrcId()) {
            setSrcId(rhs.getSrcId());
        } else {
            clearSrcId();
        }
        if (rhs.hasSubSrcId()) {
            setSubSrcId(rhs.getSubSrcId());
        } else {
            clearSubSrcId();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
        if (rhs.hasConnectionState()) {
            setConnectionState(rhs.getConnectionState());
        } else {
            clearConnectionState();
        }
    }
    return *this;
}

inline bool sourceData::operator == (const sourceData& rhs) const {
    return (((!hasSrcId() && !rhs.hasSrcId()) || getSrcId() == rhs.getSrcId()) &&
        ((!hasSubSrcId() && !rhs.hasSubSrcId()) || getSubSrcId() == rhs.getSubSrcId()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()) &&
        ((!hasConnectionState() && !rhs.hasConnectionState()) || getConnectionState() == rhs.getConnectionState()));
}

inline bool sourceData::operator != (const sourceData& rhs) const {
    return ! (*this == rhs);
}

inline bool sourceData::operator < (const sourceData& rhs) const {
    if (hasSrcId() || rhs.hasSrcId()) {
        if (getSrcId() < rhs.getSrcId()) return true;
        if (getSrcId() > rhs.getSrcId()) return false;
    }
    if (hasSubSrcId() || rhs.hasSubSrcId()) {
        if (getSubSrcId() < rhs.getSubSrcId()) return true;
        if (getSubSrcId() > rhs.getSubSrcId()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    if (hasConnectionState() || rhs.hasConnectionState()) {
        if (getConnectionState() < rhs.getConnectionState()) return true;
        if (getConnectionState() > rhs.getConnectionState()) return false;
    }
    return false;
}

inline bool sourceData::operator > (const sourceData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void sourceData::clear() {
    clearSrcId();
    clearSubSrcId();
    clearSinkId();
    clearConnectionState();
}

inline void sourceData::clearSrcId() {
    if (hasSrcId()) {
         clear_has_srcId();
        _srcId = 0;
     }
}

inline bool sourceData::hasSrcId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 sourceData::getSrcId () const {
    return _srcId;
}

inline void sourceData::setSrcId (int32 srcId_) {
    set_has_srcId();
    this->_srcId = srcId_;
}

inline void sourceData::clearSubSrcId() {
    if (hasSubSrcId()) {
         clear_has_subSrcId();
        _subSrcId = 0;
     }
}

inline bool sourceData::hasSubSrcId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 sourceData::getSubSrcId () const {
    return _subSrcId;
}

inline void sourceData::setSubSrcId (int32 subSrcId_) {
    set_has_subSrcId();
    this->_subSrcId = subSrcId_;
}

inline void sourceData::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool sourceData::hasSinkId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 sourceData::getSinkId () const {
    return _sinkId;
}

inline void sourceData::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void sourceData::clearConnectionState() {
    if (hasConnectionState()) {
         clear_has_connectionState();
        _connectionState = 0u;
     }
}

inline bool sourceData::hasConnectionState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 sourceData::getConnectionState () const {
    return _connectionState;
}

inline void sourceData::setConnectionState (uint32 connectionState_) {
    set_has_connectionState();
    this->_connectionState = connectionState_;
}

inline void sourceData::set_has_srcId () {
    _has_bits_[0] |= 1u << 0;
}

inline void sourceData::clear_has_srcId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void sourceData::set_has_subSrcId () {
    _has_bits_[0] |= 1u << 1;
}

inline void sourceData::clear_has_subSrcId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void sourceData::set_has_sinkId () {
    _has_bits_[0] |= 1u << 2;
}

inline void sourceData::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void sourceData::set_has_connectionState () {
    _has_bits_[0] |= 1u << 3;
}

inline void sourceData::clear_has_connectionState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  sourceDetails::sourceDetails ()  :
    _srcId (0),
    _subSrcId (0),
    _availability (0),
    _availabilityReason (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  sourceDetails::sourceDetails (const sourceDetails &rhs)  :
    _srcId (0),
    _subSrcId (0),
    _availability (0),
    _availabilityReason (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  sourceDetails::sourceDetails (int32 srcId_, int32 subSrcId_, int32 availability_, int32 availabilityReason_)  :
    _srcId (srcId_),
    _subSrcId (subSrcId_),
    _availability (availability_),
    _availabilityReason (availabilityReason_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  sourceDetails::~sourceDetails() {
}

inline sourceDetails& sourceDetails::operator = (const sourceDetails& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSrcId()) {
            setSrcId(rhs.getSrcId());
        } else {
            clearSrcId();
        }
        if (rhs.hasSubSrcId()) {
            setSubSrcId(rhs.getSubSrcId());
        } else {
            clearSubSrcId();
        }
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
        if (rhs.hasAvailabilityReason()) {
            setAvailabilityReason(rhs.getAvailabilityReason());
        } else {
            clearAvailabilityReason();
        }
    }
    return *this;
}

inline bool sourceDetails::operator == (const sourceDetails& rhs) const {
    return (((!hasSrcId() && !rhs.hasSrcId()) || getSrcId() == rhs.getSrcId()) &&
        ((!hasSubSrcId() && !rhs.hasSubSrcId()) || getSubSrcId() == rhs.getSubSrcId()) &&
        ((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()) &&
        ((!hasAvailabilityReason() && !rhs.hasAvailabilityReason()) || getAvailabilityReason() == rhs.getAvailabilityReason()));
}

inline bool sourceDetails::operator != (const sourceDetails& rhs) const {
    return ! (*this == rhs);
}

inline bool sourceDetails::operator < (const sourceDetails& rhs) const {
    if (hasSrcId() || rhs.hasSrcId()) {
        if (getSrcId() < rhs.getSrcId()) return true;
        if (getSrcId() > rhs.getSrcId()) return false;
    }
    if (hasSubSrcId() || rhs.hasSubSrcId()) {
        if (getSubSrcId() < rhs.getSubSrcId()) return true;
        if (getSubSrcId() > rhs.getSubSrcId()) return false;
    }
    if (hasAvailability() || rhs.hasAvailability()) {
        if (getAvailability() < rhs.getAvailability()) return true;
        if (getAvailability() > rhs.getAvailability()) return false;
    }
    if (hasAvailabilityReason() || rhs.hasAvailabilityReason()) {
        if (getAvailabilityReason() < rhs.getAvailabilityReason()) return true;
        if (getAvailabilityReason() > rhs.getAvailabilityReason()) return false;
    }
    return false;
}

inline bool sourceDetails::operator > (const sourceDetails& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void sourceDetails::clear() {
    clearSrcId();
    clearSubSrcId();
    clearAvailability();
    clearAvailabilityReason();
}

inline void sourceDetails::clearSrcId() {
    if (hasSrcId()) {
         clear_has_srcId();
        _srcId = 0;
     }
}

inline bool sourceDetails::hasSrcId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 sourceDetails::getSrcId () const {
    return _srcId;
}

inline void sourceDetails::setSrcId (int32 srcId_) {
    set_has_srcId();
    this->_srcId = srcId_;
}

inline void sourceDetails::clearSubSrcId() {
    if (hasSubSrcId()) {
         clear_has_subSrcId();
        _subSrcId = 0;
     }
}

inline bool sourceDetails::hasSubSrcId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 sourceDetails::getSubSrcId () const {
    return _subSrcId;
}

inline void sourceDetails::setSubSrcId (int32 subSrcId_) {
    set_has_subSrcId();
    this->_subSrcId = subSrcId_;
}

inline void sourceDetails::clearAvailability() {
    if (hasAvailability()) {
         clear_has_availability();
        _availability = 0;
     }
}

inline bool sourceDetails::hasAvailability () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 sourceDetails::getAvailability () const {
    return _availability;
}

inline void sourceDetails::setAvailability (int32 availability_) {
    set_has_availability();
    this->_availability = availability_;
}

inline void sourceDetails::clearAvailabilityReason() {
    if (hasAvailabilityReason()) {
         clear_has_availabilityReason();
        _availabilityReason = 0;
     }
}

inline bool sourceDetails::hasAvailabilityReason () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 sourceDetails::getAvailabilityReason () const {
    return _availabilityReason;
}

inline void sourceDetails::setAvailabilityReason (int32 availabilityReason_) {
    set_has_availabilityReason();
    this->_availabilityReason = availabilityReason_;
}

inline void sourceDetails::set_has_srcId () {
    _has_bits_[0] |= 1u << 0;
}

inline void sourceDetails::clear_has_srcId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void sourceDetails::set_has_subSrcId () {
    _has_bits_[0] |= 1u << 1;
}

inline void sourceDetails::clear_has_subSrcId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void sourceDetails::set_has_availability () {
    _has_bits_[0] |= 1u << 2;
}

inline void sourceDetails::clear_has_availability () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void sourceDetails::set_has_availabilityReason () {
    _has_bits_[0] |= 1u << 3;
}

inline void sourceDetails::clear_has_availabilityReason () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ActivateSourceRequest::ActivateSourceRequest ()  :
    _sourceInfo (),
    _forceViewChange (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateSourceRequest::ActivateSourceRequest (const ActivateSourceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceInfo (),
    _forceViewChange (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateSourceRequest::ActivateSourceRequest (const sourceData& sourceInfo_, bool forceViewChange_)  :
    _sourceInfo (sourceInfo_),
    _forceViewChange (forceViewChange_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateSourceRequest::~ActivateSourceRequest() {
}

inline ActivateSourceRequest& ActivateSourceRequest::operator = (const ActivateSourceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceInfo()) {
            setSourceInfo(rhs.getSourceInfo());
        } else {
            clearSourceInfo();
        }
        if (rhs.hasForceViewChange()) {
            setForceViewChange(rhs.getForceViewChange());
        } else {
            clearForceViewChange();
        }
    }
    return *this;
}

inline bool ActivateSourceRequest::operator == (const ActivateSourceRequest& rhs) const {
    return (((!hasSourceInfo() && !rhs.hasSourceInfo()) || getSourceInfo() == rhs.getSourceInfo()) &&
        ((!hasForceViewChange() && !rhs.hasForceViewChange()) || getForceViewChange() == rhs.getForceViewChange()));
}

inline bool ActivateSourceRequest::operator != (const ActivateSourceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateSourceRequest::operator < (const ActivateSourceRequest& rhs) const {
    if (hasSourceInfo() || rhs.hasSourceInfo()) {
        if (getSourceInfo() < rhs.getSourceInfo()) return true;
        if (getSourceInfo() > rhs.getSourceInfo()) return false;
    }
    if (hasForceViewChange() || rhs.hasForceViewChange()) {
        if (getForceViewChange() < rhs.getForceViewChange()) return true;
        if (getForceViewChange() > rhs.getForceViewChange()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateSourceRequest::clone() {
    return new ActivateSourceRequest(*this);
}

inline bool ActivateSourceRequest::operator > (const ActivateSourceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateSourceRequest::clear() {
    clearSourceInfo();
    clearForceViewChange();
}

inline void ActivateSourceRequest::clearSourceInfo() {
    if (hasSourceInfo()) {
         clear_has_sourceInfo();
        _sourceInfo.clear();
     }
}

inline bool ActivateSourceRequest::hasSourceInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const sourceData& ActivateSourceRequest::getSourceInfo () const {
    return _sourceInfo;
}

inline sourceData& ActivateSourceRequest::getSourceInfoMutable () {
    set_has_sourceInfo();
    return _sourceInfo;
}

inline void ActivateSourceRequest::setSourceInfo (const sourceData& sourceInfo_) {
    set_has_sourceInfo();
    this->_sourceInfo = sourceInfo_;
}

inline void ActivateSourceRequest::clearForceViewChange() {
    if (hasForceViewChange()) {
         clear_has_forceViewChange();
        _forceViewChange = false;
     }
}

inline bool ActivateSourceRequest::hasForceViewChange () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool ActivateSourceRequest::getForceViewChange () const {
    return _forceViewChange;
}

inline void ActivateSourceRequest::setForceViewChange (bool forceViewChange_) {
    set_has_forceViewChange();
    this->_forceViewChange = forceViewChange_;
}

inline void ActivateSourceRequest::set_has_sourceInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateSourceRequest::clear_has_sourceInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ActivateSourceRequest::set_has_forceViewChange () {
    _has_bits_[0] |= 1u << 1;
}

inline void ActivateSourceRequest::clear_has_forceViewChange () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DeactivateSourceRequest::DeactivateSourceRequest ()  :
    _sourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeactivateSourceRequest::DeactivateSourceRequest (const DeactivateSourceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeactivateSourceRequest::DeactivateSourceRequest (const sourceData& sourceInfo_)  :
    _sourceInfo (sourceInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeactivateSourceRequest::~DeactivateSourceRequest() {
}

inline DeactivateSourceRequest& DeactivateSourceRequest::operator = (const DeactivateSourceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceInfo()) {
            setSourceInfo(rhs.getSourceInfo());
        } else {
            clearSourceInfo();
        }
    }
    return *this;
}

inline bool DeactivateSourceRequest::operator == (const DeactivateSourceRequest& rhs) const {
    return (((!hasSourceInfo() && !rhs.hasSourceInfo()) || getSourceInfo() == rhs.getSourceInfo()));
}

inline bool DeactivateSourceRequest::operator != (const DeactivateSourceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DeactivateSourceRequest::operator < (const DeactivateSourceRequest& rhs) const {
    if (hasSourceInfo() || rhs.hasSourceInfo()) {
        if (getSourceInfo() < rhs.getSourceInfo()) return true;
        if (getSourceInfo() > rhs.getSourceInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeactivateSourceRequest::clone() {
    return new DeactivateSourceRequest(*this);
}

inline bool DeactivateSourceRequest::operator > (const DeactivateSourceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeactivateSourceRequest::clear() {
    clearSourceInfo();
}

inline void DeactivateSourceRequest::clearSourceInfo() {
    if (hasSourceInfo()) {
         clear_has_sourceInfo();
        _sourceInfo.clear();
     }
}

inline bool DeactivateSourceRequest::hasSourceInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const sourceData& DeactivateSourceRequest::getSourceInfo () const {
    return _sourceInfo;
}

inline sourceData& DeactivateSourceRequest::getSourceInfoMutable () {
    set_has_sourceInfo();
    return _sourceInfo;
}

inline void DeactivateSourceRequest::setSourceInfo (const sourceData& sourceInfo_) {
    set_has_sourceInfo();
    this->_sourceInfo = sourceInfo_;
}

inline void DeactivateSourceRequest::set_has_sourceInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeactivateSourceRequest::clear_has_sourceInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSourceListRequest::GetSourceListRequest ()  :
    _srcGroupId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSourceListRequest::GetSourceListRequest (const GetSourceListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _srcGroupId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSourceListRequest::GetSourceListRequest (int32 srcGroupId_)  :
    _srcGroupId (srcGroupId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSourceListRequest::~GetSourceListRequest() {
}

inline GetSourceListRequest& GetSourceListRequest::operator = (const GetSourceListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSrcGroupId()) {
            setSrcGroupId(rhs.getSrcGroupId());
        } else {
            clearSrcGroupId();
        }
    }
    return *this;
}

inline bool GetSourceListRequest::operator == (const GetSourceListRequest& rhs) const {
    return (((!hasSrcGroupId() && !rhs.hasSrcGroupId()) || getSrcGroupId() == rhs.getSrcGroupId()));
}

inline bool GetSourceListRequest::operator != (const GetSourceListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSourceListRequest::operator < (const GetSourceListRequest& rhs) const {
    if (hasSrcGroupId() || rhs.hasSrcGroupId()) {
        if (getSrcGroupId() < rhs.getSrcGroupId()) return true;
        if (getSrcGroupId() > rhs.getSrcGroupId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSourceListRequest::clone() {
    return new GetSourceListRequest(*this);
}

inline bool GetSourceListRequest::operator > (const GetSourceListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSourceListRequest::clear() {
    clearSrcGroupId();
}

inline void GetSourceListRequest::clearSrcGroupId() {
    if (hasSrcGroupId()) {
         clear_has_srcGroupId();
        _srcGroupId = 0;
     }
}

inline bool GetSourceListRequest::hasSrcGroupId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 GetSourceListRequest::getSrcGroupId () const {
    return _srcGroupId;
}

inline void GetSourceListRequest::setSrcGroupId (int32 srcGroupId_) {
    set_has_srcGroupId();
    this->_srcGroupId = srcGroupId_;
}

inline void GetSourceListRequest::set_has_srcGroupId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSourceListRequest::clear_has_srcGroupId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSourceListResponse::GetSourceListResponse ()  :
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSourceListResponse::GetSourceListResponse (const GetSourceListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _sources ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSourceListResponse::GetSourceListResponse (const ::std::vector< sourceDetails >& sources_)  :
    _sources (sources_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSourceListResponse::~GetSourceListResponse() {
}

inline GetSourceListResponse& GetSourceListResponse::operator = (const GetSourceListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSources()) {
            setSources(rhs.getSources());
        } else {
            clearSources();
        }
    }
    return *this;
}

inline bool GetSourceListResponse::operator == (const GetSourceListResponse& rhs) const {
    return (((!hasSources() && !rhs.hasSources()) || getSources() == rhs.getSources()));
}

inline bool GetSourceListResponse::operator != (const GetSourceListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSourceListResponse::operator < (const GetSourceListResponse& rhs) const {
    if (hasSources() || rhs.hasSources()) {
        if (getSources() < rhs.getSources()) return true;
        if (getSources() > rhs.getSources()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSourceListResponse::clone() {
    return new GetSourceListResponse(*this);
}

inline bool GetSourceListResponse::operator > (const GetSourceListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSourceListResponse::clear() {
    clearSources();
}

inline void GetSourceListResponse::clearSources() {
    if (hasSources()) {
         clear_has_sources();
        _sources.clear();
     }
}

inline bool GetSourceListResponse::hasSources () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< sourceDetails >& GetSourceListResponse::getSources () const {
    return _sources;
}

inline ::std::vector< sourceDetails >& GetSourceListResponse::getSourcesMutable () {
    set_has_sources();
    return _sources;
}

inline void GetSourceListResponse::setSources (const ::std::vector< sourceDetails >& sources_) {
    set_has_sources();
    this->_sources = sources_;
}

inline void GetSourceListResponse::set_has_sources () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSourceListResponse::clear_has_sources () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveSourceUpdate::ActiveSourceUpdate ()  :
    _activeSource ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveSourceUpdate::ActiveSourceUpdate (const ActiveSourceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeSource ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveSourceUpdate::ActiveSourceUpdate (const sourceData& activeSource_)  :
    _activeSource (activeSource_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveSourceUpdate::~ActiveSourceUpdate() {
}

inline ActiveSourceUpdate& ActiveSourceUpdate::operator = (const ActiveSourceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveSource()) {
            setActiveSource(rhs.getActiveSource());
        } else {
            clearActiveSource();
        }
    }
    return *this;
}

inline bool ActiveSourceUpdate::operator == (const ActiveSourceUpdate& rhs) const {
    return (((!hasActiveSource() && !rhs.hasActiveSource()) || getActiveSource() == rhs.getActiveSource()));
}

inline bool ActiveSourceUpdate::operator != (const ActiveSourceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveSourceUpdate::operator < (const ActiveSourceUpdate& rhs) const {
    if (hasActiveSource() || rhs.hasActiveSource()) {
        if (getActiveSource() < rhs.getActiveSource()) return true;
        if (getActiveSource() > rhs.getActiveSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveSourceUpdate::clone() {
    return new ActiveSourceUpdate(*this);
}

inline bool ActiveSourceUpdate::operator > (const ActiveSourceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveSourceUpdate::clear() {
    clearActiveSource();
}

inline void ActiveSourceUpdate::clearActiveSource() {
    if (hasActiveSource()) {
         clear_has_activeSource();
        _activeSource.clear();
     }
}

inline bool ActiveSourceUpdate::hasActiveSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const sourceData& ActiveSourceUpdate::getActiveSource () const {
    return _activeSource;
}

inline sourceData& ActiveSourceUpdate::getActiveSourceMutable () {
    set_has_activeSource();
    return _activeSource;
}

inline void ActiveSourceUpdate::setActiveSource (const sourceData& activeSource_) {
    set_has_activeSource();
    this->_activeSource = activeSource_;
}

inline void ActiveSourceUpdate::set_has_activeSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveSourceUpdate::clear_has_activeSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveSourceRegister::ActiveSourceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveSourceRegister::ActiveSourceRegister (const ActiveSourceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveSourceRegister::~ActiveSourceRegister() {
}

inline ActiveSourceRegister& ActiveSourceRegister::operator = (const ActiveSourceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveSourceRegister::operator == (const ActiveSourceRegister& ) const {
    return true;
}

inline bool ActiveSourceRegister::operator != (const ActiveSourceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveSourceRegister::operator < (const ActiveSourceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveSourceRegister::clone() {
    return new ActiveSourceRegister(*this);
}

inline bool ActiveSourceRegister::operator > (const ActiveSourceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveSourceRegister::clear() {
}

inline  ActiveSourceListUpdate::ActiveSourceListUpdate ()  :
    _activeSourceList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveSourceListUpdate::ActiveSourceListUpdate (const ActiveSourceListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeSourceList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveSourceListUpdate::ActiveSourceListUpdate (const ::std::vector< sourceData >& activeSourceList_)  :
    _activeSourceList (activeSourceList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveSourceListUpdate::~ActiveSourceListUpdate() {
}

inline ActiveSourceListUpdate& ActiveSourceListUpdate::operator = (const ActiveSourceListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveSourceList()) {
            setActiveSourceList(rhs.getActiveSourceList());
        } else {
            clearActiveSourceList();
        }
    }
    return *this;
}

inline bool ActiveSourceListUpdate::operator == (const ActiveSourceListUpdate& rhs) const {
    return (((!hasActiveSourceList() && !rhs.hasActiveSourceList()) || getActiveSourceList() == rhs.getActiveSourceList()));
}

inline bool ActiveSourceListUpdate::operator != (const ActiveSourceListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveSourceListUpdate::operator < (const ActiveSourceListUpdate& rhs) const {
    if (hasActiveSourceList() || rhs.hasActiveSourceList()) {
        if (getActiveSourceList() < rhs.getActiveSourceList()) return true;
        if (getActiveSourceList() > rhs.getActiveSourceList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveSourceListUpdate::clone() {
    return new ActiveSourceListUpdate(*this);
}

inline bool ActiveSourceListUpdate::operator > (const ActiveSourceListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveSourceListUpdate::clear() {
    clearActiveSourceList();
}

inline void ActiveSourceListUpdate::clearActiveSourceList() {
    if (hasActiveSourceList()) {
         clear_has_activeSourceList();
        _activeSourceList.clear();
     }
}

inline bool ActiveSourceListUpdate::hasActiveSourceList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< sourceData >& ActiveSourceListUpdate::getActiveSourceList () const {
    return _activeSourceList;
}

inline ::std::vector< sourceData >& ActiveSourceListUpdate::getActiveSourceListMutable () {
    set_has_activeSourceList();
    return _activeSourceList;
}

inline void ActiveSourceListUpdate::setActiveSourceList (const ::std::vector< sourceData >& activeSourceList_) {
    set_has_activeSourceList();
    this->_activeSourceList = activeSourceList_;
}

inline void ActiveSourceListUpdate::set_has_activeSourceList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveSourceListUpdate::clear_has_activeSourceList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveSourceListRegister::ActiveSourceListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveSourceListRegister::ActiveSourceListRegister (const ActiveSourceListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveSourceListRegister::~ActiveSourceListRegister() {
}

inline ActiveSourceListRegister& ActiveSourceListRegister::operator = (const ActiveSourceListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveSourceListRegister::operator == (const ActiveSourceListRegister& ) const {
    return true;
}

inline bool ActiveSourceListRegister::operator != (const ActiveSourceListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveSourceListRegister::operator < (const ActiveSourceListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveSourceListRegister::clone() {
    return new ActiveSourceListRegister(*this);
}

inline bool ActiveSourceListRegister::operator > (const ActiveSourceListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveSourceListRegister::clear() {
}

inline  SourceActivatedSignal::SourceActivatedSignal ()  :
    _sourceId (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceActivatedSignal::SourceActivatedSignal (const SourceActivatedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceId (0),
    _sinkId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceActivatedSignal::SourceActivatedSignal (int32 sourceId_, uint16 sinkId_)  :
    _sourceId (sourceId_),
    _sinkId (sinkId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceActivatedSignal::~SourceActivatedSignal() {
}

inline SourceActivatedSignal& SourceActivatedSignal::operator = (const SourceActivatedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceId()) {
            setSourceId(rhs.getSourceId());
        } else {
            clearSourceId();
        }
        if (rhs.hasSinkId()) {
            setSinkId(rhs.getSinkId());
        } else {
            clearSinkId();
        }
    }
    return *this;
}

inline bool SourceActivatedSignal::operator == (const SourceActivatedSignal& rhs) const {
    return (((!hasSourceId() && !rhs.hasSourceId()) || getSourceId() == rhs.getSourceId()) &&
        ((!hasSinkId() && !rhs.hasSinkId()) || getSinkId() == rhs.getSinkId()));
}

inline bool SourceActivatedSignal::operator != (const SourceActivatedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceActivatedSignal::operator < (const SourceActivatedSignal& rhs) const {
    if (hasSourceId() || rhs.hasSourceId()) {
        if (getSourceId() < rhs.getSourceId()) return true;
        if (getSourceId() > rhs.getSourceId()) return false;
    }
    if (hasSinkId() || rhs.hasSinkId()) {
        if (getSinkId() < rhs.getSinkId()) return true;
        if (getSinkId() > rhs.getSinkId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceActivatedSignal::clone() {
    return new SourceActivatedSignal(*this);
}

inline bool SourceActivatedSignal::operator > (const SourceActivatedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceActivatedSignal::clear() {
    clearSourceId();
    clearSinkId();
}

inline void SourceActivatedSignal::clearSourceId() {
    if (hasSourceId()) {
         clear_has_sourceId();
        _sourceId = 0;
     }
}

inline bool SourceActivatedSignal::hasSourceId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SourceActivatedSignal::getSourceId () const {
    return _sourceId;
}

inline void SourceActivatedSignal::setSourceId (int32 sourceId_) {
    set_has_sourceId();
    this->_sourceId = sourceId_;
}

inline void SourceActivatedSignal::clearSinkId() {
    if (hasSinkId()) {
         clear_has_sinkId();
        _sinkId = 0u;
     }
}

inline bool SourceActivatedSignal::hasSinkId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SourceActivatedSignal::getSinkId () const {
    return _sinkId;
}

inline void SourceActivatedSignal::setSinkId (uint16 sinkId_) {
    set_has_sinkId();
    this->_sinkId = sinkId_;
}

inline void SourceActivatedSignal::set_has_sourceId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceActivatedSignal::clear_has_sourceId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceActivatedSignal::set_has_sinkId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceActivatedSignal::clear_has_sinkId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceListChangedSignal::SourceListChangedSignal ()  :
    _groupId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceListChangedSignal::SourceListChangedSignal (const SourceListChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _groupId (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceListChangedSignal::SourceListChangedSignal (int32 groupId_)  :
    _groupId (groupId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceListChangedSignal::~SourceListChangedSignal() {
}

inline SourceListChangedSignal& SourceListChangedSignal::operator = (const SourceListChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroupId()) {
            setGroupId(rhs.getGroupId());
        } else {
            clearGroupId();
        }
    }
    return *this;
}

inline bool SourceListChangedSignal::operator == (const SourceListChangedSignal& rhs) const {
    return (((!hasGroupId() && !rhs.hasGroupId()) || getGroupId() == rhs.getGroupId()));
}

inline bool SourceListChangedSignal::operator != (const SourceListChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceListChangedSignal::operator < (const SourceListChangedSignal& rhs) const {
    if (hasGroupId() || rhs.hasGroupId()) {
        if (getGroupId() < rhs.getGroupId()) return true;
        if (getGroupId() > rhs.getGroupId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceListChangedSignal::clone() {
    return new SourceListChangedSignal(*this);
}

inline bool SourceListChangedSignal::operator > (const SourceListChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceListChangedSignal::clear() {
    clearGroupId();
}

inline void SourceListChangedSignal::clearGroupId() {
    if (hasGroupId()) {
         clear_has_groupId();
        _groupId = 0;
     }
}

inline bool SourceListChangedSignal::hasGroupId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SourceListChangedSignal::getGroupId () const {
    return _groupId;
}

inline void SourceListChangedSignal::setGroupId (int32 groupId_) {
    set_has_groupId();
    this->_groupId = groupId_;
}

inline void SourceListChangedSignal::set_has_groupId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceListChangedSignal::clear_has_groupId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal ()  :
    _sourceAvailability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal (const SourceAvailabilityChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceAvailability ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAvailabilityChangedSignal::SourceAvailabilityChangedSignal (const sourceDetails& sourceAvailability_)  :
    _sourceAvailability (sourceAvailability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAvailabilityChangedSignal::~SourceAvailabilityChangedSignal() {
}

inline SourceAvailabilityChangedSignal& SourceAvailabilityChangedSignal::operator = (const SourceAvailabilityChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceAvailability()) {
            setSourceAvailability(rhs.getSourceAvailability());
        } else {
            clearSourceAvailability();
        }
    }
    return *this;
}

inline bool SourceAvailabilityChangedSignal::operator == (const SourceAvailabilityChangedSignal& rhs) const {
    return (((!hasSourceAvailability() && !rhs.hasSourceAvailability()) || getSourceAvailability() == rhs.getSourceAvailability()));
}

inline bool SourceAvailabilityChangedSignal::operator != (const SourceAvailabilityChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAvailabilityChangedSignal::operator < (const SourceAvailabilityChangedSignal& rhs) const {
    if (hasSourceAvailability() || rhs.hasSourceAvailability()) {
        if (getSourceAvailability() < rhs.getSourceAvailability()) return true;
        if (getSourceAvailability() > rhs.getSourceAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceAvailabilityChangedSignal::clone() {
    return new SourceAvailabilityChangedSignal(*this);
}

inline bool SourceAvailabilityChangedSignal::operator > (const SourceAvailabilityChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAvailabilityChangedSignal::clear() {
    clearSourceAvailability();
}

inline void SourceAvailabilityChangedSignal::clearSourceAvailability() {
    if (hasSourceAvailability()) {
         clear_has_sourceAvailability();
        _sourceAvailability.clear();
     }
}

inline bool SourceAvailabilityChangedSignal::hasSourceAvailability () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const sourceDetails& SourceAvailabilityChangedSignal::getSourceAvailability () const {
    return _sourceAvailability;
}

inline sourceDetails& SourceAvailabilityChangedSignal::getSourceAvailabilityMutable () {
    set_has_sourceAvailability();
    return _sourceAvailability;
}

inline void SourceAvailabilityChangedSignal::setSourceAvailability (const sourceDetails& sourceAvailability_) {
    set_has_sourceAvailability();
    this->_sourceAvailability = sourceAvailability_;
}

inline void SourceAvailabilityChangedSignal::set_has_sourceAvailability () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAvailabilityChangedSignal::clear_has_sourceAvailability () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace AudioSourceChange
} // namespace masteraudioservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_MASTERAUDIOSERVICE_AUDIOSOURCECHANGE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
