/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERSTUB_H
#define COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/LifeCycleManager.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace LifeCycleManager {

class LifeCycleManagerStubDelegate;

class LifeCycleManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the LifeCycleManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    LifeCycleManagerStub (const std::string& portName);

    /**
     * Create an instance of the LifeCycleManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    LifeCycleManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~LifeCycleManagerStub();

    // signal 'LifecycleRequest'

    /**
     * Raise the signal 'LifecycleRequest' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LifecycleRequest'</b>:
     *
     * If the meaning of "LifecycleRequest" isn't clear, then there should be a description here.
     */
    void sendLifecycleRequestSignal(uint32 mode, uint32 request_id);

    // method 'Register'

    /**
     * The method onRegister() is called by ASF when a client invokes the
     * method 'Register'. A subclass has to implement this method and send
     * back a response to the client either with the sendRegister() or
     * sendRegisterError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Register'</b>:
     *
     * If the meaning of "Register" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterRequest (const ::boost::shared_ptr< RegisterRequest >& request) = 0;

    /**
     * The method sendRegisterResponse() sends a response of a previous method
     * invocation of 'Register' back to the client.
     *
     * <b>Documentation of 'Register'</b>:
     *
     * If the meaning of "Register" isn't clear, then there should be a description here.
     *
     * @param request_id If the meaning of "request_id" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegister(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterResponse (uint32 request_id, act_t act = 0);

    /**
     * The method sendRegisterError() sends an error response of a previous
     * method invocation of 'Register' back to the client.
     *
     * <b>Documentation of 'Register'</b>:
     *
     * If the meaning of "Register" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegister(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRegisterError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HeartBeatNotification'

    /**
     * The method onHeartBeatNotification() is called by ASF when a client
     * invokes the method 'HeartBeatNotification'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendHeartBeatNotification() or sendHeartBeatNotificationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'HeartBeatNotification'</b>:
     *
     * If the meaning of "HeartBeatNotification" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHeartBeatNotificationRequest (const ::boost::shared_ptr< HeartBeatNotificationRequest >& request) = 0;

    /**
     * The method sendHeartBeatNotificationResponse() sends a response of a
     * previous method invocation of 'HeartBeatNotification' back to the
     * client.
     *
     * <b>Documentation of 'HeartBeatNotification'</b>:
     *
     * If the meaning of "HeartBeatNotification" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHeartBeatNotification(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHeartBeatNotificationResponse (act_t act = 0);

    /**
     * The method sendHeartBeatNotificationError() sends an error response of
     * a previous method invocation of 'HeartBeatNotification' back to the
     * client.
     *
     * <b>Documentation of 'HeartBeatNotification'</b>:
     *
     * If the meaning of "HeartBeatNotification" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onHeartBeatNotification(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendHeartBeatNotificationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'LifecycleRequestComplete'

    /**
     * The method onLifecycleRequestComplete() is called by ASF when a client
     * invokes the method 'LifecycleRequestComplete'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendLifecycleRequestComplete() or
     * sendLifecycleRequestCompleteError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * If the meaning of "LifecycleRequestComplete" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLifecycleRequestCompleteRequest (const ::boost::shared_ptr< LifecycleRequestCompleteRequest >& request) = 0;

    /**
     * The method sendLifecycleRequestCompleteResponse() sends a response of a
     * previous method invocation of 'LifecycleRequestComplete' back to the
     * client.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * If the meaning of "LifecycleRequestComplete" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLifecycleRequestComplete(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLifecycleRequestCompleteResponse (act_t act = 0);

    /**
     * The method sendLifecycleRequestCompleteError() sends an error response
     * of a previous method invocation of 'LifecycleRequestComplete' back to
     * the client.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * If the meaning of "LifecycleRequestComplete" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onLifecycleRequestComplete(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLifecycleRequestCompleteError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestForRestart'

    /**
     * The method onRequestForRestart() is called by ASF when a client invokes
     * the method 'RequestForRestart'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRequestForRestart() or sendRequestForRestartError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'RequestForRestart'</b>:
     *
     * If the meaning of "RequestForRestart" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestForRestartRequest (const ::boost::shared_ptr< RequestForRestartRequest >& request) = 0;

    /**
     * The method sendRequestForRestartResponse() sends a response of a
     * previous method invocation of 'RequestForRestart' back to the client.
     *
     * <b>Documentation of 'RequestForRestart'</b>:
     *
     * If the meaning of "RequestForRestart" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestForRestart(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestForRestartResponse (act_t act = 0);

    /**
     * The method sendRequestForRestartError() sends an error response of a
     * previous method invocation of 'RequestForRestart' back to the client.
     *
     * <b>Documentation of 'RequestForRestart'</b>:
     *
     * If the meaning of "RequestForRestart" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestForRestart().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestForRestartError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class LifeCycleManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace LifeCycleManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_AUTOMOTIVEPROXY_LIFECYCLEMANAGERSTUB_H
