/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/LifeCycleManager.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerDBus.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerJson.h"
#include "com/bosch/AutomotiveProxy/LifeCycleManagerStub.h"

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace LifeCycleManager {

DEFINE_CLASS_LOGGER("//com/bosch/AutomotiveProxy/LifeCycleManager/com/bosch/AutomotiveProxy/LifeCycleManager", LifeCycleManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "Register", 0 },
    { 17, "RequestForRestart", 3 },
    { 21, "HeartBeatNotification", 1 },
    { 24, "LifecycleRequestComplete", 2 },
};


class LifeCycleManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LifeCycleManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LifeCycleManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LifeCycleManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.AutomotiveProxy.LifeCycleManager"),
          _logger(logger) {}

    virtual ~LifeCycleManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LifeCycleManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Register'

            LOG_DEBUG_STUB("process method '%s'", "Register");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Register", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterRequest > payload = ::boost::static_pointer_cast<RegisterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifeCycleManagerStub*>(getStub())->onRegisterRequest(payload);
            return;
        }
        case 1: {

            // method 'HeartBeatNotification'

            LOG_DEBUG_STUB("process method '%s'", "HeartBeatNotification");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HeartBeatNotificationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HeartBeatNotification", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HeartBeatNotificationRequest > payload = ::boost::static_pointer_cast<HeartBeatNotificationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifeCycleManagerStub*>(getStub())->onHeartBeatNotificationRequest(payload);
            return;
        }
        case 2: {

            // method 'LifecycleRequestComplete'

            LOG_DEBUG_STUB("process method '%s'", "LifecycleRequestComplete");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LifecycleRequestComplete", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LifecycleRequestCompleteRequest > payload = ::boost::static_pointer_cast<LifecycleRequestCompleteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifeCycleManagerStub*>(getStub())->onLifecycleRequestCompleteRequest(payload);
            return;
        }
        case 3: {

            // method 'RequestForRestart'

            LOG_DEBUG_STUB("process method '%s'", "RequestForRestart");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestForRestartRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestForRestart", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestForRestartRequest > payload = ::boost::static_pointer_cast<RequestForRestartRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LifeCycleManagerStub*>(getStub())->onRequestForRestartRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LifeCycleManagerStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.AutomotiveProxy.LifeCycleManager\">\n"
            "      <method name=\"Register\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"credentials\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"in\" name=\"request_mode\" type=\"u\"/>\n"
            "        <arg direction=\"out\" name=\"request_id\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"HeartBeatNotification\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"request_id\" type=\"u\"/>\n"
            "      </method>\n"
            "      <signal name=\"LifecycleRequest\">\n"
            "        <arg name=\"mode\" type=\"u\"/>\n"
            "        <arg name=\"request_id\" type=\"u\"/>\n"
            "      </signal>\n"
            "      <method name=\"LifecycleRequestComplete\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"request_id\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestForRestart\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"request_id\" type=\"u\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void LifeCycleManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LifeCycleManagerStub*>(getStub()))->onGetAll (properties);
}

void LifeCycleManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LifeCycleManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LifeCycleManagerStub::LifeCycleManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifeCycleManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifeCycleManagerStub::LifeCycleManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LifeCycleManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LifeCycleManagerStub::~LifeCycleManagerStub() {
    delete _stubDelegate;
}

void LifeCycleManagerStub::sendLifecycleRequestSignal(uint32 mode, uint32 request_id) {
    if (_stubDelegate->isConnected()) {
        LifecycleRequestSignal* payload = new LifecycleRequestSignal(mode, request_id);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LifecycleRequest", LifecycleRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "LifecycleRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LifecycleRequest");
    }
}

void  LifeCycleManagerStub::sendRegisterResponse (uint32 request_id, act_t act) {
    RegisterResponse* payload = new RegisterResponse(request_id);
    DBUS_MESSAGE_REPLY(dbusMessage, "Register", RegisterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Register", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendRegisterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterError* payload = new RegisterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Register", RegisterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Register", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendHeartBeatNotificationResponse (act_t act) {
    HeartBeatNotificationResponse* payload = new HeartBeatNotificationResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HeartBeatNotification", HeartBeatNotificationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HeartBeatNotification", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendHeartBeatNotificationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HeartBeatNotificationError* payload = new HeartBeatNotificationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HeartBeatNotification", HeartBeatNotificationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HeartBeatNotification", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendLifecycleRequestCompleteResponse (act_t act) {
    LifecycleRequestCompleteResponse* payload = new LifecycleRequestCompleteResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LifecycleRequestComplete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendLifecycleRequestCompleteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LifecycleRequestCompleteError* payload = new LifecycleRequestCompleteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LifecycleRequestComplete", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendRequestForRestartResponse (act_t act) {
    RequestForRestartResponse* payload = new RequestForRestartResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestForRestart", RequestForRestartResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestForRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LifeCycleManagerStub::sendRequestForRestartError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestForRestartError* payload = new RequestForRestartError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestForRestart", RequestForRestartError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestForRestart", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void LifeCycleManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace LifeCycleManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com
