/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "IntercomApp/IntercomApplication.h"
#include "IntercomApp/IntercomComponent.h"
#include "IntercomApp/IntercomNanoMessageClientHandler.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "IntercomApplication" isn't clear, then there should be a description here.
 */

namespace IntercomApp {

DEFINE_LOGGER_AND_LEVEL (_logger, "/IntercomApp/IntercomApplication", Info);

/* static */ const char* IntercomApplication::IntercomComponent = "IntercomComponent";
/* static */ const char* IntercomApplication::IntercomNanoMessageClientHandler = "IntercomNanoMessageClientHandler";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool IntercomApplication_enabledASFSignalHandler = false;

void importIntercomApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach IntercomApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression1;
        {
            __expression1.setApplicationId(156);
        }
        ccaConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'T_IntercomApp'

    ::asf::core::ComponentContainerSharedPtr T_IntercomApp(new ::asf::core::ComponentContainer("T_IntercomApp", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T_IntercomApp);

        // Component 'IntercomComponent IntercomComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::IntercomApp::IntercomComponent > > intercomComponentFactory(new ::asf::core::ComponentFactory< ::IntercomApp::IntercomComponent >);
        ::asf::core::ComponentDescriptionSharedPtr intercomComponentDescription(new ::asf::core::ComponentDescription(1, "IntercomComponent", /* immediate = */ true, /* threadBridge = */ false, intercomComponentFactory));
        T_IntercomApp->addComponentDescription(intercomComponentDescription);

            // Port 'IntercomServerPort'

            ::asf::core::ProvidedPort& IntercomComponent_IntercomServerPort = intercomComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.IntercomAudioService", "IntercomServerPort", false, false));
            (void)IntercomComponent_IntercomServerPort; // prevent unused variable warning

            // Port 'strFiPort'

            ::asf::core::RequiredPort& IntercomComponent_strFiPort = intercomComponentDescription->addRequiredPort (::asf::core::RequiredPort ("midw_streamrouter_fi", "strFiPort"));
            (void)IntercomComponent_strFiPort; // prevent unused variable warning

            // Port 'spmLcmFiImport'

            ::asf::core::RequiredPort& IntercomComponent_spmLcmFiImport = intercomComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmLcmFiImport"));
            (void)IntercomComponent_spmLcmFiImport; // prevent unused variable warning

            // Port 'lcmdbusclient_main_fiPort'

            ::asf::core::RequiredPort& IntercomComponent_lcmdbusclient_main_fiPort = intercomComponentDescription->addRequiredPort (::asf::core::RequiredPort ("lcmdbusclient_main_fi", "lcmdbusclient_main_fiPort"));
            (void)IntercomComponent_lcmdbusclient_main_fiPort; // prevent unused variable warning

        // Component 'IntercomNanoMessageClientHandler IntercomNanoMessageClientHandler'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::IntercomApp::IntercomNanoMessageClientHandler > > intercomNanoMessageClientHandlerFactory(new ::asf::core::ComponentFactory< ::IntercomApp::IntercomNanoMessageClientHandler >);
        ::asf::core::ComponentDescriptionSharedPtr intercomNanoMessageClientHandlerDescription(new ::asf::core::ComponentDescription(2, "IntercomNanoMessageClientHandler", /* immediate = */ true, /* threadBridge = */ false, intercomNanoMessageClientHandlerFactory));
        T_IntercomApp->addComponentDescription(intercomNanoMessageClientHandlerDescription);

            // Port 'NanoMsgIntercomPort'

            ::asf::core::RequiredPort& IntercomNanoMessageClientHandler_NanoMsgIntercomPort = intercomNanoMessageClientHandlerDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgIntercomInterface", "NanoMsgIntercomPort"));
            (void)IntercomNanoMessageClientHandler_NanoMsgIntercomPort; // prevent unused variable warning

    // Expression

    dbusConnector_->exportByName (IntercomComponent_IntercomServerPort, ::std::string("/bosch/cm/ai/IntercomAudioService"));

    // Expression

    ::asf::cca::CcaImportedPort& strFiImport = ccaConnector_->importByName (82, 1, 0, 2);
    strFiImport.setServiceName("midw_streamrouter_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (IntercomComponent_strFiPort, strFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmLcmFiImport = ccaConnector_->importByName (0, 1, 2, 2);
    spmLcmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (IntercomComponent_spmLcmFiImport, spmLcmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgIntercomImport = dbusConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgIntercomInterface"));
    NanoMsgIntercomImport.setServiceName("bosch.cm.di.NanoMsgIntercomInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (IntercomNanoMessageClientHandler_NanoMsgIntercomPort, NanoMsgIntercomImport);

    // Expression

    ::asf::cca::CcaImportedPort& lcmdbusclient_main_fiImport = ccaConnector_->importByName (243, 1, 0, 2);
    lcmdbusclient_main_fiImport.setServiceName("lcmdbusclient_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (IntercomComponent_lcmdbusclient_main_fiPort, lcmdbusclient_main_fiImport);


    LOG_INFO_STATIC("Starting application 'IntercomApplication' version 1.0.0");

    app->start();
}

int executeIntercomApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("IntercomApp", "IntercomApplication");
    } else {
        ::asf::core::Logger::setupLogging ("IntercomApp", "IntercomApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", IntercomApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("IntercomApp", "IntercomApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create IntercomApplication");

    app->enableExceptionHandler(true);

    importIntercomApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace IntercomApp

int main(int argc, char* argv[]) {
    ::IntercomApp::IntercomApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::IntercomApp::executeIntercomApplication(argc, argv);
}

