/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorService.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceDBus.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceJson.h"
#include "bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmimonitorservice {
namespace HmiMonitorService {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/nissan/hmi/hmimonitorservice/bosch/cm/ai/nissan/hmi/hmimonitorservice/HmiMonitorService", HmiMonitorServiceProxy);

class HmiMonitorServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HmiMonitorServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HmiMonitorServiceProxy >& proxyShared = ::boost::static_pointer_cast< HmiMonitorServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_activeRenderedViewName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRenderedViewNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRenderedViewName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRenderedViewNameError> payload = ::boost::static_pointer_cast<ActiveRenderedViewNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveRenderedViewNameCallbackIF*) _callback)->onActiveRenderedViewNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRenderedViewNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRenderedViewName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRenderedViewNameUpdate> payload = ::boost::static_pointer_cast<ActiveRenderedViewNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveRenderedViewNameCallbackIF*) _callback)->onActiveRenderedViewNameUpdate(proxyShared, payload);
                        proxyShared->_activeRenderedViewName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_activeRenderedUpperViewName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRenderedUpperViewNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRenderedUpperViewName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRenderedUpperViewNameError> payload = ::boost::static_pointer_cast<ActiveRenderedUpperViewNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveRenderedUpperViewNameCallbackIF*) _callback)->onActiveRenderedUpperViewNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRenderedUpperViewNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRenderedUpperViewName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRenderedUpperViewNameUpdate> payload = ::boost::static_pointer_cast<ActiveRenderedUpperViewNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveRenderedUpperViewNameCallbackIF*) _callback)->onActiveRenderedUpperViewNameUpdate(proxyShared, payload);
                        proxyShared->_activeRenderedUpperViewName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_nextActiveAppUpper:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextActiveAppUpperError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextActiveAppUpperError> payload = ::boost::static_pointer_cast<NextActiveAppUpperError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NextActiveAppUpperCallbackIF*) _callback)->onNextActiveAppUpperError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextActiveAppUpperUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextActiveAppUpperUpdate> payload = ::boost::static_pointer_cast<NextActiveAppUpperUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NextActiveAppUpperCallbackIF*) _callback)->onNextActiveAppUpperUpdate(proxyShared, payload);
                        proxyShared->_nextActiveAppUpper = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_nextActiveAppLower:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextActiveAppLowerError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextActiveAppLower", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextActiveAppLowerError> payload = ::boost::static_pointer_cast<NextActiveAppLowerError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NextActiveAppLowerCallbackIF*) _callback)->onNextActiveAppLowerError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NextActiveAppLowerUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NextActiveAppLower", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NextActiveAppLowerUpdate> payload = ::boost::static_pointer_cast<NextActiveAppLowerUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NextActiveAppLowerCallbackIF*) _callback)->onNextActiveAppLowerUpdate(proxyShared, payload);
                        proxyShared->_nextActiveAppLower = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_getStartUpTimeInterval:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetStartUpTimeIntervalError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStartUpTimeInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetStartUpTimeIntervalError> payload = ::boost::static_pointer_cast<GetStartUpTimeIntervalError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetStartUpTimeIntervalCallbackIF*) _callback)->onGetStartUpTimeIntervalError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetStartUpTimeIntervalResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStartUpTimeInterval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetStartUpTimeIntervalResponse> payload = ::boost::static_pointer_cast<GetStartUpTimeIntervalResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetStartUpTimeIntervalCallbackIF*) _callback)->onGetStartUpTimeIntervalResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getActiveForegroundScene:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetActiveForegroundScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetActiveForegroundSceneError> payload = ::boost::static_pointer_cast<GetActiveForegroundSceneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetActiveForegroundSceneCallbackIF*) _callback)->onGetActiveForegroundSceneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetActiveForegroundScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetActiveForegroundSceneResponse> payload = ::boost::static_pointer_cast<GetActiveForegroundSceneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetActiveForegroundSceneCallbackIF*) _callback)->onGetActiveForegroundSceneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getActiveForegroundSceneUpper:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneUpperError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetActiveForegroundSceneUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetActiveForegroundSceneUpperError> payload = ::boost::static_pointer_cast<GetActiveForegroundSceneUpperError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetActiveForegroundSceneUpperCallbackIF*) _callback)->onGetActiveForegroundSceneUpperError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetActiveForegroundSceneUpperResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetActiveForegroundSceneUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetActiveForegroundSceneUpperResponse> payload = ::boost::static_pointer_cast<GetActiveForegroundSceneUpperResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetActiveForegroundSceneUpperCallbackIF*) _callback)->onGetActiveForegroundSceneUpperResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setHMIInfoServiceStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetHMIInfoServiceStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetHMIInfoServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetHMIInfoServiceStatusError> payload = ::boost::static_pointer_cast<SetHMIInfoServiceStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetHMIInfoServiceStatusCallbackIF*) _callback)->onSetHMIInfoServiceStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetHMIInfoServiceStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetHMIInfoServiceStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetHMIInfoServiceStatusResponse> payload = ::boost::static_pointer_cast<SetHMIInfoServiceStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetHMIInfoServiceStatusCallbackIF*) _callback)->onSetHMIInfoServiceStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getNextActiveAppUpper:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppUpperError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNextActiveAppUpperError> payload = ::boost::static_pointer_cast<GetNextActiveAppUpperError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNextActiveAppUpperCallbackIF*) _callback)->onGetNextActiveAppUpperError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppUpperResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNextActiveAppUpperResponse> payload = ::boost::static_pointer_cast<GetNextActiveAppUpperResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNextActiveAppUpperCallbackIF*) _callback)->onGetNextActiveAppUpperResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getNextActiveAppLower:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppLowerError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNextActiveAppLower", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNextActiveAppLowerError> payload = ::boost::static_pointer_cast<GetNextActiveAppLowerError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNextActiveAppLowerCallbackIF*) _callback)->onGetNextActiveAppLowerError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNextActiveAppLowerResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNextActiveAppLower", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNextActiveAppLowerResponse> payload = ::boost::static_pointer_cast<GetNextActiveAppLowerResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNextActiveAppLowerCallbackIF*) _callback)->onGetNextActiveAppLowerResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_activeRenderedViewName: {
                ::boost::shared_ptr< ActiveRenderedViewNameError > payload = ::boost::shared_ptr< ActiveRenderedViewNameError >
                (new ActiveRenderedViewNameError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveRenderedViewName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveRenderedViewNameCallbackIF*) _callback)->onActiveRenderedViewNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeRenderedUpperViewName: {
                ::boost::shared_ptr< ActiveRenderedUpperViewNameError > payload = ::boost::shared_ptr< ActiveRenderedUpperViewNameError >
                (new ActiveRenderedUpperViewNameError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveRenderedUpperViewName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveRenderedUpperViewNameCallbackIF*) _callback)->onActiveRenderedUpperViewNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_nextActiveAppUpper: {
                ::boost::shared_ptr< NextActiveAppUpperError > payload = ::boost::shared_ptr< NextActiveAppUpperError >
                (new NextActiveAppUpperError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NextActiveAppUpperCallbackIF*) _callback)->onNextActiveAppUpperError (proxyShared,payload);
                return true;
            }
            break;
            case ID_nextActiveAppLower: {
                ::boost::shared_ptr< NextActiveAppLowerError > payload = ::boost::shared_ptr< NextActiveAppLowerError >
                (new NextActiveAppLowerError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NextActiveAppLower", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NextActiveAppLowerCallbackIF*) _callback)->onNextActiveAppLowerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getStartUpTimeInterval: {
                ::boost::shared_ptr< GetStartUpTimeIntervalError > payload = ::boost::shared_ptr< GetStartUpTimeIntervalError >
                (new GetStartUpTimeIntervalError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetStartUpTimeInterval", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetStartUpTimeIntervalCallbackIF*) _callback)->onGetStartUpTimeIntervalError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getActiveForegroundScene: {
                ::boost::shared_ptr< GetActiveForegroundSceneError > payload = ::boost::shared_ptr< GetActiveForegroundSceneError >
                (new GetActiveForegroundSceneError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetActiveForegroundScene", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetActiveForegroundSceneCallbackIF*) _callback)->onGetActiveForegroundSceneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getActiveForegroundSceneUpper: {
                ::boost::shared_ptr< GetActiveForegroundSceneUpperError > payload = ::boost::shared_ptr< GetActiveForegroundSceneUpperError >
                (new GetActiveForegroundSceneUpperError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetActiveForegroundSceneUpper", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetActiveForegroundSceneUpperCallbackIF*) _callback)->onGetActiveForegroundSceneUpperError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setHMIInfoServiceStatus: {
                ::boost::shared_ptr< SetHMIInfoServiceStatusError > payload = ::boost::shared_ptr< SetHMIInfoServiceStatusError >
                (new SetHMIInfoServiceStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetHMIInfoServiceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetHMIInfoServiceStatusCallbackIF*) _callback)->onSetHMIInfoServiceStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getNextActiveAppUpper: {
                ::boost::shared_ptr< GetNextActiveAppUpperError > payload = ::boost::shared_ptr< GetNextActiveAppUpperError >
                (new GetNextActiveAppUpperError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetNextActiveAppUpper", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetNextActiveAppUpperCallbackIF*) _callback)->onGetNextActiveAppUpperError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getNextActiveAppLower: {
                ::boost::shared_ptr< GetNextActiveAppLowerError > payload = ::boost::shared_ptr< GetNextActiveAppLowerError >
                (new GetNextActiveAppLowerError(DBUS_ERROR_NO_SERVER, "The DBus service HmiMonitorService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetNextActiveAppLower", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiMonitorServiceProxy> proxyShared = ::boost::static_pointer_cast<HmiMonitorServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetNextActiveAppLowerCallbackIF*) _callback)->onGetNextActiveAppLowerError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HmiMonitorServiceProxyCallback::_logger (HmiMonitorServiceProxy::_logger);

HmiMonitorServiceProxy::HmiMonitorServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.nissan.hmi.hmimonitorservice.HmiMonitorService", serviceAvailable, _logger) {
}

HmiMonitorServiceProxy::~HmiMonitorServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HmiMonitorServiceProxy > HmiMonitorServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HmiMonitorServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HmiMonitorServiceProxy > proxyNew(new HmiMonitorServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HmiMonitorServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HmiMonitorServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiMonitorServiceProxy::clearAllProperties ()
{
    _activeRenderedViewName = ::asf::core::nullable< ActiveRenderedViewNameUpdate >();
    _activeRenderedUpperViewName = ::asf::core::nullable< ActiveRenderedUpperViewNameUpdate >();
    _nextActiveAppUpper = ::asf::core::nullable< NextActiveAppUpperUpdate >();
    _nextActiveAppLower = ::asf::core::nullable< NextActiveAppLowerUpdate >();
}

void HmiMonitorServiceProxy::sendDeregisterAll () const
{
    sendActiveRenderedViewNameDeregisterAll();
    sendActiveRenderedUpperViewNameDeregisterAll();
    sendNextActiveAppUpperDeregisterAll();
    sendNextActiveAppLowerDeregisterAll();
}

act_t HmiMonitorServiceProxy::sendActiveRenderedViewNameRegister(ActiveRenderedViewNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeRenderedViewName, "activeRenderedViewName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveRenderedViewName", &cb, act);
    return act;
}

bool HmiMonitorServiceProxy::sendActiveRenderedViewNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeRenderedViewName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveRenderedViewName", act, static_cast<int>(rv));
    return rv;
}

act_t HmiMonitorServiceProxy::sendActiveRenderedViewNameGet(ActiveRenderedViewNameCallbackIF& cb) {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(ID_activeRenderedViewName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveRenderedViewName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeRenderedViewName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& HmiMonitorServiceProxy::getActiveRenderedViewName() const {
    return _activeRenderedViewName.get().getActiveRenderedViewName();
}

bool HmiMonitorServiceProxy::hasActiveRenderedViewName() const {
    return _activeRenderedViewName.hasValue();
}

void HmiMonitorServiceProxy::sendActiveRenderedViewNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveRenderedViewName");
    _dbusProxyDelegate->deregisterSignalCallback("activeRenderedViewName", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiMonitorServiceProxy::sendActiveRenderedUpperViewNameRegister(ActiveRenderedUpperViewNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeRenderedUpperViewName, "activeRenderedUpperViewName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveRenderedUpperViewName", &cb, act);
    return act;
}

bool HmiMonitorServiceProxy::sendActiveRenderedUpperViewNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeRenderedUpperViewName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveRenderedUpperViewName", act, static_cast<int>(rv));
    return rv;
}

act_t HmiMonitorServiceProxy::sendActiveRenderedUpperViewNameGet(ActiveRenderedUpperViewNameCallbackIF& cb) {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(ID_activeRenderedUpperViewName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveRenderedUpperViewName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeRenderedUpperViewName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& HmiMonitorServiceProxy::getActiveRenderedUpperViewName() const {
    return _activeRenderedUpperViewName.get().getActiveRenderedUpperViewName();
}

bool HmiMonitorServiceProxy::hasActiveRenderedUpperViewName() const {
    return _activeRenderedUpperViewName.hasValue();
}

void HmiMonitorServiceProxy::sendActiveRenderedUpperViewNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveRenderedUpperViewName");
    _dbusProxyDelegate->deregisterSignalCallback("activeRenderedUpperViewName", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiMonitorServiceProxy::sendNextActiveAppUpperRegister(NextActiveAppUpperCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_nextActiveAppUpper, "nextActiveAppUpper", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NextActiveAppUpper", &cb, act);
    return act;
}

bool HmiMonitorServiceProxy::sendNextActiveAppUpperDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("nextActiveAppUpper", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NextActiveAppUpper", act, static_cast<int>(rv));
    return rv;
}

act_t HmiMonitorServiceProxy::sendNextActiveAppUpperGet(NextActiveAppUpperCallbackIF& cb) {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(ID_nextActiveAppUpper, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NextActiveAppUpper", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("nextActiveAppUpper", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& HmiMonitorServiceProxy::getNextActiveAppUpper() const {
    return _nextActiveAppUpper.get().getNextActiveAppUpper();
}

bool HmiMonitorServiceProxy::hasNextActiveAppUpper() const {
    return _nextActiveAppUpper.hasValue();
}

void HmiMonitorServiceProxy::sendNextActiveAppUpperDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NextActiveAppUpper");
    _dbusProxyDelegate->deregisterSignalCallback("nextActiveAppUpper", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiMonitorServiceProxy::sendNextActiveAppLowerRegister(NextActiveAppLowerCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_nextActiveAppLower, "nextActiveAppLower", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NextActiveAppLower", &cb, act);
    return act;
}

bool HmiMonitorServiceProxy::sendNextActiveAppLowerDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("nextActiveAppLower", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NextActiveAppLower", act, static_cast<int>(rv));
    return rv;
}

act_t HmiMonitorServiceProxy::sendNextActiveAppLowerGet(NextActiveAppLowerCallbackIF& cb) {
    HmiMonitorServiceProxyCallback* callback = new HmiMonitorServiceProxyCallback(ID_nextActiveAppLower, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "NextActiveAppLower", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("nextActiveAppLower", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& HmiMonitorServiceProxy::getNextActiveAppLower() const {
    return _nextActiveAppLower.get().getNextActiveAppLower();
}

bool HmiMonitorServiceProxy::hasNextActiveAppLower() const {
    return _nextActiveAppLower.hasValue();
}

void HmiMonitorServiceProxy::sendNextActiveAppLowerDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NextActiveAppLower");
    _dbusProxyDelegate->deregisterSignalCallback("nextActiveAppLower", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiMonitorServiceProxy::sendGetStartUpTimeIntervalRequest(GetStartUpTimeIntervalCallbackIF& cb) const {
    GetStartUpTimeIntervalRequest* payload = new GetStartUpTimeIntervalRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getStartUpTimeInterval", GetStartUpTimeIntervalRequest, payload, true)
    act_t act = addMethodCallback(ID_getStartUpTimeInterval, dbusMessage.getUniqueSerial(), "getStartUpTimeInterval", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetStartUpTimeInterval", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiMonitorServiceProxy::sendGetActiveForegroundSceneRequest(GetActiveForegroundSceneCallbackIF& cb) const {
    GetActiveForegroundSceneRequest* payload = new GetActiveForegroundSceneRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getActiveForegroundScene", GetActiveForegroundSceneRequest, payload, true)
    act_t act = addMethodCallback(ID_getActiveForegroundScene, dbusMessage.getUniqueSerial(), "getActiveForegroundScene", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetActiveForegroundScene", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiMonitorServiceProxy::sendGetActiveForegroundSceneUpperRequest(GetActiveForegroundSceneUpperCallbackIF& cb) const {
    GetActiveForegroundSceneUpperRequest* payload = new GetActiveForegroundSceneUpperRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getActiveForegroundSceneUpper", GetActiveForegroundSceneUpperRequest, payload, true)
    act_t act = addMethodCallback(ID_getActiveForegroundSceneUpper, dbusMessage.getUniqueSerial(), "getActiveForegroundSceneUpper", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetActiveForegroundSceneUpper", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiMonitorServiceProxy::sendSetHMIInfoServiceStatusRequest(SetHMIInfoServiceStatusCallbackIF& cb, bool hmiInfoStatus) const {
    SetHMIInfoServiceStatusRequest* payload = new SetHMIInfoServiceStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setHmiInfoStatus(hmiInfoStatus);
    DBUS_MESSAGE_CALL(dbusMessage, "setHMIInfoServiceStatus", SetHMIInfoServiceStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_setHMIInfoServiceStatus, dbusMessage.getUniqueSerial(), "setHMIInfoServiceStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetHMIInfoServiceStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiMonitorServiceProxy::sendGetNextActiveAppUpperRequest(GetNextActiveAppUpperCallbackIF& cb) const {
    GetNextActiveAppUpperRequest* payload = new GetNextActiveAppUpperRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getNextActiveAppUpper", GetNextActiveAppUpperRequest, payload, true)
    act_t act = addMethodCallback(ID_getNextActiveAppUpper, dbusMessage.getUniqueSerial(), "getNextActiveAppUpper", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetNextActiveAppUpper", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiMonitorServiceProxy::sendGetNextActiveAppLowerRequest(GetNextActiveAppLowerCallbackIF& cb) const {
    GetNextActiveAppLowerRequest* payload = new GetNextActiveAppLowerRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getNextActiveAppLower", GetNextActiveAppLowerRequest, payload, true)
    act_t act = addMethodCallback(ID_getNextActiveAppLower, dbusMessage.getUniqueSerial(), "getNextActiveAppLower", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetNextActiveAppLower", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace HmiMonitorService
} // namespace hmimonitorservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch
