#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICE_H
#define BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * todo
 */

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmimonitorservice {
namespace HmiMonitorService {

// method IDs
static const uint16 ID_getStartUpTimeInterval = 0;
static const uint16 ID_getActiveForegroundScene = 1;
static const uint16 ID_getActiveForegroundSceneUpper = 2;
static const uint16 ID_setHMIInfoServiceStatus = 3;
static const uint16 ID_getNextActiveAppUpper = 4;
static const uint16 ID_getNextActiveAppLower = 5;

// signal IDs

// property IDs
static const uint16 ID_activeRenderedViewName = 6;
static const uint16 ID_activeRenderedUpperViewName = 7;
static const uint16 ID_nextActiveAppUpper = 8;
static const uint16 ID_nextActiveAppLower = 9;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetStartUpTimeIntervalResponse;

class GetActiveForegroundSceneResponse;

class GetActiveForegroundSceneUpperResponse;

class SetHMIInfoServiceStatusRequest;

class GetNextActiveAppUpperResponse;

class GetNextActiveAppLowerResponse;

class ActiveRenderedViewNameUpdate;

class ActiveRenderedViewNameRegister;

class ActiveRenderedUpperViewNameUpdate;

class ActiveRenderedUpperViewNameRegister;

class NextActiveAppUpperUpdate;

class NextActiveAppUpperRegister;

class NextActiveAppLowerUpdate;

class NextActiveAppLowerRegister;

// type definitions
/**
 * Method to give startup time interval till OEM logo performance indicator
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetStartUpTimeIntervalRequest;

/**
 * If the meaning of "GetStartUpTimeIntervalError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetStartUpTimeIntervalError;

/**
 * Method to give active screen/popup on foreground
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetActiveForegroundSceneRequest;

/**
 * If the meaning of "GetActiveForegroundSceneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetActiveForegroundSceneError;

/**
 * Method to give active screen/popup on foreground in Upper Display
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetActiveForegroundSceneUpperRequest;

/**
 * If the meaning of "GetActiveForegroundSceneUpperError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetActiveForegroundSceneUpperError;

/**
 * Method to enable or disable HMIInfo service
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetHMIInfoServiceStatusResponse;

/**
 * If the meaning of "SetHMIInfoServiceStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetHMIInfoServiceStatusError;

/**
 * Method to give next active application Id of Upper display
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetNextActiveAppUpperRequest;

/**
 * If the meaning of "GetNextActiveAppUpperError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNextActiveAppUpperError;

/**
 * Method to give next active application Id of Lower display
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetNextActiveAppLowerRequest;

/**
 * If the meaning of "GetNextActiveAppLowerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNextActiveAppLowerError;

/**
 * Property to state the current active rendered view name
 */
typedef ActiveRenderedViewNameUpdate ActiveRenderedViewNameSet;

/**
 * Property to state the current active rendered view name
 */
typedef ActiveRenderedViewNameUpdate ActiveRenderedViewNameGet;

/**
 * If the meaning of "ActiveRenderedViewNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveRenderedViewNameError;

/**
 * Property to state the current active rendered view name
 */
typedef ActiveRenderedUpperViewNameUpdate ActiveRenderedUpperViewNameSet;

/**
 * Property to state the current active rendered view name
 */
typedef ActiveRenderedUpperViewNameUpdate ActiveRenderedUpperViewNameGet;

/**
 * If the meaning of "ActiveRenderedUpperViewNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveRenderedUpperViewNameError;

/**
 * Property to state the next active application in upper display
 */
typedef NextActiveAppUpperUpdate NextActiveAppUpperSet;

/**
 * Property to state the next active application in upper display
 */
typedef NextActiveAppUpperUpdate NextActiveAppUpperGet;

/**
 * If the meaning of "NextActiveAppUpperError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NextActiveAppUpperError;

/**
 * Property to state the next active application in lower display
 */
typedef NextActiveAppLowerUpdate NextActiveAppLowerSet;

/**
 * Property to state the next active application in lower display
 */
typedef NextActiveAppLowerUpdate NextActiveAppLowerGet;

/**
 * If the meaning of "NextActiveAppLowerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NextActiveAppLowerError;


/**
 * Method to give startup time interval till OEM logo performance indicator
 */
class GetStartUpTimeIntervalResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStartUpTimeIntervalResponse ();

    /**
     * Copy constructor
     */
    inline  GetStartUpTimeIntervalResponse (const GetStartUpTimeIntervalResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetStartUpTimeIntervalResponse (uint32 startUpTimeInterval_);

    /**
     * Destructor
     */
    inline virtual  ~GetStartUpTimeIntervalResponse();

    /**
     * Assignment operator
     */
    inline GetStartUpTimeIntervalResponse& operator = (const GetStartUpTimeIntervalResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStartUpTimeIntervalResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStartUpTimeIntervalResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStartUpTimeIntervalResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStartUpTimeIntervalResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "startUpTimeInterval"

    static const int kStartUpTimeInterval = 0;

    /**
     * Clears the field "startUpTimeInterval".
     *
     * The field will be set to its default value. The hasStartUpTimeInterval()
     * method will return false.
     */
    inline void clearStartUpTimeInterval();

    /**
     * Checks whether the field "startUpTimeInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartUpTimeInterval()). Otherwise it will return false.
     */
    inline bool hasStartUpTimeInterval () const;

    /**
     * Returns the value of the member "startUpTimeInterval".
     *
     * If the meaning of "startUpTimeInterval" isn't clear, then there should be a description here.
     *
     * @return The value of the field "startUpTimeInterval"
     */
    inline uint32 getStartUpTimeInterval () const;

    /**
     * Sets the value of the member "startUpTimeInterval".
     *
     * If the meaning of "startUpTimeInterval" isn't clear, then there should be a description here.
     *
     * @param startUpTimeInterval The value which will be set
     */
    inline void setStartUpTimeInterval (uint32 startUpTimeInterval_);

    static const GetStartUpTimeIntervalResponse &getDefaultInstance();

private:

    inline void set_has_startUpTimeInterval ();

    inline void clear_has_startUpTimeInterval ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _startUpTimeInterval;

};

/**
 * Method to give active screen/popup on foreground
 */
class GetActiveForegroundSceneResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetActiveForegroundSceneResponse ();

    /**
     * Copy constructor
     */
    inline  GetActiveForegroundSceneResponse (const GetActiveForegroundSceneResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetActiveForegroundSceneResponse (const ::std::string& activeSceneName_);

    /**
     * Destructor
     */
    inline virtual  ~GetActiveForegroundSceneResponse();

    /**
     * Assignment operator
     */
    inline GetActiveForegroundSceneResponse& operator = (const GetActiveForegroundSceneResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetActiveForegroundSceneResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetActiveForegroundSceneResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetActiveForegroundSceneResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetActiveForegroundSceneResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeSceneName"

    static const int kActiveSceneName = 0;

    /**
     * Clears the field "activeSceneName".
     *
     * The field will be set to its default value. The hasActiveSceneName()
     * method will return false.
     */
    inline void clearActiveSceneName();

    /**
     * Checks whether the field "activeSceneName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveSceneName()). Otherwise it will return false.
     */
    inline bool hasActiveSceneName () const;

    /**
     * Returns the value of the member "activeSceneName".
     *
     * If the meaning of "activeSceneName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activeSceneName"
     */
    inline const ::std::string& getActiveSceneName () const;

    /**
     * Retrieves the value of the field "activeSceneName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeSceneName".
     */
    inline ::std::string& getActiveSceneNameMutable ();

    /**
     * Sets the value of the member "activeSceneName".
     *
     * If the meaning of "activeSceneName" isn't clear, then there should be a description here.
     *
     * @param activeSceneName The value which will be set
     */
    inline void setActiveSceneName (const ::std::string& activeSceneName_);

    /**
     * Sets the value of the member "activeSceneName".
     *
     * If the meaning of "activeSceneName" isn't clear, then there should be a description here.
     *
     * @param activeSceneName The value which will be set
     */
    inline void setActiveSceneName (const char* activeSceneName_);

    /**
     * Sets the value of the member "activeSceneName".
     *
     * If the meaning of "activeSceneName" isn't clear, then there should be a description here.
     *
     * @param activeSceneName The value which will be set
     */
    inline void setActiveSceneName (const char* value, size_t size);

    static const GetActiveForegroundSceneResponse &getDefaultInstance();

private:

    inline void set_has_activeSceneName ();

    inline void clear_has_activeSceneName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _activeSceneName;

};

/**
 * Method to give active screen/popup on foreground in Upper Display
 */
class GetActiveForegroundSceneUpperResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetActiveForegroundSceneUpperResponse ();

    /**
     * Copy constructor
     */
    inline  GetActiveForegroundSceneUpperResponse (const GetActiveForegroundSceneUpperResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetActiveForegroundSceneUpperResponse (const ::std::string& activeSceneNameUpper_);

    /**
     * Destructor
     */
    inline virtual  ~GetActiveForegroundSceneUpperResponse();

    /**
     * Assignment operator
     */
    inline GetActiveForegroundSceneUpperResponse& operator = (const GetActiveForegroundSceneUpperResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetActiveForegroundSceneUpperResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetActiveForegroundSceneUpperResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetActiveForegroundSceneUpperResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetActiveForegroundSceneUpperResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeSceneNameUpper"

    static const int kActiveSceneNameUpper = 0;

    /**
     * Clears the field "activeSceneNameUpper".
     *
     * The field will be set to its default value. The hasActiveSceneNameUpper()
     * method will return false.
     */
    inline void clearActiveSceneNameUpper();

    /**
     * Checks whether the field "activeSceneNameUpper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveSceneNameUpper()). Otherwise it will return false.
     */
    inline bool hasActiveSceneNameUpper () const;

    /**
     * Returns the value of the member "activeSceneNameUpper".
     *
     * If the meaning of "activeSceneNameUpper" isn't clear, then there should be a description here.
     *
     * @return The value of the field "activeSceneNameUpper"
     */
    inline const ::std::string& getActiveSceneNameUpper () const;

    /**
     * Retrieves the value of the field "activeSceneNameUpper" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeSceneNameUpper".
     */
    inline ::std::string& getActiveSceneNameUpperMutable ();

    /**
     * Sets the value of the member "activeSceneNameUpper".
     *
     * If the meaning of "activeSceneNameUpper" isn't clear, then there should be a description here.
     *
     * @param activeSceneNameUpper The value which will be set
     */
    inline void setActiveSceneNameUpper (const ::std::string& activeSceneNameUpper_);

    /**
     * Sets the value of the member "activeSceneNameUpper".
     *
     * If the meaning of "activeSceneNameUpper" isn't clear, then there should be a description here.
     *
     * @param activeSceneNameUpper The value which will be set
     */
    inline void setActiveSceneNameUpper (const char* activeSceneNameUpper_);

    /**
     * Sets the value of the member "activeSceneNameUpper".
     *
     * If the meaning of "activeSceneNameUpper" isn't clear, then there should be a description here.
     *
     * @param activeSceneNameUpper The value which will be set
     */
    inline void setActiveSceneNameUpper (const char* value, size_t size);

    static const GetActiveForegroundSceneUpperResponse &getDefaultInstance();

private:

    inline void set_has_activeSceneNameUpper ();

    inline void clear_has_activeSceneNameUpper ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _activeSceneNameUpper;

};

/**
 * Method to enable or disable HMIInfo service
 */
class SetHMIInfoServiceStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetHMIInfoServiceStatusRequest ();

    /**
     * Copy constructor
     */
    inline  SetHMIInfoServiceStatusRequest (const SetHMIInfoServiceStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetHMIInfoServiceStatusRequest (bool hmiInfoStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetHMIInfoServiceStatusRequest();

    /**
     * Assignment operator
     */
    inline SetHMIInfoServiceStatusRequest& operator = (const SetHMIInfoServiceStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetHMIInfoServiceStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetHMIInfoServiceStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetHMIInfoServiceStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetHMIInfoServiceStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "hmiInfoStatus"

    static const int kHmiInfoStatus = 0;

    /**
     * Clears the field "hmiInfoStatus".
     *
     * The field will be set to its default value. The hasHmiInfoStatus()
     * method will return false.
     */
    inline void clearHmiInfoStatus();

    /**
     * Checks whether the field "hmiInfoStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiInfoStatus()). Otherwise it will return false.
     */
    inline bool hasHmiInfoStatus () const;

    /**
     * Returns the value of the member "hmiInfoStatus".
     *
     * If the meaning of "hmiInfoStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hmiInfoStatus"
     */
    inline bool getHmiInfoStatus () const;

    /**
     * Sets the value of the member "hmiInfoStatus".
     *
     * If the meaning of "hmiInfoStatus" isn't clear, then there should be a description here.
     *
     * @param hmiInfoStatus The value which will be set
     */
    inline void setHmiInfoStatus (bool hmiInfoStatus_);

    static const SetHMIInfoServiceStatusRequest &getDefaultInstance();

private:

    inline void set_has_hmiInfoStatus ();

    inline void clear_has_hmiInfoStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _hmiInfoStatus;

};

/**
 * Method to give next active application Id of Upper display
 */
class GetNextActiveAppUpperResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNextActiveAppUpperResponse ();

    /**
     * Copy constructor
     */
    inline  GetNextActiveAppUpperResponse (const GetNextActiveAppUpperResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNextActiveAppUpperResponse (const ::std::string& appIdUpper_);

    /**
     * Destructor
     */
    inline virtual  ~GetNextActiveAppUpperResponse();

    /**
     * Assignment operator
     */
    inline GetNextActiveAppUpperResponse& operator = (const GetNextActiveAppUpperResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNextActiveAppUpperResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNextActiveAppUpperResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNextActiveAppUpperResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNextActiveAppUpperResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appIdUpper"

    static const int kAppIdUpper = 0;

    /**
     * Clears the field "appIdUpper".
     *
     * The field will be set to its default value. The hasAppIdUpper()
     * method will return false.
     */
    inline void clearAppIdUpper();

    /**
     * Checks whether the field "appIdUpper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppIdUpper()). Otherwise it will return false.
     */
    inline bool hasAppIdUpper () const;

    /**
     * Returns the value of the member "appIdUpper".
     *
     * If the meaning of "appIdUpper" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appIdUpper"
     */
    inline const ::std::string& getAppIdUpper () const;

    /**
     * Retrieves the value of the field "appIdUpper" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appIdUpper".
     */
    inline ::std::string& getAppIdUpperMutable ();

    /**
     * Sets the value of the member "appIdUpper".
     *
     * If the meaning of "appIdUpper" isn't clear, then there should be a description here.
     *
     * @param appIdUpper The value which will be set
     */
    inline void setAppIdUpper (const ::std::string& appIdUpper_);

    /**
     * Sets the value of the member "appIdUpper".
     *
     * If the meaning of "appIdUpper" isn't clear, then there should be a description here.
     *
     * @param appIdUpper The value which will be set
     */
    inline void setAppIdUpper (const char* appIdUpper_);

    /**
     * Sets the value of the member "appIdUpper".
     *
     * If the meaning of "appIdUpper" isn't clear, then there should be a description here.
     *
     * @param appIdUpper The value which will be set
     */
    inline void setAppIdUpper (const char* value, size_t size);

    static const GetNextActiveAppUpperResponse &getDefaultInstance();

private:

    inline void set_has_appIdUpper ();

    inline void clear_has_appIdUpper ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _appIdUpper;

};

/**
 * Method to give next active application Id of Lower display
 */
class GetNextActiveAppLowerResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNextActiveAppLowerResponse ();

    /**
     * Copy constructor
     */
    inline  GetNextActiveAppLowerResponse (const GetNextActiveAppLowerResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNextActiveAppLowerResponse (const ::std::string& appIdLower_);

    /**
     * Destructor
     */
    inline virtual  ~GetNextActiveAppLowerResponse();

    /**
     * Assignment operator
     */
    inline GetNextActiveAppLowerResponse& operator = (const GetNextActiveAppLowerResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNextActiveAppLowerResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNextActiveAppLowerResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNextActiveAppLowerResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNextActiveAppLowerResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appIdLower"

    static const int kAppIdLower = 0;

    /**
     * Clears the field "appIdLower".
     *
     * The field will be set to its default value. The hasAppIdLower()
     * method will return false.
     */
    inline void clearAppIdLower();

    /**
     * Checks whether the field "appIdLower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppIdLower()). Otherwise it will return false.
     */
    inline bool hasAppIdLower () const;

    /**
     * Returns the value of the member "appIdLower".
     *
     * If the meaning of "appIdLower" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appIdLower"
     */
    inline const ::std::string& getAppIdLower () const;

    /**
     * Retrieves the value of the field "appIdLower" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "appIdLower".
     */
    inline ::std::string& getAppIdLowerMutable ();

    /**
     * Sets the value of the member "appIdLower".
     *
     * If the meaning of "appIdLower" isn't clear, then there should be a description here.
     *
     * @param appIdLower The value which will be set
     */
    inline void setAppIdLower (const ::std::string& appIdLower_);

    /**
     * Sets the value of the member "appIdLower".
     *
     * If the meaning of "appIdLower" isn't clear, then there should be a description here.
     *
     * @param appIdLower The value which will be set
     */
    inline void setAppIdLower (const char* appIdLower_);

    /**
     * Sets the value of the member "appIdLower".
     *
     * If the meaning of "appIdLower" isn't clear, then there should be a description here.
     *
     * @param appIdLower The value which will be set
     */
    inline void setAppIdLower (const char* value, size_t size);

    static const GetNextActiveAppLowerResponse &getDefaultInstance();

private:

    inline void set_has_appIdLower ();

    inline void clear_has_appIdLower ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _appIdLower;

};

/**
 * Property to state the current active rendered view name
 */
class ActiveRenderedViewNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRenderedViewNameUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveRenderedViewNameUpdate (const ActiveRenderedViewNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveRenderedViewNameUpdate (const ::std::string& activeRenderedViewName_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveRenderedViewNameUpdate();

    /**
     * Assignment operator
     */
    inline ActiveRenderedViewNameUpdate& operator = (const ActiveRenderedViewNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRenderedViewNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRenderedViewNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRenderedViewNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRenderedViewNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeRenderedViewName"

    static const int kActiveRenderedViewName = 0;

    /**
     * Clears the field "activeRenderedViewName".
     *
     * The field will be set to its default value. The hasActiveRenderedViewName()
     * method will return false.
     */
    inline void clearActiveRenderedViewName();

    /**
     * Checks whether the field "activeRenderedViewName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveRenderedViewName()). Otherwise it will return false.
     */
    inline bool hasActiveRenderedViewName () const;

    /**
     * Returns the value of the member "activeRenderedViewName".
     *
     * Property to state the current active rendered view name
     *
     * @return The value of the field "activeRenderedViewName"
     */
    inline const ::std::string& getActiveRenderedViewName () const;

    /**
     * Retrieves the value of the field "activeRenderedViewName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeRenderedViewName".
     */
    inline ::std::string& getActiveRenderedViewNameMutable ();

    /**
     * Sets the value of the member "activeRenderedViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedViewName The value which will be set
     */
    inline void setActiveRenderedViewName (const ::std::string& activeRenderedViewName_);

    /**
     * Sets the value of the member "activeRenderedViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedViewName The value which will be set
     */
    inline void setActiveRenderedViewName (const char* activeRenderedViewName_);

    /**
     * Sets the value of the member "activeRenderedViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedViewName The value which will be set
     */
    inline void setActiveRenderedViewName (const char* value, size_t size);

    static const ActiveRenderedViewNameUpdate &getDefaultInstance();

private:

    inline void set_has_activeRenderedViewName ();

    inline void clear_has_activeRenderedViewName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _activeRenderedViewName;

};

/**
 * Property to state the current active rendered view name
 */
class ActiveRenderedViewNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRenderedViewNameRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveRenderedViewNameRegister (const ActiveRenderedViewNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveRenderedViewNameRegister();

    /**
     * Assignment operator
     */
    inline ActiveRenderedViewNameRegister& operator = (const ActiveRenderedViewNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRenderedViewNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRenderedViewNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRenderedViewNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRenderedViewNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveRenderedViewNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the current active rendered view name
 */
class ActiveRenderedUpperViewNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRenderedUpperViewNameUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveRenderedUpperViewNameUpdate (const ActiveRenderedUpperViewNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveRenderedUpperViewNameUpdate (const ::std::string& activeRenderedUpperViewName_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveRenderedUpperViewNameUpdate();

    /**
     * Assignment operator
     */
    inline ActiveRenderedUpperViewNameUpdate& operator = (const ActiveRenderedUpperViewNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRenderedUpperViewNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRenderedUpperViewNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRenderedUpperViewNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRenderedUpperViewNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeRenderedUpperViewName"

    static const int kActiveRenderedUpperViewName = 0;

    /**
     * Clears the field "activeRenderedUpperViewName".
     *
     * The field will be set to its default value. The hasActiveRenderedUpperViewName()
     * method will return false.
     */
    inline void clearActiveRenderedUpperViewName();

    /**
     * Checks whether the field "activeRenderedUpperViewName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveRenderedUpperViewName()). Otherwise it will return false.
     */
    inline bool hasActiveRenderedUpperViewName () const;

    /**
     * Returns the value of the member "activeRenderedUpperViewName".
     *
     * Property to state the current active rendered view name
     *
     * @return The value of the field "activeRenderedUpperViewName"
     */
    inline const ::std::string& getActiveRenderedUpperViewName () const;

    /**
     * Retrieves the value of the field "activeRenderedUpperViewName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "activeRenderedUpperViewName".
     */
    inline ::std::string& getActiveRenderedUpperViewNameMutable ();

    /**
     * Sets the value of the member "activeRenderedUpperViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedUpperViewName The value which will be set
     */
    inline void setActiveRenderedUpperViewName (const ::std::string& activeRenderedUpperViewName_);

    /**
     * Sets the value of the member "activeRenderedUpperViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedUpperViewName The value which will be set
     */
    inline void setActiveRenderedUpperViewName (const char* activeRenderedUpperViewName_);

    /**
     * Sets the value of the member "activeRenderedUpperViewName".
     *
     * Property to state the current active rendered view name
     *
     * @param activeRenderedUpperViewName The value which will be set
     */
    inline void setActiveRenderedUpperViewName (const char* value, size_t size);

    static const ActiveRenderedUpperViewNameUpdate &getDefaultInstance();

private:

    inline void set_has_activeRenderedUpperViewName ();

    inline void clear_has_activeRenderedUpperViewName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _activeRenderedUpperViewName;

};

/**
 * Property to state the current active rendered view name
 */
class ActiveRenderedUpperViewNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRenderedUpperViewNameRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveRenderedUpperViewNameRegister (const ActiveRenderedUpperViewNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveRenderedUpperViewNameRegister();

    /**
     * Assignment operator
     */
    inline ActiveRenderedUpperViewNameRegister& operator = (const ActiveRenderedUpperViewNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRenderedUpperViewNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRenderedUpperViewNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRenderedUpperViewNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRenderedUpperViewNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveRenderedUpperViewNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the next active application in upper display
 */
class NextActiveAppUpperUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextActiveAppUpperUpdate ();

    /**
     * Copy constructor
     */
    inline  NextActiveAppUpperUpdate (const NextActiveAppUpperUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NextActiveAppUpperUpdate (const ::std::string& nextActiveAppUpper_);

    /**
     * Destructor
     */
    inline virtual  ~NextActiveAppUpperUpdate();

    /**
     * Assignment operator
     */
    inline NextActiveAppUpperUpdate& operator = (const NextActiveAppUpperUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextActiveAppUpperUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextActiveAppUpperUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextActiveAppUpperUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextActiveAppUpperUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nextActiveAppUpper"

    static const int kNextActiveAppUpper = 0;

    /**
     * Clears the field "nextActiveAppUpper".
     *
     * The field will be set to its default value. The hasNextActiveAppUpper()
     * method will return false.
     */
    inline void clearNextActiveAppUpper();

    /**
     * Checks whether the field "nextActiveAppUpper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextActiveAppUpper()). Otherwise it will return false.
     */
    inline bool hasNextActiveAppUpper () const;

    /**
     * Returns the value of the member "nextActiveAppUpper".
     *
     * Property to state the next active application in upper display
     *
     * @return The value of the field "nextActiveAppUpper"
     */
    inline const ::std::string& getNextActiveAppUpper () const;

    /**
     * Retrieves the value of the field "nextActiveAppUpper" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "nextActiveAppUpper".
     */
    inline ::std::string& getNextActiveAppUpperMutable ();

    /**
     * Sets the value of the member "nextActiveAppUpper".
     *
     * Property to state the next active application in upper display
     *
     * @param nextActiveAppUpper The value which will be set
     */
    inline void setNextActiveAppUpper (const ::std::string& nextActiveAppUpper_);

    /**
     * Sets the value of the member "nextActiveAppUpper".
     *
     * Property to state the next active application in upper display
     *
     * @param nextActiveAppUpper The value which will be set
     */
    inline void setNextActiveAppUpper (const char* nextActiveAppUpper_);

    /**
     * Sets the value of the member "nextActiveAppUpper".
     *
     * Property to state the next active application in upper display
     *
     * @param nextActiveAppUpper The value which will be set
     */
    inline void setNextActiveAppUpper (const char* value, size_t size);

    static const NextActiveAppUpperUpdate &getDefaultInstance();

private:

    inline void set_has_nextActiveAppUpper ();

    inline void clear_has_nextActiveAppUpper ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _nextActiveAppUpper;

};

/**
 * Property to state the next active application in upper display
 */
class NextActiveAppUpperRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextActiveAppUpperRegister ();

    /**
     * Copy constructor
     */
    inline  NextActiveAppUpperRegister (const NextActiveAppUpperRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NextActiveAppUpperRegister();

    /**
     * Assignment operator
     */
    inline NextActiveAppUpperRegister& operator = (const NextActiveAppUpperRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextActiveAppUpperRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextActiveAppUpperRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextActiveAppUpperRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextActiveAppUpperRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NextActiveAppUpperRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the next active application in lower display
 */
class NextActiveAppLowerUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextActiveAppLowerUpdate ();

    /**
     * Copy constructor
     */
    inline  NextActiveAppLowerUpdate (const NextActiveAppLowerUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NextActiveAppLowerUpdate (const ::std::string& nextActiveAppLower_);

    /**
     * Destructor
     */
    inline virtual  ~NextActiveAppLowerUpdate();

    /**
     * Assignment operator
     */
    inline NextActiveAppLowerUpdate& operator = (const NextActiveAppLowerUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextActiveAppLowerUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextActiveAppLowerUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextActiveAppLowerUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextActiveAppLowerUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "nextActiveAppLower"

    static const int kNextActiveAppLower = 0;

    /**
     * Clears the field "nextActiveAppLower".
     *
     * The field will be set to its default value. The hasNextActiveAppLower()
     * method will return false.
     */
    inline void clearNextActiveAppLower();

    /**
     * Checks whether the field "nextActiveAppLower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextActiveAppLower()). Otherwise it will return false.
     */
    inline bool hasNextActiveAppLower () const;

    /**
     * Returns the value of the member "nextActiveAppLower".
     *
     * Property to state the next active application in lower display
     *
     * @return The value of the field "nextActiveAppLower"
     */
    inline const ::std::string& getNextActiveAppLower () const;

    /**
     * Retrieves the value of the field "nextActiveAppLower" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "nextActiveAppLower".
     */
    inline ::std::string& getNextActiveAppLowerMutable ();

    /**
     * Sets the value of the member "nextActiveAppLower".
     *
     * Property to state the next active application in lower display
     *
     * @param nextActiveAppLower The value which will be set
     */
    inline void setNextActiveAppLower (const ::std::string& nextActiveAppLower_);

    /**
     * Sets the value of the member "nextActiveAppLower".
     *
     * Property to state the next active application in lower display
     *
     * @param nextActiveAppLower The value which will be set
     */
    inline void setNextActiveAppLower (const char* nextActiveAppLower_);

    /**
     * Sets the value of the member "nextActiveAppLower".
     *
     * Property to state the next active application in lower display
     *
     * @param nextActiveAppLower The value which will be set
     */
    inline void setNextActiveAppLower (const char* value, size_t size);

    static const NextActiveAppLowerUpdate &getDefaultInstance();

private:

    inline void set_has_nextActiveAppLower ();

    inline void clear_has_nextActiveAppLower ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _nextActiveAppLower;

};

/**
 * Property to state the next active application in lower display
 */
class NextActiveAppLowerRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NextActiveAppLowerRegister ();

    /**
     * Copy constructor
     */
    inline  NextActiveAppLowerRegister (const NextActiveAppLowerRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NextActiveAppLowerRegister();

    /**
     * Assignment operator
     */
    inline NextActiveAppLowerRegister& operator = (const NextActiveAppLowerRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NextActiveAppLowerRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NextActiveAppLowerRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NextActiveAppLowerRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NextActiveAppLowerRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NextActiveAppLowerRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetStartUpTimeIntervalResponse::GetStartUpTimeIntervalResponse ()  :
    _startUpTimeInterval (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStartUpTimeIntervalResponse::GetStartUpTimeIntervalResponse (const GetStartUpTimeIntervalResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _startUpTimeInterval (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStartUpTimeIntervalResponse::GetStartUpTimeIntervalResponse (uint32 startUpTimeInterval_)  :
    _startUpTimeInterval (startUpTimeInterval_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStartUpTimeIntervalResponse::~GetStartUpTimeIntervalResponse() {
}

inline GetStartUpTimeIntervalResponse& GetStartUpTimeIntervalResponse::operator = (const GetStartUpTimeIntervalResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStartUpTimeInterval()) {
            setStartUpTimeInterval(rhs.getStartUpTimeInterval());
        } else {
            clearStartUpTimeInterval();
        }
    }
    return *this;
}

inline bool GetStartUpTimeIntervalResponse::operator == (const GetStartUpTimeIntervalResponse& rhs) const {
    return (((!hasStartUpTimeInterval() && !rhs.hasStartUpTimeInterval()) || getStartUpTimeInterval() == rhs.getStartUpTimeInterval()));
}

inline bool GetStartUpTimeIntervalResponse::operator != (const GetStartUpTimeIntervalResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStartUpTimeIntervalResponse::operator < (const GetStartUpTimeIntervalResponse& rhs) const {
    if (hasStartUpTimeInterval() || rhs.hasStartUpTimeInterval()) {
        if (getStartUpTimeInterval() < rhs.getStartUpTimeInterval()) return true;
        if (getStartUpTimeInterval() > rhs.getStartUpTimeInterval()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStartUpTimeIntervalResponse::clone() {
    return new GetStartUpTimeIntervalResponse(*this);
}

inline bool GetStartUpTimeIntervalResponse::operator > (const GetStartUpTimeIntervalResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStartUpTimeIntervalResponse::clear() {
    clearStartUpTimeInterval();
}

inline void GetStartUpTimeIntervalResponse::clearStartUpTimeInterval() {
    if (hasStartUpTimeInterval()) {
         clear_has_startUpTimeInterval();
        _startUpTimeInterval = 0u;
     }
}

inline bool GetStartUpTimeIntervalResponse::hasStartUpTimeInterval () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetStartUpTimeIntervalResponse::getStartUpTimeInterval () const {
    return _startUpTimeInterval;
}

inline void GetStartUpTimeIntervalResponse::setStartUpTimeInterval (uint32 startUpTimeInterval_) {
    set_has_startUpTimeInterval();
    this->_startUpTimeInterval = startUpTimeInterval_;
}

inline void GetStartUpTimeIntervalResponse::set_has_startUpTimeInterval () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStartUpTimeIntervalResponse::clear_has_startUpTimeInterval () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetActiveForegroundSceneResponse::GetActiveForegroundSceneResponse ()  :
    _activeSceneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetActiveForegroundSceneResponse::GetActiveForegroundSceneResponse (const GetActiveForegroundSceneResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _activeSceneName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetActiveForegroundSceneResponse::GetActiveForegroundSceneResponse (const ::std::string& activeSceneName_)  :
    _activeSceneName (activeSceneName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetActiveForegroundSceneResponse::~GetActiveForegroundSceneResponse() {
}

inline GetActiveForegroundSceneResponse& GetActiveForegroundSceneResponse::operator = (const GetActiveForegroundSceneResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveSceneName()) {
            setActiveSceneName(rhs.getActiveSceneName());
        } else {
            clearActiveSceneName();
        }
    }
    return *this;
}

inline bool GetActiveForegroundSceneResponse::operator == (const GetActiveForegroundSceneResponse& rhs) const {
    return (((!hasActiveSceneName() && !rhs.hasActiveSceneName()) || getActiveSceneName() == rhs.getActiveSceneName()));
}

inline bool GetActiveForegroundSceneResponse::operator != (const GetActiveForegroundSceneResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetActiveForegroundSceneResponse::operator < (const GetActiveForegroundSceneResponse& rhs) const {
    if (hasActiveSceneName() || rhs.hasActiveSceneName()) {
        if (getActiveSceneName() < rhs.getActiveSceneName()) return true;
        if (getActiveSceneName() > rhs.getActiveSceneName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetActiveForegroundSceneResponse::clone() {
    return new GetActiveForegroundSceneResponse(*this);
}

inline bool GetActiveForegroundSceneResponse::operator > (const GetActiveForegroundSceneResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetActiveForegroundSceneResponse::clear() {
    clearActiveSceneName();
}

inline void GetActiveForegroundSceneResponse::clearActiveSceneName() {
    if (hasActiveSceneName()) {
         clear_has_activeSceneName();
        _activeSceneName.clear();
     }
}

inline bool GetActiveForegroundSceneResponse::hasActiveSceneName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetActiveForegroundSceneResponse::getActiveSceneName () const {
    return _activeSceneName;
}

inline ::std::string& GetActiveForegroundSceneResponse::getActiveSceneNameMutable () {
    set_has_activeSceneName();
    return _activeSceneName;
}

inline void GetActiveForegroundSceneResponse::setActiveSceneName (const ::std::string& activeSceneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneName();
    this->_activeSceneName = activeSceneName_;
}

inline void GetActiveForegroundSceneResponse::setActiveSceneName (const char* activeSceneName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneName();
    this->_activeSceneName.assign(activeSceneName_);
}

inline void GetActiveForegroundSceneResponse::setActiveSceneName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneName();
    this->_activeSceneName.assign(value, size);
}

inline void GetActiveForegroundSceneResponse::set_has_activeSceneName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetActiveForegroundSceneResponse::clear_has_activeSceneName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetActiveForegroundSceneUpperResponse::GetActiveForegroundSceneUpperResponse ()  :
    _activeSceneNameUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetActiveForegroundSceneUpperResponse::GetActiveForegroundSceneUpperResponse (const GetActiveForegroundSceneUpperResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _activeSceneNameUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetActiveForegroundSceneUpperResponse::GetActiveForegroundSceneUpperResponse (const ::std::string& activeSceneNameUpper_)  :
    _activeSceneNameUpper (activeSceneNameUpper_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneNameUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetActiveForegroundSceneUpperResponse::~GetActiveForegroundSceneUpperResponse() {
}

inline GetActiveForegroundSceneUpperResponse& GetActiveForegroundSceneUpperResponse::operator = (const GetActiveForegroundSceneUpperResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveSceneNameUpper()) {
            setActiveSceneNameUpper(rhs.getActiveSceneNameUpper());
        } else {
            clearActiveSceneNameUpper();
        }
    }
    return *this;
}

inline bool GetActiveForegroundSceneUpperResponse::operator == (const GetActiveForegroundSceneUpperResponse& rhs) const {
    return (((!hasActiveSceneNameUpper() && !rhs.hasActiveSceneNameUpper()) || getActiveSceneNameUpper() == rhs.getActiveSceneNameUpper()));
}

inline bool GetActiveForegroundSceneUpperResponse::operator != (const GetActiveForegroundSceneUpperResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetActiveForegroundSceneUpperResponse::operator < (const GetActiveForegroundSceneUpperResponse& rhs) const {
    if (hasActiveSceneNameUpper() || rhs.hasActiveSceneNameUpper()) {
        if (getActiveSceneNameUpper() < rhs.getActiveSceneNameUpper()) return true;
        if (getActiveSceneNameUpper() > rhs.getActiveSceneNameUpper()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetActiveForegroundSceneUpperResponse::clone() {
    return new GetActiveForegroundSceneUpperResponse(*this);
}

inline bool GetActiveForegroundSceneUpperResponse::operator > (const GetActiveForegroundSceneUpperResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetActiveForegroundSceneUpperResponse::clear() {
    clearActiveSceneNameUpper();
}

inline void GetActiveForegroundSceneUpperResponse::clearActiveSceneNameUpper() {
    if (hasActiveSceneNameUpper()) {
         clear_has_activeSceneNameUpper();
        _activeSceneNameUpper.clear();
     }
}

inline bool GetActiveForegroundSceneUpperResponse::hasActiveSceneNameUpper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetActiveForegroundSceneUpperResponse::getActiveSceneNameUpper () const {
    return _activeSceneNameUpper;
}

inline ::std::string& GetActiveForegroundSceneUpperResponse::getActiveSceneNameUpperMutable () {
    set_has_activeSceneNameUpper();
    return _activeSceneNameUpper;
}

inline void GetActiveForegroundSceneUpperResponse::setActiveSceneNameUpper (const ::std::string& activeSceneNameUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneNameUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneNameUpper();
    this->_activeSceneNameUpper = activeSceneNameUpper_;
}

inline void GetActiveForegroundSceneUpperResponse::setActiveSceneNameUpper (const char* activeSceneNameUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeSceneNameUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneNameUpper();
    this->_activeSceneNameUpper.assign(activeSceneNameUpper_);
}

inline void GetActiveForegroundSceneUpperResponse::setActiveSceneNameUpper (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeSceneNameUpper();
    this->_activeSceneNameUpper.assign(value, size);
}

inline void GetActiveForegroundSceneUpperResponse::set_has_activeSceneNameUpper () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetActiveForegroundSceneUpperResponse::clear_has_activeSceneNameUpper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetHMIInfoServiceStatusRequest::SetHMIInfoServiceStatusRequest ()  :
    _hmiInfoStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetHMIInfoServiceStatusRequest::SetHMIInfoServiceStatusRequest (const SetHMIInfoServiceStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _hmiInfoStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetHMIInfoServiceStatusRequest::SetHMIInfoServiceStatusRequest (bool hmiInfoStatus_)  :
    _hmiInfoStatus (hmiInfoStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetHMIInfoServiceStatusRequest::~SetHMIInfoServiceStatusRequest() {
}

inline SetHMIInfoServiceStatusRequest& SetHMIInfoServiceStatusRequest::operator = (const SetHMIInfoServiceStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHmiInfoStatus()) {
            setHmiInfoStatus(rhs.getHmiInfoStatus());
        } else {
            clearHmiInfoStatus();
        }
    }
    return *this;
}

inline bool SetHMIInfoServiceStatusRequest::operator == (const SetHMIInfoServiceStatusRequest& rhs) const {
    return (((!hasHmiInfoStatus() && !rhs.hasHmiInfoStatus()) || getHmiInfoStatus() == rhs.getHmiInfoStatus()));
}

inline bool SetHMIInfoServiceStatusRequest::operator != (const SetHMIInfoServiceStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetHMIInfoServiceStatusRequest::operator < (const SetHMIInfoServiceStatusRequest& rhs) const {
    if (hasHmiInfoStatus() || rhs.hasHmiInfoStatus()) {
        if (getHmiInfoStatus() < rhs.getHmiInfoStatus()) return true;
        if (getHmiInfoStatus() > rhs.getHmiInfoStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetHMIInfoServiceStatusRequest::clone() {
    return new SetHMIInfoServiceStatusRequest(*this);
}

inline bool SetHMIInfoServiceStatusRequest::operator > (const SetHMIInfoServiceStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetHMIInfoServiceStatusRequest::clear() {
    clearHmiInfoStatus();
}

inline void SetHMIInfoServiceStatusRequest::clearHmiInfoStatus() {
    if (hasHmiInfoStatus()) {
         clear_has_hmiInfoStatus();
        _hmiInfoStatus = false;
     }
}

inline bool SetHMIInfoServiceStatusRequest::hasHmiInfoStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetHMIInfoServiceStatusRequest::getHmiInfoStatus () const {
    return _hmiInfoStatus;
}

inline void SetHMIInfoServiceStatusRequest::setHmiInfoStatus (bool hmiInfoStatus_) {
    set_has_hmiInfoStatus();
    this->_hmiInfoStatus = hmiInfoStatus_;
}

inline void SetHMIInfoServiceStatusRequest::set_has_hmiInfoStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetHMIInfoServiceStatusRequest::clear_has_hmiInfoStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNextActiveAppUpperResponse::GetNextActiveAppUpperResponse ()  :
    _appIdUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNextActiveAppUpperResponse::GetNextActiveAppUpperResponse (const GetNextActiveAppUpperResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _appIdUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNextActiveAppUpperResponse::GetNextActiveAppUpperResponse (const ::std::string& appIdUpper_)  :
    _appIdUpper (appIdUpper_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNextActiveAppUpperResponse::~GetNextActiveAppUpperResponse() {
}

inline GetNextActiveAppUpperResponse& GetNextActiveAppUpperResponse::operator = (const GetNextActiveAppUpperResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppIdUpper()) {
            setAppIdUpper(rhs.getAppIdUpper());
        } else {
            clearAppIdUpper();
        }
    }
    return *this;
}

inline bool GetNextActiveAppUpperResponse::operator == (const GetNextActiveAppUpperResponse& rhs) const {
    return (((!hasAppIdUpper() && !rhs.hasAppIdUpper()) || getAppIdUpper() == rhs.getAppIdUpper()));
}

inline bool GetNextActiveAppUpperResponse::operator != (const GetNextActiveAppUpperResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNextActiveAppUpperResponse::operator < (const GetNextActiveAppUpperResponse& rhs) const {
    if (hasAppIdUpper() || rhs.hasAppIdUpper()) {
        if (getAppIdUpper() < rhs.getAppIdUpper()) return true;
        if (getAppIdUpper() > rhs.getAppIdUpper()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNextActiveAppUpperResponse::clone() {
    return new GetNextActiveAppUpperResponse(*this);
}

inline bool GetNextActiveAppUpperResponse::operator > (const GetNextActiveAppUpperResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNextActiveAppUpperResponse::clear() {
    clearAppIdUpper();
}

inline void GetNextActiveAppUpperResponse::clearAppIdUpper() {
    if (hasAppIdUpper()) {
         clear_has_appIdUpper();
        _appIdUpper.clear();
     }
}

inline bool GetNextActiveAppUpperResponse::hasAppIdUpper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNextActiveAppUpperResponse::getAppIdUpper () const {
    return _appIdUpper;
}

inline ::std::string& GetNextActiveAppUpperResponse::getAppIdUpperMutable () {
    set_has_appIdUpper();
    return _appIdUpper;
}

inline void GetNextActiveAppUpperResponse::setAppIdUpper (const ::std::string& appIdUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdUpper();
    this->_appIdUpper = appIdUpper_;
}

inline void GetNextActiveAppUpperResponse::setAppIdUpper (const char* appIdUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdUpper();
    this->_appIdUpper.assign(appIdUpper_);
}

inline void GetNextActiveAppUpperResponse::setAppIdUpper (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdUpper();
    this->_appIdUpper.assign(value, size);
}

inline void GetNextActiveAppUpperResponse::set_has_appIdUpper () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNextActiveAppUpperResponse::clear_has_appIdUpper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNextActiveAppLowerResponse::GetNextActiveAppLowerResponse ()  :
    _appIdLower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNextActiveAppLowerResponse::GetNextActiveAppLowerResponse (const GetNextActiveAppLowerResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _appIdLower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNextActiveAppLowerResponse::GetNextActiveAppLowerResponse (const ::std::string& appIdLower_)  :
    _appIdLower (appIdLower_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdLower_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNextActiveAppLowerResponse::~GetNextActiveAppLowerResponse() {
}

inline GetNextActiveAppLowerResponse& GetNextActiveAppLowerResponse::operator = (const GetNextActiveAppLowerResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppIdLower()) {
            setAppIdLower(rhs.getAppIdLower());
        } else {
            clearAppIdLower();
        }
    }
    return *this;
}

inline bool GetNextActiveAppLowerResponse::operator == (const GetNextActiveAppLowerResponse& rhs) const {
    return (((!hasAppIdLower() && !rhs.hasAppIdLower()) || getAppIdLower() == rhs.getAppIdLower()));
}

inline bool GetNextActiveAppLowerResponse::operator != (const GetNextActiveAppLowerResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNextActiveAppLowerResponse::operator < (const GetNextActiveAppLowerResponse& rhs) const {
    if (hasAppIdLower() || rhs.hasAppIdLower()) {
        if (getAppIdLower() < rhs.getAppIdLower()) return true;
        if (getAppIdLower() > rhs.getAppIdLower()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNextActiveAppLowerResponse::clone() {
    return new GetNextActiveAppLowerResponse(*this);
}

inline bool GetNextActiveAppLowerResponse::operator > (const GetNextActiveAppLowerResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNextActiveAppLowerResponse::clear() {
    clearAppIdLower();
}

inline void GetNextActiveAppLowerResponse::clearAppIdLower() {
    if (hasAppIdLower()) {
         clear_has_appIdLower();
        _appIdLower.clear();
     }
}

inline bool GetNextActiveAppLowerResponse::hasAppIdLower () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNextActiveAppLowerResponse::getAppIdLower () const {
    return _appIdLower;
}

inline ::std::string& GetNextActiveAppLowerResponse::getAppIdLowerMutable () {
    set_has_appIdLower();
    return _appIdLower;
}

inline void GetNextActiveAppLowerResponse::setAppIdLower (const ::std::string& appIdLower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdLower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdLower();
    this->_appIdLower = appIdLower_;
}

inline void GetNextActiveAppLowerResponse::setAppIdLower (const char* appIdLower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (appIdLower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdLower();
    this->_appIdLower.assign(appIdLower_);
}

inline void GetNextActiveAppLowerResponse::setAppIdLower (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_appIdLower();
    this->_appIdLower.assign(value, size);
}

inline void GetNextActiveAppLowerResponse::set_has_appIdLower () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNextActiveAppLowerResponse::clear_has_appIdLower () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveRenderedViewNameUpdate::ActiveRenderedViewNameUpdate ()  :
    _activeRenderedViewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRenderedViewNameUpdate::ActiveRenderedViewNameUpdate (const ActiveRenderedViewNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeRenderedViewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRenderedViewNameUpdate::ActiveRenderedViewNameUpdate (const ::std::string& activeRenderedViewName_)  :
    _activeRenderedViewName (activeRenderedViewName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveRenderedViewNameUpdate::~ActiveRenderedViewNameUpdate() {
}

inline ActiveRenderedViewNameUpdate& ActiveRenderedViewNameUpdate::operator = (const ActiveRenderedViewNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveRenderedViewName()) {
            setActiveRenderedViewName(rhs.getActiveRenderedViewName());
        } else {
            clearActiveRenderedViewName();
        }
    }
    return *this;
}

inline bool ActiveRenderedViewNameUpdate::operator == (const ActiveRenderedViewNameUpdate& rhs) const {
    return (((!hasActiveRenderedViewName() && !rhs.hasActiveRenderedViewName()) || getActiveRenderedViewName() == rhs.getActiveRenderedViewName()));
}

inline bool ActiveRenderedViewNameUpdate::operator != (const ActiveRenderedViewNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRenderedViewNameUpdate::operator < (const ActiveRenderedViewNameUpdate& rhs) const {
    if (hasActiveRenderedViewName() || rhs.hasActiveRenderedViewName()) {
        if (getActiveRenderedViewName() < rhs.getActiveRenderedViewName()) return true;
        if (getActiveRenderedViewName() > rhs.getActiveRenderedViewName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveRenderedViewNameUpdate::clone() {
    return new ActiveRenderedViewNameUpdate(*this);
}

inline bool ActiveRenderedViewNameUpdate::operator > (const ActiveRenderedViewNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRenderedViewNameUpdate::clear() {
    clearActiveRenderedViewName();
}

inline void ActiveRenderedViewNameUpdate::clearActiveRenderedViewName() {
    if (hasActiveRenderedViewName()) {
         clear_has_activeRenderedViewName();
        _activeRenderedViewName.clear();
     }
}

inline bool ActiveRenderedViewNameUpdate::hasActiveRenderedViewName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActiveRenderedViewNameUpdate::getActiveRenderedViewName () const {
    return _activeRenderedViewName;
}

inline ::std::string& ActiveRenderedViewNameUpdate::getActiveRenderedViewNameMutable () {
    set_has_activeRenderedViewName();
    return _activeRenderedViewName;
}

inline void ActiveRenderedViewNameUpdate::setActiveRenderedViewName (const ::std::string& activeRenderedViewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedViewName();
    this->_activeRenderedViewName = activeRenderedViewName_;
}

inline void ActiveRenderedViewNameUpdate::setActiveRenderedViewName (const char* activeRenderedViewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedViewName();
    this->_activeRenderedViewName.assign(activeRenderedViewName_);
}

inline void ActiveRenderedViewNameUpdate::setActiveRenderedViewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedViewName();
    this->_activeRenderedViewName.assign(value, size);
}

inline void ActiveRenderedViewNameUpdate::set_has_activeRenderedViewName () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveRenderedViewNameUpdate::clear_has_activeRenderedViewName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveRenderedViewNameRegister::ActiveRenderedViewNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRenderedViewNameRegister::ActiveRenderedViewNameRegister (const ActiveRenderedViewNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRenderedViewNameRegister::~ActiveRenderedViewNameRegister() {
}

inline ActiveRenderedViewNameRegister& ActiveRenderedViewNameRegister::operator = (const ActiveRenderedViewNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveRenderedViewNameRegister::operator == (const ActiveRenderedViewNameRegister& ) const {
    return true;
}

inline bool ActiveRenderedViewNameRegister::operator != (const ActiveRenderedViewNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRenderedViewNameRegister::operator < (const ActiveRenderedViewNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveRenderedViewNameRegister::clone() {
    return new ActiveRenderedViewNameRegister(*this);
}

inline bool ActiveRenderedViewNameRegister::operator > (const ActiveRenderedViewNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRenderedViewNameRegister::clear() {
}

inline  ActiveRenderedUpperViewNameUpdate::ActiveRenderedUpperViewNameUpdate ()  :
    _activeRenderedUpperViewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRenderedUpperViewNameUpdate::ActiveRenderedUpperViewNameUpdate (const ActiveRenderedUpperViewNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeRenderedUpperViewName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRenderedUpperViewNameUpdate::ActiveRenderedUpperViewNameUpdate (const ::std::string& activeRenderedUpperViewName_)  :
    _activeRenderedUpperViewName (activeRenderedUpperViewName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedUpperViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveRenderedUpperViewNameUpdate::~ActiveRenderedUpperViewNameUpdate() {
}

inline ActiveRenderedUpperViewNameUpdate& ActiveRenderedUpperViewNameUpdate::operator = (const ActiveRenderedUpperViewNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveRenderedUpperViewName()) {
            setActiveRenderedUpperViewName(rhs.getActiveRenderedUpperViewName());
        } else {
            clearActiveRenderedUpperViewName();
        }
    }
    return *this;
}

inline bool ActiveRenderedUpperViewNameUpdate::operator == (const ActiveRenderedUpperViewNameUpdate& rhs) const {
    return (((!hasActiveRenderedUpperViewName() && !rhs.hasActiveRenderedUpperViewName()) || getActiveRenderedUpperViewName() == rhs.getActiveRenderedUpperViewName()));
}

inline bool ActiveRenderedUpperViewNameUpdate::operator != (const ActiveRenderedUpperViewNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRenderedUpperViewNameUpdate::operator < (const ActiveRenderedUpperViewNameUpdate& rhs) const {
    if (hasActiveRenderedUpperViewName() || rhs.hasActiveRenderedUpperViewName()) {
        if (getActiveRenderedUpperViewName() < rhs.getActiveRenderedUpperViewName()) return true;
        if (getActiveRenderedUpperViewName() > rhs.getActiveRenderedUpperViewName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveRenderedUpperViewNameUpdate::clone() {
    return new ActiveRenderedUpperViewNameUpdate(*this);
}

inline bool ActiveRenderedUpperViewNameUpdate::operator > (const ActiveRenderedUpperViewNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRenderedUpperViewNameUpdate::clear() {
    clearActiveRenderedUpperViewName();
}

inline void ActiveRenderedUpperViewNameUpdate::clearActiveRenderedUpperViewName() {
    if (hasActiveRenderedUpperViewName()) {
         clear_has_activeRenderedUpperViewName();
        _activeRenderedUpperViewName.clear();
     }
}

inline bool ActiveRenderedUpperViewNameUpdate::hasActiveRenderedUpperViewName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ActiveRenderedUpperViewNameUpdate::getActiveRenderedUpperViewName () const {
    return _activeRenderedUpperViewName;
}

inline ::std::string& ActiveRenderedUpperViewNameUpdate::getActiveRenderedUpperViewNameMutable () {
    set_has_activeRenderedUpperViewName();
    return _activeRenderedUpperViewName;
}

inline void ActiveRenderedUpperViewNameUpdate::setActiveRenderedUpperViewName (const ::std::string& activeRenderedUpperViewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedUpperViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedUpperViewName();
    this->_activeRenderedUpperViewName = activeRenderedUpperViewName_;
}

inline void ActiveRenderedUpperViewNameUpdate::setActiveRenderedUpperViewName (const char* activeRenderedUpperViewName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (activeRenderedUpperViewName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedUpperViewName();
    this->_activeRenderedUpperViewName.assign(activeRenderedUpperViewName_);
}

inline void ActiveRenderedUpperViewNameUpdate::setActiveRenderedUpperViewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_activeRenderedUpperViewName();
    this->_activeRenderedUpperViewName.assign(value, size);
}

inline void ActiveRenderedUpperViewNameUpdate::set_has_activeRenderedUpperViewName () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveRenderedUpperViewNameUpdate::clear_has_activeRenderedUpperViewName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveRenderedUpperViewNameRegister::ActiveRenderedUpperViewNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRenderedUpperViewNameRegister::ActiveRenderedUpperViewNameRegister (const ActiveRenderedUpperViewNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRenderedUpperViewNameRegister::~ActiveRenderedUpperViewNameRegister() {
}

inline ActiveRenderedUpperViewNameRegister& ActiveRenderedUpperViewNameRegister::operator = (const ActiveRenderedUpperViewNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveRenderedUpperViewNameRegister::operator == (const ActiveRenderedUpperViewNameRegister& ) const {
    return true;
}

inline bool ActiveRenderedUpperViewNameRegister::operator != (const ActiveRenderedUpperViewNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRenderedUpperViewNameRegister::operator < (const ActiveRenderedUpperViewNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveRenderedUpperViewNameRegister::clone() {
    return new ActiveRenderedUpperViewNameRegister(*this);
}

inline bool ActiveRenderedUpperViewNameRegister::operator > (const ActiveRenderedUpperViewNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRenderedUpperViewNameRegister::clear() {
}

inline  NextActiveAppUpperUpdate::NextActiveAppUpperUpdate ()  :
    _nextActiveAppUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NextActiveAppUpperUpdate::NextActiveAppUpperUpdate (const NextActiveAppUpperUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _nextActiveAppUpper ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NextActiveAppUpperUpdate::NextActiveAppUpperUpdate (const ::std::string& nextActiveAppUpper_)  :
    _nextActiveAppUpper (nextActiveAppUpper_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NextActiveAppUpperUpdate::~NextActiveAppUpperUpdate() {
}

inline NextActiveAppUpperUpdate& NextActiveAppUpperUpdate::operator = (const NextActiveAppUpperUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNextActiveAppUpper()) {
            setNextActiveAppUpper(rhs.getNextActiveAppUpper());
        } else {
            clearNextActiveAppUpper();
        }
    }
    return *this;
}

inline bool NextActiveAppUpperUpdate::operator == (const NextActiveAppUpperUpdate& rhs) const {
    return (((!hasNextActiveAppUpper() && !rhs.hasNextActiveAppUpper()) || getNextActiveAppUpper() == rhs.getNextActiveAppUpper()));
}

inline bool NextActiveAppUpperUpdate::operator != (const NextActiveAppUpperUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NextActiveAppUpperUpdate::operator < (const NextActiveAppUpperUpdate& rhs) const {
    if (hasNextActiveAppUpper() || rhs.hasNextActiveAppUpper()) {
        if (getNextActiveAppUpper() < rhs.getNextActiveAppUpper()) return true;
        if (getNextActiveAppUpper() > rhs.getNextActiveAppUpper()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NextActiveAppUpperUpdate::clone() {
    return new NextActiveAppUpperUpdate(*this);
}

inline bool NextActiveAppUpperUpdate::operator > (const NextActiveAppUpperUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NextActiveAppUpperUpdate::clear() {
    clearNextActiveAppUpper();
}

inline void NextActiveAppUpperUpdate::clearNextActiveAppUpper() {
    if (hasNextActiveAppUpper()) {
         clear_has_nextActiveAppUpper();
        _nextActiveAppUpper.clear();
     }
}

inline bool NextActiveAppUpperUpdate::hasNextActiveAppUpper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NextActiveAppUpperUpdate::getNextActiveAppUpper () const {
    return _nextActiveAppUpper;
}

inline ::std::string& NextActiveAppUpperUpdate::getNextActiveAppUpperMutable () {
    set_has_nextActiveAppUpper();
    return _nextActiveAppUpper;
}

inline void NextActiveAppUpperUpdate::setNextActiveAppUpper (const ::std::string& nextActiveAppUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppUpper();
    this->_nextActiveAppUpper = nextActiveAppUpper_;
}

inline void NextActiveAppUpperUpdate::setNextActiveAppUpper (const char* nextActiveAppUpper_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppUpper_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppUpper();
    this->_nextActiveAppUpper.assign(nextActiveAppUpper_);
}

inline void NextActiveAppUpperUpdate::setNextActiveAppUpper (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppUpper();
    this->_nextActiveAppUpper.assign(value, size);
}

inline void NextActiveAppUpperUpdate::set_has_nextActiveAppUpper () {
    _has_bits_[0] |= 1u << 0;
}

inline void NextActiveAppUpperUpdate::clear_has_nextActiveAppUpper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NextActiveAppUpperRegister::NextActiveAppUpperRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NextActiveAppUpperRegister::NextActiveAppUpperRegister (const NextActiveAppUpperRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NextActiveAppUpperRegister::~NextActiveAppUpperRegister() {
}

inline NextActiveAppUpperRegister& NextActiveAppUpperRegister::operator = (const NextActiveAppUpperRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NextActiveAppUpperRegister::operator == (const NextActiveAppUpperRegister& ) const {
    return true;
}

inline bool NextActiveAppUpperRegister::operator != (const NextActiveAppUpperRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NextActiveAppUpperRegister::operator < (const NextActiveAppUpperRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NextActiveAppUpperRegister::clone() {
    return new NextActiveAppUpperRegister(*this);
}

inline bool NextActiveAppUpperRegister::operator > (const NextActiveAppUpperRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NextActiveAppUpperRegister::clear() {
}

inline  NextActiveAppLowerUpdate::NextActiveAppLowerUpdate ()  :
    _nextActiveAppLower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NextActiveAppLowerUpdate::NextActiveAppLowerUpdate (const NextActiveAppLowerUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _nextActiveAppLower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NextActiveAppLowerUpdate::NextActiveAppLowerUpdate (const ::std::string& nextActiveAppLower_)  :
    _nextActiveAppLower (nextActiveAppLower_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppLower_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NextActiveAppLowerUpdate::~NextActiveAppLowerUpdate() {
}

inline NextActiveAppLowerUpdate& NextActiveAppLowerUpdate::operator = (const NextActiveAppLowerUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNextActiveAppLower()) {
            setNextActiveAppLower(rhs.getNextActiveAppLower());
        } else {
            clearNextActiveAppLower();
        }
    }
    return *this;
}

inline bool NextActiveAppLowerUpdate::operator == (const NextActiveAppLowerUpdate& rhs) const {
    return (((!hasNextActiveAppLower() && !rhs.hasNextActiveAppLower()) || getNextActiveAppLower() == rhs.getNextActiveAppLower()));
}

inline bool NextActiveAppLowerUpdate::operator != (const NextActiveAppLowerUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NextActiveAppLowerUpdate::operator < (const NextActiveAppLowerUpdate& rhs) const {
    if (hasNextActiveAppLower() || rhs.hasNextActiveAppLower()) {
        if (getNextActiveAppLower() < rhs.getNextActiveAppLower()) return true;
        if (getNextActiveAppLower() > rhs.getNextActiveAppLower()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NextActiveAppLowerUpdate::clone() {
    return new NextActiveAppLowerUpdate(*this);
}

inline bool NextActiveAppLowerUpdate::operator > (const NextActiveAppLowerUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NextActiveAppLowerUpdate::clear() {
    clearNextActiveAppLower();
}

inline void NextActiveAppLowerUpdate::clearNextActiveAppLower() {
    if (hasNextActiveAppLower()) {
         clear_has_nextActiveAppLower();
        _nextActiveAppLower.clear();
     }
}

inline bool NextActiveAppLowerUpdate::hasNextActiveAppLower () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NextActiveAppLowerUpdate::getNextActiveAppLower () const {
    return _nextActiveAppLower;
}

inline ::std::string& NextActiveAppLowerUpdate::getNextActiveAppLowerMutable () {
    set_has_nextActiveAppLower();
    return _nextActiveAppLower;
}

inline void NextActiveAppLowerUpdate::setNextActiveAppLower (const ::std::string& nextActiveAppLower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppLower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppLower();
    this->_nextActiveAppLower = nextActiveAppLower_;
}

inline void NextActiveAppLowerUpdate::setNextActiveAppLower (const char* nextActiveAppLower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (nextActiveAppLower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppLower();
    this->_nextActiveAppLower.assign(nextActiveAppLower_);
}

inline void NextActiveAppLowerUpdate::setNextActiveAppLower (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_nextActiveAppLower();
    this->_nextActiveAppLower.assign(value, size);
}

inline void NextActiveAppLowerUpdate::set_has_nextActiveAppLower () {
    _has_bits_[0] |= 1u << 0;
}

inline void NextActiveAppLowerUpdate::clear_has_nextActiveAppLower () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NextActiveAppLowerRegister::NextActiveAppLowerRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NextActiveAppLowerRegister::NextActiveAppLowerRegister (const NextActiveAppLowerRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NextActiveAppLowerRegister::~NextActiveAppLowerRegister() {
}

inline NextActiveAppLowerRegister& NextActiveAppLowerRegister::operator = (const NextActiveAppLowerRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NextActiveAppLowerRegister::operator == (const NextActiveAppLowerRegister& ) const {
    return true;
}

inline bool NextActiveAppLowerRegister::operator != (const NextActiveAppLowerRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NextActiveAppLowerRegister::operator < (const NextActiveAppLowerRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NextActiveAppLowerRegister::clone() {
    return new NextActiveAppLowerRegister(*this);
}

inline bool NextActiveAppLowerRegister::operator > (const NextActiveAppLowerRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NextActiveAppLowerRegister::clear() {
}

} // namespace HmiMonitorService
} // namespace hmimonitorservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_NISSAN_HMI_HMIMONITORSERVICE_HMIMONITORSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
