/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICEPROXY_H
#define BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {

class HmiInfoServiceProxy;

class CabinSourcesConnectionStatusCallbackIF {
public:
    virtual ~CabinSourcesConnectionStatusCallbackIF() {}

    virtual void onCabinSourcesConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinSourcesConnectionStatusError >& error) = 0;

    virtual void onCabinSourcesConnectionStatusUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinSourcesConnectionStatusUpdate >& update) = 0;
};

class CabinsSourceDisconnectionTriggerCallbackIF {
public:
    virtual ~CabinsSourceDisconnectionTriggerCallbackIF() {}

    virtual void onCabinsSourceDisconnectionTriggerError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceDisconnectionTriggerError >& error) = 0;

    virtual void onCabinsSourceDisconnectionTriggerSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceDisconnectionTriggerSignal >& signal) = 0;
};

class CabinsSourceRestorationInfoCallbackIF {
public:
    virtual ~CabinsSourceRestorationInfoCallbackIF() {}

    virtual void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error) = 0;

    virtual void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update) = 0;
};

class CabinsSystemsInfoCallbackIF {
public:
    virtual ~CabinsSystemsInfoCallbackIF() {}

    virtual void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoError >& error) = 0;

    virtual void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update) = 0;
};

class CabinsVideoMixInfoCallbackIF {
public:
    virtual ~CabinsVideoMixInfoCallbackIF() {}

    virtual void onCabinsVideoMixInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsVideoMixInfoError >& error) = 0;

    virtual void onCabinsVideoMixInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinsVideoMixInfoUpdate >& update) = 0;
};

class CurrentForegroundApplicationIdCallbackIF {
public:
    virtual ~CurrentForegroundApplicationIdCallbackIF() {}

    virtual void onCurrentForegroundApplicationIdError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CurrentForegroundApplicationIdError >& error) = 0;

    virtual void onCurrentForegroundApplicationIdUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CurrentForegroundApplicationIdUpdate >& update) = 0;
};

class ETAAvailableCallbackIF {
public:
    virtual ~ETAAvailableCallbackIF() {}

    virtual void onETAAvailableError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableError >& error) = 0;

    virtual void onETAAvailableUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableUpdate >& update) = 0;
};

class GetCurrentForegroundApplicationIdCallbackIF {
public:
    virtual ~GetCurrentForegroundApplicationIdCallbackIF() {}

    virtual void onGetCurrentForegroundApplicationIdError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< GetCurrentForegroundApplicationIdError >& error) = 0;

    virtual void onGetCurrentForegroundApplicationIdResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< GetCurrentForegroundApplicationIdResponse >& response) = 0;
};

class GetRVCSignalStatusCallbackIF {
public:
    virtual ~GetRVCSignalStatusCallbackIF() {}

    virtual void onGetRVCSignalStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< GetRVCSignalStatusError >& error) = 0;

    virtual void onGetRVCSignalStatusResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< GetRVCSignalStatusResponse >& response) = 0;
};

class LanguageStatusInfoCallbackIF {
public:
    virtual ~LanguageStatusInfoCallbackIF() {}

    virtual void onLanguageStatusInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< LanguageStatusInfoError >& error) = 0;

    virtual void onLanguageStatusInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< LanguageStatusInfoUpdate >& update) = 0;
};

class NavigationModeChangeTriggerCallbackIF {
public:
    virtual ~NavigationModeChangeTriggerCallbackIF() {}

    virtual void onNavigationModeChangeTriggerError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< NavigationModeChangeTriggerError >& error) = 0;

    virtual void onNavigationModeChangeTriggerSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< NavigationModeChangeTriggerSignal >& signal) = 0;
};

class RVCSignalStatusCallbackIF {
public:
    virtual ~RVCSignalStatusCallbackIF() {}

    virtual void onRVCSignalStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RVCSignalStatusError >& error) = 0;

    virtual void onRVCSignalStatusUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RVCSignalStatusUpdate >& update) = 0;
};

class RegionsMapOutStatusInfoCallbackIF {
public:
    virtual ~RegionsMapOutStatusInfoCallbackIF() {}

    virtual void onRegionsMapOutStatusInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RegionsMapOutStatusInfoError >& error) = 0;

    virtual void onRegionsMapOutStatusInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RegionsMapOutStatusInfoUpdate >& update) = 0;
};

class RemoveCabinSourceConnectionCallbackIF {
public:
    virtual ~RemoveCabinSourceConnectionCallbackIF() {}

    virtual void onRemoveCabinSourceConnectionError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RemoveCabinSourceConnectionError >& error) = 0;

    virtual void onRemoveCabinSourceConnectionResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RemoveCabinSourceConnectionResponse >& response) = 0;
};

class RestoreAVSourceCallbackIF {
public:
    virtual ~RestoreAVSourceCallbackIF() {}

    virtual void onRestoreAVSourceError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RestoreAVSourceError >& error) = 0;

    virtual void onRestoreAVSourceSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< RestoreAVSourceSignal >& signal) = 0;
};

class SetCabinSourceConnectionStatusCallbackIF {
public:
    virtual ~SetCabinSourceConnectionStatusCallbackIF() {}

    virtual void onSetCabinSourceConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinSourceConnectionStatusError >& error) = 0;

    virtual void onSetCabinSourceConnectionStatusResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinSourceConnectionStatusResponse >& response) = 0;
};

class SetCabinVideoMixIndexCallbackIF {
public:
    virtual ~SetCabinVideoMixIndexCallbackIF() {}

    virtual void onSetCabinVideoMixIndexError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinVideoMixIndexError >& error) = 0;

    virtual void onSetCabinVideoMixIndexResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetCabinVideoMixIndexResponse >& response) = 0;
};

class SetNavigationModeCallbackIF {
public:
    virtual ~SetNavigationModeCallbackIF() {}

    virtual void onSetNavigationModeError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetNavigationModeError >& error) = 0;

    virtual void onSetNavigationModeResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetNavigationModeResponse >& response) = 0;
};

class SpiConnectionStatusInfoCallbackIF {
public:
    virtual ~SpiConnectionStatusInfoCallbackIF() {}

    virtual void onSpiConnectionStatusInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SpiConnectionStatusInfoError >& error) = 0;

    virtual void onSpiConnectionStatusInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SpiConnectionStatusInfoUpdate >& update) = 0;
};

class ToggleGadgetAudioSourceCallbackIF {
public:
    virtual ~ToggleGadgetAudioSourceCallbackIF() {}

    virtual void onToggleGadgetAudioSourceError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceError >& error) = 0;

    virtual void onToggleGadgetAudioSourceResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceResponse >& response) = 0;
};

class ToggleGadgetAudioSourceRequestCallbackIF {
public:
    virtual ~ToggleGadgetAudioSourceRequestCallbackIF() {}

    virtual void onToggleGadgetAudioSourceRequestError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestError >& error) = 0;

    virtual void onToggleGadgetAudioSourceRequestSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ToggleGadgetAudioSourceRequestSignal >& signal) = 0;
};


/**
 * HmiInfoServiceProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService'
 * (specified in file HmiInfoService_.xml).
 *
 * todo
 */
class HmiInfoServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HmiInfoServiceProxy.
     */
    static ::boost::shared_ptr< HmiInfoServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HmiInfoServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HmiInfoServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HmiInfoServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HmiInfoServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HmiInfoServiceProxy > proxyNew(new HmiInfoServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~HmiInfoServiceProxy ();


    // Signal 'toggleGadgetAudioSourceRequest'

    /**
     * Notify on the signal 'toggleGadgetAudioSourceRequest'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'toggleGadgetAudioSourceRequest'</b>:
     *
     * Signal to update the trigger of gadget audio source toggle
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendToggleGadgetAudioSourceRequestRegister(ToggleGadgetAudioSourceRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'toggleGadgetAudioSourceRequest'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'toggleGadgetAudioSourceRequest'</b>:
     *
     * Signal to update the trigger of gadget audio source toggle
     *
     * @param act The act which was previously returned by the
     * sendToggleGadgetAudioSourceRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendToggleGadgetAudioSourceRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'toggleGadgetAudioSourceRequest'.
     */
    void sendToggleGadgetAudioSourceRequestDeregisterAll () const;

    // Signal 'cabinsSourceDisconnectionTrigger'

    /**
     * Notify on the signal 'cabinsSourceDisconnectionTrigger'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'cabinsSourceDisconnectionTrigger'</b>:
     *
     * Signal to trigger cabin source disconnection on subsystem error
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsSourceDisconnectionTriggerRegister(CabinsSourceDisconnectionTriggerCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'cabinsSourceDisconnectionTrigger'.
     * This method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'cabinsSourceDisconnectionTrigger'</b>:
     *
     * Signal to trigger cabin source disconnection on subsystem error
     *
     * @param act The act which was previously returned by the
     * sendCabinsSourceDisconnectionTriggerRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCabinsSourceDisconnectionTriggerDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'cabinsSourceDisconnectionTrigger'.
     */
    void sendCabinsSourceDisconnectionTriggerDeregisterAll () const;

    // Signal 'restoreAVSource'

    /**
     * Notify on the signal 'restoreAVSource'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'restoreAVSource'</b>:
     *
     * Signal to trigger AV source restoration
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestoreAVSourceRegister(RestoreAVSourceCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'restoreAVSource'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'restoreAVSource'</b>:
     *
     * Signal to trigger AV source restoration
     *
     * @param act The act which was previously returned by the
     * sendRestoreAVSourceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRestoreAVSourceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'restoreAVSource'.
     */
    void sendRestoreAVSourceDeregisterAll () const;

    // Signal 'navigationModeChangeTrigger'

    /**
     * Notify on the signal 'navigationModeChangeTrigger'. This method
     * registers for signal changes by D-Bus service.
     *
     * <b>Documentation of 'navigationModeChangeTrigger'</b>:
     *
     * Signal to trigger change car mode by Navigation application
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationModeChangeTriggerRegister(NavigationModeChangeTriggerCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'navigationModeChangeTrigger'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'navigationModeChangeTrigger'</b>:
     *
     * Signal to trigger change car mode by Navigation application
     *
     * @param act The act which was previously returned by the
     * sendNavigationModeChangeTriggerRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNavigationModeChangeTriggerDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'navigationModeChangeTrigger'.
     */
    void sendNavigationModeChangeTriggerDeregisterAll () const;


    // Property 'currentForegroundApplicationId'

    /**
     * Notify on the property 'currentForegroundApplicationId'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentForegroundApplicationIdRegister(CurrentForegroundApplicationIdCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'currentForegroundApplicationId'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     *
     * @param act The act which was previously returned by the
     * sendCurrentForegroundApplicationIdRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCurrentForegroundApplicationIdDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'currentForegroundApplicationId'.
     */
    void sendCurrentForegroundApplicationIdDeregisterAll() const;

    /**
     * Request the value of the property 'currentForegroundApplicationId' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'currentForegroundApplicationId'</b>:
     *
     * Property to state the currentVisibleScene
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentForegroundApplicationIdGet(CurrentForegroundApplicationIdCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'currentForegroundApplicationId' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasCurrentForegroundApplicationId() returns true.
     *
     * @return the previously received value of the property 'currentForegroundApplicationId'.
     */
    uint8 getCurrentForegroundApplicationId() const;

    /**
     * Determines whether a status message for the property
     * 'currentForegroundApplicationId' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCurrentForegroundApplicationId() const;

    // Property 'RVCSignalStatus'

    /**
     * Notify on the property 'RVCSignalStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCSignalStatusRegister(RVCSignalStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RVCSignalStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @param act The act which was previously returned by the
     * sendRVCSignalStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRVCSignalStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RVCSignalStatus'.
     */
    void sendRVCSignalStatusDeregisterAll() const;

    /**
     * Request the value of the property 'RVCSignalStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RVCSignalStatus'</b>:
     *
     * Property to state the RVCSignal status false = RVC not active, true = RVC active
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRVCSignalStatusGet(RVCSignalStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'RVCSignalStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRVCSignalStatus() returns true.
     *
     * @return the previously received value of the property 'RVCSignalStatus'.
     */
    bool getRVCSignalStatus() const;

    /**
     * Determines whether a status message for the property 'RVCSignalStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRVCSignalStatus() const;

    // Property 'regionsMapOutStatusInfo'

    /**
     * Notify on the property 'regionsMapOutStatusInfo'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegionsMapOutStatusInfoRegister(RegionsMapOutStatusInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'regionsMapOutStatusInfo'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     *
     * @param act The act which was previously returned by the
     * sendRegionsMapOutStatusInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRegionsMapOutStatusInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'regionsMapOutStatusInfo'.
     */
    void sendRegionsMapOutStatusInfoDeregisterAll() const;

    /**
     * Request the value of the property 'regionsMapOutStatusInfo' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'regionsMapOutStatusInfo'</b>:
     *
     * Property to update map out status information of regions
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegionsMapOutStatusInfoGet(RegionsMapOutStatusInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'regionsMapOutStatusInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRegionsMapOutStatusInfo() returns true.
     *
     * @return the previously received value of the property 'regionsMapOutStatusInfo'.
     */
    const ::std::vector< RegionMapOutStatusInfo >& getRegionsMapOutStatusInfo() const;

    /**
     * Determines whether a status message for the property
     * 'regionsMapOutStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRegionsMapOutStatusInfo() const;

    // Property 'cabinsSourceRestorationInfo'

    /**
     * Notify on the property 'cabinsSourceRestorationInfo'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsSourceRestorationInfoRegister(CabinsSourceRestorationInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'cabinsSourceRestorationInfo'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @param act The act which was previously returned by the
     * sendCabinsSourceRestorationInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCabinsSourceRestorationInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'cabinsSourceRestorationInfo'.
     */
    void sendCabinsSourceRestorationInfoDeregisterAll() const;

    /**
     * Request the value of the property 'cabinsSourceRestorationInfo' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'cabinsSourceRestorationInfo'</b>:
     *
     * Property to trigger cabin source restoration on subsystem error clearance
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsSourceRestorationInfoGet(CabinsSourceRestorationInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'cabinsSourceRestorationInfo'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCabinsSourceRestorationInfo() returns true.
     *
     * @return the previously received value of the property 'cabinsSourceRestorationInfo'.
     */
    const ::std::vector< CabinSourceRestorationInfo >& getCabinsSourceRestorationInfo() const;

    /**
     * Determines whether a status message for the property
     * 'cabinsSourceRestorationInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCabinsSourceRestorationInfo() const;

    // Property 'cabinsSystemsInfo'

    /**
     * Notify on the property 'cabinsSystemsInfo'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsSystemsInfoRegister(CabinsSystemsInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'cabinsSystemsInfo'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     *
     * @param act The act which was previously returned by the
     * sendCabinsSystemsInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCabinsSystemsInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'cabinsSystemsInfo'.
     */
    void sendCabinsSystemsInfoDeregisterAll() const;

    /**
     * Request the value of the property 'cabinsSystemsInfo' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'cabinsSystemsInfo'</b>:
     *
     * Property to update cabins systems information
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsSystemsInfoGet(CabinsSystemsInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'cabinsSystemsInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCabinsSystemsInfo() returns true.
     *
     * @return the previously received value of the property 'cabinsSystemsInfo'.
     */
    const ::std::vector< SystemInfo >& getCabinsSystemsInfo() const;

    /**
     * Determines whether a status message for the property
     * 'cabinsSystemsInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCabinsSystemsInfo() const;

    // Property 'LanguageStatusInfo'

    /**
     * Notify on the property 'LanguageStatusInfo'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLanguageStatusInfoRegister(LanguageStatusInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'LanguageStatusInfo'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     *
     * @param act The act which was previously returned by the
     * sendLanguageStatusInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLanguageStatusInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'LanguageStatusInfo'.
     */
    void sendLanguageStatusInfoDeregisterAll() const;

    /**
     * Request the value of the property 'LanguageStatusInfo' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'LanguageStatusInfo'</b>:
     *
     * Property to update language status information
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLanguageStatusInfoGet(LanguageStatusInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'LanguageStatusInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasLanguageStatusInfo() returns true.
     *
     * @return the previously received value of the property 'LanguageStatusInfo'.
     */
    uint32 getLanguageStatusInfo() const;

    /**
     * Determines whether a status message for the property
     * 'LanguageStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLanguageStatusInfo() const;

    // Property 'spiConnectionStatusInfo'

    /**
     * Notify on the property 'spiConnectionStatusInfo'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpiConnectionStatusInfoRegister(SpiConnectionStatusInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'spiConnectionStatusInfo'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param act The act which was previously returned by the
     * sendSpiConnectionStatusInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSpiConnectionStatusInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'spiConnectionStatusInfo'.
     */
    void sendSpiConnectionStatusInfoDeregisterAll() const;

    /**
     * Request the value of the property 'spiConnectionStatusInfo' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpiConnectionStatusInfoGet(SpiConnectionStatusInfoCallbackIF& cb);

    /**
     * Set the value of the property 'spiConnectionStatusInfo'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendSpiConnectionStatusInfoSet(SpiConnectionStatusInfoCallbackIF& cb,
     * const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo) method
     * instead.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     */
    void sendSpiConnectionStatusInfoSet(const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo);

    /**
     * Set the value of the property 'spiConnectionStatusInfo'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'spiConnectionStatusInfo'</b>:
     *
     * Property to update SPI connection status information
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpiConnectionStatusInfoSet(SpiConnectionStatusInfoCallbackIF& cb, const SPIConnectionStatusInfoHolder& spiConnectionStatusInfo);

    /**
     * Returns the current value of the property 'spiConnectionStatusInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSpiConnectionStatusInfo() returns true.
     *
     * @return the previously received value of the property 'spiConnectionStatusInfo'.
     */
    const SPIConnectionStatusInfoHolder& getSpiConnectionStatusInfo() const;

    /**
     * Determines whether a status message for the property
     * 'spiConnectionStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSpiConnectionStatusInfo() const;

    // Property 'cabinSourcesConnectionStatus'

    /**
     * Notify on the property 'cabinSourcesConnectionStatus'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinSourcesConnectionStatusRegister(CabinSourcesConnectionStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'cabinSourcesConnectionStatus'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     *
     * @param act The act which was previously returned by the
     * sendCabinSourcesConnectionStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCabinSourcesConnectionStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'cabinSourcesConnectionStatus'.
     */
    void sendCabinSourcesConnectionStatusDeregisterAll() const;

    /**
     * Request the value of the property 'cabinSourcesConnectionStatus' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'cabinSourcesConnectionStatus'</b>:
     *
     * Property to update the cabin sources connection status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinSourcesConnectionStatusGet(CabinSourcesConnectionStatusCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'cabinSourcesConnectionStatus' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasCabinSourcesConnectionStatus()
     * returns true.
     *
     * @return the previously received value of the property 'cabinSourcesConnectionStatus'.
     */
    const ::std::vector< CabinSourceConnectionStatusInfo >& getCabinSourcesConnectionStatus() const;

    /**
     * Determines whether a status message for the property
     * 'cabinSourcesConnectionStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCabinSourcesConnectionStatus() const;

    // Property 'cabinsVideoMixInfo'

    /**
     * Notify on the property 'cabinsVideoMixInfo'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsVideoMixInfoRegister(CabinsVideoMixInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'cabinsVideoMixInfo'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     *
     * @param act The act which was previously returned by the
     * sendCabinsVideoMixInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCabinsVideoMixInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'cabinsVideoMixInfo'.
     */
    void sendCabinsVideoMixInfoDeregisterAll() const;

    /**
     * Request the value of the property 'cabinsVideoMixInfo' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'cabinsVideoMixInfo'</b>:
     *
     * Property to update the cabin video mix info
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCabinsVideoMixInfoGet(CabinsVideoMixInfoCallbackIF& cb);


    /**
     * Returns the current value of the property 'cabinsVideoMixInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCabinsVideoMixInfo() returns true.
     *
     * @return the previously received value of the property 'cabinsVideoMixInfo'.
     */
    const ::std::vector< CabinVideoMixInfo >& getCabinsVideoMixInfo() const;

    /**
     * Determines whether a status message for the property
     * 'cabinsVideoMixInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCabinsVideoMixInfo() const;

    // Property 'ETAAvailable'

    /**
     * Notify on the property 'ETAAvailable'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ETAAvailable'</b>:
     *
     * Property to state the ETA on secondary map status false = ETA not active, true = ETA active
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendETAAvailableRegister(ETAAvailableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ETAAvailable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ETAAvailable'</b>:
     *
     * Property to state the ETA on secondary map status false = ETA not active, true = ETA active
     *
     * @param act The act which was previously returned by the
     * sendETAAvailableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendETAAvailableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ETAAvailable'.
     */
    void sendETAAvailableDeregisterAll() const;

    /**
     * Request the value of the property 'ETAAvailable' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ETAAvailable'</b>:
     *
     * Property to state the ETA on secondary map status false = ETA not active, true = ETA active
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendETAAvailableGet(ETAAvailableCallbackIF& cb);

    /**
     * Set the value of the property 'ETAAvailable'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendETAAvailableSet(ETAAvailableCallbackIF& cb,
     * bool eTAAvailable) method instead.
     *
     * <b>Documentation of 'ETAAvailable'</b>:
     *
     * Property to state the ETA on secondary map status false = ETA not active, true = ETA active
     */
    void sendETAAvailableSet(bool eTAAvailable);

    /**
     * Set the value of the property 'ETAAvailable'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ETAAvailable'</b>:
     *
     * Property to state the ETA on secondary map status false = ETA not active, true = ETA active
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendETAAvailableSet(ETAAvailableCallbackIF& cb, bool eTAAvailable);

    /**
     * Returns the current value of the property 'ETAAvailable' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasETAAvailable() returns true.
     *
     * @return the previously received value of the property 'ETAAvailable'.
     */
    bool getETAAvailable() const;

    /**
     * Determines whether a status message for the property 'ETAAvailable' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasETAAvailable() const;


    // Method 'getRVCSignalStatus'

    /**
     * Call the method 'getRVCSignalStatus'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'getRVCSignalStatus'</b>:
     *
     * Method to give RVC Signal status
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetRVCSignalStatusRequest(GetRVCSignalStatusCallbackIF& cb) const;

    // Method 'getCurrentForegroundApplicationId'

    /**
     * Call the method 'getCurrentForegroundApplicationId'. This method sends
     * a message to the D-Bus server.
     *
     * <b>Documentation of 'getCurrentForegroundApplicationId'</b>:
     *
     * Method to give active screen/popup name
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetCurrentForegroundApplicationIdRequest(GetCurrentForegroundApplicationIdCallbackIF& cb) const;

    // Method 'toggleGadgetAudioSource'

    /**
     * Call the method 'toggleGadgetAudioSource'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'toggleGadgetAudioSource'</b>:
     *
     * Method to update the trigger of gadget audio source toggle
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param regionId If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param srcApplicationId If the meaning of "srcApplicationId" isn't clear, then there should be a description here.
     *
     * @param destApplicationId If the meaning of "destApplicationId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendToggleGadgetAudioSourceRequest(ToggleGadgetAudioSourceCallbackIF& cb, uint32 regionId, uint8 srcApplicationId, uint8 destApplicationId) const;

    // Method 'setCabinSourceConnectionStatus'

    /**
     * Call the method 'setCabinSourceConnectionStatus'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'setCabinSourceConnectionStatus'</b>:
     *
     * Method to update the cabin source connection status
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param cabinSourcesConnectionStatusInfo If the meaning of "cabinSourcesConnectionStatusInfo" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCabinSourceConnectionStatusRequest(SetCabinSourceConnectionStatusCallbackIF& cb, const ::std::vector< CabinSourceConnectionStatusInfo >& cabinSourcesConnectionStatusInfo) const;

    // Method 'removeCabinSourceConnection'

    /**
     * Call the method 'removeCabinSourceConnection'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'removeCabinSourceConnection'</b>:
     *
     * Method to remove source from cabin source connection array
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourcesIdInfo If the meaning of "sourcesIdInfo" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveCabinSourceConnectionRequest(RemoveCabinSourceConnectionCallbackIF& cb, const ::std::vector< uint32 >& sourcesIdInfo) const;

    // Method 'setCabinVideoMixIndex'

    /**
     * Call the method 'setCabinVideoMixIndex'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'setCabinVideoMixIndex'</b>:
     *
     * Method to update the cabin video mix info
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param cabinVideoMixInfo If the meaning of "cabinVideoMixInfo" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCabinVideoMixIndexRequest(SetCabinVideoMixIndexCallbackIF& cb, const CabinVideoMixInfo& cabinVideoMixInfo) const;

    // Method 'setNavigationMode'

    /**
     * Call the method 'setNavigationMode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setNavigationMode'</b>:
     *
     * Method to update vehicle profile car mode and coach mode by Navigation application
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param carModeActive If the meaning of "carModeActive" isn't clear, then there should be a description here.
     *
     * @param coachModeActive If the meaning of "coachModeActive" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetNavigationModeRequest(SetNavigationModeCallbackIF& cb, bool carModeActive, bool coachModeActive) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HmiInfoServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'currentForegroundApplicationId'

    ::asf::core::nullable< CurrentForegroundApplicationIdUpdate > _currentForegroundApplicationId;

    // Property 'RVCSignalStatus'

    ::asf::core::nullable< RVCSignalStatusUpdate > _rVCSignalStatus;

    // Property 'regionsMapOutStatusInfo'

    ::asf::core::nullable< RegionsMapOutStatusInfoUpdate > _regionsMapOutStatusInfo;

    // Property 'cabinsSourceRestorationInfo'

    ::asf::core::nullable< CabinsSourceRestorationInfoUpdate > _cabinsSourceRestorationInfo;

    // Property 'cabinsSystemsInfo'

    ::asf::core::nullable< CabinsSystemsInfoUpdate > _cabinsSystemsInfo;

    // Property 'LanguageStatusInfo'

    ::asf::core::nullable< LanguageStatusInfoUpdate > _languageStatusInfo;

    // Property 'spiConnectionStatusInfo'

    ::asf::core::nullable< SpiConnectionStatusInfoUpdate > _spiConnectionStatusInfo;

    // Property 'cabinSourcesConnectionStatus'

    ::asf::core::nullable< CabinSourcesConnectionStatusUpdate > _cabinSourcesConnectionStatus;

    // Property 'cabinsVideoMixInfo'

    ::asf::core::nullable< CabinsVideoMixInfoUpdate > _cabinsVideoMixInfo;

    // Property 'ETAAvailable'

    ::asf::core::nullable< ETAAvailableUpdate > _eTAAvailable;

    DECLARE_CLASS_LOGGER();

    friend class HmiInfoServiceProxyCallback;
};

} // namespace HmiInfoService
} // namespace hmiinfoservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_HMIINFOSERVICE_HMIINFOSERVICEPROXY_H
