/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATAPROXY_H
#define BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATAPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiData.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmidataservice {
namespace HmiData {

class HmiDataProxy;

class DimmingModeCallbackIF {
public:
    virtual ~DimmingModeCallbackIF() {}

    virtual void onDimmingModeError(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< DimmingModeError >& error) = 0;

    virtual void onDimmingModeUpdate(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< DimmingModeUpdate >& update) = 0;
};

class SpeedLockStatusCallbackIF {
public:
    virtual ~SpeedLockStatusCallbackIF() {}

    virtual void onSpeedLockStatusError(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< SpeedLockStatusError >& error) = 0;

    virtual void onSpeedLockStatusUpdate(const ::boost::shared_ptr< HmiDataProxy >& proxy, const ::boost::shared_ptr< SpeedLockStatusUpdate >& update) = 0;
};


/**
 * HmiDataProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.ai.nissan.hmi.hmidataservice.HmiData' (specified in
 * file HmiDataService_.xml).
 *
 * HmiDataService - properties for touch click, encoder status, beep tone, hmi state
 */
class HmiDataProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HmiDataProxy.
     */
    static ::boost::shared_ptr< HmiDataProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HmiDataProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HmiDataProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HmiDataProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HmiDataProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HmiDataProxy > proxyNew(new HmiDataProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~HmiDataProxy ();



    // Property 'SpeedLockStatus'

    /**
     * Notify on the property 'SpeedLockStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SpeedLockStatus'</b>:
     *
     * Property to state the current Speed Lock status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedLockStatusRegister(SpeedLockStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SpeedLockStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SpeedLockStatus'</b>:
     *
     * Property to state the current Speed Lock status
     *
     * @param act The act which was previously returned by the
     * sendSpeedLockStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSpeedLockStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SpeedLockStatus'.
     */
    void sendSpeedLockStatusDeregisterAll() const;

    /**
     * Request the value of the property 'SpeedLockStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SpeedLockStatus'</b>:
     *
     * Property to state the current Speed Lock status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedLockStatusGet(SpeedLockStatusCallbackIF& cb);

    /**
     * Set the value of the property 'SpeedLockStatus'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendSpeedLockStatusSet(SpeedLockStatusCallbackIF&
     * cb, bool speedLockStatus) method instead.
     *
     * <b>Documentation of 'SpeedLockStatus'</b>:
     *
     * Property to state the current Speed Lock status
     */
    void sendSpeedLockStatusSet(bool speedLockStatus);

    /**
     * Set the value of the property 'SpeedLockStatus'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'SpeedLockStatus'</b>:
     *
     * Property to state the current Speed Lock status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSpeedLockStatusSet(SpeedLockStatusCallbackIF& cb, bool speedLockStatus);

    /**
     * Returns the current value of the property 'SpeedLockStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSpeedLockStatus() returns true.
     *
     * @return the previously received value of the property 'SpeedLockStatus'.
     */
    bool getSpeedLockStatus() const;

    /**
     * Determines whether a status message for the property 'SpeedLockStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSpeedLockStatus() const;

    // Property 'DimmingMode'

    /**
     * Notify on the property 'DimmingMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DimmingMode'</b>:
     *
     * Property to state the current Dimming mode
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDimmingModeRegister(DimmingModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DimmingMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DimmingMode'</b>:
     *
     * Property to state the current Dimming mode
     *
     * @param act The act which was previously returned by the
     * sendDimmingModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDimmingModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DimmingMode'.
     */
    void sendDimmingModeDeregisterAll() const;

    /**
     * Request the value of the property 'DimmingMode' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DimmingMode'</b>:
     *
     * Property to state the current Dimming mode
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDimmingModeGet(DimmingModeCallbackIF& cb);

    /**
     * Set the value of the property 'DimmingMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendDimmingModeSet(DimmingModeCallbackIF& cb, uint8
     * dimmingMode) method instead.
     *
     * <b>Documentation of 'DimmingMode'</b>:
     *
     * Property to state the current Dimming mode
     */
    void sendDimmingModeSet(uint8 dimmingMode);

    /**
     * Set the value of the property 'DimmingMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'DimmingMode'</b>:
     *
     * Property to state the current Dimming mode
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDimmingModeSet(DimmingModeCallbackIF& cb, uint8 dimmingMode);

    /**
     * Returns the current value of the property 'DimmingMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDimmingMode() returns true.
     *
     * @return the previously received value of the property 'DimmingMode'.
     */
    uint8 getDimmingMode() const;

    /**
     * Determines whether a status message for the property 'DimmingMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDimmingMode() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HmiDataProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'SpeedLockStatus'

    ::asf::core::nullable< SpeedLockStatusUpdate > _speedLockStatus;

    // Property 'DimmingMode'

    ::asf::core::nullable< DimmingModeUpdate > _dimmingMode;

    DECLARE_CLASS_LOGGER();

    friend class HmiDataProxyCallback;
};

} // namespace HmiData
} // namespace hmidataservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATAPROXY_H
