#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATA_H
#define BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATA_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>

/**
 * HmiDataService - properties for touch click, encoder status, beep tone, hmi state
 */

namespace bosch {
namespace cm {
namespace ai {
namespace nissan {
namespace hmi {
namespace hmidataservice {
namespace HmiData {

// method IDs

// signal IDs

// property IDs
static const uint16 ID_SpeedLockStatus = 0;
static const uint16 ID_DimmingMode = 1;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SpeedLockStatusUpdate;

class SpeedLockStatusRegister;

class DimmingModeUpdate;

class DimmingModeRegister;

// type definitions
/**
 * Property to state the current Speed Lock status
 */
typedef SpeedLockStatusUpdate SpeedLockStatusSet;

/**
 * Property to state the current Speed Lock status
 */
typedef SpeedLockStatusUpdate SpeedLockStatusGet;

/**
 * If the meaning of "SpeedLockStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeedLockStatusError;

/**
 * Property to state the current Dimming mode
 */
typedef DimmingModeUpdate DimmingModeSet;

/**
 * Property to state the current Dimming mode
 */
typedef DimmingModeUpdate DimmingModeGet;

/**
 * If the meaning of "DimmingModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DimmingModeError;


/**
 * Property to state the current Speed Lock status
 */
class SpeedLockStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLockStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  SpeedLockStatusUpdate (const SpeedLockStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedLockStatusUpdate (bool SpeedLockStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedLockStatusUpdate();

    /**
     * Assignment operator
     */
    inline SpeedLockStatusUpdate& operator = (const SpeedLockStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLockStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLockStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLockStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLockStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeedLockStatus"

    static const int kSpeedLockStatus = 0;

    /**
     * Clears the field "SpeedLockStatus".
     *
     * The field will be set to its default value. The hasSpeedLockStatus()
     * method will return false.
     */
    inline void clearSpeedLockStatus();

    /**
     * Checks whether the field "SpeedLockStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedLockStatus()). Otherwise it will return false.
     */
    inline bool hasSpeedLockStatus () const;

    /**
     * Returns the value of the member "SpeedLockStatus".
     *
     * Property to state the current Speed Lock status
     *
     * @return The value of the field "SpeedLockStatus"
     */
    inline bool getSpeedLockStatus () const;

    /**
     * Sets the value of the member "SpeedLockStatus".
     *
     * Property to state the current Speed Lock status
     *
     * @param SpeedLockStatus The value which will be set
     */
    inline void setSpeedLockStatus (bool SpeedLockStatus_);

    static const SpeedLockStatusUpdate &getDefaultInstance();

private:

    inline void set_has_SpeedLockStatus ();

    inline void clear_has_SpeedLockStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SpeedLockStatus;

};

/**
 * Property to state the current Speed Lock status
 */
class SpeedLockStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedLockStatusRegister ();

    /**
     * Copy constructor
     */
    inline  SpeedLockStatusRegister (const SpeedLockStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpeedLockStatusRegister();

    /**
     * Assignment operator
     */
    inline SpeedLockStatusRegister& operator = (const SpeedLockStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedLockStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedLockStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedLockStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedLockStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpeedLockStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Property to state the current Dimming mode
 */
class DimmingModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimmingModeUpdate ();

    /**
     * Copy constructor
     */
    inline  DimmingModeUpdate (const DimmingModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DimmingModeUpdate (uint8 DimmingMode_);

    /**
     * Destructor
     */
    inline virtual  ~DimmingModeUpdate();

    /**
     * Assignment operator
     */
    inline DimmingModeUpdate& operator = (const DimmingModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimmingModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimmingModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimmingModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimmingModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimmingMode"

    static const int kDimmingMode = 0;

    /**
     * Clears the field "DimmingMode".
     *
     * The field will be set to its default value. The hasDimmingMode()
     * method will return false.
     */
    inline void clearDimmingMode();

    /**
     * Checks whether the field "DimmingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingMode()). Otherwise it will return false.
     */
    inline bool hasDimmingMode () const;

    /**
     * Returns the value of the member "DimmingMode".
     *
     * Property to state the current Dimming mode
     *
     * @return The value of the field "DimmingMode"
     */
    inline uint8 getDimmingMode () const;

    /**
     * Sets the value of the member "DimmingMode".
     *
     * Property to state the current Dimming mode
     *
     * @param DimmingMode The value which will be set
     */
    inline void setDimmingMode (uint8 DimmingMode_);

    static const DimmingModeUpdate &getDefaultInstance();

private:

    inline void set_has_DimmingMode ();

    inline void clear_has_DimmingMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DimmingMode;

};

/**
 * Property to state the current Dimming mode
 */
class DimmingModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimmingModeRegister ();

    /**
     * Copy constructor
     */
    inline  DimmingModeRegister (const DimmingModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DimmingModeRegister();

    /**
     * Assignment operator
     */
    inline DimmingModeRegister& operator = (const DimmingModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimmingModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimmingModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimmingModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimmingModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DimmingModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  SpeedLockStatusUpdate::SpeedLockStatusUpdate ()  :
    _SpeedLockStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedLockStatusUpdate::SpeedLockStatusUpdate (const SpeedLockStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SpeedLockStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedLockStatusUpdate::SpeedLockStatusUpdate (bool SpeedLockStatus_)  :
    _SpeedLockStatus (SpeedLockStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeedLockStatusUpdate::~SpeedLockStatusUpdate() {
}

inline SpeedLockStatusUpdate& SpeedLockStatusUpdate::operator = (const SpeedLockStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSpeedLockStatus()) {
            setSpeedLockStatus(rhs.getSpeedLockStatus());
        } else {
            clearSpeedLockStatus();
        }
    }
    return *this;
}

inline bool SpeedLockStatusUpdate::operator == (const SpeedLockStatusUpdate& rhs) const {
    return (((!hasSpeedLockStatus() && !rhs.hasSpeedLockStatus()) || getSpeedLockStatus() == rhs.getSpeedLockStatus()));
}

inline bool SpeedLockStatusUpdate::operator != (const SpeedLockStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedLockStatusUpdate::operator < (const SpeedLockStatusUpdate& rhs) const {
    if (hasSpeedLockStatus() || rhs.hasSpeedLockStatus()) {
        if (getSpeedLockStatus() < rhs.getSpeedLockStatus()) return true;
        if (getSpeedLockStatus() > rhs.getSpeedLockStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeedLockStatusUpdate::clone() {
    return new SpeedLockStatusUpdate(*this);
}

inline bool SpeedLockStatusUpdate::operator > (const SpeedLockStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedLockStatusUpdate::clear() {
    clearSpeedLockStatus();
}

inline void SpeedLockStatusUpdate::clearSpeedLockStatus() {
    if (hasSpeedLockStatus()) {
         clear_has_SpeedLockStatus();
        _SpeedLockStatus = false;
     }
}

inline bool SpeedLockStatusUpdate::hasSpeedLockStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SpeedLockStatusUpdate::getSpeedLockStatus () const {
    return _SpeedLockStatus;
}

inline void SpeedLockStatusUpdate::setSpeedLockStatus (bool SpeedLockStatus_) {
    set_has_SpeedLockStatus();
    this->_SpeedLockStatus = SpeedLockStatus_;
}

inline void SpeedLockStatusUpdate::set_has_SpeedLockStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeedLockStatusUpdate::clear_has_SpeedLockStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeedLockStatusRegister::SpeedLockStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedLockStatusRegister::SpeedLockStatusRegister (const SpeedLockStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedLockStatusRegister::~SpeedLockStatusRegister() {
}

inline SpeedLockStatusRegister& SpeedLockStatusRegister::operator = (const SpeedLockStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SpeedLockStatusRegister::operator == (const SpeedLockStatusRegister& ) const {
    return true;
}

inline bool SpeedLockStatusRegister::operator != (const SpeedLockStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedLockStatusRegister::operator < (const SpeedLockStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SpeedLockStatusRegister::clone() {
    return new SpeedLockStatusRegister(*this);
}

inline bool SpeedLockStatusRegister::operator > (const SpeedLockStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedLockStatusRegister::clear() {
}

inline  DimmingModeUpdate::DimmingModeUpdate ()  :
    _DimmingMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DimmingModeUpdate::DimmingModeUpdate (const DimmingModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DimmingMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DimmingModeUpdate::DimmingModeUpdate (uint8 DimmingMode_)  :
    _DimmingMode (DimmingMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DimmingModeUpdate::~DimmingModeUpdate() {
}

inline DimmingModeUpdate& DimmingModeUpdate::operator = (const DimmingModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDimmingMode()) {
            setDimmingMode(rhs.getDimmingMode());
        } else {
            clearDimmingMode();
        }
    }
    return *this;
}

inline bool DimmingModeUpdate::operator == (const DimmingModeUpdate& rhs) const {
    return (((!hasDimmingMode() && !rhs.hasDimmingMode()) || getDimmingMode() == rhs.getDimmingMode()));
}

inline bool DimmingModeUpdate::operator != (const DimmingModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DimmingModeUpdate::operator < (const DimmingModeUpdate& rhs) const {
    if (hasDimmingMode() || rhs.hasDimmingMode()) {
        if (getDimmingMode() < rhs.getDimmingMode()) return true;
        if (getDimmingMode() > rhs.getDimmingMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DimmingModeUpdate::clone() {
    return new DimmingModeUpdate(*this);
}

inline bool DimmingModeUpdate::operator > (const DimmingModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DimmingModeUpdate::clear() {
    clearDimmingMode();
}

inline void DimmingModeUpdate::clearDimmingMode() {
    if (hasDimmingMode()) {
         clear_has_DimmingMode();
        _DimmingMode = 0u;
     }
}

inline bool DimmingModeUpdate::hasDimmingMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DimmingModeUpdate::getDimmingMode () const {
    return _DimmingMode;
}

inline void DimmingModeUpdate::setDimmingMode (uint8 DimmingMode_) {
    set_has_DimmingMode();
    this->_DimmingMode = DimmingMode_;
}

inline void DimmingModeUpdate::set_has_DimmingMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void DimmingModeUpdate::clear_has_DimmingMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DimmingModeRegister::DimmingModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DimmingModeRegister::DimmingModeRegister (const DimmingModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DimmingModeRegister::~DimmingModeRegister() {
}

inline DimmingModeRegister& DimmingModeRegister::operator = (const DimmingModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DimmingModeRegister::operator == (const DimmingModeRegister& ) const {
    return true;
}

inline bool DimmingModeRegister::operator != (const DimmingModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DimmingModeRegister::operator < (const DimmingModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DimmingModeRegister::clone() {
    return new DimmingModeRegister(*this);
}

inline bool DimmingModeRegister::operator > (const DimmingModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DimmingModeRegister::clear() {
}

} // namespace HmiData
} // namespace hmidataservice
} // namespace hmi
} // namespace nissan
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_NISSAN_HMI_HMIDATASERVICE_HMIDATA_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
