/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_TESTIMAGESSTUB_H
#define BOSCH_CM_AI_HMI_TESTIMAGESSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/TestImages.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace TestImages {

class TestImagesStubDelegate;

class TestImagesStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TestImagesStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TestImagesStub (const std::string& portName);

    /**
     * Create an instance of the TestImagesStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TestImagesStub (const std::string& portName, const std::string& objectPath);

    virtual ~TestImagesStub();

    // method 'ActivateTestImageProcessing'

    /**
     * The method onActivateTestImageProcessing() is called by ASF when a
     * client invokes the method 'ActivateTestImageProcessing'.  Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ActivateTestImageProcessing'</b>:
     *
     * Enable/disable displaying of testimages
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActivateTestImageProcessingRequest (const ::boost::shared_ptr< ActivateTestImageProcessingRequest >& request) = 0;

    // method 'ShowTestImage'

    /**
     * The method onShowTestImage() is called by ASF when a client invokes the
     * method 'ShowTestImage'. A subclass has to implement this method and
     * send back a response to the client either with the sendShowTestImage()
     * or sendShowTestImageError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ShowTestImage'</b>:
     *
     * Show a test image on a particular display
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowTestImageRequest (const ::boost::shared_ptr< ShowTestImageRequest >& request) = 0;

    /**
     * The method sendShowTestImageResponse() sends a response of a previous
     * method invocation of 'ShowTestImage' back to the client.
     *
     * <b>Documentation of 'ShowTestImage'</b>:
     *
     * Show a test image on a particular display
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowTestImage(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendShowTestImageResponse (const TestImageStatus& status, act_t act = 0);

    /**
     * The method sendShowTestImageError() sends an error response of a
     * previous method invocation of 'ShowTestImage' back to the client.
     *
     * <b>Documentation of 'ShowTestImage'</b>:
     *
     * Show a test image on a particular display
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onShowTestImage(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendShowTestImageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class TestImagesStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace TestImages
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_TESTIMAGESSTUB_H
