/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/TestImages.h"
#include "bosch/cm/ai/hmi/TestImagesDBus.h"
#include "bosch/cm/ai/hmi/TestImagesJson.h"
#include "bosch/cm/ai/hmi/TestImagesStub.h"

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace TestImages {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/bosch/cm/ai/hmi/TestImages", TestImagesStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "ShowTestImage", 1 },
    { 27, "ActivateTestImageProcessing", 0 },
};


class TestImagesStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TestImagesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TestImagesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TestImagesStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.TestImages"),
          _logger(logger) {}

    virtual ~TestImagesStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TestImagesStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ActivateTestImageProcessing'

            LOG_DEBUG_STUB("process method '%s'", "ActivateTestImageProcessing");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateTestImageProcessingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ActivateTestImageProcessing", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActivateTestImageProcessingRequest > payload = ::boost::static_pointer_cast<ActivateTestImageProcessingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TestImagesStub*>(getStub())->onActivateTestImageProcessingRequest(payload);
            return;
        }
        case 1: {

            // method 'ShowTestImage'

            LOG_DEBUG_STUB("process method '%s'", "ShowTestImage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowTestImageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowTestImage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowTestImageRequest > payload = ::boost::static_pointer_cast<ShowTestImageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TestImagesStub*>(getStub())->onShowTestImageRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TestImagesStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.TestImages\">\n"
            "    <method name=\"ActivateTestImageProcessing\">\n"
            "      <doc>\n"
            "        <line>ActivateTestImageProcessing = Enable/disable displaying of testimages</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"activate\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>activate = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ShowTestImage\">\n"
            "      <doc>\n"
            "        <line>ShowTestImage = Show a test image on a particular display</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"imagePath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>imagePath = full qualified path to image file to display</line>\n"
            "          <line>supported formats are png and jpeg</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"displayId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>displayId = display id where to show the test image</line>\n"
            "          <line>if displayId is 0 image will be shown on all displays</line>\n"
            "          <line>otherwise displayId will be used as index to access a</line>\n"
            "          <line>display in the array ov available displays</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"(u)\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void TestImagesStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TestImagesStub*>(getStub()))->onGetAll (properties);
}

void TestImagesStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TestImagesStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TestImagesStub::TestImagesStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TestImagesStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TestImagesStub::TestImagesStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TestImagesStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TestImagesStub::~TestImagesStub() {
    delete _stubDelegate;
}


void  TestImagesStub::sendShowTestImageResponse (const TestImageStatus& status, act_t act) {
    ShowTestImageResponse* payload = new ShowTestImageResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "ShowTestImage", ShowTestImageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShowTestImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TestImagesStub::sendShowTestImageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShowTestImageError* payload = new ShowTestImageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ShowTestImage", ShowTestImageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShowTestImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void TestImagesStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace TestImages
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
