/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_TESTIMAGESPROXY_H
#define BOSCH_CM_AI_HMI_TESTIMAGESPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/TestImages.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace TestImages {

class TestImagesProxy;

class ShowTestImageCallbackIF {
public:
    virtual ~ShowTestImageCallbackIF() {}

    virtual void onShowTestImageError(const ::boost::shared_ptr< TestImagesProxy >& proxy, const ::boost::shared_ptr< ShowTestImageError >& error) = 0;

    virtual void onShowTestImageResponse(const ::boost::shared_ptr< TestImagesProxy >& proxy, const ::boost::shared_ptr< ShowTestImageResponse >& response) = 0;
};


/**
 * TestImagesProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.ai.hmi.TestImages' (specified in file
 * TestImages_.xml).
 *
 * service for test images
 */
class TestImagesProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TestImagesProxy.
     */
    static ::boost::shared_ptr< TestImagesProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TestImagesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TestImagesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TestImagesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TestImagesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TestImagesProxy > proxyNew(new TestImagesProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~TestImagesProxy ();




    // Method 'ActivateTestImageProcessing'

    /**
     * Call the method 'ActivateTestImageProcessing'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ActivateTestImageProcessing'</b>:
     *
     * Enable/disable displaying of testimages
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param activate If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateTestImageProcessingRequest(bool activate) const;

    // Method 'ShowTestImage'

    /**
     * Call the method 'ShowTestImage'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ShowTestImage'</b>:
     *
     * Show a test image on a particular display
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param imagePath full qualified path to image file to display
     * 			                   supported formats are png and jpeg
     *
     * @param displayId display id where to show the test image
     * 			                   if displayId is 0 image will be shown on all displays
     * 			                   otherwise displayId will be used as index to access a
     * 			                   display in the array ov available displays
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShowTestImageRequest(ShowTestImageCallbackIF& cb, const ::std::string& imagePath, uint32 displayId) const;


private:

    TestImagesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class TestImagesProxyCallback;
};

} // namespace TestImages
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_TESTIMAGESPROXY_H
