/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/TestImages.h"
#include "bosch/cm/ai/hmi/TestImagesDBus.h"
#include "bosch/cm/ai/hmi/TestImagesJson.h"
#include "bosch/cm/ai/hmi/TestImagesProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace TestImages {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/bosch/cm/ai/hmi/TestImages", TestImagesProxy);

class TestImagesProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    TestImagesProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< TestImagesProxy >& proxyShared = ::boost::static_pointer_cast< TestImagesProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ShowTestImage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ShowTestImageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowTestImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowTestImageError> payload = ::boost::static_pointer_cast<ShowTestImageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowTestImageCallbackIF*) _callback)->onShowTestImageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowTestImageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShowTestImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShowTestImageResponse> payload = ::boost::static_pointer_cast<ShowTestImageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ShowTestImageCallbackIF*) _callback)->onShowTestImageResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ShowTestImage: {
                ::boost::shared_ptr< ShowTestImageError > payload = ::boost::shared_ptr< ShowTestImageError >
                (new ShowTestImageError(DBUS_ERROR_NO_SERVER, "The DBus service TestImages is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShowTestImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TestImagesProxy> proxyShared = ::boost::static_pointer_cast<TestImagesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShowTestImageCallbackIF*) _callback)->onShowTestImageError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& TestImagesProxyCallback::_logger (TestImagesProxy::_logger);

TestImagesProxy::TestImagesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.TestImages", serviceAvailable, _logger) {
}

TestImagesProxy::~TestImagesProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< TestImagesProxy > TestImagesProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<TestImagesProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< TestImagesProxy > proxyNew(new TestImagesProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t TestImagesProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    TestImagesProxyCallback* callback = new TestImagesProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t TestImagesProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    TestImagesProxyCallback* callback = new TestImagesProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t TestImagesProxy::sendActivateTestImageProcessingRequest(bool activate) const {
    ActivateTestImageProcessingRequest* payload = new ActivateTestImageProcessingRequest();
    CHECK_ALLOCATION(payload);
    payload->setActivate(activate);
    DBUS_MESSAGE_CALL(dbusMessage, "ActivateTestImageProcessing", ActivateTestImageProcessingRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ActivateTestImageProcessing");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t TestImagesProxy::sendShowTestImageRequest(ShowTestImageCallbackIF& cb, const ::std::string& imagePath, uint32 displayId) const {
    ShowTestImageRequest* payload = new ShowTestImageRequest();
    CHECK_ALLOCATION(payload);
    payload->setImagePath(imagePath);
    payload->setDisplayId(displayId);
    DBUS_MESSAGE_CALL(dbusMessage, "ShowTestImage", ShowTestImageRequest, payload, true)
    act_t act = addMethodCallback(ID_ShowTestImage, dbusMessage.getUniqueSerial(), "ShowTestImage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ShowTestImage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace TestImages
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
