/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSSTUB_H
#define BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

class CommandsStubDelegate;

class CommandsStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the CommandsStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    CommandsStub (const std::string& portName);

    /**
     * Create an instance of the CommandsStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    CommandsStub (const std::string& portName, const std::string& objectPath);

    virtual ~CommandsStub();

    // signal 'TraceQuery'

    /**
     * Raise the signal 'TraceQuery' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'TraceQuery'</b>:
     *
     * send out trace query to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendTraceQuerySignal(const TraceQueryData& data);

    // signal 'SimTouch'

    /**
     * Raise the signal 'SimTouch' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SimTouch'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimTouchSignal(const SimTouchData& data);

    // signal 'SimTouchByName'

    /**
     * Raise the signal 'SimTouchByName' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SimTouchByName'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimTouchByNameSignal(const SimTouchByNameData& data);

    // signal 'SimTouchByText'

    /**
     * Raise the signal 'SimTouchByText' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SimTouchByText'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimTouchByTextSignal(const SimTouchByTextData& data);

    // signal 'SimTouchByTextId'

    /**
     * Raise the signal 'SimTouchByTextId' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SimTouchByTextId'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimTouchByTextIdSignal(const SimTouchByTextIdData& data);

    // signal 'SimTouchByIndex'

    /**
     * Raise the signal 'SimTouchByIndex' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SimTouchByIndex'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimTouchByIndexSignal(const SimTouchByIndexData& data);

    // signal 'WidgetPropertyValueSetter'

    /**
     * Raise the signal 'WidgetPropertyValueSetter' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'WidgetPropertyValueSetter'</b>:
     *
     * send out WidgetPropertyValueSetter commands to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendWidgetPropertyValueSetterSignal(const WidgetPropertyValueSetterData& data);

    // signal 'SimRotateEncoder'

    /**
     * Raise the signal 'SimRotateEncoder' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SimRotateEncoder'</b>:
     *
     * send out EncoderStatusChangedUpdMsg to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimRotateEncoderSignal(const SimRotateEncoderData& data);

    // signal 'SimJoystick'

    /**
     * Raise the signal 'SimJoystick' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SimJoystick'</b>:
     *
     * send out JoystickStatusChangedUpdMsg to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimJoystickSignal(const SimJoystickData& data);

    // signal 'SimEnterKey'

    /**
     * Raise the signal 'SimEnterKey' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SimEnterKey'</b>:
     *
     * send out EnterKeyStatusChangedUpdMsg to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimEnterKeySignal(const SimEnterKeyData& data);

    // signal 'SimFocusReq'

    /**
     * Raise the signal 'SimFocusReq' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SimFocusReq'</b>:
     *
     * send out FocusControlReqMsg to all registered clients
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSimFocusReqSignal(const SimFocusReqData& data);

    // method 'UpdateClientStatus'

    /**
     * The method onUpdateClientStatus() is called by ASF when a client
     * invokes the method 'UpdateClientStatus'.  Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'UpdateClientStatus'</b>:
     *
     * transport information about the hmi process to stub
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateClientStatusRequest (const ::boost::shared_ptr< UpdateClientStatusRequest >& request) = 0;

    // method 'UpdateTraceQueryResult'

    /**
     * The method onUpdateTraceQueryResult() is called by ASF when a client
     * invokes the method 'UpdateTraceQueryResult'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'UpdateTraceQueryResult'</b>:
     *
     * forward status data to stub (for trace/testing purpose)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateTraceQueryResultRequest (const ::boost::shared_ptr< UpdateTraceQueryResultRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class CommandsStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSSTUB_H
