/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsDBus.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsJson.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsStub.h"

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/appctrl/trace/bosch/cm/ai/hmi/appctrl/trace/Commands", CommandsStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 18, "UpdateClientStatus", 0 },
    { 22, "UpdateTraceQueryResult", 1 },
};


class CommandsStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    CommandsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    CommandsStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    CommandsStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.appctrl.trace.Commands"),
          _logger(logger) {}

    virtual ~CommandsStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void CommandsStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'UpdateClientStatus'

            LOG_DEBUG_STUB("process method '%s'", "UpdateClientStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateClientStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateClientStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateClientStatusRequest > payload = ::boost::static_pointer_cast<UpdateClientStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandsStub*>(getStub())->onUpdateClientStatusRequest(payload);
            return;
        }
        case 1: {

            // method 'UpdateTraceQueryResult'

            LOG_DEBUG_STUB("process method '%s'", "UpdateTraceQueryResult");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateTraceQueryResultRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateTraceQueryResult", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateTraceQueryResultRequest > payload = ::boost::static_pointer_cast<UpdateTraceQueryResultRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<CommandsStub*>(getStub())->onUpdateTraceQueryResultRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* CommandsStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.appctrl.trace.Commands\">\n"
            "    <method name=\"UpdateClientStatus\">\n"
            "      <doc>\n"
            "        <line>UpdateClientStatus = transport information about the hmi process to stub</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"pid\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>pid = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"name\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>name = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaces\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>surfaces = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateTraceQueryResult\">\n"
            "      <doc>\n"
            "        <line>UpdateTraceQueryResult = forward status data to stub (for trace/testing purpose)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"data\" type=\"(iuas)\">\n"
            "        <doc>\n"
            "          <line>data (of type TraceQueryData) = Description missing</line>\n"
            "          <line>TraceQueryData struct[pid, queryId, queryInput] = struct to transport common trace query information</line>\n"
            "          <line>0: TraceQueryData.pid ('i') = Description missing</line>\n"
            "          <line>1: TraceQueryData.queryId ('?') = Description missing</line>\n"
            "          <line>2: TraceQueryData.queryInput ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"TraceQuery\">\n"
            "      <doc>\n"
            "        <line>TraceQuery = send out trace query to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iuas)\">\n"
            "        <doc>\n"
            "          <line>data (of type TraceQueryData) = Description missing</line>\n"
            "          <line>TraceQueryData struct[pid, queryId, queryInput] = struct to transport common trace query information</line>\n"
            "          <line>0: TraceQueryData.pid ('i') = Description missing</line>\n"
            "          <line>1: TraceQueryData.queryId ('?') = Description missing</line>\n"
            "          <line>2: TraceQueryData.queryInput ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimTouch\">\n"
            "      <doc>\n"
            "        <line>SimTouch = send out touch simulation commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iiiiiu)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimTouchData) = Description missing</line>\n"
            "          <line>SimTouchData struct[pid, xPos, yPos, surfaceId, pointerId, status] = struct to transport touch simulation data</line>\n"
            "          <line>0: SimTouchData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimTouchData.xPos ('i') = Description missing</line>\n"
            "          <line>2: SimTouchData.yPos ('i') = Description missing</line>\n"
            "          <line>3: SimTouchData.surfaceId ('i') = Description missing</line>\n"
            "          <line>4: SimTouchData.pointerId ('i') = Description missing</line>\n"
            "          <line>5: SimTouchData.status ('?') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimTouchByName\">\n"
            "      <doc>\n"
            "        <line>SimTouchByName = send out touch simulation commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ia(i(iiii))ss)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimTouchByNameData) = Description missing</line>\n"
            "          <line>SimTouchByNameData struct[pid, touchableSurfaces, widgetName, viewName] = struct to transport touch simulation data</line>\n"
            "          <line>0: SimTouchByNameData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimTouchByNameData.touchableSurfaces ('?') = Description missing</line>\n"
            "          <line>2: SimTouchByNameData.widgetName ('s') = Description missing</line>\n"
            "          <line>3: SimTouchByNameData.viewName ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimTouchByText\">\n"
            "      <doc>\n"
            "        <line>SimTouchByText = send out touch simulation commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ia(i(iiii))s)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimTouchByTextData) = Description missing</line>\n"
            "          <line>SimTouchByTextData struct[pid, touchableSurfaces, widgetText] = struct to transport touch simulation data</line>\n"
            "          <line>0: SimTouchByTextData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimTouchByTextData.touchableSurfaces ('?') = Description missing</line>\n"
            "          <line>2: SimTouchByTextData.widgetText ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimTouchByTextId\">\n"
            "      <doc>\n"
            "        <line>SimTouchByTextId = send out touch simulation commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ia(i(iiii))s)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimTouchByTextIdData) = Description missing</line>\n"
            "          <line>SimTouchByTextIdData struct[pid, touchableSurfaces, widgetTextId] = struct to transport touch simulation data</line>\n"
            "          <line>0: SimTouchByTextIdData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimTouchByTextIdData.touchableSurfaces ('?') = Description missing</line>\n"
            "          <line>2: SimTouchByTextIdData.widgetTextId ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimTouchByIndex\">\n"
            "      <doc>\n"
            "        <line>SimTouchByIndex = send out touch simulation commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ia(i(iiii))ii)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimTouchByIndexData) = Description missing</line>\n"
            "          <line>SimTouchByIndexData struct[pid, touchableSurfaces, ListID, ButtonWidgetIndex] = struct to transport touch simulation data of a ListItem\n"
            "			The ListID along with the index of the Button to be selected.</line>\n"
            "          <line>0: SimTouchByIndexData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimTouchByIndexData.touchableSurfaces ('?') = Description missing</line>\n"
            "          <line>2: SimTouchByIndexData.ListID ('i') = Description missing</line>\n"
            "          <line>3: SimTouchByIndexData.ButtonWidgetIndex ('i') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"WidgetPropertyValueSetter\">\n"
            "      <doc>\n"
            "        <line>WidgetPropertyValueSetter = send out WidgetPropertyValueSetter commands to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iasss)\">\n"
            "        <doc>\n"
            "          <line>data (of type WidgetPropertyValueSetterData) = Description missing</line>\n"
            "          <line>WidgetPropertyValueSetterData struct[pid, widgetNames, propertyName, propertyValue] = struct to transport common widget property setter information</line>\n"
            "          <line>0: WidgetPropertyValueSetterData.pid ('i') = Description missing</line>\n"
            "          <line>1: WidgetPropertyValueSetterData.widgetNames ('?') = Description missing</line>\n"
            "          <line>2: WidgetPropertyValueSetterData.propertyName ('s') = Description missing</line>\n"
            "          <line>3: WidgetPropertyValueSetterData.propertyValue ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimRotateEncoder\">\n"
            "      <doc>\n"
            "        <line>SimRotateEncoder = send out EncoderStatusChangedUpdMsg to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(isiu)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimRotateEncoderData) = Description missing</line>\n"
            "          <line>SimRotateEncoderData struct[pid, encCode, encSteps, userData] = struct to post Rotate Encorder message</line>\n"
            "          <line>0: SimRotateEncoderData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimRotateEncoderData.encCode ('s') = Description missing</line>\n"
            "          <line>2: SimRotateEncoderData.encSteps ('i') = Description missing</line>\n"
            "          <line>3: SimRotateEncoderData.userData ('u') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimJoystick\">\n"
            "      <doc>\n"
            "        <line>SimJoystick = send out JoystickStatusChangedUpdMsg to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ius)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimJoystickData) = Description missing</line>\n"
            "          <line>SimJoystickData struct[pid, direction, source] = struct to post Rotate Joystick message</line>\n"
            "          <line>0: SimJoystickData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimJoystickData.direction ('u') = Description missing</line>\n"
            "          <line>2: SimJoystickData.source ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimEnterKey\">\n"
            "      <doc>\n"
            "        <line>SimEnterKey = send out EnterKeyStatusChangedUpdMsg to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(ius)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimEnterKeyData) = Description missing</line>\n"
            "          <line>SimEnterKeyData struct[pid, keyState, source] = struct to post EnterKey message</line>\n"
            "          <line>0: SimEnterKeyData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimEnterKeyData.keyState ('u') = Description missing</line>\n"
            "          <line>2: SimEnterKeyData.source ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"SimFocusReq\">\n"
            "      <doc>\n"
            "        <line>SimFocusReq = send out FocusControlReqMsg to all registered clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"data\" type=\"(iuuss)\">\n"
            "        <doc>\n"
            "          <line>data (of type SimFocusReqData) = Description missing</line>\n"
            "          <line>SimFocusReqData struct[pid, action, timeAction, viewName, widgetName] = struct to post FocusReq message</line>\n"
            "          <line>0: SimFocusReqData.pid ('i') = Description missing</line>\n"
            "          <line>1: SimFocusReqData.action ('u') = Description missing</line>\n"
            "          <line>2: SimFocusReqData.timeAction ('u') = Description missing</line>\n"
            "          <line>3: SimFocusReqData.viewName ('s') = Description missing</line>\n"
            "          <line>4: SimFocusReqData.widgetName ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void CommandsStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<CommandsStub*>(getStub()))->onGetAll (properties);
}

void CommandsStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void CommandsStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

CommandsStub::CommandsStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new CommandsStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

CommandsStub::CommandsStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new CommandsStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

CommandsStub::~CommandsStub() {
    delete _stubDelegate;
}

void CommandsStub::sendTraceQuerySignal(const TraceQueryData& data) {
    if (_stubDelegate->isConnected()) {
        TraceQuerySignal* payload = new TraceQuerySignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "TraceQuery", TraceQuerySignal, payload)
        LOG_INFO ("-> send%sSignal", "TraceQuery");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "TraceQuery");
    }
}

void CommandsStub::sendSimTouchSignal(const SimTouchData& data) {
    if (_stubDelegate->isConnected()) {
        SimTouchSignal* payload = new SimTouchSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimTouch", SimTouchSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimTouch");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimTouch");
    }
}

void CommandsStub::sendSimTouchByNameSignal(const SimTouchByNameData& data) {
    if (_stubDelegate->isConnected()) {
        SimTouchByNameSignal* payload = new SimTouchByNameSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimTouchByName", SimTouchByNameSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimTouchByName");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimTouchByName");
    }
}

void CommandsStub::sendSimTouchByTextSignal(const SimTouchByTextData& data) {
    if (_stubDelegate->isConnected()) {
        SimTouchByTextSignal* payload = new SimTouchByTextSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimTouchByText", SimTouchByTextSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimTouchByText");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimTouchByText");
    }
}

void CommandsStub::sendSimTouchByTextIdSignal(const SimTouchByTextIdData& data) {
    if (_stubDelegate->isConnected()) {
        SimTouchByTextIdSignal* payload = new SimTouchByTextIdSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimTouchByTextId", SimTouchByTextIdSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimTouchByTextId");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimTouchByTextId");
    }
}

void CommandsStub::sendSimTouchByIndexSignal(const SimTouchByIndexData& data) {
    if (_stubDelegate->isConnected()) {
        SimTouchByIndexSignal* payload = new SimTouchByIndexSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimTouchByIndex", SimTouchByIndexSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimTouchByIndex");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimTouchByIndex");
    }
}

void CommandsStub::sendWidgetPropertyValueSetterSignal(const WidgetPropertyValueSetterData& data) {
    if (_stubDelegate->isConnected()) {
        WidgetPropertyValueSetterSignal* payload = new WidgetPropertyValueSetterSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "WidgetPropertyValueSetter", WidgetPropertyValueSetterSignal, payload)
        LOG_INFO ("-> send%sSignal", "WidgetPropertyValueSetter");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "WidgetPropertyValueSetter");
    }
}

void CommandsStub::sendSimRotateEncoderSignal(const SimRotateEncoderData& data) {
    if (_stubDelegate->isConnected()) {
        SimRotateEncoderSignal* payload = new SimRotateEncoderSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimRotateEncoder", SimRotateEncoderSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimRotateEncoder");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimRotateEncoder");
    }
}

void CommandsStub::sendSimJoystickSignal(const SimJoystickData& data) {
    if (_stubDelegate->isConnected()) {
        SimJoystickSignal* payload = new SimJoystickSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimJoystick", SimJoystickSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimJoystick");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimJoystick");
    }
}

void CommandsStub::sendSimEnterKeySignal(const SimEnterKeyData& data) {
    if (_stubDelegate->isConnected()) {
        SimEnterKeySignal* payload = new SimEnterKeySignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimEnterKey", SimEnterKeySignal, payload)
        LOG_INFO ("-> send%sSignal", "SimEnterKey");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimEnterKey");
    }
}

void CommandsStub::sendSimFocusReqSignal(const SimFocusReqData& data) {
    if (_stubDelegate->isConnected()) {
        SimFocusReqSignal* payload = new SimFocusReqSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SimFocusReq", SimFocusReqSignal, payload)
        LOG_INFO ("-> send%sSignal", "SimFocusReq");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SimFocusReq");
    }
}



void CommandsStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
