/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSPROXY_H
#define BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

class CommandsProxy;

class SimEnterKeyCallbackIF {
public:
    virtual ~SimEnterKeyCallbackIF() {}

    virtual void onSimEnterKeyError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimEnterKeyError >& error) = 0;

    virtual void onSimEnterKeySignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimEnterKeySignal >& signal) = 0;
};

class SimFocusReqCallbackIF {
public:
    virtual ~SimFocusReqCallbackIF() {}

    virtual void onSimFocusReqError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimFocusReqError >& error) = 0;

    virtual void onSimFocusReqSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimFocusReqSignal >& signal) = 0;
};

class SimJoystickCallbackIF {
public:
    virtual ~SimJoystickCallbackIF() {}

    virtual void onSimJoystickError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimJoystickError >& error) = 0;

    virtual void onSimJoystickSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimJoystickSignal >& signal) = 0;
};

class SimRotateEncoderCallbackIF {
public:
    virtual ~SimRotateEncoderCallbackIF() {}

    virtual void onSimRotateEncoderError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimRotateEncoderError >& error) = 0;

    virtual void onSimRotateEncoderSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimRotateEncoderSignal >& signal) = 0;
};

class SimTouchByIndexCallbackIF {
public:
    virtual ~SimTouchByIndexCallbackIF() {}

    virtual void onSimTouchByIndexError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByIndexError >& error) = 0;

    virtual void onSimTouchByIndexSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByIndexSignal >& signal) = 0;
};

class SimTouchByNameCallbackIF {
public:
    virtual ~SimTouchByNameCallbackIF() {}

    virtual void onSimTouchByNameError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByNameError >& error) = 0;

    virtual void onSimTouchByNameSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByNameSignal >& signal) = 0;
};

class SimTouchByTextCallbackIF {
public:
    virtual ~SimTouchByTextCallbackIF() {}

    virtual void onSimTouchByTextError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByTextError >& error) = 0;

    virtual void onSimTouchByTextSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByTextSignal >& signal) = 0;
};

class SimTouchByTextIdCallbackIF {
public:
    virtual ~SimTouchByTextIdCallbackIF() {}

    virtual void onSimTouchByTextIdError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByTextIdError >& error) = 0;

    virtual void onSimTouchByTextIdSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchByTextIdSignal >& signal) = 0;
};

class SimTouchCallbackIF {
public:
    virtual ~SimTouchCallbackIF() {}

    virtual void onSimTouchError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchError >& error) = 0;

    virtual void onSimTouchSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< SimTouchSignal >& signal) = 0;
};

class TraceQueryCallbackIF {
public:
    virtual ~TraceQueryCallbackIF() {}

    virtual void onTraceQueryError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< TraceQueryError >& error) = 0;

    virtual void onTraceQuerySignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< TraceQuerySignal >& signal) = 0;
};

class WidgetPropertyValueSetterCallbackIF {
public:
    virtual ~WidgetPropertyValueSetterCallbackIF() {}

    virtual void onWidgetPropertyValueSetterError(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< WidgetPropertyValueSetterError >& error) = 0;

    virtual void onWidgetPropertyValueSetterSignal(const ::boost::shared_ptr< CommandsProxy >& proxy, const ::boost::shared_ptr< WidgetPropertyValueSetterSignal >& signal) = 0;
};


/**
 * CommandsProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.ai.hmi.appctrl.trace.Commands' (specified in file
 * HMIBaseTraceCmds_.xml).
 *
 * service for common hmi trace commands
 */
class CommandsProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of CommandsProxy.
     */
    static ::boost::shared_ptr< CommandsProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of CommandsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< CommandsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of CommandsProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< CommandsProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< CommandsProxy > proxyNew(new CommandsProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~CommandsProxy ();


    // Signal 'TraceQuery'

    /**
     * Notify on the signal 'TraceQuery'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'TraceQuery'</b>:
     *
     * send out trace query to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTraceQueryRegister(TraceQueryCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'TraceQuery'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'TraceQuery'</b>:
     *
     * send out trace query to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendTraceQueryRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTraceQueryDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'TraceQuery'.
     */
    void sendTraceQueryDeregisterAll () const;

    // Signal 'SimTouch'

    /**
     * Notify on the signal 'SimTouch'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimTouch'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimTouchRegister(SimTouchCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimTouch'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimTouch'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimTouchRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimTouchDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimTouch'.
     */
    void sendSimTouchDeregisterAll () const;

    // Signal 'SimTouchByName'

    /**
     * Notify on the signal 'SimTouchByName'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimTouchByName'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimTouchByNameRegister(SimTouchByNameCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimTouchByName'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimTouchByName'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimTouchByNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimTouchByNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimTouchByName'.
     */
    void sendSimTouchByNameDeregisterAll () const;

    // Signal 'SimTouchByText'

    /**
     * Notify on the signal 'SimTouchByText'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimTouchByText'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimTouchByTextRegister(SimTouchByTextCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimTouchByText'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimTouchByText'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimTouchByTextRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimTouchByTextDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimTouchByText'.
     */
    void sendSimTouchByTextDeregisterAll () const;

    // Signal 'SimTouchByTextId'

    /**
     * Notify on the signal 'SimTouchByTextId'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SimTouchByTextId'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimTouchByTextIdRegister(SimTouchByTextIdCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimTouchByTextId'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimTouchByTextId'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimTouchByTextIdRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimTouchByTextIdDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimTouchByTextId'.
     */
    void sendSimTouchByTextIdDeregisterAll () const;

    // Signal 'SimTouchByIndex'

    /**
     * Notify on the signal 'SimTouchByIndex'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SimTouchByIndex'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimTouchByIndexRegister(SimTouchByIndexCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimTouchByIndex'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimTouchByIndex'</b>:
     *
     * send out touch simulation commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimTouchByIndexRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimTouchByIndexDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimTouchByIndex'.
     */
    void sendSimTouchByIndexDeregisterAll () const;

    // Signal 'WidgetPropertyValueSetter'

    /**
     * Notify on the signal 'WidgetPropertyValueSetter'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'WidgetPropertyValueSetter'</b>:
     *
     * send out WidgetPropertyValueSetter commands to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWidgetPropertyValueSetterRegister(WidgetPropertyValueSetterCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'WidgetPropertyValueSetter'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'WidgetPropertyValueSetter'</b>:
     *
     * send out WidgetPropertyValueSetter commands to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendWidgetPropertyValueSetterRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWidgetPropertyValueSetterDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'WidgetPropertyValueSetter'.
     */
    void sendWidgetPropertyValueSetterDeregisterAll () const;

    // Signal 'SimRotateEncoder'

    /**
     * Notify on the signal 'SimRotateEncoder'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SimRotateEncoder'</b>:
     *
     * send out EncoderStatusChangedUpdMsg to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimRotateEncoderRegister(SimRotateEncoderCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimRotateEncoder'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimRotateEncoder'</b>:
     *
     * send out EncoderStatusChangedUpdMsg to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimRotateEncoderRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimRotateEncoderDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimRotateEncoder'.
     */
    void sendSimRotateEncoderDeregisterAll () const;

    // Signal 'SimJoystick'

    /**
     * Notify on the signal 'SimJoystick'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimJoystick'</b>:
     *
     * send out JoystickStatusChangedUpdMsg to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimJoystickRegister(SimJoystickCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimJoystick'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimJoystick'</b>:
     *
     * send out JoystickStatusChangedUpdMsg to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimJoystickRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimJoystickDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimJoystick'.
     */
    void sendSimJoystickDeregisterAll () const;

    // Signal 'SimEnterKey'

    /**
     * Notify on the signal 'SimEnterKey'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimEnterKey'</b>:
     *
     * send out EnterKeyStatusChangedUpdMsg to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimEnterKeyRegister(SimEnterKeyCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimEnterKey'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimEnterKey'</b>:
     *
     * send out EnterKeyStatusChangedUpdMsg to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimEnterKeyRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimEnterKeyDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimEnterKey'.
     */
    void sendSimEnterKeyDeregisterAll () const;

    // Signal 'SimFocusReq'

    /**
     * Notify on the signal 'SimFocusReq'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'SimFocusReq'</b>:
     *
     * send out FocusControlReqMsg to all registered clients
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimFocusReqRegister(SimFocusReqCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SimFocusReq'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SimFocusReq'</b>:
     *
     * send out FocusControlReqMsg to all registered clients
     *
     * @param act The act which was previously returned by the
     * sendSimFocusReqRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSimFocusReqDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SimFocusReq'.
     */
    void sendSimFocusReqDeregisterAll () const;



    // Method 'UpdateClientStatus'

    /**
     * Call the method 'UpdateClientStatus'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'UpdateClientStatus'</b>:
     *
     * transport information about the hmi process to stub
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param pid If the meaning of "pid" isn't clear, then there should be a description here.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param surfaces If the meaning of "surfaces" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateClientStatusRequest(uint32 pid, const ::std::string& name, const ::std::vector< uint32 >& surfaces) const;

    // Method 'UpdateTraceQueryResult'

    /**
     * Call the method 'UpdateTraceQueryResult'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'UpdateTraceQueryResult'</b>:
     *
     * forward status data to stub (for trace/testing purpose)
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateTraceQueryResultRequest(const TraceQueryData& data) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    CommandsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class CommandsProxyCallback;
};

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_TRACE_COMMANDSPROXY_H
