/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsDBus.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsJson.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/appctrl/trace/bosch/cm/ai/hmi/appctrl/trace/Commands", CommandsProxy);

class CommandsProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    CommandsProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< CommandsProxy >& proxyShared = ::boost::static_pointer_cast< CommandsProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_TraceQuery:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TraceQuerySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TraceQuery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<TraceQuerySignal> payload = ::boost::static_pointer_cast<TraceQuerySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((TraceQueryCallbackIF*) _callback)->onTraceQuerySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimTouch:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimTouchSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimTouch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimTouchSignal> payload = ::boost::static_pointer_cast<SimTouchSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimTouchCallbackIF*) _callback)->onSimTouchSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimTouchByName:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimTouchByNameSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimTouchByName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimTouchByNameSignal> payload = ::boost::static_pointer_cast<SimTouchByNameSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimTouchByNameCallbackIF*) _callback)->onSimTouchByNameSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimTouchByText:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimTouchByTextSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimTouchByText", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimTouchByTextSignal> payload = ::boost::static_pointer_cast<SimTouchByTextSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimTouchByTextCallbackIF*) _callback)->onSimTouchByTextSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimTouchByTextId:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimTouchByTextIdSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimTouchByTextId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimTouchByTextIdSignal> payload = ::boost::static_pointer_cast<SimTouchByTextIdSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimTouchByTextIdCallbackIF*) _callback)->onSimTouchByTextIdSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimTouchByIndex:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimTouchByIndexSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimTouchByIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimTouchByIndexSignal> payload = ::boost::static_pointer_cast<SimTouchByIndexSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimTouchByIndexCallbackIF*) _callback)->onSimTouchByIndexSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_WidgetPropertyValueSetter:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WidgetPropertyValueSetterSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WidgetPropertyValueSetter", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<WidgetPropertyValueSetterSignal> payload = ::boost::static_pointer_cast<WidgetPropertyValueSetterSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((WidgetPropertyValueSetterCallbackIF*) _callback)->onWidgetPropertyValueSetterSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimRotateEncoder:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimRotateEncoderSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimRotateEncoder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimRotateEncoderSignal> payload = ::boost::static_pointer_cast<SimRotateEncoderSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimRotateEncoderCallbackIF*) _callback)->onSimRotateEncoderSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimJoystick:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimJoystickSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimJoystick", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimJoystickSignal> payload = ::boost::static_pointer_cast<SimJoystickSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimJoystickCallbackIF*) _callback)->onSimJoystickSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimEnterKey:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimEnterKeySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimEnterKey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimEnterKeySignal> payload = ::boost::static_pointer_cast<SimEnterKeySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimEnterKeyCallbackIF*) _callback)->onSimEnterKeySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SimFocusReq:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SimFocusReqSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SimFocusReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SimFocusReqSignal> payload = ::boost::static_pointer_cast<SimFocusReqSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SimFocusReqCallbackIF*) _callback)->onSimFocusReqSignal (proxyShared, payload);
                    return true;
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_TraceQuery: {
                ::boost::shared_ptr< TraceQueryError > payload = ::boost::shared_ptr< TraceQueryError >
                (new TraceQueryError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TraceQuery", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TraceQueryCallbackIF*) _callback)->onTraceQueryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimTouch: {
                ::boost::shared_ptr< SimTouchError > payload = ::boost::shared_ptr< SimTouchError >
                (new SimTouchError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimTouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimTouchCallbackIF*) _callback)->onSimTouchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimTouchByName: {
                ::boost::shared_ptr< SimTouchByNameError > payload = ::boost::shared_ptr< SimTouchByNameError >
                (new SimTouchByNameError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimTouchByName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimTouchByNameCallbackIF*) _callback)->onSimTouchByNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimTouchByText: {
                ::boost::shared_ptr< SimTouchByTextError > payload = ::boost::shared_ptr< SimTouchByTextError >
                (new SimTouchByTextError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimTouchByText", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimTouchByTextCallbackIF*) _callback)->onSimTouchByTextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimTouchByTextId: {
                ::boost::shared_ptr< SimTouchByTextIdError > payload = ::boost::shared_ptr< SimTouchByTextIdError >
                (new SimTouchByTextIdError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimTouchByTextId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimTouchByTextIdCallbackIF*) _callback)->onSimTouchByTextIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimTouchByIndex: {
                ::boost::shared_ptr< SimTouchByIndexError > payload = ::boost::shared_ptr< SimTouchByIndexError >
                (new SimTouchByIndexError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimTouchByIndex", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimTouchByIndexCallbackIF*) _callback)->onSimTouchByIndexError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WidgetPropertyValueSetter: {
                ::boost::shared_ptr< WidgetPropertyValueSetterError > payload = ::boost::shared_ptr< WidgetPropertyValueSetterError >
                (new WidgetPropertyValueSetterError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WidgetPropertyValueSetter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WidgetPropertyValueSetterCallbackIF*) _callback)->onWidgetPropertyValueSetterError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimRotateEncoder: {
                ::boost::shared_ptr< SimRotateEncoderError > payload = ::boost::shared_ptr< SimRotateEncoderError >
                (new SimRotateEncoderError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimRotateEncoder", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimRotateEncoderCallbackIF*) _callback)->onSimRotateEncoderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimJoystick: {
                ::boost::shared_ptr< SimJoystickError > payload = ::boost::shared_ptr< SimJoystickError >
                (new SimJoystickError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimJoystick", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimJoystickCallbackIF*) _callback)->onSimJoystickError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimEnterKey: {
                ::boost::shared_ptr< SimEnterKeyError > payload = ::boost::shared_ptr< SimEnterKeyError >
                (new SimEnterKeyError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimEnterKey", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimEnterKeyCallbackIF*) _callback)->onSimEnterKeyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SimFocusReq: {
                ::boost::shared_ptr< SimFocusReqError > payload = ::boost::shared_ptr< SimFocusReqError >
                (new SimFocusReqError(DBUS_ERROR_NO_SERVER, "The DBus service Commands is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SimFocusReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<CommandsProxy> proxyShared = ::boost::static_pointer_cast<CommandsProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SimFocusReqCallbackIF*) _callback)->onSimFocusReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& CommandsProxyCallback::_logger (CommandsProxy::_logger);

CommandsProxy::CommandsProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.appctrl.trace.Commands", serviceAvailable, _logger) {
}

CommandsProxy::~CommandsProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< CommandsProxy > CommandsProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<CommandsProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< CommandsProxy > proxyNew(new CommandsProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t CommandsProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    CommandsProxyCallback* callback = new CommandsProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t CommandsProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    CommandsProxyCallback* callback = new CommandsProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void CommandsProxy::sendDeregisterAll () const
{
    sendTraceQueryDeregisterAll();
    sendSimTouchDeregisterAll();
    sendSimTouchByNameDeregisterAll();
    sendSimTouchByTextDeregisterAll();
    sendSimTouchByTextIdDeregisterAll();
    sendSimTouchByIndexDeregisterAll();
    sendWidgetPropertyValueSetterDeregisterAll();
    sendSimRotateEncoderDeregisterAll();
    sendSimJoystickDeregisterAll();
    sendSimEnterKeyDeregisterAll();
    sendSimFocusReqDeregisterAll();
}

act_t CommandsProxy::sendTraceQueryRegister(TraceQueryCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "TraceQuery");
    act_t act = addSignalCallback(ID_TraceQuery, "TraceQuery", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TraceQuery", &cb, act);
    return act;
}

bool CommandsProxy::sendTraceQueryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TraceQuery", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TraceQuery", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendTraceQueryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TraceQuery");
    _dbusProxyDelegate->deregisterSignalCallback("TraceQuery", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimTouchRegister(SimTouchCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimTouch");
    act_t act = addSignalCallback(ID_SimTouch, "SimTouch", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimTouch", &cb, act);
    return act;
}

bool CommandsProxy::sendSimTouchDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimTouch", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimTouch", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimTouchDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimTouch");
    _dbusProxyDelegate->deregisterSignalCallback("SimTouch", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimTouchByNameRegister(SimTouchByNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimTouchByName");
    act_t act = addSignalCallback(ID_SimTouchByName, "SimTouchByName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimTouchByName", &cb, act);
    return act;
}

bool CommandsProxy::sendSimTouchByNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimTouchByName", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimTouchByName", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimTouchByNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimTouchByName");
    _dbusProxyDelegate->deregisterSignalCallback("SimTouchByName", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimTouchByTextRegister(SimTouchByTextCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimTouchByText");
    act_t act = addSignalCallback(ID_SimTouchByText, "SimTouchByText", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimTouchByText", &cb, act);
    return act;
}

bool CommandsProxy::sendSimTouchByTextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimTouchByText", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimTouchByText", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimTouchByTextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimTouchByText");
    _dbusProxyDelegate->deregisterSignalCallback("SimTouchByText", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimTouchByTextIdRegister(SimTouchByTextIdCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimTouchByTextId");
    act_t act = addSignalCallback(ID_SimTouchByTextId, "SimTouchByTextId", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimTouchByTextId", &cb, act);
    return act;
}

bool CommandsProxy::sendSimTouchByTextIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimTouchByTextId", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimTouchByTextId", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimTouchByTextIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimTouchByTextId");
    _dbusProxyDelegate->deregisterSignalCallback("SimTouchByTextId", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimTouchByIndexRegister(SimTouchByIndexCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimTouchByIndex");
    act_t act = addSignalCallback(ID_SimTouchByIndex, "SimTouchByIndex", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimTouchByIndex", &cb, act);
    return act;
}

bool CommandsProxy::sendSimTouchByIndexDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimTouchByIndex", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimTouchByIndex", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimTouchByIndexDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimTouchByIndex");
    _dbusProxyDelegate->deregisterSignalCallback("SimTouchByIndex", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendWidgetPropertyValueSetterRegister(WidgetPropertyValueSetterCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "WidgetPropertyValueSetter");
    act_t act = addSignalCallback(ID_WidgetPropertyValueSetter, "WidgetPropertyValueSetter", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WidgetPropertyValueSetter", &cb, act);
    return act;
}

bool CommandsProxy::sendWidgetPropertyValueSetterDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WidgetPropertyValueSetter", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WidgetPropertyValueSetter", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendWidgetPropertyValueSetterDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WidgetPropertyValueSetter");
    _dbusProxyDelegate->deregisterSignalCallback("WidgetPropertyValueSetter", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimRotateEncoderRegister(SimRotateEncoderCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimRotateEncoder");
    act_t act = addSignalCallback(ID_SimRotateEncoder, "SimRotateEncoder", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimRotateEncoder", &cb, act);
    return act;
}

bool CommandsProxy::sendSimRotateEncoderDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimRotateEncoder", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimRotateEncoder", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimRotateEncoderDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimRotateEncoder");
    _dbusProxyDelegate->deregisterSignalCallback("SimRotateEncoder", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimJoystickRegister(SimJoystickCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimJoystick");
    act_t act = addSignalCallback(ID_SimJoystick, "SimJoystick", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimJoystick", &cb, act);
    return act;
}

bool CommandsProxy::sendSimJoystickDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimJoystick", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimJoystick", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimJoystickDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimJoystick");
    _dbusProxyDelegate->deregisterSignalCallback("SimJoystick", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimEnterKeyRegister(SimEnterKeyCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimEnterKey");
    act_t act = addSignalCallback(ID_SimEnterKey, "SimEnterKey", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimEnterKey", &cb, act);
    return act;
}

bool CommandsProxy::sendSimEnterKeyDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimEnterKey", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimEnterKey", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimEnterKeyDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimEnterKey");
    _dbusProxyDelegate->deregisterSignalCallback("SimEnterKey", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendSimFocusReqRegister(SimFocusReqCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SimFocusReq");
    act_t act = addSignalCallback(ID_SimFocusReq, "SimFocusReq", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SimFocusReq", &cb, act);
    return act;
}

bool CommandsProxy::sendSimFocusReqDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SimFocusReq", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SimFocusReq", act, static_cast<int>(rv));
    return rv;
}

void CommandsProxy::sendSimFocusReqDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SimFocusReq");
    _dbusProxyDelegate->deregisterSignalCallback("SimFocusReq", 0, _dbusDaemonProxy.get(), false);
}

act_t CommandsProxy::sendUpdateClientStatusRequest(uint32 pid, const ::std::string& name, const ::std::vector< uint32 >& surfaces) const {
    UpdateClientStatusRequest* payload = new UpdateClientStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setPid(pid);
    payload->setName(name);
    payload->setSurfaces(surfaces);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateClientStatus", UpdateClientStatusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "UpdateClientStatus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t CommandsProxy::sendUpdateTraceQueryResultRequest(const TraceQueryData& data) const {
    UpdateTraceQueryResultRequest* payload = new UpdateTraceQueryResultRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateTraceQueryResult", UpdateTraceQueryResultRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "UpdateTraceQueryResult");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
