/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsJson.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "TraceQueryData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasQueryId()) {
        yajl_gen_string(g, (const unsigned char*)  "queryId" , 7);
        const char* s = ::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId_Name(value.getQueryId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getQueryId());
    }
    if (!isSparse || value.hasQueryInput()) {
        yajl_gen_string(g, (const unsigned char*)  "queryInput" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getQueryInput();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_integer(g, (long long)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_integer(g, (long long)value.getYPos());
    }
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasPointerId()) {
        yajl_gen_string(g, (const unsigned char*)  "pointerId" , 9);
        yajl_gen_integer(g, (long long)value.getPointerId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Rect"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_integer(g, (long long)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_integer(g, (long long)value.getYPos());
    }
    if (!isSparse || value.hasWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "width" , 5);
        yajl_gen_integer(g, (long long)value.getWidth());
    }
    if (!isSparse || value.hasHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "height" , 6);
        yajl_gen_integer(g, (long long)value.getHeight());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SurfaceInfo"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSurfaceId()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaceId" , 9);
        yajl_gen_integer(g, (long long)value.getSurfaceId());
    }
    if (!isSparse || value.hasRect()) {
        yajl_gen_string(g, (const unsigned char*)  "rect" , 4);
        serializeJson(value.getRect(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByNameData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasTouchableSurfaces()) {
        yajl_gen_string(g, (const unsigned char*)  "touchableSurfaces" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >& o3 = value.getTouchableSurfaces();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasWidgetName()) {
        yajl_gen_string(g, (const unsigned char*)  "widgetName" , 10);
        const char *s = value.getWidgetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasViewName()) {
        yajl_gen_string(g, (const unsigned char*)  "viewName" , 8);
        const char *s = value.getViewName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByTextData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasTouchableSurfaces()) {
        yajl_gen_string(g, (const unsigned char*)  "touchableSurfaces" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >& o5 = value.getTouchableSurfaces();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasWidgetText()) {
        yajl_gen_string(g, (const unsigned char*)  "widgetText" , 10);
        const char *s = value.getWidgetText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByTextIdData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasTouchableSurfaces()) {
        yajl_gen_string(g, (const unsigned char*)  "touchableSurfaces" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >& o7 = value.getTouchableSurfaces();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasWidgetTextId()) {
        yajl_gen_string(g, (const unsigned char*)  "widgetTextId" , 12);
        const char *s = value.getWidgetTextId().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByIndexData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasTouchableSurfaces()) {
        yajl_gen_string(g, (const unsigned char*)  "touchableSurfaces" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >& o9 = value.getTouchableSurfaces();
        {
            ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasListID()) {
        yajl_gen_string(g, (const unsigned char*)  "ListID" , 6);
        yajl_gen_integer(g, (long long)value.getListID());
    }
    if (!isSparse || value.hasButtonWidgetIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "ButtonWidgetIndex" , 17);
        yajl_gen_integer(g, (long long)value.getButtonWidgetIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WidgetPropertyValueSetterData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasWidgetNames()) {
        yajl_gen_string(g, (const unsigned char*)  "widgetNames" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o11 = value.getWidgetNames();
        {
            ::std::vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasPropertyName()) {
        yajl_gen_string(g, (const unsigned char*)  "propertyName" , 12);
        const char *s = value.getPropertyName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPropertyValue()) {
        yajl_gen_string(g, (const unsigned char*)  "propertyValue" , 13);
        const char *s = value.getPropertyValue().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimRotateEncoderData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasEncCode()) {
        yajl_gen_string(g, (const unsigned char*)  "encCode" , 7);
        const char *s = value.getEncCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEncSteps()) {
        yajl_gen_string(g, (const unsigned char*)  "encSteps" , 8);
        yajl_gen_integer(g, (long long)value.getEncSteps());
    }
    if (!isSparse || value.hasUserData()) {
        yajl_gen_string(g, (const unsigned char*)  "userData" , 8);
        yajl_gen_integer(g, (long long)value.getUserData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimJoystickData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "direction" , 9);
        yajl_gen_integer(g, (long long)value.getDirection());
    }
    if (!isSparse || value.hasSource()) {
        yajl_gen_string(g, (const unsigned char*)  "source" , 6);
        const char *s = value.getSource().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimEnterKeyData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasKeyState()) {
        yajl_gen_string(g, (const unsigned char*)  "keyState" , 8);
        yajl_gen_integer(g, (long long)value.getKeyState());
    }
    if (!isSparse || value.hasSource()) {
        yajl_gen_string(g, (const unsigned char*)  "source" , 6);
        const char *s = value.getSource().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimFocusReqData"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasAction()) {
        yajl_gen_string(g, (const unsigned char*)  "action" , 6);
        yajl_gen_integer(g, (long long)value.getAction());
    }
    if (!isSparse || value.hasTimeAction()) {
        yajl_gen_string(g, (const unsigned char*)  "timeAction" , 10);
        yajl_gen_integer(g, (long long)value.getTimeAction());
    }
    if (!isSparse || value.hasViewName()) {
        yajl_gen_string(g, (const unsigned char*)  "viewName" , 8);
        const char *s = value.getViewName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasWidgetName()) {
        yajl_gen_string(g, (const unsigned char*)  "widgetName" , 10);
        const char *s = value.getWidgetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateClientStatusRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPid()) {
        yajl_gen_string(g, (const unsigned char*)  "pid" , 3);
        yajl_gen_integer(g, (long long)value.getPid());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSurfaces()) {
        yajl_gen_string(g, (const unsigned char*)  "surfaces" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< uint32 >& o13 = value.getSurfaces();
        {
            ::std::vector< uint32 >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                yajl_gen_integer(g, (long long)(*o12));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateTraceQueryResultRequest"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TraceQuerySignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByNameSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByTextSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByTextIdSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimTouchByIndexSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WidgetPropertyValueSetterSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimRotateEncoderSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimJoystickSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimEnterKeySignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimFocusReqSignal"

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        serializeJson(value.getData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace trace {
namespace Commands {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace Commands
} // namespace trace
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

