/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of TraceQueryData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        int32 o1 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_INT32, &o1));
        const ::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId  o2 = in.getQueryId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o2));
        DBusMessageIter o3ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o0Struct, DBUS_TYPE_ARRAY, "s", &o3ArrayIter));
        const ::std::vector< ::std::string >* o4 = &in.getQueryInput();
        ::std::vector< ::std::string >::const_iterator o5 = o4->end();
        for (::std::vector< ::std::string >::const_iterator o6 = o4->begin(); o6 != o5; ++o6) {
            const char* o7 = (*o6).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o3ArrayIter, DBUS_TYPE_STRING, &o7));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o0Struct, &o3ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData& out) {
    {
        DBusMessageIter o8;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o8);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o8, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId queryIdValue = ::bosch::cm::ai::hmi::appctrl::trace::Commands::traceQueryId__GET_CURRENT_MAIN_VIEW;
                    dbus_message_iter_get_basic(&o8, &queryIdValue);
                    out.setQueryId(queryIdValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > queryInputValue;

                    if (dbus_message_iter_get_arg_type(&o8) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o9ArrayIter;
                        dbus_message_iter_recurse (&o8, &o9ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o9ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o10;
                                {
                                    char* o11 = 0;
                                    dbus_message_iter_get_basic(&o9ArrayIter, &o11);
                                    o10.assign (o11);
                                }
                                queryInputValue.push_back(o10);
                            } while (dbus_message_iter_next(&o9ArrayIter));
                        }
                    }
                    out.setQueryInput(queryInputValue);
                }

                if (dbus_message_iter_has_next(&o8)) {
                    dbus_message_iter_next(&o8);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimTouchData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o12Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o12Struct));
        int32 o13 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_INT32, &o13));
        int32 o14 = in.getXPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_INT32, &o14));
        int32 o15 = in.getYPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_INT32, &o15));
        int32 o16 = in.getSurfaceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_INT32, &o16));
        int32 o17 = in.getPointerId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_INT32, &o17));
        const ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates  o18 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o12Struct, DBUS_TYPE_UINT32, &o18));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o12Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData& out) {
    {
        DBusMessageIter o19;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o19);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o19, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    int32 xPosValue;
                    int32 &xPosTmpValue = xPosValue;
                    dbus_message_iter_get_basic(&o19, &xPosTmpValue);
                    out.setXPos(xPosValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    int32 yPosValue;
                    int32 &yPosTmpValue = yPosValue;
                    dbus_message_iter_get_basic(&o19, &yPosTmpValue);
                    out.setYPos(yPosValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    int32 surfaceIdValue;
                    int32 &surfaceIdTmpValue = surfaceIdValue;
                    dbus_message_iter_get_basic(&o19, &surfaceIdTmpValue);
                    out.setSurfaceId(surfaceIdValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    int32 pointerIdValue;
                    int32 &pointerIdTmpValue = pointerIdValue;
                    dbus_message_iter_get_basic(&o19, &pointerIdTmpValue);
                    out.setPointerId(pointerIdValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates statusValue = ::bosch::cm::ai::hmi::appctrl::trace::Commands::simulatedTouchStates__DOWN;
                    dbus_message_iter_get_basic(&o19, &statusValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o19)) {
                    dbus_message_iter_next(&o19);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of Rect

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect& in, DBusMessageIter* out) {
    {
        DBusMessageIter o20Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o20Struct));
        int32 o21 = in.getXPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o20Struct, DBUS_TYPE_INT32, &o21));
        int32 o22 = in.getYPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o20Struct, DBUS_TYPE_INT32, &o22));
        int32 o23 = in.getWidth();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o20Struct, DBUS_TYPE_INT32, &o23));
        int32 o24 = in.getHeight();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o20Struct, DBUS_TYPE_INT32, &o24));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o20Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect& out) {
    {
        DBusMessageIter o25;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o25);
                {
                    int32 xPosValue;
                    int32 &xPosTmpValue = xPosValue;
                    dbus_message_iter_get_basic(&o25, &xPosTmpValue);
                    out.setXPos(xPosValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

                {
                    int32 yPosValue;
                    int32 &yPosTmpValue = yPosValue;
                    dbus_message_iter_get_basic(&o25, &yPosTmpValue);
                    out.setYPos(yPosValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

                {
                    int32 widthValue;
                    int32 &widthTmpValue = widthValue;
                    dbus_message_iter_get_basic(&o25, &widthTmpValue);
                    out.setWidth(widthValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

                {
                    int32 heightValue;
                    int32 &heightTmpValue = heightValue;
                    dbus_message_iter_get_basic(&o25, &heightTmpValue);
                    out.setHeight(heightValue);
                }

                if (dbus_message_iter_has_next(&o25)) {
                    dbus_message_iter_next(&o25);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SurfaceInfo

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o26Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o26Struct));
        int32 o27 = in.getSurfaceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o26Struct, DBUS_TYPE_INT32, &o27));
        serializeDBus(in.getRect(), &o26Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o26Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo& out) {
    {
        DBusMessageIter o28;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o28);
                {
                    int32 surfaceIdValue;
                    int32 &surfaceIdTmpValue = surfaceIdValue;
                    dbus_message_iter_get_basic(&o28, &surfaceIdTmpValue);
                    out.setSurfaceId(surfaceIdValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::ai::hmi::appctrl::trace::Commands::Rect rectValue;
                    if (!deserializeDBus(&o28, rectValue)) {
                        return false;
                    }
                    out.setRect(rectValue);
                }

                if (dbus_message_iter_has_next(&o28)) {
                    dbus_message_iter_next(&o28);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByNameData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o29Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o29Struct));
        int32 o30 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o29Struct, DBUS_TYPE_INT32, &o30));
        DBusMessageIter o31ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o29Struct, DBUS_TYPE_ARRAY, "(i(iiii))", &o31ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >* o32 = &in.getTouchableSurfaces();
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o33 = o32->end();
        for (::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o34 = o32->begin(); o34 != o33; ++o34) {
            serializeDBus((*o34), &o31ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o29Struct, &o31ArrayIter));
        const char* o35 = in.getWidgetName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o29Struct, DBUS_TYPE_STRING, &o35));
        const char* o36 = in.getViewName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o29Struct, DBUS_TYPE_STRING, &o36));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o29Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData& out) {
    {
        DBusMessageIter o37;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o37);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o37, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfacesValue;

                    if (dbus_message_iter_get_arg_type(&o37) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o38ArrayIter;
                        dbus_message_iter_recurse (&o37, &o38ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o38ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo o39;
                                if (!deserializeDBus(&o38ArrayIter, o39)) {
                                    return false;
                                }
                                touchableSurfacesValue.push_back(o39);
                            } while (dbus_message_iter_next(&o38ArrayIter));
                        }
                    }
                    out.setTouchableSurfaces(touchableSurfacesValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

                {
                    ::std::string widgetNameValue;
                    ::std::string &widgetNameTmpValue = widgetNameValue;
                    {
                        char* o40 = 0;
                        dbus_message_iter_get_basic(&o37, &o40);
                        widgetNameTmpValue.assign (o40);
                    }
                    out.setWidgetName(widgetNameValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

                {
                    ::std::string viewNameValue;
                    ::std::string &viewNameTmpValue = viewNameValue;
                    {
                        char* o41 = 0;
                        dbus_message_iter_get_basic(&o37, &o41);
                        viewNameTmpValue.assign (o41);
                    }
                    out.setViewName(viewNameValue);
                }

                if (dbus_message_iter_has_next(&o37)) {
                    dbus_message_iter_next(&o37);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByTextData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o42Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o42Struct));
        int32 o43 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_INT32, &o43));
        DBusMessageIter o44ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o42Struct, DBUS_TYPE_ARRAY, "(i(iiii))", &o44ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >* o45 = &in.getTouchableSurfaces();
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o46 = o45->end();
        for (::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o47 = o45->begin(); o47 != o46; ++o47) {
            serializeDBus((*o47), &o44ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o42Struct, &o44ArrayIter));
        const char* o48 = in.getWidgetText().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o42Struct, DBUS_TYPE_STRING, &o48));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o42Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData& out) {
    {
        DBusMessageIter o49;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o49);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o49, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfacesValue;

                    if (dbus_message_iter_get_arg_type(&o49) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o50ArrayIter;
                        dbus_message_iter_recurse (&o49, &o50ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o50ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo o51;
                                if (!deserializeDBus(&o50ArrayIter, o51)) {
                                    return false;
                                }
                                touchableSurfacesValue.push_back(o51);
                            } while (dbus_message_iter_next(&o50ArrayIter));
                        }
                    }
                    out.setTouchableSurfaces(touchableSurfacesValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

                {
                    ::std::string widgetTextValue;
                    ::std::string &widgetTextTmpValue = widgetTextValue;
                    {
                        char* o52 = 0;
                        dbus_message_iter_get_basic(&o49, &o52);
                        widgetTextTmpValue.assign (o52);
                    }
                    out.setWidgetText(widgetTextValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByTextIdData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o53Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o53Struct));
        int32 o54 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_INT32, &o54));
        DBusMessageIter o55ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o53Struct, DBUS_TYPE_ARRAY, "(i(iiii))", &o55ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >* o56 = &in.getTouchableSurfaces();
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o57 = o56->end();
        for (::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o58 = o56->begin(); o58 != o57; ++o58) {
            serializeDBus((*o58), &o55ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o53Struct, &o55ArrayIter));
        const char* o59 = in.getWidgetTextId().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o53Struct, DBUS_TYPE_STRING, &o59));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o53Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData& out) {
    {
        DBusMessageIter o60;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o60);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o60, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o60)) {
                    dbus_message_iter_next(&o60);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfacesValue;

                    if (dbus_message_iter_get_arg_type(&o60) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o61ArrayIter;
                        dbus_message_iter_recurse (&o60, &o61ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o61ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo o62;
                                if (!deserializeDBus(&o61ArrayIter, o62)) {
                                    return false;
                                }
                                touchableSurfacesValue.push_back(o62);
                            } while (dbus_message_iter_next(&o61ArrayIter));
                        }
                    }
                    out.setTouchableSurfaces(touchableSurfacesValue);
                }

                if (dbus_message_iter_has_next(&o60)) {
                    dbus_message_iter_next(&o60);
                } else {
                    return true;
                }

                {
                    ::std::string widgetTextIdValue;
                    ::std::string &widgetTextIdTmpValue = widgetTextIdValue;
                    {
                        char* o63 = 0;
                        dbus_message_iter_get_basic(&o60, &o63);
                        widgetTextIdTmpValue.assign (o63);
                    }
                    out.setWidgetTextId(widgetTextIdValue);
                }

                if (dbus_message_iter_has_next(&o60)) {
                    dbus_message_iter_next(&o60);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByIndexData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o64Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o64Struct));
        int32 o65 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_INT32, &o65));
        DBusMessageIter o66ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o64Struct, DBUS_TYPE_ARRAY, "(i(iiii))", &o66ArrayIter));
        const ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >* o67 = &in.getTouchableSurfaces();
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o68 = o67->end();
        for (::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo >::const_iterator o69 = o67->begin(); o69 != o68; ++o69) {
            serializeDBus((*o69), &o66ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o64Struct, &o66ArrayIter));
        int32 o70 = in.getListID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_INT32, &o70));
        int32 o71 = in.getButtonWidgetIndex();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64Struct, DBUS_TYPE_INT32, &o71));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o64Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData& out) {
    {
        DBusMessageIter o72;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o72);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o72, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o72)) {
                    dbus_message_iter_next(&o72);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo > touchableSurfacesValue;

                    if (dbus_message_iter_get_arg_type(&o72) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o73ArrayIter;
                        dbus_message_iter_recurse (&o72, &o73ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o73ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::bosch::cm::ai::hmi::appctrl::trace::Commands::SurfaceInfo o74;
                                if (!deserializeDBus(&o73ArrayIter, o74)) {
                                    return false;
                                }
                                touchableSurfacesValue.push_back(o74);
                            } while (dbus_message_iter_next(&o73ArrayIter));
                        }
                    }
                    out.setTouchableSurfaces(touchableSurfacesValue);
                }

                if (dbus_message_iter_has_next(&o72)) {
                    dbus_message_iter_next(&o72);
                } else {
                    return true;
                }

                {
                    int32 ListIDValue;
                    int32 &ListIDTmpValue = ListIDValue;
                    dbus_message_iter_get_basic(&o72, &ListIDTmpValue);
                    out.setListID(ListIDValue);
                }

                if (dbus_message_iter_has_next(&o72)) {
                    dbus_message_iter_next(&o72);
                } else {
                    return true;
                }

                {
                    int32 ButtonWidgetIndexValue;
                    int32 &ButtonWidgetIndexTmpValue = ButtonWidgetIndexValue;
                    dbus_message_iter_get_basic(&o72, &ButtonWidgetIndexTmpValue);
                    out.setButtonWidgetIndex(ButtonWidgetIndexValue);
                }

                if (dbus_message_iter_has_next(&o72)) {
                    dbus_message_iter_next(&o72);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of WidgetPropertyValueSetterData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o75Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o75Struct));
        int32 o76 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_INT32, &o76));
        DBusMessageIter o77ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o75Struct, DBUS_TYPE_ARRAY, "s", &o77ArrayIter));
        const ::std::vector< ::std::string >* o78 = &in.getWidgetNames();
        ::std::vector< ::std::string >::const_iterator o79 = o78->end();
        for (::std::vector< ::std::string >::const_iterator o80 = o78->begin(); o80 != o79; ++o80) {
            const char* o81 = (*o80).c_str();
            DBUS_ASSERT(dbus_message_iter_append_basic(&o77ArrayIter, DBUS_TYPE_STRING, &o81));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o75Struct, &o77ArrayIter));
        const char* o82 = in.getPropertyName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_STRING, &o82));
        const char* o83 = in.getPropertyValue().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_STRING, &o83));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o75Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData& out) {
    {
        DBusMessageIter o84;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o84);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o84, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o84)) {
                    dbus_message_iter_next(&o84);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::std::string > widgetNamesValue;

                    if (dbus_message_iter_get_arg_type(&o84) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o85ArrayIter;
                        dbus_message_iter_recurse (&o84, &o85ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o85ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::std::string o86;
                                {
                                    char* o87 = 0;
                                    dbus_message_iter_get_basic(&o85ArrayIter, &o87);
                                    o86.assign (o87);
                                }
                                widgetNamesValue.push_back(o86);
                            } while (dbus_message_iter_next(&o85ArrayIter));
                        }
                    }
                    out.setWidgetNames(widgetNamesValue);
                }

                if (dbus_message_iter_has_next(&o84)) {
                    dbus_message_iter_next(&o84);
                } else {
                    return true;
                }

                {
                    ::std::string propertyNameValue;
                    ::std::string &propertyNameTmpValue = propertyNameValue;
                    {
                        char* o88 = 0;
                        dbus_message_iter_get_basic(&o84, &o88);
                        propertyNameTmpValue.assign (o88);
                    }
                    out.setPropertyName(propertyNameValue);
                }

                if (dbus_message_iter_has_next(&o84)) {
                    dbus_message_iter_next(&o84);
                } else {
                    return true;
                }

                {
                    ::std::string propertyValueValue;
                    ::std::string &propertyValueTmpValue = propertyValueValue;
                    {
                        char* o89 = 0;
                        dbus_message_iter_get_basic(&o84, &o89);
                        propertyValueTmpValue.assign (o89);
                    }
                    out.setPropertyValue(propertyValueValue);
                }

                if (dbus_message_iter_has_next(&o84)) {
                    dbus_message_iter_next(&o84);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimRotateEncoderData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o90Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o90Struct));
        int32 o91 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o90Struct, DBUS_TYPE_INT32, &o91));
        const char* o92 = in.getEncCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o90Struct, DBUS_TYPE_STRING, &o92));
        int32 o93 = in.getEncSteps();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o90Struct, DBUS_TYPE_INT32, &o93));
        uint32 o94 = in.getUserData();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o90Struct, DBUS_TYPE_UINT32, &o94));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o90Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData& out) {
    {
        DBusMessageIter o95;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o95);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o95, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    ::std::string encCodeValue;
                    ::std::string &encCodeTmpValue = encCodeValue;
                    {
                        char* o96 = 0;
                        dbus_message_iter_get_basic(&o95, &o96);
                        encCodeTmpValue.assign (o96);
                    }
                    out.setEncCode(encCodeValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    int32 encStepsValue;
                    int32 &encStepsTmpValue = encStepsValue;
                    dbus_message_iter_get_basic(&o95, &encStepsTmpValue);
                    out.setEncSteps(encStepsValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    uint32 userDataValue;
                    uint32 &userDataTmpValue = userDataValue;
                    dbus_message_iter_get_basic(&o95, &userDataTmpValue);
                    out.setUserData(userDataValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimJoystickData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o97Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o97Struct));
        int32 o98 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o97Struct, DBUS_TYPE_INT32, &o98));
        uint32 o99 = in.getDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o97Struct, DBUS_TYPE_UINT32, &o99));
        const char* o100 = in.getSource().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o97Struct, DBUS_TYPE_STRING, &o100));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o97Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData& out) {
    {
        DBusMessageIter o101;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o101);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o101, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    uint32 directionValue;
                    uint32 &directionTmpValue = directionValue;
                    dbus_message_iter_get_basic(&o101, &directionTmpValue);
                    out.setDirection(directionValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

                {
                    ::std::string sourceValue;
                    ::std::string &sourceTmpValue = sourceValue;
                    {
                        char* o102 = 0;
                        dbus_message_iter_get_basic(&o101, &o102);
                        sourceTmpValue.assign (o102);
                    }
                    out.setSource(sourceValue);
                }

                if (dbus_message_iter_has_next(&o101)) {
                    dbus_message_iter_next(&o101);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimEnterKeyData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o103Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o103Struct));
        int32 o104 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_INT32, &o104));
        uint32 o105 = in.getKeyState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_UINT32, &o105));
        const char* o106 = in.getSource().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o103Struct, DBUS_TYPE_STRING, &o106));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o103Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData& out) {
    {
        DBusMessageIter o107;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o107);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o107, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

                {
                    uint32 keyStateValue;
                    uint32 &keyStateTmpValue = keyStateValue;
                    dbus_message_iter_get_basic(&o107, &keyStateTmpValue);
                    out.setKeyState(keyStateValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

                {
                    ::std::string sourceValue;
                    ::std::string &sourceTmpValue = sourceValue;
                    {
                        char* o108 = 0;
                        dbus_message_iter_get_basic(&o107, &o108);
                        sourceTmpValue.assign (o108);
                    }
                    out.setSource(sourceValue);
                }

                if (dbus_message_iter_has_next(&o107)) {
                    dbus_message_iter_next(&o107);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SimFocusReqData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o109Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o109Struct));
        int32 o110 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109Struct, DBUS_TYPE_INT32, &o110));
        uint32 o111 = in.getAction();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109Struct, DBUS_TYPE_UINT32, &o111));
        uint32 o112 = in.getTimeAction();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109Struct, DBUS_TYPE_UINT32, &o112));
        const char* o113 = in.getViewName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109Struct, DBUS_TYPE_STRING, &o113));
        const char* o114 = in.getWidgetName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109Struct, DBUS_TYPE_STRING, &o114));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o109Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData& out) {
    {
        DBusMessageIter o115;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o115);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o115, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o115)) {
                    dbus_message_iter_next(&o115);
                } else {
                    return true;
                }

                {
                    uint32 actionValue;
                    uint32 &actionTmpValue = actionValue;
                    dbus_message_iter_get_basic(&o115, &actionTmpValue);
                    out.setAction(actionValue);
                }

                if (dbus_message_iter_has_next(&o115)) {
                    dbus_message_iter_next(&o115);
                } else {
                    return true;
                }

                {
                    uint32 timeActionValue;
                    uint32 &timeActionTmpValue = timeActionValue;
                    dbus_message_iter_get_basic(&o115, &timeActionTmpValue);
                    out.setTimeAction(timeActionValue);
                }

                if (dbus_message_iter_has_next(&o115)) {
                    dbus_message_iter_next(&o115);
                } else {
                    return true;
                }

                {
                    ::std::string viewNameValue;
                    ::std::string &viewNameTmpValue = viewNameValue;
                    {
                        char* o116 = 0;
                        dbus_message_iter_get_basic(&o115, &o116);
                        viewNameTmpValue.assign (o116);
                    }
                    out.setViewName(viewNameValue);
                }

                if (dbus_message_iter_has_next(&o115)) {
                    dbus_message_iter_next(&o115);
                } else {
                    return true;
                }

                {
                    ::std::string widgetNameValue;
                    ::std::string &widgetNameTmpValue = widgetNameValue;
                    {
                        char* o117 = 0;
                        dbus_message_iter_get_basic(&o115, &o117);
                        widgetNameTmpValue.assign (o117);
                    }
                    out.setWidgetName(widgetNameValue);
                }

                if (dbus_message_iter_has_next(&o115)) {
                    dbus_message_iter_next(&o115);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateClientStatusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest& in, DBusMessageIter* out) {
    uint32 o118 = in.getPid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o118));
    const char* o119 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o119));
    DBusMessageIter o120ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o120ArrayIter));
    const ::std::vector< uint32 >* o121 = &in.getSurfaces();
    ::std::vector< uint32 >::const_iterator o122 = o121->end();
    for (::std::vector< uint32 >::const_iterator o123 = o121->begin(); o123 != o122; ++o123) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o120ArrayIter, DBUS_TYPE_UINT32, &(*o123)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o120ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateClientStatusRequest& out) {
    {
        uint32 pidValue;
        uint32 &pidTmpValue = pidValue;
        dbus_message_iter_get_basic(in, &pidTmpValue);
        out.setPid(pidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o124 = 0;
            dbus_message_iter_get_basic(in, &o124);
            nameTmpValue.assign (o124);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > surfacesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o125ArrayIter;
            dbus_message_iter_recurse (in, &o125ArrayIter);

            if(dbus_message_iter_get_arg_type(&o125ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o126;
                    dbus_message_iter_get_basic(&o125ArrayIter, &o126);
                    surfacesValue.push_back(o126);
                } while (dbus_message_iter_next(&o125ArrayIter));
            }
        }
        out.setSurfaces(surfacesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UpdateTraceQueryResultRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::UpdateTraceQueryResultRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TraceQuerySignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQuerySignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::TraceQueryData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimTouchSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByNameSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByNameData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByTextSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByTextIdSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByTextIdData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimTouchByIndexSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimTouchByIndexData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WidgetPropertyValueSetterSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::WidgetPropertyValueSetterData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimRotateEncoderSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimRotateEncoderData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimJoystickSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimJoystickData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimEnterKeySignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeySignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimEnterKeyData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SimFocusReqSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::trace::Commands::SimFocusReqData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

