/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLSTUB_H
#define BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

class HMIAppCtrlStubDelegate;

class HMIAppCtrlStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HMIAppCtrlStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HMIAppCtrlStub (const std::string& portName);

    /**
     * Create an instance of the HMIAppCtrlStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HMIAppCtrlStub (const std::string& portName, const std::string& objectPath);

    virtual ~HMIAppCtrlStub();

    // signal 'QueryClient'

    /**
     * Raise the signal 'QueryClient' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'QueryClient'</b>:
     *
     * send out query to get info about all registered clients
     */
    void sendQueryClientSignal();

    // signal 'subSurfaceSwitchUpdate'

    /**
     * Raise the signal 'subSurfaceSwitchUpdate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'subSurfaceSwitchUpdate'</b>:
     *
     * broadcast sub surface switch complete msg to all apps
     *
     * @param surfaceid If the meaning of "surfaceid" isn't clear, then there should be a description here.
     *
     * @param surfaceState If the meaning of "surfaceState" isn't clear, then there should be a description here.
     */
    void sendSubSurfaceSwitchUpdateSignal(int32 surfaceid, int32 surfaceState);

    // signal 'keyInfoForwarding'

    /**
     * Raise the signal 'keyInfoForwarding' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'keyInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendKeyInfoForwardingSignal(const keyInfo& data);

    // signal 'encoderInfoForwarding'

    /**
     * Raise the signal 'encoderInfoForwarding' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'encoderInfoForwarding'</b>:
     *
     * broadcast key information to be processed by a particular client
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendEncoderInfoForwardingSignal(const encoderInfo& data);

    // signal 'SetDisplay'

    /**
     * Raise the signal 'SetDisplay' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'SetDisplay'</b>:
     *
     * todo
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSetDisplaySignal(const displayData& data);

    // signal 'SetMultiDisplay'

    /**
     * Raise the signal 'SetMultiDisplay' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SetMultiDisplay'</b>:
     *
     * todo
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendSetMultiDisplaySignal(const MultidisplayData& data);

    // signal 'evDisplayStatusEval'

    /**
     * Raise the signal 'evDisplayStatusEval' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'evDisplayStatusEval'</b>:
     *
     * use this to start display status evaluation (mainly used for statusline)
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     */
    void sendEvDisplayStatusEvalSignal(const MultidisplayData& data);

    // signal 'ActivateExternalImageProvider'

    /**
     * Raise the signal 'ActivateExternalImageProvider' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'ActivateExternalImageProvider'</b>:
     *
     * todo
     *
     * @param targetState If the meaning of "targetState" isn't clear, then there should be a description here.
     *
     * @param instanceIds If the meaning of "instanceIds" isn't clear, then there should be a description here.
     *
     * @param consumerId If the meaning of "consumerId" isn't clear, then there should be a description here.
     */
    void sendActivateExternalImageProviderSignal(gadgetStatus targetState, const ::std::vector< int32 >& instanceIds, int32 consumerId);

    // signal 'ExternalImageProviderTouch'

    /**
     * Raise the signal 'ExternalImageProviderTouch' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'ExternalImageProviderTouch'</b>:
     *
     * todo
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     */
    void sendExternalImageProviderTouchSignal(uint32 pidSender, const touchInfo& data, int32 instanceId);

    // signal 'SlaveSurfaceRepositioning'

    /**
     * Raise the signal 'SlaveSurfaceRepositioning' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioning'</b>:
     *
     * todo
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param activate If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param surfaceId If the meaning of "surfaceId" isn't clear, then there should be a description here.
     */
    void sendSlaveSurfaceRepositioningSignal(uint32 pidSender, bool activate, uint32 surfaceId);

    // signal 'SlaveSurfaceRepositioningAck'

    /**
     * Raise the signal 'SlaveSurfaceRepositioningAck' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'SlaveSurfaceRepositioningAck'</b>:
     *
     * todo
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param activate If the meaning of "activate" isn't clear, then there should be a description here.
     *
     * @param surfaceId If the meaning of "surfaceId" isn't clear, then there should be a description here.
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSlaveSurfaceRepositioningAckSignal(uint32 pidSender, bool activate, uint32 surfaceId, bool status);

    // signal 'DirectTextureConsumerPositionInfoRequest'

    /**
     * Raise the signal 'DirectTextureConsumerPositionInfoRequest' and send an
     * update message to registered clients.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoRequest'</b>:
     *
     * todo
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     */
    void sendDirectTextureConsumerPositionInfoRequestSignal(uint32 pidSender, uint32 instanceId);

    // signal 'DirectTextureConsumerPositionInfoResponse'

    /**
     * Raise the signal 'DirectTextureConsumerPositionInfoResponse' and send
     * an update message to registered clients.
     *
     * <b>Documentation of 'DirectTextureConsumerPositionInfoResponse'</b>:
     *
     * todo
     *
     * @param pidSender If the meaning of "pidSender" isn't clear, then there should be a description here.
     *
     * @param instanceId If the meaning of "instanceId" isn't clear, then there should be a description here.
     *
     * @param xPos If the meaning of "xPos" isn't clear, then there should be a description here.
     *
     * @param yPos If the meaning of "yPos" isn't clear, then there should be a description here.
     */
    void sendDirectTextureConsumerPositionInfoResponseSignal(uint32 pidSender, uint32 instanceId, float xPos, float yPos);

    // signal 'DrmGarbageCollectionRequest'

    /**
     * Raise the signal 'DrmGarbageCollectionRequest' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'DrmGarbageCollectionRequest'</b>:
     *
     * Request all clients to clean up their dma buffer allocations
     */
    void sendDrmGarbageCollectionRequestSignal();

    // signal 'FollowUpActionRequest'

    /**
     * Raise the signal 'FollowUpActionRequest' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'FollowUpActionRequest'</b>:
     *
     * todo
     *
     * @param actionType If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param userData If the meaning of "userData" isn't clear, then there should be a description here.
     */
    void sendFollowUpActionRequestSignal(followUpAction actionType, uint32 userData);

    // signal 'FollowUpActionResponse'

    /**
     * Raise the signal 'FollowUpActionResponse' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'FollowUpActionResponse'</b>:
     *
     * todo
     *
     * @param actionType If the meaning of "actionType" isn't clear, then there should be a description here.
     *
     * @param userData If the meaning of "userData" isn't clear, then there should be a description here.
     */
    void sendFollowUpActionResponseSignal(followUpAction actionType, uint32 userData);

    // property 'ExternalImagesStatus'

    /**
     * The method onExternalImagesStatusGet() is called by ASF when a client
     * invokes the read method for the property 'ExternalImagesStatus'. The
     * onExternalImagesStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     */
    virtual void onExternalImagesStatusGet(const ::boost::shared_ptr< ExternalImagesStatusGet >& payload);

    /**
     * Sends back the update to a previous onExternalImagesStatusGet().
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     *
     * @param act Identifies a previous invocation of
     * onExternalImagesStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendExternalImagesStatusGetUpdate(const ::std::vector< ExternalImageData >& externalImagesStatus, act_t act = 0);

    /**
     * Set the value of the property 'ExternalImagesStatus' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     */
    void setExternalImagesStatus(const ::std::vector< ExternalImageData >& externalImagesStatus);

    /**
     * Returns the current value of the property 'ExternalImagesStatus'.
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     */
    const ::std::vector< ExternalImageData >& getExternalImagesStatus() const;

    /**
     * Returns the current value of the property 'ExternalImagesStatus' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendExternalImagesStatusUpdate() method.
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     */
    ::std::vector< ExternalImageData >& getExternalImagesStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendExternalImagesStatusUpdate().
     *
     * <b>Documentation of 'ExternalImagesStatus'</b>:
     *
     * Property to state the known/already requested external images.
     */
    void sendExternalImagesStatusUpdate();

    // property 'Clients'

    /**
     * The method onClientsGet() is called by ASF when a client invokes the
     * read method for the property 'Clients'. The onClientsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     */
    virtual void onClientsGet(const ::boost::shared_ptr< ClientsGet >& payload);

    /**
     * Sends back the update to a previous onClientsGet().
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     *
     * @param act Identifies a previous invocation of onClientsGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClientsGetUpdate(const ::std::vector< ApplicationState >& clients, act_t act = 0);

    /**
     * Set the value of the property 'Clients' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     */
    void setClients(const ::std::vector< ApplicationState >& clients);

    /**
     * Returns the current value of the property 'Clients'.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     */
    const ::std::vector< ApplicationState >& getClients() const;

    /**
     * Returns the current value of the property 'Clients' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendClientsUpdate() method.
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     */
    ::std::vector< ApplicationState >& getClientsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendClientsUpdate().
     *
     * <b>Documentation of 'Clients'</b>:
     *
     * Property to state the application status of registered clients.
     */
    void sendClientsUpdate();

    // method 'UpdateClientStatus'

    /**
     * The method onUpdateClientStatus() is called by ASF when a client
     * invokes the method 'UpdateClientStatus'.  Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'UpdateClientStatus'</b>:
     *
     * transport information about the hmi process to stub
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateClientStatusRequest (const ::boost::shared_ptr< UpdateClientStatusRequest >& request) = 0;

    // method 'KeyForwarding'

    /**
     * The method onKeyForwarding() is called by ASF when a client invokes the
     * method 'KeyForwarding'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'KeyForwarding'</b>:
     *
     * forward a received (and not consumed) key event to stub
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onKeyForwardingRequest (const ::boost::shared_ptr< KeyForwardingRequest >& request) = 0;

    // method 'EncoderForwarding'

    /**
     * The method onEncoderForwarding() is called by ASF when a client invokes
     * the method 'EncoderForwarding'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'EncoderForwarding'</b>:
     *
     * forward a received (and not consumed) encoder event to stub
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEncoderForwardingRequest (const ::boost::shared_ptr< EncoderForwardingRequest >& request) = 0;

    // method 'BeepForwarding'

    /**
     * The method onBeepForwarding() is called by ASF when a client invokes
     * the method 'BeepForwarding'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'BeepForwarding'</b>:
     *
     * forward a beep request to stub
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBeepForwardingRequest (const ::boost::shared_ptr< BeepForwardingRequest >& request) = 0;

    // method 'SetApplicationMandatory'

    /**
     * The method onSetApplicationMandatory() is called by ASF when a client
     * invokes the method 'SetApplicationMandatory'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'SetApplicationMandatory'</b>:
     *
     * set the calling application as mandatory for synchronized hmi startup
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetApplicationMandatoryRequest (const ::boost::shared_ptr< SetApplicationMandatoryRequest >& request) = 0;

    // method 'DisplayCmd'

    /**
     * The method onDisplayCmd() is called by ASF when a client invokes the
     * method 'DisplayCmd'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'DisplayCmd'</b>:
     *
     * todo
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisplayCmdRequest (const ::boost::shared_ptr< DisplayCmdRequest >& request) = 0;

    // method 'MultiDisplayCmd'

    /**
     * The method onMultiDisplayCmd() is called by ASF when a client invokes
     * the method 'MultiDisplayCmd'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'MultiDisplayCmd'</b>:
     *
     * If the meaning of "MultiDisplayCmd" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMultiDisplayCmdRequest (const ::boost::shared_ptr< MultiDisplayCmdRequest >& request) = 0;

    // method 'DisplayStatusEval'

    /**
     * The method onDisplayStatusEval() is called by ASF when a client invokes
     * the method 'DisplayStatusEval'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'DisplayStatusEval'</b>:
     *
     * todo
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisplayStatusEvalRequest (const ::boost::shared_ptr< DisplayStatusEvalRequest >& request) = 0;

    // method 'RequestExternalImageProviderActivation'

    /**
     * The method onRequestExternalImageProviderActivation() is called by ASF
     * when a client invokes the method
     * 'RequestExternalImageProviderActivation'.  Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'RequestExternalImageProviderActivation'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestExternalImageProviderActivationRequest (const ::boost::shared_ptr< RequestExternalImageProviderActivationRequest >& request) = 0;

    // method 'RequestExternalImageProviderTouch'

    /**
     * The method onRequestExternalImageProviderTouch() is called by ASF when
     * a client invokes the method 'RequestExternalImageProviderTouch'.  Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RequestExternalImageProviderTouch'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestExternalImageProviderTouchRequest (const ::boost::shared_ptr< RequestExternalImageProviderTouchRequest >& request) = 0;

    // method 'RequestSlaveSurfaceRepositioning'

    /**
     * The method onRequestSlaveSurfaceRepositioning() is called by ASF when a
     * client invokes the method 'RequestSlaveSurfaceRepositioning'.  Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'RequestSlaveSurfaceRepositioning'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestSlaveSurfaceRepositioningRequest (const ::boost::shared_ptr< RequestSlaveSurfaceRepositioningRequest >& request) = 0;

    // method 'ResponseSlaveSurfaceRepositioning'

    /**
     * The method onResponseSlaveSurfaceRepositioning() is called by ASF when
     * a client invokes the method 'ResponseSlaveSurfaceRepositioning'.  Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ResponseSlaveSurfaceRepositioning'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResponseSlaveSurfaceRepositioningRequest (const ::boost::shared_ptr< ResponseSlaveSurfaceRepositioningRequest >& request) = 0;

    // method 'RequestDirectTextureConsumerPositionInfo'

    /**
     * The method onRequestDirectTextureConsumerPositionInfo() is called by
     * ASF when a client invokes the method
     * 'RequestDirectTextureConsumerPositionInfo'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'RequestDirectTextureConsumerPositionInfo'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestDirectTextureConsumerPositionInfoRequest (const ::boost::shared_ptr< RequestDirectTextureConsumerPositionInfoRequest >& request) = 0;

    // method 'ResponseDirectTextureConsumerPositionInfo'

    /**
     * The method onResponseDirectTextureConsumerPositionInfo() is called by
     * ASF when a client invokes the method
     * 'ResponseDirectTextureConsumerPositionInfo'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ResponseDirectTextureConsumerPositionInfo'</b>:
     *
     * request stub to distribute
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResponseDirectTextureConsumerPositionInfoRequest (const ::boost::shared_ptr< ResponseDirectTextureConsumerPositionInfoRequest >& request) = 0;

    // method 'ApplicationRenderedUpdate'

    /**
     * The method onApplicationRenderedUpdate() is called by ASF when a client
     * invokes the method 'ApplicationRenderedUpdate'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ApplicationRenderedUpdate'</b>:
     *
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onApplicationRenderedUpdateRequest (const ::boost::shared_ptr< ApplicationRenderedUpdateRequest >& request) = 0;

    // method 'ApplicationSwitchComplete'

    /**
     * The method onApplicationSwitchComplete() is called by ASF when a client
     * invokes the method 'ApplicationSwitchComplete'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ApplicationSwitchComplete'</b>:
     *
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onApplicationSwitchCompleteRequest (const ::boost::shared_ptr< ApplicationSwitchCompleteRequest >& request) = 0;

    // method 'SubSurfaceSwitchComplete'

    /**
     * The method onSubSurfaceSwitchComplete() is called by ASF when a client
     * invokes the method 'SubSurfaceSwitchComplete'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'SubSurfaceSwitchComplete'</b>:
     *
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSubSurfaceSwitchCompleteRequest (const ::boost::shared_ptr< SubSurfaceSwitchCompleteRequest >& request) = 0;

    // method 'FollowUpAction'

    /**
     * The method onFollowUpAction() is called by ASF when a client invokes
     * the method 'FollowUpAction'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'FollowUpAction'</b>:
     *
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFollowUpActionRequest (const ::boost::shared_ptr< FollowUpActionRequest >& request) = 0;

    // method 'ResponseFollowUpAction'

    /**
     * The method onResponseFollowUpAction() is called by ASF when a client
     * invokes the method 'ResponseFollowUpAction'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ResponseFollowUpAction'</b>:
     *
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onResponseFollowUpActionRequest (const ::boost::shared_ptr< ResponseFollowUpActionRequest >& request) = 0;

    // method 'DrmBufferAllocationStatus'

    /**
     * The method onDrmBufferAllocationStatus() is called by ASF when a client
     * invokes the method 'DrmBufferAllocationStatus'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'DrmBufferAllocationStatus'</b>:
     *
     * Report the status of dma buffer allocation
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDrmBufferAllocationStatusRequest (const ::boost::shared_ptr< DrmBufferAllocationStatusRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ExternalImagesStatusUpdate _ExternalImagesStatusProperty;

    ClientsUpdate _ClientsProperty;

    friend class HMIAppCtrlStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_APPCTRL_HMIAPPCTRLSTUB_H
