/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlDBus.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlJson.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace appctrl {
namespace HMIAppCtrl {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/appctrl/bosch/cm/ai/hmi/appctrl/HMIAppCtrl", HMIAppCtrlProxy);

class HMIAppCtrlProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HMIAppCtrlProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HMIAppCtrlProxy >& proxyShared = ::boost::static_pointer_cast< HMIAppCtrlProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_QueryClient:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), QueryClientSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "QueryClient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<QueryClientSignal> payload = ::boost::static_pointer_cast<QueryClientSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((QueryClientCallbackIF*) _callback)->onQueryClientSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_subSurfaceSwitchUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubSurfaceSwitchUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SubSurfaceSwitchUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SubSurfaceSwitchUpdateSignal> payload = ::boost::static_pointer_cast<SubSurfaceSwitchUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SubSurfaceSwitchUpdateCallbackIF*) _callback)->onSubSurfaceSwitchUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_keyInfoForwarding:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyInfoForwardingSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyInfoForwarding", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<KeyInfoForwardingSignal> payload = ::boost::static_pointer_cast<KeyInfoForwardingSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((KeyInfoForwardingCallbackIF*) _callback)->onKeyInfoForwardingSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_encoderInfoForwarding:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EncoderInfoForwardingSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EncoderInfoForwarding", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EncoderInfoForwardingSignal> payload = ::boost::static_pointer_cast<EncoderInfoForwardingSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EncoderInfoForwardingCallbackIF*) _callback)->onEncoderInfoForwardingSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SetDisplay:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetDisplaySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SetDisplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SetDisplaySignal> payload = ::boost::static_pointer_cast<SetDisplaySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SetDisplayCallbackIF*) _callback)->onSetDisplaySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SetMultiDisplay:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMultiDisplaySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SetMultiDisplay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SetMultiDisplaySignal> payload = ::boost::static_pointer_cast<SetMultiDisplaySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SetMultiDisplayCallbackIF*) _callback)->onSetMultiDisplaySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_evDisplayStatusEval:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EvDisplayStatusEvalSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EvDisplayStatusEval", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EvDisplayStatusEvalSignal> payload = ::boost::static_pointer_cast<EvDisplayStatusEvalSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EvDisplayStatusEvalCallbackIF*) _callback)->onEvDisplayStatusEvalSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ActivateExternalImageProvider:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateExternalImageProviderSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActivateExternalImageProvider", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ActivateExternalImageProviderSignal> payload = ::boost::static_pointer_cast<ActivateExternalImageProviderSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ActivateExternalImageProviderCallbackIF*) _callback)->onActivateExternalImageProviderSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ExternalImageProviderTouch:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExternalImageProviderTouchSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExternalImageProviderTouch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ExternalImageProviderTouchSignal> payload = ::boost::static_pointer_cast<ExternalImageProviderTouchSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ExternalImageProviderTouchCallbackIF*) _callback)->onExternalImageProviderTouchSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SlaveSurfaceRepositioning:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SlaveSurfaceRepositioningSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SlaveSurfaceRepositioning", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SlaveSurfaceRepositioningSignal> payload = ::boost::static_pointer_cast<SlaveSurfaceRepositioningSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SlaveSurfaceRepositioningCallbackIF*) _callback)->onSlaveSurfaceRepositioningSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SlaveSurfaceRepositioningAck:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SlaveSurfaceRepositioningAckSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SlaveSurfaceRepositioningAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SlaveSurfaceRepositioningAckSignal> payload = ::boost::static_pointer_cast<SlaveSurfaceRepositioningAckSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SlaveSurfaceRepositioningAckCallbackIF*) _callback)->onSlaveSurfaceRepositioningAckSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DirectTextureConsumerPositionInfoRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DirectTextureConsumerPositionInfoRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DirectTextureConsumerPositionInfoRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DirectTextureConsumerPositionInfoRequestSignal> payload = ::boost::static_pointer_cast<DirectTextureConsumerPositionInfoRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DirectTextureConsumerPositionInfoRequestCallbackIF*) _callback)->onDirectTextureConsumerPositionInfoRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DirectTextureConsumerPositionInfoResponse:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DirectTextureConsumerPositionInfoResponseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DirectTextureConsumerPositionInfoResponse", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DirectTextureConsumerPositionInfoResponseSignal> payload = ::boost::static_pointer_cast<DirectTextureConsumerPositionInfoResponseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DirectTextureConsumerPositionInfoResponseCallbackIF*) _callback)->onDirectTextureConsumerPositionInfoResponseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DrmGarbageCollectionRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DrmGarbageCollectionRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DrmGarbageCollectionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DrmGarbageCollectionRequestSignal> payload = ::boost::static_pointer_cast<DrmGarbageCollectionRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DrmGarbageCollectionRequestCallbackIF*) _callback)->onDrmGarbageCollectionRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FollowUpActionRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FollowUpActionRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FollowUpActionRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FollowUpActionRequestSignal> payload = ::boost::static_pointer_cast<FollowUpActionRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FollowUpActionRequestCallbackIF*) _callback)->onFollowUpActionRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FollowUpActionResponse:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FollowUpActionResponseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FollowUpActionResponse", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FollowUpActionResponseSignal> payload = ::boost::static_pointer_cast<FollowUpActionResponseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FollowUpActionResponseCallbackIF*) _callback)->onFollowUpActionResponseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ExternalImagesStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExternalImagesStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExternalImagesStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExternalImagesStatusError> payload = ::boost::static_pointer_cast<ExternalImagesStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ExternalImagesStatusCallbackIF*) _callback)->onExternalImagesStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExternalImagesStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ExternalImagesStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExternalImagesStatusUpdate> payload = ::boost::static_pointer_cast<ExternalImagesStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ExternalImagesStatusCallbackIF*) _callback)->onExternalImagesStatusUpdate(proxyShared, payload);
                        proxyShared->_externalImagesStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Clients:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClientsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Clients", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClientsError> payload = ::boost::static_pointer_cast<ClientsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ClientsCallbackIF*) _callback)->onClientsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClientsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Clients", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClientsUpdate> payload = ::boost::static_pointer_cast<ClientsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ClientsCallbackIF*) _callback)->onClientsUpdate(proxyShared, payload);
                        proxyShared->_clients = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_QueryClient: {
                ::boost::shared_ptr< QueryClientError > payload = ::boost::shared_ptr< QueryClientError >
                (new QueryClientError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "QueryClient", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((QueryClientCallbackIF*) _callback)->onQueryClientError (proxyShared,payload);
                return true;
            }
            break;
            case ID_subSurfaceSwitchUpdate: {
                ::boost::shared_ptr< SubSurfaceSwitchUpdateError > payload = ::boost::shared_ptr< SubSurfaceSwitchUpdateError >
                (new SubSurfaceSwitchUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SubSurfaceSwitchUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SubSurfaceSwitchUpdateCallbackIF*) _callback)->onSubSurfaceSwitchUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_keyInfoForwarding: {
                ::boost::shared_ptr< KeyInfoForwardingError > payload = ::boost::shared_ptr< KeyInfoForwardingError >
                (new KeyInfoForwardingError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KeyInfoForwarding", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KeyInfoForwardingCallbackIF*) _callback)->onKeyInfoForwardingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_encoderInfoForwarding: {
                ::boost::shared_ptr< EncoderInfoForwardingError > payload = ::boost::shared_ptr< EncoderInfoForwardingError >
                (new EncoderInfoForwardingError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EncoderInfoForwarding", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EncoderInfoForwardingCallbackIF*) _callback)->onEncoderInfoForwardingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetDisplay: {
                ::boost::shared_ptr< SetDisplayError > payload = ::boost::shared_ptr< SetDisplayError >
                (new SetDisplayError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetDisplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetDisplayCallbackIF*) _callback)->onSetDisplayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetMultiDisplay: {
                ::boost::shared_ptr< SetMultiDisplayError > payload = ::boost::shared_ptr< SetMultiDisplayError >
                (new SetMultiDisplayError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMultiDisplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMultiDisplayCallbackIF*) _callback)->onSetMultiDisplayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_evDisplayStatusEval: {
                ::boost::shared_ptr< EvDisplayStatusEvalError > payload = ::boost::shared_ptr< EvDisplayStatusEvalError >
                (new EvDisplayStatusEvalError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EvDisplayStatusEval", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EvDisplayStatusEvalCallbackIF*) _callback)->onEvDisplayStatusEvalError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActivateExternalImageProvider: {
                ::boost::shared_ptr< ActivateExternalImageProviderError > payload = ::boost::shared_ptr< ActivateExternalImageProviderError >
                (new ActivateExternalImageProviderError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateExternalImageProvider", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateExternalImageProviderCallbackIF*) _callback)->onActivateExternalImageProviderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExternalImageProviderTouch: {
                ::boost::shared_ptr< ExternalImageProviderTouchError > payload = ::boost::shared_ptr< ExternalImageProviderTouchError >
                (new ExternalImageProviderTouchError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExternalImageProviderTouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExternalImageProviderTouchCallbackIF*) _callback)->onExternalImageProviderTouchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SlaveSurfaceRepositioning: {
                ::boost::shared_ptr< SlaveSurfaceRepositioningError > payload = ::boost::shared_ptr< SlaveSurfaceRepositioningError >
                (new SlaveSurfaceRepositioningError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SlaveSurfaceRepositioning", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SlaveSurfaceRepositioningCallbackIF*) _callback)->onSlaveSurfaceRepositioningError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SlaveSurfaceRepositioningAck: {
                ::boost::shared_ptr< SlaveSurfaceRepositioningAckError > payload = ::boost::shared_ptr< SlaveSurfaceRepositioningAckError >
                (new SlaveSurfaceRepositioningAckError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SlaveSurfaceRepositioningAck", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SlaveSurfaceRepositioningAckCallbackIF*) _callback)->onSlaveSurfaceRepositioningAckError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DirectTextureConsumerPositionInfoRequest: {
                ::boost::shared_ptr< DirectTextureConsumerPositionInfoRequestError > payload = ::boost::shared_ptr< DirectTextureConsumerPositionInfoRequestError >
                (new DirectTextureConsumerPositionInfoRequestError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DirectTextureConsumerPositionInfoRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DirectTextureConsumerPositionInfoRequestCallbackIF*) _callback)->onDirectTextureConsumerPositionInfoRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DirectTextureConsumerPositionInfoResponse: {
                ::boost::shared_ptr< DirectTextureConsumerPositionInfoResponseError > payload = ::boost::shared_ptr< DirectTextureConsumerPositionInfoResponseError >
                (new DirectTextureConsumerPositionInfoResponseError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DirectTextureConsumerPositionInfoResponse", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DirectTextureConsumerPositionInfoResponseCallbackIF*) _callback)->onDirectTextureConsumerPositionInfoResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DrmGarbageCollectionRequest: {
                ::boost::shared_ptr< DrmGarbageCollectionRequestError > payload = ::boost::shared_ptr< DrmGarbageCollectionRequestError >
                (new DrmGarbageCollectionRequestError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DrmGarbageCollectionRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DrmGarbageCollectionRequestCallbackIF*) _callback)->onDrmGarbageCollectionRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FollowUpActionRequest: {
                ::boost::shared_ptr< FollowUpActionRequestError > payload = ::boost::shared_ptr< FollowUpActionRequestError >
                (new FollowUpActionRequestError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FollowUpActionRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FollowUpActionRequestCallbackIF*) _callback)->onFollowUpActionRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FollowUpActionResponse: {
                ::boost::shared_ptr< FollowUpActionResponseError > payload = ::boost::shared_ptr< FollowUpActionResponseError >
                (new FollowUpActionResponseError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FollowUpActionResponse", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FollowUpActionResponseCallbackIF*) _callback)->onFollowUpActionResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ExternalImagesStatus: {
                ::boost::shared_ptr< ExternalImagesStatusError > payload = ::boost::shared_ptr< ExternalImagesStatusError >
                (new ExternalImagesStatusError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExternalImagesStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExternalImagesStatusCallbackIF*) _callback)->onExternalImagesStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Clients: {
                ::boost::shared_ptr< ClientsError > payload = ::boost::shared_ptr< ClientsError >
                (new ClientsError(DBUS_ERROR_NO_SERVER, "The DBus service HMIAppCtrl is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Clients", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HMIAppCtrlProxy> proxyShared = ::boost::static_pointer_cast<HMIAppCtrlProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClientsCallbackIF*) _callback)->onClientsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HMIAppCtrlProxyCallback::_logger (HMIAppCtrlProxy::_logger);

HMIAppCtrlProxy::HMIAppCtrlProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.appctrl.HMIAppCtrl", serviceAvailable, _logger) {
}

HMIAppCtrlProxy::~HMIAppCtrlProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HMIAppCtrlProxy > HMIAppCtrlProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HMIAppCtrlProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HMIAppCtrlProxy > proxyNew(new HMIAppCtrlProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HMIAppCtrlProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HMIAppCtrlProxyCallback* callback = new HMIAppCtrlProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HMIAppCtrlProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HMIAppCtrlProxyCallback* callback = new HMIAppCtrlProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HMIAppCtrlProxy::clearAllProperties ()
{
    _externalImagesStatus = ::asf::core::nullable< ExternalImagesStatusUpdate >();
    _clients = ::asf::core::nullable< ClientsUpdate >();
}

void HMIAppCtrlProxy::sendDeregisterAll () const
{
    sendClientsDeregisterAll();
    sendQueryClientDeregisterAll();
    sendSubSurfaceSwitchUpdateDeregisterAll();
    sendKeyInfoForwardingDeregisterAll();
    sendEncoderInfoForwardingDeregisterAll();
    sendSetDisplayDeregisterAll();
    sendSetMultiDisplayDeregisterAll();
    sendEvDisplayStatusEvalDeregisterAll();
    sendActivateExternalImageProviderDeregisterAll();
    sendExternalImageProviderTouchDeregisterAll();
    sendSlaveSurfaceRepositioningDeregisterAll();
    sendSlaveSurfaceRepositioningAckDeregisterAll();
    sendDirectTextureConsumerPositionInfoRequestDeregisterAll();
    sendDirectTextureConsumerPositionInfoResponseDeregisterAll();
    sendDrmGarbageCollectionRequestDeregisterAll();
    sendFollowUpActionRequestDeregisterAll();
    sendFollowUpActionResponseDeregisterAll();
}

act_t HMIAppCtrlProxy::sendQueryClientRegister(QueryClientCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "QueryClient");
    act_t act = addSignalCallback(ID_QueryClient, "QueryClient", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "QueryClient", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendQueryClientDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("QueryClient", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "QueryClient", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendQueryClientDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "QueryClient");
    _dbusProxyDelegate->deregisterSignalCallback("QueryClient", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendSubSurfaceSwitchUpdateRegister(SubSurfaceSwitchUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "subSurfaceSwitchUpdate");
    act_t act = addSignalCallback(ID_subSurfaceSwitchUpdate, "subSurfaceSwitchUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SubSurfaceSwitchUpdate", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendSubSurfaceSwitchUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("subSurfaceSwitchUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SubSurfaceSwitchUpdate", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendSubSurfaceSwitchUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SubSurfaceSwitchUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("subSurfaceSwitchUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendKeyInfoForwardingRegister(KeyInfoForwardingCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "keyInfoForwarding");
    act_t act = addSignalCallback(ID_keyInfoForwarding, "keyInfoForwarding", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KeyInfoForwarding", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendKeyInfoForwardingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("keyInfoForwarding", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KeyInfoForwarding", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendKeyInfoForwardingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KeyInfoForwarding");
    _dbusProxyDelegate->deregisterSignalCallback("keyInfoForwarding", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendEncoderInfoForwardingRegister(EncoderInfoForwardingCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "encoderInfoForwarding");
    act_t act = addSignalCallback(ID_encoderInfoForwarding, "encoderInfoForwarding", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EncoderInfoForwarding", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendEncoderInfoForwardingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("encoderInfoForwarding", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EncoderInfoForwarding", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendEncoderInfoForwardingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EncoderInfoForwarding");
    _dbusProxyDelegate->deregisterSignalCallback("encoderInfoForwarding", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendSetDisplayRegister(SetDisplayCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SetDisplay");
    act_t act = addSignalCallback(ID_SetDisplay, "SetDisplay", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SetDisplay", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendSetDisplayDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SetDisplay", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SetDisplay", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendSetDisplayDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SetDisplay");
    _dbusProxyDelegate->deregisterSignalCallback("SetDisplay", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendSetMultiDisplayRegister(SetMultiDisplayCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SetMultiDisplay");
    act_t act = addSignalCallback(ID_SetMultiDisplay, "SetMultiDisplay", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SetMultiDisplay", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendSetMultiDisplayDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SetMultiDisplay", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SetMultiDisplay", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendSetMultiDisplayDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SetMultiDisplay");
    _dbusProxyDelegate->deregisterSignalCallback("SetMultiDisplay", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendEvDisplayStatusEvalRegister(EvDisplayStatusEvalCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "evDisplayStatusEval");
    act_t act = addSignalCallback(ID_evDisplayStatusEval, "evDisplayStatusEval", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EvDisplayStatusEval", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendEvDisplayStatusEvalDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("evDisplayStatusEval", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EvDisplayStatusEval", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendEvDisplayStatusEvalDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EvDisplayStatusEval");
    _dbusProxyDelegate->deregisterSignalCallback("evDisplayStatusEval", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendActivateExternalImageProviderRegister(ActivateExternalImageProviderCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ActivateExternalImageProvider");
    act_t act = addSignalCallback(ID_ActivateExternalImageProvider, "ActivateExternalImageProvider", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActivateExternalImageProvider", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendActivateExternalImageProviderDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActivateExternalImageProvider", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActivateExternalImageProvider", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendActivateExternalImageProviderDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActivateExternalImageProvider");
    _dbusProxyDelegate->deregisterSignalCallback("ActivateExternalImageProvider", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendExternalImageProviderTouchRegister(ExternalImageProviderTouchCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ExternalImageProviderTouch");
    act_t act = addSignalCallback(ID_ExternalImageProviderTouch, "ExternalImageProviderTouch", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ExternalImageProviderTouch", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendExternalImageProviderTouchDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ExternalImageProviderTouch", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ExternalImageProviderTouch", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendExternalImageProviderTouchDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ExternalImageProviderTouch");
    _dbusProxyDelegate->deregisterSignalCallback("ExternalImageProviderTouch", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendSlaveSurfaceRepositioningRegister(SlaveSurfaceRepositioningCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SlaveSurfaceRepositioning");
    act_t act = addSignalCallback(ID_SlaveSurfaceRepositioning, "SlaveSurfaceRepositioning", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SlaveSurfaceRepositioning", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendSlaveSurfaceRepositioningDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SlaveSurfaceRepositioning", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SlaveSurfaceRepositioning", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendSlaveSurfaceRepositioningDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SlaveSurfaceRepositioning");
    _dbusProxyDelegate->deregisterSignalCallback("SlaveSurfaceRepositioning", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendSlaveSurfaceRepositioningAckRegister(SlaveSurfaceRepositioningAckCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SlaveSurfaceRepositioningAck");
    act_t act = addSignalCallback(ID_SlaveSurfaceRepositioningAck, "SlaveSurfaceRepositioningAck", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SlaveSurfaceRepositioningAck", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendSlaveSurfaceRepositioningAckDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SlaveSurfaceRepositioningAck", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SlaveSurfaceRepositioningAck", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendSlaveSurfaceRepositioningAckDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SlaveSurfaceRepositioningAck");
    _dbusProxyDelegate->deregisterSignalCallback("SlaveSurfaceRepositioningAck", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoRequestRegister(DirectTextureConsumerPositionInfoRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DirectTextureConsumerPositionInfoRequest");
    act_t act = addSignalCallback(ID_DirectTextureConsumerPositionInfoRequest, "DirectTextureConsumerPositionInfoRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DirectTextureConsumerPositionInfoRequest", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DirectTextureConsumerPositionInfoRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DirectTextureConsumerPositionInfoRequest", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DirectTextureConsumerPositionInfoRequest");
    _dbusProxyDelegate->deregisterSignalCallback("DirectTextureConsumerPositionInfoRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoResponseRegister(DirectTextureConsumerPositionInfoResponseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DirectTextureConsumerPositionInfoResponse");
    act_t act = addSignalCallback(ID_DirectTextureConsumerPositionInfoResponse, "DirectTextureConsumerPositionInfoResponse", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DirectTextureConsumerPositionInfoResponse", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoResponseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DirectTextureConsumerPositionInfoResponse", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DirectTextureConsumerPositionInfoResponse", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendDirectTextureConsumerPositionInfoResponseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DirectTextureConsumerPositionInfoResponse");
    _dbusProxyDelegate->deregisterSignalCallback("DirectTextureConsumerPositionInfoResponse", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendDrmGarbageCollectionRequestRegister(DrmGarbageCollectionRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DrmGarbageCollectionRequest");
    act_t act = addSignalCallback(ID_DrmGarbageCollectionRequest, "DrmGarbageCollectionRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DrmGarbageCollectionRequest", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendDrmGarbageCollectionRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DrmGarbageCollectionRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DrmGarbageCollectionRequest", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendDrmGarbageCollectionRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DrmGarbageCollectionRequest");
    _dbusProxyDelegate->deregisterSignalCallback("DrmGarbageCollectionRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendFollowUpActionRequestRegister(FollowUpActionRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FollowUpActionRequest");
    act_t act = addSignalCallback(ID_FollowUpActionRequest, "FollowUpActionRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FollowUpActionRequest", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendFollowUpActionRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FollowUpActionRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FollowUpActionRequest", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendFollowUpActionRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FollowUpActionRequest");
    _dbusProxyDelegate->deregisterSignalCallback("FollowUpActionRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t HMIAppCtrlProxy::sendFollowUpActionResponseRegister(FollowUpActionResponseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FollowUpActionResponse");
    act_t act = addSignalCallback(ID_FollowUpActionResponse, "FollowUpActionResponse", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FollowUpActionResponse", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendFollowUpActionResponseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FollowUpActionResponse", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FollowUpActionResponse", act, static_cast<int>(rv));
    return rv;
}

void HMIAppCtrlProxy::sendFollowUpActionResponseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FollowUpActionResponse");
    _dbusProxyDelegate->deregisterSignalCallback("FollowUpActionResponse", 0, _dbusDaemonProxy.get(), false);
}


act_t HMIAppCtrlProxy::sendExternalImagesStatusGet(ExternalImagesStatusCallbackIF& cb) {
    HMIAppCtrlProxyCallback* callback = new HMIAppCtrlProxyCallback(ID_ExternalImagesStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ExternalImagesStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ExternalImagesStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ExternalImageData >& HMIAppCtrlProxy::getExternalImagesStatus() const {
    return _externalImagesStatus.get().getExternalImagesStatus();
}

bool HMIAppCtrlProxy::hasExternalImagesStatus() const {
    return _externalImagesStatus.hasValue();
}


act_t HMIAppCtrlProxy::sendClientsRegister(ClientsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Clients, "Clients", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Clients", &cb, act);
    return act;
}

bool HMIAppCtrlProxy::sendClientsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Clients", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Clients", act, static_cast<int>(rv));
    return rv;
}

act_t HMIAppCtrlProxy::sendClientsGet(ClientsCallbackIF& cb) {
    HMIAppCtrlProxyCallback* callback = new HMIAppCtrlProxyCallback(ID_Clients, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Clients", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Clients", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ApplicationState >& HMIAppCtrlProxy::getClients() const {
    return _clients.get().getClients();
}

bool HMIAppCtrlProxy::hasClients() const {
    return _clients.hasValue();
}

void HMIAppCtrlProxy::sendClientsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Clients");
    _dbusProxyDelegate->deregisterSignalCallback("Clients", 0, _dbusDaemonProxy.get(), true);
}

act_t HMIAppCtrlProxy::sendUpdateClientStatusRequest(uint32 pid, const ::std::string& name, hmiAppState state_) const {
    UpdateClientStatusRequest* payload = new UpdateClientStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setPid(pid);
    payload->setName(name);
    payload->setState_(state_);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateClientStatus", UpdateClientStatusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "UpdateClientStatus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendKeyForwardingRequest(const keyInfo& keyRequest) const {
    KeyForwardingRequest* payload = new KeyForwardingRequest();
    CHECK_ALLOCATION(payload);
    payload->setKeyRequest(keyRequest);
    DBUS_MESSAGE_CALL(dbusMessage, "KeyForwarding", KeyForwardingRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "KeyForwarding");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendEncoderForwardingRequest(const encoderInfo& encoderRequest) const {
    EncoderForwardingRequest* payload = new EncoderForwardingRequest();
    CHECK_ALLOCATION(payload);
    payload->setEncoderRequest(encoderRequest);
    DBUS_MESSAGE_CALL(dbusMessage, "EncoderForwarding", EncoderForwardingRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "EncoderForwarding");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendBeepForwardingRequest(int32 beepType) const {
    BeepForwardingRequest* payload = new BeepForwardingRequest();
    CHECK_ALLOCATION(payload);
    payload->setBeepType(beepType);
    DBUS_MESSAGE_CALL(dbusMessage, "BeepForwarding", BeepForwardingRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "BeepForwarding");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendSetApplicationMandatoryRequest(const ::std::string& name, bool value) const {
    SetApplicationMandatoryRequest* payload = new SetApplicationMandatoryRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetApplicationMandatory", SetApplicationMandatoryRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "SetApplicationMandatory");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendDisplayCmdRequest(const displayData& data) const {
    DisplayCmdRequest* payload = new DisplayCmdRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "DisplayCmd", DisplayCmdRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "DisplayCmd");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendMultiDisplayCmdRequest(const MultidisplayData& data) const {
    MultiDisplayCmdRequest* payload = new MultiDisplayCmdRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "MultiDisplayCmd", MultiDisplayCmdRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "MultiDisplayCmd");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendDisplayStatusEvalRequest(const MultidisplayData& data) const {
    DisplayStatusEvalRequest* payload = new DisplayStatusEvalRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "DisplayStatusEval", DisplayStatusEvalRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "DisplayStatusEval");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendRequestExternalImageProviderActivationRequest(gadgetStatus targetState, const ::std::vector< int32 >& instanceIds, int32 consumerId) const {
    RequestExternalImageProviderActivationRequest* payload = new RequestExternalImageProviderActivationRequest();
    CHECK_ALLOCATION(payload);
    payload->setTargetState(targetState);
    payload->setInstanceIds(instanceIds);
    payload->setConsumerId(consumerId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestExternalImageProviderActivation", RequestExternalImageProviderActivationRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestExternalImageProviderActivation");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendRequestExternalImageProviderTouchRequest(uint32 pidSender, const touchInfo& data, int32 instanceId) const {
    RequestExternalImageProviderTouchRequest* payload = new RequestExternalImageProviderTouchRequest();
    CHECK_ALLOCATION(payload);
    payload->setPidSender(pidSender);
    payload->setData(data);
    payload->setInstanceId(instanceId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestExternalImageProviderTouch", RequestExternalImageProviderTouchRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestExternalImageProviderTouch");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendRequestSlaveSurfaceRepositioningRequest(uint32 pidSender, bool activate, uint32 surfaceId) const {
    RequestSlaveSurfaceRepositioningRequest* payload = new RequestSlaveSurfaceRepositioningRequest();
    CHECK_ALLOCATION(payload);
    payload->setPidSender(pidSender);
    payload->setActivate(activate);
    payload->setSurfaceId(surfaceId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestSlaveSurfaceRepositioning", RequestSlaveSurfaceRepositioningRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestSlaveSurfaceRepositioning");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendResponseSlaveSurfaceRepositioningRequest(uint32 pidSender, bool activate, uint32 surfaceId, bool status) const {
    ResponseSlaveSurfaceRepositioningRequest* payload = new ResponseSlaveSurfaceRepositioningRequest();
    CHECK_ALLOCATION(payload);
    payload->setPidSender(pidSender);
    payload->setActivate(activate);
    payload->setSurfaceId(surfaceId);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "ResponseSlaveSurfaceRepositioning", ResponseSlaveSurfaceRepositioningRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ResponseSlaveSurfaceRepositioning");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendRequestDirectTextureConsumerPositionInfoRequest(uint32 pidSender, uint32 instanceId) const {
    RequestDirectTextureConsumerPositionInfoRequest* payload = new RequestDirectTextureConsumerPositionInfoRequest();
    CHECK_ALLOCATION(payload);
    payload->setPidSender(pidSender);
    payload->setInstanceId(instanceId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestDirectTextureConsumerPositionInfo", RequestDirectTextureConsumerPositionInfoRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestDirectTextureConsumerPositionInfo");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendResponseDirectTextureConsumerPositionInfoRequest(uint32 pidSender, uint32 instanceId, float xPos, float yPos) const {
    ResponseDirectTextureConsumerPositionInfoRequest* payload = new ResponseDirectTextureConsumerPositionInfoRequest();
    CHECK_ALLOCATION(payload);
    payload->setPidSender(pidSender);
    payload->setInstanceId(instanceId);
    payload->setXPos(xPos);
    payload->setYPos(yPos);
    DBUS_MESSAGE_CALL(dbusMessage, "ResponseDirectTextureConsumerPositionInfo", ResponseDirectTextureConsumerPositionInfoRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ResponseDirectTextureConsumerPositionInfo");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendApplicationRenderedUpdateRequest(int32 surfaceid) const {
    ApplicationRenderedUpdateRequest* payload = new ApplicationRenderedUpdateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSurfaceid(surfaceid);
    DBUS_MESSAGE_CALL(dbusMessage, "ApplicationRenderedUpdate", ApplicationRenderedUpdateRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ApplicationRenderedUpdate");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendApplicationSwitchCompleteRequest(int32 surfaceid, int32 surfaceState) const {
    ApplicationSwitchCompleteRequest* payload = new ApplicationSwitchCompleteRequest();
    CHECK_ALLOCATION(payload);
    payload->setSurfaceid(surfaceid);
    payload->setSurfaceState(surfaceState);
    DBUS_MESSAGE_CALL(dbusMessage, "ApplicationSwitchComplete", ApplicationSwitchCompleteRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ApplicationSwitchComplete");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendSubSurfaceSwitchCompleteRequest(int32 surfaceid, int32 surfaceState) const {
    SubSurfaceSwitchCompleteRequest* payload = new SubSurfaceSwitchCompleteRequest();
    CHECK_ALLOCATION(payload);
    payload->setSurfaceid(surfaceid);
    payload->setSurfaceState(surfaceState);
    DBUS_MESSAGE_CALL(dbusMessage, "SubSurfaceSwitchComplete", SubSurfaceSwitchCompleteRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "SubSurfaceSwitchComplete");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendFollowUpActionRequest(followUpAction actionType, uint32 userData) const {
    FollowUpActionRequest* payload = new FollowUpActionRequest();
    CHECK_ALLOCATION(payload);
    payload->setActionType(actionType);
    payload->setUserData(userData);
    DBUS_MESSAGE_CALL(dbusMessage, "FollowUpAction", FollowUpActionRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "FollowUpAction");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendResponseFollowUpActionRequest(followUpAction actionType, uint32 userData) const {
    ResponseFollowUpActionRequest* payload = new ResponseFollowUpActionRequest();
    CHECK_ALLOCATION(payload);
    payload->setActionType(actionType);
    payload->setUserData(userData);
    DBUS_MESSAGE_CALL(dbusMessage, "ResponseFollowUpAction", ResponseFollowUpActionRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ResponseFollowUpAction");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t HMIAppCtrlProxy::sendDrmBufferAllocationStatusRequest(int32 pid, drmBufferAllocationStatus status, uint32 bufferSize) const {
    DrmBufferAllocationStatusRequest* payload = new DrmBufferAllocationStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setPid(pid);
    payload->setStatus(status);
    payload->setBufferSize(bufferSize);
    DBUS_MESSAGE_CALL(dbusMessage, "DrmBufferAllocationStatus", DrmBufferAllocationStatusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "DrmBufferAllocationStatus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace HMIAppCtrl
} // namespace appctrl
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
