/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrl.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlConst.h"
#include "bosch/cm/ai/hmi/appctrl/HMIAppCtrlDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of keyInfo

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint32 o1 = in.getKeyCode();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o1));
        uint8 o2 = in.getKeyState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BYTE, &o2));
        uint32 o3 = in.getPidSender();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o3));
        uint32 o4 = in.getPidReceiver();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o4));
        uint32 o5 = in.getDisplayId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o5));
        uint32 o6 = in.getUserData();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o6));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo& out) {
    {
        DBusMessageIter o7;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o7);
                {
                    uint32 keyCodeValue;
                    uint32 &keyCodeTmpValue = keyCodeValue;
                    dbus_message_iter_get_basic(&o7, &keyCodeTmpValue);
                    out.setKeyCode(keyCodeValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

                {
                    uint8 keyStateValue;
                    uint8 &keyStateTmpValue = keyStateValue;
                    dbus_message_iter_get_basic(&o7, &keyStateTmpValue);
                    out.setKeyState(keyStateValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

                {
                    uint32 pidSenderValue;
                    uint32 &pidSenderTmpValue = pidSenderValue;
                    dbus_message_iter_get_basic(&o7, &pidSenderTmpValue);
                    out.setPidSender(pidSenderValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

                {
                    uint32 pidReceiverValue;
                    uint32 &pidReceiverTmpValue = pidReceiverValue;
                    dbus_message_iter_get_basic(&o7, &pidReceiverTmpValue);
                    out.setPidReceiver(pidReceiverValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

                {
                    uint32 displayIdValue;
                    uint32 &displayIdTmpValue = displayIdValue;
                    dbus_message_iter_get_basic(&o7, &displayIdTmpValue);
                    out.setDisplayId(displayIdValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

                {
                    uint32 userDataValue;
                    uint32 &userDataTmpValue = userDataValue;
                    dbus_message_iter_get_basic(&o7, &userDataTmpValue);
                    out.setUserData(userDataValue);
                }

                if (dbus_message_iter_has_next(&o7)) {
                    dbus_message_iter_next(&o7);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of touchInfo

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o8Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o8Struct));
        uint8 o9 = in.getTouchState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o8Struct, DBUS_TYPE_BYTE, &o9));
        int32 o10 = in.getXPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o8Struct, DBUS_TYPE_INT32, &o10));
        int32 o11 = in.getYPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o8Struct, DBUS_TYPE_INT32, &o11));
        uint32 o12 = in.getTimeStamp();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o8Struct, DBUS_TYPE_UINT32, &o12));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o8Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo& out) {
    {
        DBusMessageIter o13;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o13);
                {
                    uint8 touchStateValue;
                    uint8 &touchStateTmpValue = touchStateValue;
                    dbus_message_iter_get_basic(&o13, &touchStateTmpValue);
                    out.setTouchState(touchStateValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

                {
                    int32 xPosValue;
                    int32 &xPosTmpValue = xPosValue;
                    dbus_message_iter_get_basic(&o13, &xPosTmpValue);
                    out.setXPos(xPosValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

                {
                    int32 yPosValue;
                    int32 &yPosTmpValue = yPosValue;
                    dbus_message_iter_get_basic(&o13, &yPosTmpValue);
                    out.setYPos(yPosValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

                {
                    uint32 timeStampValue;
                    uint32 &timeStampTmpValue = timeStampValue;
                    dbus_message_iter_get_basic(&o13, &timeStampTmpValue);
                    out.setTimeStamp(timeStampValue);
                }

                if (dbus_message_iter_has_next(&o13)) {
                    dbus_message_iter_next(&o13);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of encoderInfo

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        int32 o15 = in.getEncCode();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_INT32, &o15));
        int32 o16 = in.getEncValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_INT32, &o16));
        uint32 o17 = in.getPidSender();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o17));
        uint32 o18 = in.getPidReceiver();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o18));
        uint32 o19 = in.getSurfaceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o19));
        uint32 o20 = in.getUserData();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o20));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo& out) {
    {
        DBusMessageIter o21;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o21);
                {
                    int32 encCodeValue;
                    int32 &encCodeTmpValue = encCodeValue;
                    dbus_message_iter_get_basic(&o21, &encCodeTmpValue);
                    out.setEncCode(encCodeValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    int32 encValueValue;
                    int32 &encValueTmpValue = encValueValue;
                    dbus_message_iter_get_basic(&o21, &encValueTmpValue);
                    out.setEncValue(encValueValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    uint32 pidSenderValue;
                    uint32 &pidSenderTmpValue = pidSenderValue;
                    dbus_message_iter_get_basic(&o21, &pidSenderTmpValue);
                    out.setPidSender(pidSenderValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    uint32 pidReceiverValue;
                    uint32 &pidReceiverTmpValue = pidReceiverValue;
                    dbus_message_iter_get_basic(&o21, &pidReceiverTmpValue);
                    out.setPidReceiver(pidReceiverValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    uint32 surfaceIdValue;
                    uint32 &surfaceIdTmpValue = surfaceIdValue;
                    dbus_message_iter_get_basic(&o21, &surfaceIdTmpValue);
                    out.setSurfaceId(surfaceIdValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

                {
                    uint32 userDataValue;
                    uint32 &userDataTmpValue = userDataValue;
                    dbus_message_iter_get_basic(&o21, &userDataTmpValue);
                    out.setUserData(userDataValue);
                }

                if (dbus_message_iter_has_next(&o21)) {
                    dbus_message_iter_next(&o21);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of displayData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o22Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o22Struct));
        int32 o23 = in.getPidReceiver();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_INT32, &o23));
        const char* o24 = in.getSenderName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_STRING, &o24));
        const char* o25 = in.getReceiverName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_STRING, &o25));
        int32 o26 = in.getDisplayRegion();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_INT32, &o26));
        int32 o27 = in.getRegionType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_INT32, &o27));
        int16 o28 = in.getDisplayRegionStatus();
        int16 o29 = o28;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22Struct, DBUS_TYPE_INT16, &o29));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o22Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData& out) {
    {
        DBusMessageIter o30;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o30);
                {
                    int32 pidReceiverValue;
                    int32 &pidReceiverTmpValue = pidReceiverValue;
                    dbus_message_iter_get_basic(&o30, &pidReceiverTmpValue);
                    out.setPidReceiver(pidReceiverValue);
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

                {
                    ::std::string senderNameValue;
                    ::std::string &senderNameTmpValue = senderNameValue;
                    {
                        char* o31 = 0;
                        dbus_message_iter_get_basic(&o30, &o31);
                        senderNameTmpValue.assign (o31);
                    }
                    out.setSenderName(senderNameValue);
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

                {
                    ::std::string receiverNameValue;
                    ::std::string &receiverNameTmpValue = receiverNameValue;
                    {
                        char* o32 = 0;
                        dbus_message_iter_get_basic(&o30, &o32);
                        receiverNameTmpValue.assign (o32);
                    }
                    out.setReceiverName(receiverNameValue);
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

                {
                    int32 displayRegionValue;
                    int32 &displayRegionTmpValue = displayRegionValue;
                    dbus_message_iter_get_basic(&o30, &displayRegionTmpValue);
                    out.setDisplayRegion(displayRegionValue);
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

                {
                    int32 regionTypeValue;
                    int32 &regionTypeTmpValue = regionTypeValue;
                    dbus_message_iter_get_basic(&o30, &regionTypeTmpValue);
                    out.setRegionType(regionTypeValue);
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

                {
                    int16 displayRegionStatusValue;
                    int16 &displayRegionStatusTmpValue = displayRegionStatusValue;
                    dbus_message_iter_get_basic(&o30, &displayRegionStatusTmpValue);
                    out.setDisplayRegionStatus(static_cast<int8>(displayRegionStatusValue));
                }

                if (dbus_message_iter_has_next(&o30)) {
                    dbus_message_iter_next(&o30);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of MultidisplayData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o33Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o33Struct));
        int32 o34 = in.getPidReceiver();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_INT32, &o34));
        uint32 o35 = in.getDisplayid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_UINT32, &o35));
        const char* o36 = in.getSenderName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_STRING, &o36));
        const char* o37 = in.getReceiverName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_STRING, &o37));
        int32 o38 = in.getDisplayRegion();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_INT32, &o38));
        int32 o39 = in.getRegionType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_INT32, &o39));
        int16 o40 = in.getDisplayRegionStatus();
        int16 o41 = o40;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o33Struct, DBUS_TYPE_INT16, &o41));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o33Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData& out) {
    {
        DBusMessageIter o42;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o42);
                {
                    int32 pidReceiverValue;
                    int32 &pidReceiverTmpValue = pidReceiverValue;
                    dbus_message_iter_get_basic(&o42, &pidReceiverTmpValue);
                    out.setPidReceiver(pidReceiverValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    uint32 displayidValue;
                    uint32 &displayidTmpValue = displayidValue;
                    dbus_message_iter_get_basic(&o42, &displayidTmpValue);
                    out.setDisplayid(displayidValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    ::std::string senderNameValue;
                    ::std::string &senderNameTmpValue = senderNameValue;
                    {
                        char* o43 = 0;
                        dbus_message_iter_get_basic(&o42, &o43);
                        senderNameTmpValue.assign (o43);
                    }
                    out.setSenderName(senderNameValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    ::std::string receiverNameValue;
                    ::std::string &receiverNameTmpValue = receiverNameValue;
                    {
                        char* o44 = 0;
                        dbus_message_iter_get_basic(&o42, &o44);
                        receiverNameTmpValue.assign (o44);
                    }
                    out.setReceiverName(receiverNameValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    int32 displayRegionValue;
                    int32 &displayRegionTmpValue = displayRegionValue;
                    dbus_message_iter_get_basic(&o42, &displayRegionTmpValue);
                    out.setDisplayRegion(displayRegionValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    int32 regionTypeValue;
                    int32 &regionTypeTmpValue = regionTypeValue;
                    dbus_message_iter_get_basic(&o42, &regionTypeTmpValue);
                    out.setRegionType(regionTypeValue);
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

                {
                    int16 displayRegionStatusValue;
                    int16 &displayRegionStatusTmpValue = displayRegionStatusValue;
                    dbus_message_iter_get_basic(&o42, &displayRegionStatusTmpValue);
                    out.setDisplayRegionStatus(static_cast<int8>(displayRegionStatusValue));
                }

                if (dbus_message_iter_has_next(&o42)) {
                    dbus_message_iter_next(&o42);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ExternalImageData

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o45Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o45Struct));
        const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus  o46 = in.getGadgetState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_UINT32, &o46));
        int32 o47 = in.getInstanceId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_INT32, &o47));
        uint32 o48 = in.getConsumerId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_UINT32, &o48));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o45Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData& out) {
    {
        DBusMessageIter o49;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o49);
                {
                    ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus gadgetStateValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
                    dbus_message_iter_get_basic(&o49, &gadgetStateValue);
                    out.setGadgetState(gadgetStateValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

                {
                    int32 instanceIdValue;
                    int32 &instanceIdTmpValue = instanceIdValue;
                    dbus_message_iter_get_basic(&o49, &instanceIdTmpValue);
                    out.setInstanceId(instanceIdValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

                {
                    uint32 consumerIdValue;
                    uint32 &consumerIdTmpValue = consumerIdValue;
                    dbus_message_iter_get_basic(&o49, &consumerIdTmpValue);
                    out.setConsumerId(consumerIdValue);
                }

                if (dbus_message_iter_has_next(&o49)) {
                    dbus_message_iter_next(&o49);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ApplicationState

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState& in, DBusMessageIter* out) {
    {
        DBusMessageIter o50Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o50Struct));
        int32 o51 = in.getPid();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50Struct, DBUS_TYPE_INT32, &o51));
        const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState  o52 = in.getAppState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50Struct, DBUS_TYPE_UINT32, &o52));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o50Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState& out) {
    {
        DBusMessageIter o53;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o53);
                {
                    int32 pidValue;
                    int32 &pidTmpValue = pidValue;
                    dbus_message_iter_get_basic(&o53, &pidTmpValue);
                    out.setPid(pidValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState appStateValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EnumAppState__APP_STATE_UNKNOWN;
                    dbus_message_iter_get_basic(&o53, &appStateValue);
                    out.setAppState(appStateValue);
                }

                if (dbus_message_iter_has_next(&o53)) {
                    dbus_message_iter_next(&o53);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of UpdateClientStatusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest& in, DBusMessageIter* out) {
    uint32 o54 = in.getPid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o54));
    const char* o55 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o55));
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState  o56 = in.getState_();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o56));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::UpdateClientStatusRequest& out) {
    {
        uint32 pidValue;
        uint32 &pidTmpValue = pidValue;
        dbus_message_iter_get_basic(in, &pidTmpValue);
        out.setPid(pidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o57 = 0;
            dbus_message_iter_get_basic(in, &o57);
            nameTmpValue.assign (o57);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState state_Value = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::hmiAppState__HMIAPP_UNINITIALIZED;
        dbus_message_iter_get_basic(in, &state_Value);
        out.setState_(state_Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KeyForwardingRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getKeyRequest(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo keyRequestValue;
        if (!deserializeDBus(in, keyRequestValue)) {
            return false;
        }
        out.setKeyRequest(keyRequestValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EncoderForwardingRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getEncoderRequest(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderForwardingRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo encoderRequestValue;
        if (!deserializeDBus(in, encoderRequestValue)) {
            return false;
        }
        out.setEncoderRequest(encoderRequestValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BeepForwardingRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest& in, DBusMessageIter* out) {
    int32 o58 = in.getBeepType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o58));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::BeepForwardingRequest& out) {
    {
        int32 beepTypeValue;
        int32 &beepTypeTmpValue = beepTypeValue;
        dbus_message_iter_get_basic(in, &beepTypeTmpValue);
        out.setBeepType(beepTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetApplicationMandatoryRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest& in, DBusMessageIter* out) {
    const char* o59 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o59));
    dbus_bool_t o60 = in.getValue() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o60));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o61 = 0;
            dbus_message_iter_get_basic(in, &o61);
            nameTmpValue.assign (o61);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool valueValue;
        bool &valueTmpValue = valueValue;
        {
            dbus_bool_t o62;
            dbus_message_iter_get_basic(in, &o62);
            valueTmpValue = o62 ? true : false;
        }
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisplayCmdRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayCmdRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MultiDisplayCmdRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultiDisplayCmdRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisplayStatusEvalRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DisplayStatusEvalRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestExternalImageProviderActivationRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus  o63 = in.getTargetState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o63));
    DBusMessageIter o64ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "i", &o64ArrayIter));
    const ::std::vector< int32 >* o65 = &in.getInstanceIds();
    ::std::vector< int32 >::const_iterator o66 = o65->end();
    for (::std::vector< int32 >::const_iterator o67 = o65->begin(); o67 != o66; ++o67) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64ArrayIter, DBUS_TYPE_INT32, &(*o67)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o64ArrayIter));
    int32 o68 = in.getConsumerId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o68));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderActivationRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus targetStateValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
        dbus_message_iter_get_basic(in, &targetStateValue);
        out.setTargetState(targetStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< int32 > instanceIdsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o69ArrayIter;
            dbus_message_iter_recurse (in, &o69ArrayIter);

            if(dbus_message_iter_get_arg_type(&o69ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    int32 o70;
                    dbus_message_iter_get_basic(&o69ArrayIter, &o70);
                    instanceIdsValue.push_back(o70);
                } while (dbus_message_iter_next(&o69ArrayIter));
            }
        }
        out.setInstanceIds(instanceIdsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 consumerIdValue;
        int32 &consumerIdTmpValue = consumerIdValue;
        dbus_message_iter_get_basic(in, &consumerIdTmpValue);
        out.setConsumerId(consumerIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestExternalImageProviderTouchRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest& in, DBusMessageIter* out) {
    uint32 o71 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o71));
    serializeDBus(in.getData(), out);
    int32 o72 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o72));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestExternalImageProviderTouchRequest& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 instanceIdValue;
        int32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestSlaveSurfaceRepositioningRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest& in, DBusMessageIter* out) {
    uint32 o73 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o73));
    dbus_bool_t o74 = in.getActivate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o74));
    uint32 o75 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o75));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestSlaveSurfaceRepositioningRequest& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool activateValue;
        bool &activateTmpValue = activateValue;
        {
            dbus_bool_t o76;
            dbus_message_iter_get_basic(in, &o76);
            activateTmpValue = o76 ? true : false;
        }
        out.setActivate(activateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResponseSlaveSurfaceRepositioningRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest& in, DBusMessageIter* out) {
    uint32 o77 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o77));
    dbus_bool_t o78 = in.getActivate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o78));
    uint32 o79 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o79));
    dbus_bool_t o80 = in.getStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseSlaveSurfaceRepositioningRequest& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool activateValue;
        bool &activateTmpValue = activateValue;
        {
            dbus_bool_t o81;
            dbus_message_iter_get_basic(in, &o81);
            activateTmpValue = o81 ? true : false;
        }
        out.setActivate(activateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool statusValue;
        bool &statusTmpValue = statusValue;
        {
            dbus_bool_t o82;
            dbus_message_iter_get_basic(in, &o82);
            statusTmpValue = o82 ? true : false;
        }
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDirectTextureConsumerPositionInfoRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest& in, DBusMessageIter* out) {
    uint32 o83 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o83));
    uint32 o84 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o84));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::RequestDirectTextureConsumerPositionInfoRequest& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 instanceIdValue;
        uint32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResponseDirectTextureConsumerPositionInfoRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest& in, DBusMessageIter* out) {
    uint32 o85 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o85));
    uint32 o86 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o86));
    double o87 = in.getXPos();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_DOUBLE, &o87));
    double o88 = in.getYPos();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_DOUBLE, &o88));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseDirectTextureConsumerPositionInfoRequest& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 instanceIdValue;
        uint32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        float xPosValue;
        float &xPosTmpValue = xPosValue;
        {
            double o89;
            dbus_message_iter_get_basic(in, &o89);
            xPosTmpValue = static_cast<float>(o89);
        }
        out.setXPos(xPosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        float yPosValue;
        float &yPosTmpValue = yPosValue;
        {
            double o90;
            dbus_message_iter_get_basic(in, &o90);
            yPosTmpValue = static_cast<float>(o90);
        }
        out.setYPos(yPosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ApplicationRenderedUpdateRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest& in, DBusMessageIter* out) {
    int32 o91 = in.getSurfaceid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o91));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationRenderedUpdateRequest& out) {
    {
        int32 surfaceidValue;
        int32 &surfaceidTmpValue = surfaceidValue;
        dbus_message_iter_get_basic(in, &surfaceidTmpValue);
        out.setSurfaceid(surfaceidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ApplicationSwitchCompleteRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest& in, DBusMessageIter* out) {
    int32 o92 = in.getSurfaceid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o92));
    int32 o93 = in.getSurfaceState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o93));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationSwitchCompleteRequest& out) {
    {
        int32 surfaceidValue;
        int32 &surfaceidTmpValue = surfaceidValue;
        dbus_message_iter_get_basic(in, &surfaceidTmpValue);
        out.setSurfaceid(surfaceidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 surfaceStateValue;
        int32 &surfaceStateTmpValue = surfaceStateValue;
        dbus_message_iter_get_basic(in, &surfaceStateTmpValue);
        out.setSurfaceState(surfaceStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SubSurfaceSwitchCompleteRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest& in, DBusMessageIter* out) {
    int32 o94 = in.getSurfaceid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o94));
    int32 o95 = in.getSurfaceState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchCompleteRequest& out) {
    {
        int32 surfaceidValue;
        int32 &surfaceidTmpValue = surfaceidValue;
        dbus_message_iter_get_basic(in, &surfaceidTmpValue);
        out.setSurfaceid(surfaceidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 surfaceStateValue;
        int32 &surfaceStateTmpValue = surfaceStateValue;
        dbus_message_iter_get_basic(in, &surfaceStateTmpValue);
        out.setSurfaceState(surfaceStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FollowUpActionRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction  o96 = in.getActionType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o96));
    uint32 o97 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o97));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionTypeValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
        dbus_message_iter_get_basic(in, &actionTypeValue);
        out.setActionType(actionTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ResponseFollowUpActionRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction  o98 = in.getActionType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o98));
    uint32 o99 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o99));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ResponseFollowUpActionRequest& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionTypeValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
        dbus_message_iter_get_basic(in, &actionTypeValue);
        out.setActionType(actionTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DrmBufferAllocationStatusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest& in, DBusMessageIter* out) {
    int32 o100 = in.getPid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o100));
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus  o101 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o101));
    uint32 o102 = in.getBufferSize();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o102));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DrmBufferAllocationStatusRequest& out) {
    {
        int32 pidValue;
        int32 &pidTmpValue = pidValue;
        dbus_message_iter_get_basic(in, &pidTmpValue);
        out.setPid(pidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus statusValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::drmBufferAllocationStatus__DRM_BUFFER_ALLOCATION_FAILED;
        dbus_message_iter_get_basic(in, &statusValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 bufferSizeValue;
        uint32 &bufferSizeTmpValue = bufferSizeValue;
        dbus_message_iter_get_basic(in, &bufferSizeTmpValue);
        out.setBufferSize(bufferSizeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExternalImagesStatusUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o103ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uiu)", &o103ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData >* o104 = &in.getExternalImagesStatus();
    ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData >::const_iterator o105 = o104->end();
    for (::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData >::const_iterator o106 = o104->begin(); o106 != o105; ++o106) {
        serializeDBus((*o106), &o103ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o103ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData > ExternalImagesStatusValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o107ArrayIter;
            dbus_message_iter_recurse (in, &o107ArrayIter);

            if(dbus_message_iter_get_arg_type(&o107ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageData o108;
                    if (!deserializeDBus(&o107ArrayIter, o108)) {
                        return false;
                    }
                    ExternalImagesStatusValue.push_back(o108);
                } while (dbus_message_iter_next(&o107ArrayIter));
            }
        }
        out.setExternalImagesStatus(ExternalImagesStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExternalImagesStatusRegister

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImagesStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ClientsUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o109ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(iu)", &o109ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState >* o110 = &in.getClients();
    ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState >::const_iterator o111 = o110->end();
    for (::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState >::const_iterator o112 = o110->begin(); o112 != o111; ++o112) {
        serializeDBus((*o112), &o109ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o109ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState > ClientsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o113ArrayIter;
            dbus_message_iter_recurse (in, &o113ArrayIter);

            if(dbus_message_iter_get_arg_type(&o113ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ApplicationState o114;
                    if (!deserializeDBus(&o113ArrayIter, o114)) {
                        return false;
                    }
                    ClientsValue.push_back(o114);
                } while (dbus_message_iter_next(&o113ArrayIter));
            }
        }
        out.setClients(ClientsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ClientsRegister

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ClientsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SubSurfaceSwitchUpdateSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal& in, DBusMessageIter* out) {
    int32 o115 = in.getSurfaceid();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o115));
    int32 o116 = in.getSurfaceState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o116));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SubSurfaceSwitchUpdateSignal& out) {
    {
        int32 surfaceidValue;
        int32 &surfaceidTmpValue = surfaceidValue;
        dbus_message_iter_get_basic(in, &surfaceidTmpValue);
        out.setSurfaceid(surfaceidValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 surfaceStateValue;
        int32 &surfaceStateTmpValue = surfaceStateValue;
        dbus_message_iter_get_basic(in, &surfaceStateTmpValue);
        out.setSurfaceState(surfaceStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KeyInfoForwardingSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyInfoForwardingSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EncoderInfoForwardingSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EncoderInfoForwardingSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::encoderInfo dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetDisplaySignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetDisplaySignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::displayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMultiDisplaySignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetMultiDisplaySignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EvDisplayStatusEvalSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal& in, DBusMessageIter* out) {
    serializeDBus(in.getData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::MultidisplayData dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActivateExternalImageProviderSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus  o117 = in.getTargetState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o117));
    DBusMessageIter o118ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "i", &o118ArrayIter));
    const ::std::vector< int32 >* o119 = &in.getInstanceIds();
    ::std::vector< int32 >::const_iterator o120 = o119->end();
    for (::std::vector< int32 >::const_iterator o121 = o119->begin(); o121 != o120; ++o121) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o118ArrayIter, DBUS_TYPE_INT32, &(*o121)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o118ArrayIter));
    int32 o122 = in.getConsumerId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o122));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ActivateExternalImageProviderSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus targetStateValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::gadgetStatus__ACTIVE;
        dbus_message_iter_get_basic(in, &targetStateValue);
        out.setTargetState(targetStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< int32 > instanceIdsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o123ArrayIter;
            dbus_message_iter_recurse (in, &o123ArrayIter);

            if(dbus_message_iter_get_arg_type(&o123ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    int32 o124;
                    dbus_message_iter_get_basic(&o123ArrayIter, &o124);
                    instanceIdsValue.push_back(o124);
                } while (dbus_message_iter_next(&o123ArrayIter));
            }
        }
        out.setInstanceIds(instanceIdsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 consumerIdValue;
        int32 &consumerIdTmpValue = consumerIdValue;
        dbus_message_iter_get_basic(in, &consumerIdTmpValue);
        out.setConsumerId(consumerIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ExternalImageProviderTouchSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal& in, DBusMessageIter* out) {
    uint32 o125 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o125));
    serializeDBus(in.getData(), out);
    int32 o126 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o126));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::ExternalImageProviderTouchSignal& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::touchInfo dataValue;
        if (!deserializeDBus(in, dataValue)) {
            return false;
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 instanceIdValue;
        int32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SlaveSurfaceRepositioningSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal& in, DBusMessageIter* out) {
    uint32 o127 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o127));
    dbus_bool_t o128 = in.getActivate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o128));
    uint32 o129 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o129));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningSignal& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool activateValue;
        bool &activateTmpValue = activateValue;
        {
            dbus_bool_t o130;
            dbus_message_iter_get_basic(in, &o130);
            activateTmpValue = o130 ? true : false;
        }
        out.setActivate(activateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SlaveSurfaceRepositioningAckSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal& in, DBusMessageIter* out) {
    uint32 o131 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o131));
    dbus_bool_t o132 = in.getActivate() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o132));
    uint32 o133 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o133));
    dbus_bool_t o134 = in.getStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o134));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SlaveSurfaceRepositioningAckSignal& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool activateValue;
        bool &activateTmpValue = activateValue;
        {
            dbus_bool_t o135;
            dbus_message_iter_get_basic(in, &o135);
            activateTmpValue = o135 ? true : false;
        }
        out.setActivate(activateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool statusValue;
        bool &statusTmpValue = statusValue;
        {
            dbus_bool_t o136;
            dbus_message_iter_get_basic(in, &o136);
            statusTmpValue = o136 ? true : false;
        }
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DirectTextureConsumerPositionInfoRequestSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal& in, DBusMessageIter* out) {
    uint32 o137 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o137));
    uint32 o138 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o138));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoRequestSignal& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 instanceIdValue;
        uint32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DirectTextureConsumerPositionInfoResponseSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal& in, DBusMessageIter* out) {
    uint32 o139 = in.getPidSender();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o139));
    uint32 o140 = in.getInstanceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o140));
    double o141 = in.getXPos();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_DOUBLE, &o141));
    double o142 = in.getYPos();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_DOUBLE, &o142));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::DirectTextureConsumerPositionInfoResponseSignal& out) {
    {
        uint32 pidSenderValue;
        uint32 &pidSenderTmpValue = pidSenderValue;
        dbus_message_iter_get_basic(in, &pidSenderTmpValue);
        out.setPidSender(pidSenderValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 instanceIdValue;
        uint32 &instanceIdTmpValue = instanceIdValue;
        dbus_message_iter_get_basic(in, &instanceIdTmpValue);
        out.setInstanceId(instanceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        float xPosValue;
        float &xPosTmpValue = xPosValue;
        {
            double o143;
            dbus_message_iter_get_basic(in, &o143);
            xPosTmpValue = static_cast<float>(o143);
        }
        out.setXPos(xPosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        float yPosValue;
        float &yPosTmpValue = yPosValue;
        {
            double o144;
            dbus_message_iter_get_basic(in, &o144);
            yPosTmpValue = static_cast<float>(o144);
        }
        out.setYPos(yPosValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FollowUpActionRequestSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction  o145 = in.getActionType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o145));
    uint32 o146 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o146));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionRequestSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionTypeValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
        dbus_message_iter_get_basic(in, &actionTypeValue);
        out.setActionType(actionTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of FollowUpActionResponseSignal

void serializeDBus (const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction  o147 = in.getActionType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o147));
    uint32 o148 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o148));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::FollowUpActionResponseSignal& out) {
    {
        ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction actionTypeValue = ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::followUpAction__GADGET_PRESSED;
        dbus_message_iter_get_basic(in, &actionTypeValue);
        out.setActionType(actionTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

