/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "FC_STC/FC_STCApp.h"
#include "FC_STC/FC_STCMain.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "FC_STCApp" isn't clear, then there should be a description here.
 */

namespace FC_STC {

DEFINE_LOGGER_AND_LEVEL (_logger, "/FC_STC/FC_STCApp", Info);

/* static */ const char* FC_STCApp::fc_stcMainComp = "fc_stcMainComp";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool FC_STCApp_enabledASFSignalHandler = false;

void importFC_STCApp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach FC_STCApp, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSesConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSesConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSesConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSesConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSesConnector_(new ::asf::dbus::DBusConnector(*app, dbusSesConnector));
    app->addStarter(dbusSesConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSysConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSysConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSysConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSysConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSysConnector_(new ::asf::dbus::DBusConnector(*app, dbusSysConnector));
    app->addStarter(dbusSysConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(257);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'T_FC_STC_Thread'

    ::asf::core::ComponentContainerSharedPtr T_FC_STC_Thread(new ::asf::core::ComponentContainer("T_FC_STC_Thread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T_FC_STC_Thread);

        // Component 'FC_STCMain fc_stcMainComp'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::FC_STC::FC_STCMain > > fc_stcMainCompFactory(new ::asf::core::ComponentFactory< ::FC_STC::FC_STCMain >);
        ::asf::core::ComponentDescriptionSharedPtr fc_stcMainCompDescription(new ::asf::core::ComponentDescription(1, "fc_stcMainComp", /* immediate = */ true, /* threadBridge = */ false, fc_stcMainCompFactory));
        T_FC_STC_Thread->addComponentDescription(fc_stcMainCompDescription);

            // Port 'FCSTCStubPort'

            ::asf::core::ProvidedPort& fc_stcMainComp_FCSTCStubPort = fc_stcMainCompDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.stc.stcservices", "FCSTCStubPort", false, false));
            (void)fc_stcMainComp_FCSTCStubPort; // prevent unused variable warning

            // Port 'GNSPort'

            ::asf::core::RequiredPort& fc_stcMainComp_GNSPort = fc_stcMainCompDescription->addRequiredPort (::asf::core::RequiredPort ("sensor_location_fi", "GNSPort"));
            (void)fc_stcMainComp_GNSPort; // prevent unused variable warning

    // Expression

    dbusSesConnector_->exportByName (fc_stcMainComp_FCSTCStubPort, ::std::string("/org/bosch/stc/fc_stc"));

    // Expression

    ::asf::cca::CcaImportedPort& GNSsensorImport = ccaConnector_->importByName (10041, 1, 1, 2);
    GNSsensorImport.setServiceName("sensor_location_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fc_stcMainComp_GNSPort, GNSsensorImport);


    LOG_INFO_STATIC("Starting application 'FC_STCApp' version ");

    app->start();
}

int executeFC_STCApp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("FC_STC", "FC_STCApp");
    } else {
        ::asf::core::Logger::setupLogging ("FC_STC", "FC_STCApp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", FC_STCApp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("FC_STC", "FC_STCApp", ::asf::core::Version(), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create FC_STCApp");

    app->enableExceptionHandler(true);

    importFC_STCApp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace FC_STC

int main(int argc, char* argv[]) {
    ::FC_STC::FC_STCApp_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::FC_STC::executeFC_STCApp(argc, argv);
}

