/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_HMIEMPLISTINTERFACEPROXY_H
#define BOSCH_CM_DI_HMIEMPLISTINTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

class HmiEmpListInterfaceProxy;

class ListSizeCallbackIF {
public:
    virtual ~ListSizeCallbackIF() {}

    virtual void onListSizeError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ListSizeError >& error) = 0;

    virtual void onListSizeUpdate(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ListSizeUpdate >& update) = 0;
};

class ReqCreateMediaPlayerFolderListCallbackIF {
public:
    virtual ~ReqCreateMediaPlayerFolderListCallbackIF() {}

    virtual void onReqCreateMediaPlayerFolderListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListError >& error) = 0;

    virtual void onReqCreateMediaPlayerFolderListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListResponse >& response) = 0;
};

class ReqCreateMediaPlayerListCallbackIF {
public:
    virtual ~ReqCreateMediaPlayerListCallbackIF() {}

    virtual void onReqCreateMediaPlayerListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerListError >& error) = 0;

    virtual void onReqCreateMediaPlayerListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerListResponse >& response) = 0;
};

class ReqDBDownloadCallbackIF {
public:
    virtual ~ReqDBDownloadCallbackIF() {}

    virtual void onReqDBDownloadError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadError >& error) = 0;

    virtual void onReqDBDownloadResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadResponse >& response) = 0;
};

class ReqMediaPlayerFolderListSliceCallbackIF {
public:
    virtual ~ReqMediaPlayerFolderListSliceCallbackIF() {}

    virtual void onReqMediaPlayerFolderListSliceError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceError >& error) = 0;

    virtual void onReqMediaPlayerFolderListSliceResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceResponse >& response) = 0;
};

class ReqMediaPlayerListSliceCallbackIF {
public:
    virtual ~ReqMediaPlayerListSliceCallbackIF() {}

    virtual void onReqMediaPlayerListSliceError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerListSliceError >& error) = 0;

    virtual void onReqMediaPlayerListSliceResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerListSliceResponse >& response) = 0;
};

class SetMediaVideoLanguagesListCallbackIF {
public:
    virtual ~SetMediaVideoLanguagesListCallbackIF() {}

    virtual void onSetMediaVideoLanguagesListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMediaVideoLanguagesListError >& error) = 0;

    virtual void onSetMediaVideoLanguagesListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< SetMediaVideoLanguagesListResponse >& response) = 0;
};

class Sig_AlbumArtStateCallbackIF {
public:
    virtual ~Sig_AlbumArtStateCallbackIF() {}

    virtual void onSig_AlbumArtStateError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_AlbumArtStateError >& error) = 0;

    virtual void onSig_AlbumArtStateSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_AlbumArtStateSignal >& signal) = 0;
};

class Sig_CurrentTrackInfoCallbackIF {
public:
    virtual ~Sig_CurrentTrackInfoCallbackIF() {}

    virtual void onSig_CurrentTrackInfoError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CurrentTrackInfoError >& error) = 0;

    virtual void onSig_CurrentTrackInfoSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CurrentTrackInfoSignal >& signal) = 0;
};

class Sig_DBStateCallbackIF {
public:
    virtual ~Sig_DBStateCallbackIF() {}

    virtual void onSig_DBStateError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateError >& error) = 0;

    virtual void onSig_DBStateSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateSignal >& signal) = 0;
};

class Sig_PlayableFlagCallbackIF {
public:
    virtual ~Sig_PlayableFlagCallbackIF() {}

    virtual void onSig_PlayableFlagError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagError >& error) = 0;

    virtual void onSig_PlayableFlagSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagSignal >& signal) = 0;
};


/**
 * HmiEmpListInterfaceProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.di.HmiEmpListInterface' (specified in file
 * HmiEmpListInterface_.xml).
 *
 * If the meaning of "bosch.cm.di.HmiEmpListInterface" isn't clear, then there should be a description here.
 */
class HmiEmpListInterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of HmiEmpListInterfaceProxy.
     */
    static ::boost::shared_ptr< HmiEmpListInterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of HmiEmpListInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< HmiEmpListInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of HmiEmpListInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< HmiEmpListInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< HmiEmpListInterfaceProxy > proxyNew(new HmiEmpListInterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~HmiEmpListInterfaceProxy ();


    // Signal 'sig_DBState'

    /**
     * Notify on the signal 'sig_DBState'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'sig_DBState'</b>:
     *
     * sig_DBState =  DB download state
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_DBStateRegister(Sig_DBStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_DBState'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_DBState'</b>:
     *
     * sig_DBState =  DB download state
     *
     * @param act The act which was previously returned by the
     * sendSig_DBStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_DBStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_DBState'.
     */
    void sendSig_DBStateDeregisterAll () const;

    // Signal 'sig_AlbumArtState'

    /**
     * Notify on the signal 'sig_AlbumArtState'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_AlbumArtState'</b>:
     *
     * sig_AlbumArtState =  AlbumArt download state
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_AlbumArtStateRegister(Sig_AlbumArtStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_AlbumArtState'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_AlbumArtState'</b>:
     *
     * sig_AlbumArtState =  AlbumArt download state
     *
     * @param act The act which was previously returned by the
     * sendSig_AlbumArtStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_AlbumArtStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_AlbumArtState'.
     */
    void sendSig_AlbumArtStateDeregisterAll () const;

    // Signal 'sig_PlayableFlag'

    /**
     * Notify on the signal 'sig_PlayableFlag'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_PlayableFlag'</b>:
     *
     * sig_PlayableFlag =  playable content in USB
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_PlayableFlagRegister(Sig_PlayableFlagCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_PlayableFlag'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_PlayableFlag'</b>:
     *
     * sig_PlayableFlag =  playable content in USB
     *
     * @param act The act which was previously returned by the
     * sendSig_PlayableFlagRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_PlayableFlagDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_PlayableFlag'.
     */
    void sendSig_PlayableFlagDeregisterAll () const;

    // Signal 'sig_CurrentTrackInfo'

    /**
     * Notify on the signal 'sig_CurrentTrackInfo'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_CurrentTrackInfo'</b>:
     *
     * If the meaning of "sig_CurrentTrackInfo" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_CurrentTrackInfoRegister(Sig_CurrentTrackInfoCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_CurrentTrackInfo'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_CurrentTrackInfo'</b>:
     *
     * If the meaning of "sig_CurrentTrackInfo" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSig_CurrentTrackInfoRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_CurrentTrackInfoDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_CurrentTrackInfo'.
     */
    void sendSig_CurrentTrackInfoDeregisterAll () const;


    // Property 'listSize'

    /**
     * Notify on the property 'listSize'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListSizeRegister(ListSizeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'listSize'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     *
     * @param act The act which was previously returned by the
     * sendListSizeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendListSizeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'listSize'.
     */
    void sendListSizeDeregisterAll() const;

    /**
     * Request the value of the property 'listSize' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListSizeGet(ListSizeCallbackIF& cb);


    /**
     * Returns the current value of the property 'listSize' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasListSize()
     * returns true.
     *
     * @return the previously received value of the property 'listSize'.
     */
    const ListSizeStruct& getListSize() const;

    /**
     * Determines whether a status message for the property 'listSize' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasListSize() const;


    // Method 'ReqCreateMediaPlayerList'

    /**
     * Call the method 'ReqCreateMediaPlayerList'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerList'</b>:
     *
     * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ListType If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param AbsoluteIndex If the meaning of "AbsoluteIndex" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqCreateMediaPlayerListRequest(ReqCreateMediaPlayerListCallbackIF& cb, entListType listType, entSourceType sourceType, uint8 region, uint16 absoluteIndex) const;

    // Method 'ReqMediaPlayerListSlice'

    /**
     * Call the method 'ReqMediaPlayerListSlice'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'ReqMediaPlayerListSlice'</b>:
     *
     * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ListType If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param StartingIndex If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @param WindowSize If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqMediaPlayerListSliceRequest(ReqMediaPlayerListSliceCallbackIF& cb, entListType listType, entSourceType sourceType, uint8 region, uint16 startingIndex, uint8 windowSize) const;

    // Method 'ReqDBDownload'

    /**
     * Call the method 'ReqDBDownload'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ReqDBDownload'</b>:
     *
     * ReqDBDownload = Method to Request DB Download
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqDBDownloadRequest(ReqDBDownloadCallbackIF& cb, entSourceType sourceType) const;

    // Method 'ReqCreateMediaPlayerFolderList'

    /**
     * Call the method 'ReqCreateMediaPlayerFolderList'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerFolderList'</b>:
     *
     * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param FolderPath If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqCreateMediaPlayerFolderListRequest(ReqCreateMediaPlayerFolderListCallbackIF& cb, entSourceType sourceType, uint8 region, const ::std::string& folderPath) const;

    // Method 'ReqMediaPlayerFolderListSlice'

    /**
     * Call the method 'ReqMediaPlayerFolderListSlice'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ReqMediaPlayerFolderListSlice'</b>:
     *
     * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param StartingIndex If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @param WindowSize If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @param FolderPath If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReqMediaPlayerFolderListSliceRequest(ReqMediaPlayerFolderListSliceCallbackIF& cb, entSourceType sourceType, uint8 region, uint16 startingIndex, uint8 windowSize, const ::std::string& folderPath) const;

    // Method 'SetMediaVideoLanguagesList'

    /**
     * Call the method 'SetMediaVideoLanguagesList'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'SetMediaVideoLanguagesList'</b>:
     *
     * SetMediaVideoLanguagesList = Method to update list of selected languages
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param VideoLanguageIds If the meaning of "VideoLanguageIds" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMediaVideoLanguagesListRequest(SetMediaVideoLanguagesListCallbackIF& cb, entSourceType sourceType, uint8 region, const ::std::vector< uint16 >& videoLanguageIds) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    HmiEmpListInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'listSize'

    ::asf::core::nullable< ListSizeUpdate > _listSize;

    DECLARE_CLASS_LOGGER();

    friend class HmiEmpListInterfaceProxyCallback;
};

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_HMIEMPLISTINTERFACEPROXY_H
