/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include "bosch/cm/di/HmiEmpListInterfaceDBus.h"
#include "bosch/cm/di/HmiEmpListInterfaceJson.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/HmiEmpListInterface", HmiEmpListInterfaceProxy);

class HmiEmpListInterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HmiEmpListInterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxyShared = ::boost::static_pointer_cast< HmiEmpListInterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_sig_DBState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_DBStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_DBState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_DBStateSignal> payload = ::boost::static_pointer_cast<Sig_DBStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_DBStateCallbackIF*) _callback)->onSig_DBStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_AlbumArtState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_AlbumArtStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_AlbumArtState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_AlbumArtStateSignal> payload = ::boost::static_pointer_cast<Sig_AlbumArtStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_AlbumArtStateCallbackIF*) _callback)->onSig_AlbumArtStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_PlayableFlag:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_PlayableFlagSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_PlayableFlag", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_PlayableFlagSignal> payload = ::boost::static_pointer_cast<Sig_PlayableFlagSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_PlayableFlagCallbackIF*) _callback)->onSig_PlayableFlagSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_CurrentTrackInfo:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_CurrentTrackInfoSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_CurrentTrackInfo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_CurrentTrackInfoSignal> payload = ::boost::static_pointer_cast<Sig_CurrentTrackInfoSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_CurrentTrackInfoCallbackIF*) _callback)->onSig_CurrentTrackInfoSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_listSize:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListSizeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ListSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListSizeError> payload = ::boost::static_pointer_cast<ListSizeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ListSizeCallbackIF*) _callback)->onListSizeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListSizeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ListSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListSizeUpdate> payload = ::boost::static_pointer_cast<ListSizeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ListSizeCallbackIF*) _callback)->onListSizeUpdate(proxyShared, payload);
                        proxyShared->_listSize = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReqCreateMediaPlayerList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCreateMediaPlayerList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCreateMediaPlayerListError> payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCreateMediaPlayerListCallbackIF*) _callback)->onReqCreateMediaPlayerListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCreateMediaPlayerList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCreateMediaPlayerListResponse> payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCreateMediaPlayerListCallbackIF*) _callback)->onReqCreateMediaPlayerListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqMediaPlayerListSlice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerListSliceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqMediaPlayerListSlice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqMediaPlayerListSliceError> payload = ::boost::static_pointer_cast<ReqMediaPlayerListSliceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqMediaPlayerListSliceCallbackIF*) _callback)->onReqMediaPlayerListSliceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerListSliceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqMediaPlayerListSlice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqMediaPlayerListSliceResponse> payload = ::boost::static_pointer_cast<ReqMediaPlayerListSliceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqMediaPlayerListSliceCallbackIF*) _callback)->onReqMediaPlayerListSliceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqDBDownload:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqDBDownloadError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqDBDownload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqDBDownloadError> payload = ::boost::static_pointer_cast<ReqDBDownloadError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqDBDownloadCallbackIF*) _callback)->onReqDBDownloadError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqDBDownloadResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqDBDownload", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqDBDownloadResponse> payload = ::boost::static_pointer_cast<ReqDBDownloadResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqDBDownloadCallbackIF*) _callback)->onReqDBDownloadResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqCreateMediaPlayerFolderList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerFolderListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCreateMediaPlayerFolderList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCreateMediaPlayerFolderListError> payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerFolderListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCreateMediaPlayerFolderListCallbackIF*) _callback)->onReqCreateMediaPlayerFolderListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerFolderListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqCreateMediaPlayerFolderList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqCreateMediaPlayerFolderListResponse> payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerFolderListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqCreateMediaPlayerFolderListCallbackIF*) _callback)->onReqCreateMediaPlayerFolderListResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReqMediaPlayerFolderListSlice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerFolderListSliceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqMediaPlayerFolderListSlice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqMediaPlayerFolderListSliceError> payload = ::boost::static_pointer_cast<ReqMediaPlayerFolderListSliceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqMediaPlayerFolderListSliceCallbackIF*) _callback)->onReqMediaPlayerFolderListSliceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerFolderListSliceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReqMediaPlayerFolderListSlice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReqMediaPlayerFolderListSliceResponse> payload = ::boost::static_pointer_cast<ReqMediaPlayerFolderListSliceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReqMediaPlayerFolderListSliceCallbackIF*) _callback)->onReqMediaPlayerFolderListSliceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetMediaVideoLanguagesList:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetMediaVideoLanguagesListError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMediaVideoLanguagesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMediaVideoLanguagesListError> payload = ::boost::static_pointer_cast<SetMediaVideoLanguagesListError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMediaVideoLanguagesListCallbackIF*) _callback)->onSetMediaVideoLanguagesListError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMediaVideoLanguagesListResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMediaVideoLanguagesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetMediaVideoLanguagesListResponse> payload = ::boost::static_pointer_cast<SetMediaVideoLanguagesListResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetMediaVideoLanguagesListCallbackIF*) _callback)->onSetMediaVideoLanguagesListResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_sig_DBState: {
                ::boost::shared_ptr< Sig_DBStateError > payload = ::boost::shared_ptr< Sig_DBStateError >
                (new Sig_DBStateError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_DBState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_DBStateCallbackIF*) _callback)->onSig_DBStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_AlbumArtState: {
                ::boost::shared_ptr< Sig_AlbumArtStateError > payload = ::boost::shared_ptr< Sig_AlbumArtStateError >
                (new Sig_AlbumArtStateError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_AlbumArtState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_AlbumArtStateCallbackIF*) _callback)->onSig_AlbumArtStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_PlayableFlag: {
                ::boost::shared_ptr< Sig_PlayableFlagError > payload = ::boost::shared_ptr< Sig_PlayableFlagError >
                (new Sig_PlayableFlagError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_PlayableFlag", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_PlayableFlagCallbackIF*) _callback)->onSig_PlayableFlagError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_CurrentTrackInfo: {
                ::boost::shared_ptr< Sig_CurrentTrackInfoError > payload = ::boost::shared_ptr< Sig_CurrentTrackInfoError >
                (new Sig_CurrentTrackInfoError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_CurrentTrackInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_CurrentTrackInfoCallbackIF*) _callback)->onSig_CurrentTrackInfoError (proxyShared,payload);
                return true;
            }
            break;
            case ID_listSize: {
                ::boost::shared_ptr< ListSizeError > payload = ::boost::shared_ptr< ListSizeError >
                (new ListSizeError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListSize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListSizeCallbackIF*) _callback)->onListSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqCreateMediaPlayerList: {
                ::boost::shared_ptr< ReqCreateMediaPlayerListError > payload = ::boost::shared_ptr< ReqCreateMediaPlayerListError >
                (new ReqCreateMediaPlayerListError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqCreateMediaPlayerList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqCreateMediaPlayerListCallbackIF*) _callback)->onReqCreateMediaPlayerListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqMediaPlayerListSlice: {
                ::boost::shared_ptr< ReqMediaPlayerListSliceError > payload = ::boost::shared_ptr< ReqMediaPlayerListSliceError >
                (new ReqMediaPlayerListSliceError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqMediaPlayerListSlice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqMediaPlayerListSliceCallbackIF*) _callback)->onReqMediaPlayerListSliceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqDBDownload: {
                ::boost::shared_ptr< ReqDBDownloadError > payload = ::boost::shared_ptr< ReqDBDownloadError >
                (new ReqDBDownloadError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqDBDownload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqDBDownloadCallbackIF*) _callback)->onReqDBDownloadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqCreateMediaPlayerFolderList: {
                ::boost::shared_ptr< ReqCreateMediaPlayerFolderListError > payload = ::boost::shared_ptr< ReqCreateMediaPlayerFolderListError >
                (new ReqCreateMediaPlayerFolderListError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqCreateMediaPlayerFolderList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqCreateMediaPlayerFolderListCallbackIF*) _callback)->onReqCreateMediaPlayerFolderListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReqMediaPlayerFolderListSlice: {
                ::boost::shared_ptr< ReqMediaPlayerFolderListSliceError > payload = ::boost::shared_ptr< ReqMediaPlayerFolderListSliceError >
                (new ReqMediaPlayerFolderListSliceError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReqMediaPlayerFolderListSlice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReqMediaPlayerFolderListSliceCallbackIF*) _callback)->onReqMediaPlayerFolderListSliceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetMediaVideoLanguagesList: {
                ::boost::shared_ptr< SetMediaVideoLanguagesListError > payload = ::boost::shared_ptr< SetMediaVideoLanguagesListError >
                (new SetMediaVideoLanguagesListError(DBUS_ERROR_NO_SERVER, "The DBus service HmiEmpListInterface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetMediaVideoLanguagesList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HmiEmpListInterfaceProxy> proxyShared = ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetMediaVideoLanguagesListCallbackIF*) _callback)->onSetMediaVideoLanguagesListError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HmiEmpListInterfaceProxyCallback::_logger (HmiEmpListInterfaceProxy::_logger);

HmiEmpListInterfaceProxy::HmiEmpListInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.di.HmiEmpListInterface", serviceAvailable, _logger) {
}

HmiEmpListInterfaceProxy::~HmiEmpListInterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HmiEmpListInterfaceProxy > HmiEmpListInterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HmiEmpListInterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HmiEmpListInterfaceProxy > proxyNew(new HmiEmpListInterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HmiEmpListInterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HmiEmpListInterfaceProxyCallback* callback = new HmiEmpListInterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HmiEmpListInterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HmiEmpListInterfaceProxyCallback* callback = new HmiEmpListInterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HmiEmpListInterfaceProxy::clearAllProperties ()
{
    _listSize = ::asf::core::nullable< ListSizeUpdate >();
}

void HmiEmpListInterfaceProxy::sendDeregisterAll () const
{
    sendListSizeDeregisterAll();
    sendSig_DBStateDeregisterAll();
    sendSig_AlbumArtStateDeregisterAll();
    sendSig_PlayableFlagDeregisterAll();
    sendSig_CurrentTrackInfoDeregisterAll();
}

act_t HmiEmpListInterfaceProxy::sendSig_DBStateRegister(Sig_DBStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_DBState");
    act_t act = addSignalCallback(ID_sig_DBState, "sig_DBState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_DBState", &cb, act);
    return act;
}

bool HmiEmpListInterfaceProxy::sendSig_DBStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_DBState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_DBState", act, static_cast<int>(rv));
    return rv;
}

void HmiEmpListInterfaceProxy::sendSig_DBStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_DBState");
    _dbusProxyDelegate->deregisterSignalCallback("sig_DBState", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiEmpListInterfaceProxy::sendSig_AlbumArtStateRegister(Sig_AlbumArtStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_AlbumArtState");
    act_t act = addSignalCallback(ID_sig_AlbumArtState, "sig_AlbumArtState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_AlbumArtState", &cb, act);
    return act;
}

bool HmiEmpListInterfaceProxy::sendSig_AlbumArtStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_AlbumArtState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_AlbumArtState", act, static_cast<int>(rv));
    return rv;
}

void HmiEmpListInterfaceProxy::sendSig_AlbumArtStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_AlbumArtState");
    _dbusProxyDelegate->deregisterSignalCallback("sig_AlbumArtState", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiEmpListInterfaceProxy::sendSig_PlayableFlagRegister(Sig_PlayableFlagCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_PlayableFlag");
    act_t act = addSignalCallback(ID_sig_PlayableFlag, "sig_PlayableFlag", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_PlayableFlag", &cb, act);
    return act;
}

bool HmiEmpListInterfaceProxy::sendSig_PlayableFlagDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_PlayableFlag", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_PlayableFlag", act, static_cast<int>(rv));
    return rv;
}

void HmiEmpListInterfaceProxy::sendSig_PlayableFlagDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_PlayableFlag");
    _dbusProxyDelegate->deregisterSignalCallback("sig_PlayableFlag", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiEmpListInterfaceProxy::sendSig_CurrentTrackInfoRegister(Sig_CurrentTrackInfoCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_CurrentTrackInfo");
    act_t act = addSignalCallback(ID_sig_CurrentTrackInfo, "sig_CurrentTrackInfo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_CurrentTrackInfo", &cb, act);
    return act;
}

bool HmiEmpListInterfaceProxy::sendSig_CurrentTrackInfoDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_CurrentTrackInfo", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_CurrentTrackInfo", act, static_cast<int>(rv));
    return rv;
}

void HmiEmpListInterfaceProxy::sendSig_CurrentTrackInfoDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_CurrentTrackInfo");
    _dbusProxyDelegate->deregisterSignalCallback("sig_CurrentTrackInfo", 0, _dbusDaemonProxy.get(), false);
}

act_t HmiEmpListInterfaceProxy::sendListSizeRegister(ListSizeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_listSize, "listSize", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ListSize", &cb, act);
    return act;
}

bool HmiEmpListInterfaceProxy::sendListSizeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("listSize", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ListSize", act, static_cast<int>(rv));
    return rv;
}

act_t HmiEmpListInterfaceProxy::sendListSizeGet(ListSizeCallbackIF& cb) {
    HmiEmpListInterfaceProxyCallback* callback = new HmiEmpListInterfaceProxyCallback(ID_listSize, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ListSize", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("listSize", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ListSizeStruct& HmiEmpListInterfaceProxy::getListSize() const {
    return _listSize.get().getListSize();
}

bool HmiEmpListInterfaceProxy::hasListSize() const {
    return _listSize.hasValue();
}

void HmiEmpListInterfaceProxy::sendListSizeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ListSize");
    _dbusProxyDelegate->deregisterSignalCallback("listSize", 0, _dbusDaemonProxy.get(), true);
}

act_t HmiEmpListInterfaceProxy::sendReqCreateMediaPlayerListRequest(ReqCreateMediaPlayerListCallbackIF& cb, entListType listType, entSourceType sourceType, uint8 region, uint16 absoluteIndex) const {
    ReqCreateMediaPlayerListRequest* payload = new ReqCreateMediaPlayerListRequest();
    CHECK_ALLOCATION(payload);
    payload->setListType(listType);
    payload->setSourceType(sourceType);
    payload->setRegion(region);
    payload->setAbsoluteIndex(absoluteIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqCreateMediaPlayerList", ReqCreateMediaPlayerListRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqCreateMediaPlayerList, dbusMessage.getUniqueSerial(), "ReqCreateMediaPlayerList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqCreateMediaPlayerList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiEmpListInterfaceProxy::sendReqMediaPlayerListSliceRequest(ReqMediaPlayerListSliceCallbackIF& cb, entListType listType, entSourceType sourceType, uint8 region, uint16 startingIndex, uint8 windowSize) const {
    ReqMediaPlayerListSliceRequest* payload = new ReqMediaPlayerListSliceRequest();
    CHECK_ALLOCATION(payload);
    payload->setListType(listType);
    payload->setSourceType(sourceType);
    payload->setRegion(region);
    payload->setStartingIndex(startingIndex);
    payload->setWindowSize(windowSize);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqMediaPlayerListSlice", ReqMediaPlayerListSliceRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqMediaPlayerListSlice, dbusMessage.getUniqueSerial(), "ReqMediaPlayerListSlice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqMediaPlayerListSlice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiEmpListInterfaceProxy::sendReqDBDownloadRequest(ReqDBDownloadCallbackIF& cb, entSourceType sourceType) const {
    ReqDBDownloadRequest* payload = new ReqDBDownloadRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceType(sourceType);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqDBDownload", ReqDBDownloadRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqDBDownload, dbusMessage.getUniqueSerial(), "ReqDBDownload", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqDBDownload", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiEmpListInterfaceProxy::sendReqCreateMediaPlayerFolderListRequest(ReqCreateMediaPlayerFolderListCallbackIF& cb, entSourceType sourceType, uint8 region, const ::std::string& folderPath) const {
    ReqCreateMediaPlayerFolderListRequest* payload = new ReqCreateMediaPlayerFolderListRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceType(sourceType);
    payload->setRegion(region);
    payload->setFolderPath(folderPath);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqCreateMediaPlayerFolderList", ReqCreateMediaPlayerFolderListRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqCreateMediaPlayerFolderList, dbusMessage.getUniqueSerial(), "ReqCreateMediaPlayerFolderList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqCreateMediaPlayerFolderList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiEmpListInterfaceProxy::sendReqMediaPlayerFolderListSliceRequest(ReqMediaPlayerFolderListSliceCallbackIF& cb, entSourceType sourceType, uint8 region, uint16 startingIndex, uint8 windowSize, const ::std::string& folderPath) const {
    ReqMediaPlayerFolderListSliceRequest* payload = new ReqMediaPlayerFolderListSliceRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceType(sourceType);
    payload->setRegion(region);
    payload->setStartingIndex(startingIndex);
    payload->setWindowSize(windowSize);
    payload->setFolderPath(folderPath);
    DBUS_MESSAGE_CALL(dbusMessage, "ReqMediaPlayerFolderListSlice", ReqMediaPlayerFolderListSliceRequest, payload, true)
    act_t act = addMethodCallback(ID_ReqMediaPlayerFolderListSlice, dbusMessage.getUniqueSerial(), "ReqMediaPlayerFolderListSlice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReqMediaPlayerFolderListSlice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HmiEmpListInterfaceProxy::sendSetMediaVideoLanguagesListRequest(SetMediaVideoLanguagesListCallbackIF& cb, entSourceType sourceType, uint8 region, const ::std::vector< uint16 >& videoLanguageIds) const {
    SetMediaVideoLanguagesListRequest* payload = new SetMediaVideoLanguagesListRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceType(sourceType);
    payload->setRegion(region);
    payload->setVideoLanguageIds(videoLanguageIds);
    DBUS_MESSAGE_CALL(dbusMessage, "SetMediaVideoLanguagesList", SetMediaVideoLanguagesListRequest, payload, true)
    act_t act = addMethodCallback(ID_SetMediaVideoLanguagesList, dbusMessage.getUniqueSerial(), "SetMediaVideoLanguagesList", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetMediaVideoLanguagesList", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
