/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include "bosch/cm/di/HmiEmpListInterfaceJson.h"
#include "bosch/cm/di/HmiEmpListInterfaceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "ListContainerStruct"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasText1()) {
        yajl_gen_string(g, (const unsigned char*)  "Text1" , 5);
        const char *s = value.getText1().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasText2()) {
        yajl_gen_string(g, (const unsigned char*)  "Text2" , 5);
        const char *s = value.getText2().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAbsoluteIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "AbsoluteIndex" , 13);
        yajl_gen_integer(g, (long long)value.getAbsoluteIndex());
    }
    if (!isSparse || value.hasIsSelectedLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "IsSelectedLanguage" , 18);
        yajl_gen_bool(g, (bool)value.getIsSelectedLanguage());
    }
    if (!isSparse || value.hasFileType()) {
        yajl_gen_string(g, (const unsigned char*)  "FileType" , 8);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entFileType_Name(value.getFileType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFileType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListSizeStruct"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCount()) {
        yajl_gen_string(g, (const unsigned char*)  "Count" , 5);
        yajl_gen_integer(g, (long long)value.getCount());
    }
    if (!isSparse || value.hasListType()) {
        yajl_gen_string(g, (const unsigned char*)  "ListType" , 8);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entListType_Name(value.getListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getListType());
    }
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqCreateMediaPlayerListRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListType()) {
        yajl_gen_string(g, (const unsigned char*)  "ListType" , 8);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entListType_Name(value.getListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getListType());
    }
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasAbsoluteIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "AbsoluteIndex" , 13);
        yajl_gen_integer(g, (long long)value.getAbsoluteIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqCreateMediaPlayerListResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponse()) {
        yajl_gen_string(g, (const unsigned char*)  "response" , 8);
        yajl_gen_bool(g, (bool)value.getResponse());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqMediaPlayerListSliceRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListType()) {
        yajl_gen_string(g, (const unsigned char*)  "ListType" , 8);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entListType_Name(value.getListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getListType());
    }
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasStartingIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "StartingIndex" , 13);
        yajl_gen_integer(g, (long long)value.getStartingIndex());
    }
    if (!isSparse || value.hasWindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "WindowSize" , 10);
        yajl_gen_integer(g, (long long)value.getWindowSize());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqMediaPlayerListSliceResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMArrayListContainer()) {
        yajl_gen_string(g, (const unsigned char*)  "mArrayListContainer" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >& o1 = value.getMArrayListContainer();
        {
            ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqDBDownloadRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqDBDownloadResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponse()) {
        yajl_gen_string(g, (const unsigned char*)  "response" , 8);
        yajl_gen_bool(g, (bool)value.getResponse());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqCreateMediaPlayerFolderListRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasFolderPath()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderPath" , 10);
        const char *s = value.getFolderPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqCreateMediaPlayerFolderListResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListCount()) {
        yajl_gen_string(g, (const unsigned char*)  "ListCount" , 9);
        yajl_gen_integer(g, (long long)value.getListCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqMediaPlayerFolderListSliceRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasStartingIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "StartingIndex" , 13);
        yajl_gen_integer(g, (long long)value.getStartingIndex());
    }
    if (!isSparse || value.hasWindowSize()) {
        yajl_gen_string(g, (const unsigned char*)  "WindowSize" , 10);
        yajl_gen_integer(g, (long long)value.getWindowSize());
    }
    if (!isSparse || value.hasFolderPath()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderPath" , 10);
        const char *s = value.getFolderPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReqMediaPlayerFolderListSliceResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMArrayListContainer()) {
        yajl_gen_string(g, (const unsigned char*)  "mArrayListContainer" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >& o3 = value.getMArrayListContainer();
        {
            ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMediaVideoLanguagesListRequest"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasVideoLanguageIds()) {
        yajl_gen_string(g, (const unsigned char*)  "VideoLanguageIds" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o5 = value.getVideoLanguageIds();
        {
            ::std::vector< uint16 >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMediaVideoLanguagesListResponse"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResponse()) {
        yajl_gen_string(g, (const unsigned char*)  "response" , 8);
        yajl_gen_bool(g, (bool)value.getResponse());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListSizeUpdate"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListSize()) {
        yajl_gen_string(g, (const unsigned char*)  "listSize" , 8);
        serializeJson(value.getListSize(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ListSizeRegister"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::ListSizeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Sig_DBStateSignal"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDownloadState()) {
        yajl_gen_string(g, (const unsigned char*)  "DownloadState" , 13);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entDownloadState_Name(value.getDownloadState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDownloadState());
    }
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Sig_AlbumArtStateSignal"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDownloadState()) {
        yajl_gen_string(g, (const unsigned char*)  "DownloadState" , 13);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entDownloadState_Name(value.getDownloadState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDownloadState());
    }
    if (!isSparse || value.hasSongId()) {
        yajl_gen_string(g, (const unsigned char*)  "SongId" , 6);
        yajl_gen_integer(g, (long long)value.getSongId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Sig_PlayableFlagSignal"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsPlayableAudio()) {
        yajl_gen_string(g, (const unsigned char*)  "isPlayableAudio" , 15);
        yajl_gen_bool(g, (bool)value.getIsPlayableAudio());
    }
    if (!isSparse || value.hasIsPlayableVideo()) {
        yajl_gen_string(g, (const unsigned char*)  "isPlayableVideo" , 15);
        yajl_gen_bool(g, (bool)value.getIsPlayableVideo());
    }
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Sig_CurrentTrackInfoSignal"

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoSignal& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceType()) {
        yajl_gen_string(g, (const unsigned char*)  "SourceType" , 10);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entSourceType_Name(value.getSourceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSourceType());
    }
    if (!isSparse || value.hasListType()) {
        yajl_gen_string(g, (const unsigned char*)  "ListType" , 8);
        const char* s = ::bosch::cm::di::HmiEmpListInterface::entListType_Name(value.getListType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getListType());
    }
    if (!isSparse || value.hasRegion()) {
        yajl_gen_string(g, (const unsigned char*)  "Region" , 6);
        yajl_gen_integer(g, (long long)value.getRegion());
    }
    if (!isSparse || value.hasSongId()) {
        yajl_gen_string(g, (const unsigned char*)  "SongId" , 6);
        yajl_gen_integer(g, (long long)value.getSongId());
    }
    if (!isSparse || value.hasFolderPath()) {
        yajl_gen_string(g, (const unsigned char*)  "FolderPath" , 10);
        const char *s = value.getFolderPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoSignal& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ListSizeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::ListSizeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoSignal& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch

