/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include "bosch/cm/di/HmiEmpListInterfaceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of ListContainerStruct

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        const char* o1 = in.getText1().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o1));
        const char* o2 = in.getText2().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_STRING, &o2));
        uint16 o3 = in.getAbsoluteIndex();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT16, &o3));
        dbus_bool_t o4 = in.getIsSelectedLanguage() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BOOLEAN, &o4));
        const ::bosch::cm::di::HmiEmpListInterface::entFileType  o5 = in.getFileType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o5));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct& out) {
    {
        DBusMessageIter o6;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o6);
                {
                    ::std::string Text1Value;
                    ::std::string &Text1TmpValue = Text1Value;
                    {
                        char* o7 = 0;
                        dbus_message_iter_get_basic(&o6, &o7);
                        Text1TmpValue.assign (o7);
                    }
                    out.setText1(Text1Value);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

                {
                    ::std::string Text2Value;
                    ::std::string &Text2TmpValue = Text2Value;
                    {
                        char* o8 = 0;
                        dbus_message_iter_get_basic(&o6, &o8);
                        Text2TmpValue.assign (o8);
                    }
                    out.setText2(Text2Value);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

                {
                    uint16 AbsoluteIndexValue;
                    uint16 &AbsoluteIndexTmpValue = AbsoluteIndexValue;
                    dbus_message_iter_get_basic(&o6, &AbsoluteIndexTmpValue);
                    out.setAbsoluteIndex(AbsoluteIndexValue);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

                {
                    bool IsSelectedLanguageValue;
                    bool &IsSelectedLanguageTmpValue = IsSelectedLanguageValue;
                    {
                        dbus_bool_t o9;
                        dbus_message_iter_get_basic(&o6, &o9);
                        IsSelectedLanguageTmpValue = o9 ? true : false;
                    }
                    out.setIsSelectedLanguage(IsSelectedLanguageValue);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::di::HmiEmpListInterface::entFileType FileTypeValue = ::bosch::cm::di::HmiEmpListInterface::entFileType__entFileType_unknown;
                    dbus_message_iter_get_basic(&o6, &FileTypeValue);
                    out.setFileType(FileTypeValue);
                }

                if (dbus_message_iter_has_next(&o6)) {
                    dbus_message_iter_next(&o6);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ListSizeStruct

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct& in, DBusMessageIter* out) {
    {
        DBusMessageIter o10Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o10Struct));
        uint32 o11 = in.getCount();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_UINT32, &o11));
        const ::bosch::cm::di::HmiEmpListInterface::entListType  o12 = in.getListType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_UINT32, &o12));
        const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o13 = in.getSourceType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_UINT32, &o13));
        uint8 o14 = in.getRegion();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o10Struct, DBUS_TYPE_BYTE, &o14));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o10Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct& out) {
    {
        DBusMessageIter o15;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o15);
                {
                    uint32 CountValue;
                    uint32 &CountTmpValue = CountValue;
                    dbus_message_iter_get_basic(&o15, &CountTmpValue);
                    out.setCount(CountValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::di::HmiEmpListInterface::entListType ListTypeValue = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
                    dbus_message_iter_get_basic(&o15, &ListTypeValue);
                    out.setListType(ListTypeValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
                    dbus_message_iter_get_basic(&o15, &SourceTypeValue);
                    out.setSourceType(SourceTypeValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

                {
                    uint8 RegionValue;
                    uint8 &RegionTmpValue = RegionValue;
                    dbus_message_iter_get_basic(&o15, &RegionTmpValue);
                    out.setRegion(RegionValue);
                }

                if (dbus_message_iter_has_next(&o15)) {
                    dbus_message_iter_next(&o15);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ReqCreateMediaPlayerListRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entListType  o16 = in.getListType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o16));
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o17 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o17));
    uint8 o18 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o18));
    uint16 o19 = in.getAbsoluteIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o19));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entListType ListTypeValue = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
        dbus_message_iter_get_basic(in, &ListTypeValue);
        out.setListType(ListTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 AbsoluteIndexValue;
        uint16 &AbsoluteIndexTmpValue = AbsoluteIndexValue;
        dbus_message_iter_get_basic(in, &AbsoluteIndexTmpValue);
        out.setAbsoluteIndex(AbsoluteIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqCreateMediaPlayerListResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListResponse& in, DBusMessageIter* out) {
    dbus_bool_t o20 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o21;
            dbus_message_iter_get_basic(in, &o21);
            responseTmpValue = o21 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqMediaPlayerListSliceRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entListType  o22 = in.getListType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o22));
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o23 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o23));
    uint8 o24 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o24));
    uint16 o25 = in.getStartingIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o25));
    uint8 o26 = in.getWindowSize();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o26));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entListType ListTypeValue = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
        dbus_message_iter_get_basic(in, &ListTypeValue);
        out.setListType(ListTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 StartingIndexValue;
        uint16 &StartingIndexTmpValue = StartingIndexValue;
        dbus_message_iter_get_basic(in, &StartingIndexTmpValue);
        out.setStartingIndex(StartingIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 WindowSizeValue;
        uint8 &WindowSizeTmpValue = WindowSizeValue;
        dbus_message_iter_get_basic(in, &WindowSizeTmpValue);
        out.setWindowSize(WindowSizeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqMediaPlayerListSliceResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceResponse& in, DBusMessageIter* out) {
    DBusMessageIter o27ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ssqbu)", &o27ArrayIter));
    const ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >* o28 = &in.getMArrayListContainer();
    ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o29 = o28->end();
    for (::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o30 = o28->begin(); o30 != o29; ++o30) {
        serializeDBus((*o30), &o27ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o27ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceResponse& out) {
    {
        ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct > mArrayListContainerValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o31ArrayIter;
            dbus_message_iter_recurse (in, &o31ArrayIter);

            if(dbus_message_iter_get_arg_type(&o31ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct o32;
                    if (!deserializeDBus(&o31ArrayIter, o32)) {
                        return false;
                    }
                    mArrayListContainerValue.push_back(o32);
                } while (dbus_message_iter_next(&o31ArrayIter));
            }
        }
        out.setMArrayListContainer(mArrayListContainerValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqDBDownloadRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o33 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o33));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqDBDownloadResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadResponse& in, DBusMessageIter* out) {
    dbus_bool_t o34 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o34));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqDBDownloadResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o35;
            dbus_message_iter_get_basic(in, &o35);
            responseTmpValue = o35 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqCreateMediaPlayerFolderListRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o36 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o36));
    uint8 o37 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o37));
    const char* o38 = in.getFolderPath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o38));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string FolderPathValue;
        ::std::string &FolderPathTmpValue = FolderPathValue;
        {
            char* o39 = 0;
            dbus_message_iter_get_basic(in, &o39);
            FolderPathTmpValue.assign (o39);
        }
        out.setFolderPath(FolderPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqCreateMediaPlayerFolderListResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListResponse& in, DBusMessageIter* out) {
    uint16 o40 = in.getListCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o40));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListResponse& out) {
    {
        uint16 ListCountValue;
        uint16 &ListCountTmpValue = ListCountValue;
        dbus_message_iter_get_basic(in, &ListCountTmpValue);
        out.setListCount(ListCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqMediaPlayerFolderListSliceRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o41 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o41));
    uint8 o42 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o42));
    uint16 o43 = in.getStartingIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o43));
    uint8 o44 = in.getWindowSize();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o44));
    const char* o45 = in.getFolderPath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o45));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 StartingIndexValue;
        uint16 &StartingIndexTmpValue = StartingIndexValue;
        dbus_message_iter_get_basic(in, &StartingIndexTmpValue);
        out.setStartingIndex(StartingIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 WindowSizeValue;
        uint8 &WindowSizeTmpValue = WindowSizeValue;
        dbus_message_iter_get_basic(in, &WindowSizeTmpValue);
        out.setWindowSize(WindowSizeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string FolderPathValue;
        ::std::string &FolderPathTmpValue = FolderPathValue;
        {
            char* o46 = 0;
            dbus_message_iter_get_basic(in, &o46);
            FolderPathTmpValue.assign (o46);
        }
        out.setFolderPath(FolderPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReqMediaPlayerFolderListSliceResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceResponse& in, DBusMessageIter* out) {
    DBusMessageIter o47ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(ssqbu)", &o47ArrayIter));
    const ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >* o48 = &in.getMArrayListContainer();
    ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o49 = o48->end();
    for (::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct >::const_iterator o50 = o48->begin(); o50 != o49; ++o50) {
        serializeDBus((*o50), &o47ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o47ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceResponse& out) {
    {
        ::std::vector< ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct > mArrayListContainerValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o51ArrayIter;
            dbus_message_iter_recurse (in, &o51ArrayIter);

            if(dbus_message_iter_get_arg_type(&o51ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::di::HmiEmpListInterface::ListContainerStruct o52;
                    if (!deserializeDBus(&o51ArrayIter, o52)) {
                        return false;
                    }
                    mArrayListContainerValue.push_back(o52);
                } while (dbus_message_iter_next(&o51ArrayIter));
            }
        }
        out.setMArrayListContainer(mArrayListContainerValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMediaVideoLanguagesListRequest

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListRequest& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o53 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o53));
    uint8 o54 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o54));
    DBusMessageIter o55ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "q", &o55ArrayIter));
    const ::std::vector< uint16 >* o56 = &in.getVideoLanguageIds();
    ::std::vector< uint16 >::const_iterator o57 = o56->end();
    for (::std::vector< uint16 >::const_iterator o58 = o56->begin(); o58 != o57; ++o58) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o55ArrayIter, DBUS_TYPE_UINT16, &(*o58)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o55ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListRequest& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint16 > VideoLanguageIdsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o59ArrayIter;
            dbus_message_iter_recurse (in, &o59ArrayIter);

            if(dbus_message_iter_get_arg_type(&o59ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint16 o60;
                    dbus_message_iter_get_basic(&o59ArrayIter, &o60);
                    VideoLanguageIdsValue.push_back(o60);
                } while (dbus_message_iter_next(&o59ArrayIter));
            }
        }
        out.setVideoLanguageIds(VideoLanguageIdsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMediaVideoLanguagesListResponse

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListResponse& in, DBusMessageIter* out) {
    dbus_bool_t o61 = in.getResponse() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o61));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListResponse& out) {
    {
        bool responseValue;
        bool &responseTmpValue = responseValue;
        {
            dbus_bool_t o62;
            dbus_message_iter_get_basic(in, &o62);
            responseTmpValue = o62 ? true : false;
        }
        out.setResponse(responseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListSizeUpdate

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ListSizeUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getListSize(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::ListSizeUpdate& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::ListSizeStruct listSizeValue;
        if (!deserializeDBus(in, listSizeValue)) {
            return false;
        }
        out.setListSize(listSizeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ListSizeRegister

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::ListSizeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::di::HmiEmpListInterface::ListSizeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of Sig_DBStateSignal

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entDownloadState  o63 = in.getDownloadState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o63));
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o64 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o64));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::Sig_DBStateSignal& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entDownloadState DownloadStateValue = ::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError;
        dbus_message_iter_get_basic(in, &DownloadStateValue);
        out.setDownloadState(DownloadStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_AlbumArtStateSignal

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entDownloadState  o65 = in.getDownloadState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o65));
    uint16 o66 = in.getSongId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o66));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::Sig_AlbumArtStateSignal& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entDownloadState DownloadStateValue = ::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError;
        dbus_message_iter_get_basic(in, &DownloadStateValue);
        out.setDownloadState(DownloadStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 SongIdValue;
        uint16 &SongIdTmpValue = SongIdValue;
        dbus_message_iter_get_basic(in, &SongIdTmpValue);
        out.setSongId(SongIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_PlayableFlagSignal

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagSignal& in, DBusMessageIter* out) {
    dbus_bool_t o67 = in.getIsPlayableAudio() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o67));
    dbus_bool_t o68 = in.getIsPlayableVideo() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o68));
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o69 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o69));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagSignal& out) {
    {
        bool isPlayableAudioValue;
        bool &isPlayableAudioTmpValue = isPlayableAudioValue;
        {
            dbus_bool_t o70;
            dbus_message_iter_get_basic(in, &o70);
            isPlayableAudioTmpValue = o70 ? true : false;
        }
        out.setIsPlayableAudio(isPlayableAudioValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool isPlayableVideoValue;
        bool &isPlayableVideoTmpValue = isPlayableVideoValue;
        {
            dbus_bool_t o71;
            dbus_message_iter_get_basic(in, &o71);
            isPlayableVideoTmpValue = o71 ? true : false;
        }
        out.setIsPlayableVideo(isPlayableVideoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Sig_CurrentTrackInfoSignal

void serializeDBus (const ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoSignal& in, DBusMessageIter* out) {
    const ::bosch::cm::di::HmiEmpListInterface::entSourceType  o72 = in.getSourceType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o72));
    const ::bosch::cm::di::HmiEmpListInterface::entListType  o73 = in.getListType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o73));
    uint8 o74 = in.getRegion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o74));
    uint16 o75 = in.getSongId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o75));
    const char* o76 = in.getFolderPath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::di::HmiEmpListInterface::Sig_CurrentTrackInfoSignal& out) {
    {
        ::bosch::cm::di::HmiEmpListInterface::entSourceType SourceTypeValue = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
        dbus_message_iter_get_basic(in, &SourceTypeValue);
        out.setSourceType(SourceTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::di::HmiEmpListInterface::entListType ListTypeValue = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
        dbus_message_iter_get_basic(in, &ListTypeValue);
        out.setListType(ListTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 RegionValue;
        uint8 &RegionTmpValue = RegionValue;
        dbus_message_iter_get_basic(in, &RegionTmpValue);
        out.setRegion(RegionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 SongIdValue;
        uint16 &SongIdTmpValue = SongIdValue;
        dbus_message_iter_get_basic(in, &SongIdTmpValue);
        out.setSongId(SongIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string FolderPathValue;
        ::std::string &FolderPathTmpValue = FolderPathValue;
        {
            char* o77 = 0;
            dbus_message_iter_get_basic(in, &o77);
            FolderPathTmpValue.assign (o77);
        }
        out.setFolderPath(FolderPathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

