#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_HMIEMPLISTINTERFACE_H
#define BOSCH_CM_DI_HMIEMPLISTINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "bosch.cm.di.HmiEmpListInterface" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

// method IDs
static const uint16 ID_ReqCreateMediaPlayerList = 0;
static const uint16 ID_ReqMediaPlayerListSlice = 1;
static const uint16 ID_ReqDBDownload = 2;
static const uint16 ID_ReqCreateMediaPlayerFolderList = 3;
static const uint16 ID_ReqMediaPlayerFolderListSlice = 4;
static const uint16 ID_SetMediaVideoLanguagesList = 5;

// signal IDs
static const uint16 ID_sig_DBState = 6;
static const uint16 ID_sig_AlbumArtState = 7;
static const uint16 ID_sig_PlayableFlag = 8;
static const uint16 ID_sig_CurrentTrackInfo = 9;

// property IDs
static const uint16 ID_listSize = 10;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ListContainerStruct;

class ListSizeStruct;

class ReqCreateMediaPlayerListRequest;

class ReqCreateMediaPlayerListResponse;

class ReqMediaPlayerListSliceRequest;

class ReqMediaPlayerListSliceResponse;

class ReqDBDownloadRequest;

class ReqDBDownloadResponse;

class ReqCreateMediaPlayerFolderListRequest;

class ReqCreateMediaPlayerFolderListResponse;

class ReqMediaPlayerFolderListSliceRequest;

class ReqMediaPlayerFolderListSliceResponse;

class SetMediaVideoLanguagesListRequest;

class SetMediaVideoLanguagesListResponse;

class ListSizeUpdate;

class ListSizeRegister;

class Sig_DBStateSignal;

class Sig_AlbumArtStateSignal;

class Sig_PlayableFlagSignal;

class Sig_CurrentTrackInfoSignal;

// type definitions
/**
 * If the meaning of "ReqCreateMediaPlayerListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqCreateMediaPlayerListError;

/**
 * If the meaning of "ReqMediaPlayerListSliceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqMediaPlayerListSliceError;

/**
 * If the meaning of "ReqDBDownloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqDBDownloadError;

/**
 * If the meaning of "ReqCreateMediaPlayerFolderListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqCreateMediaPlayerFolderListError;

/**
 * If the meaning of "ReqMediaPlayerFolderListSliceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReqMediaPlayerFolderListSliceError;

/**
 * If the meaning of "SetMediaVideoLanguagesListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetMediaVideoLanguagesListError;

/**
 * Attribute to get List size
 */
typedef ListSizeUpdate ListSizeSet;

/**
 * Attribute to get List size
 */
typedef ListSizeUpdate ListSizeGet;

/**
 * If the meaning of "ListSizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListSizeError;

/**
 * If the meaning of "Sig_DBStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_DBStateError;

/**
 * If the meaning of "Sig_AlbumArtStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_AlbumArtStateError;

/**
 * If the meaning of "Sig_PlayableFlagError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_PlayableFlagError;

/**
 * If the meaning of "Sig_CurrentTrackInfoError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_CurrentTrackInfoError;


/**
 * If the meaning of "ListContainerStruct" isn't clear, then there should be a description here.
 */
class ListContainerStruct {
public:

    /**
     * Default constructor
     */
    inline  ListContainerStruct ();

    /**
     * Copy constructor
     */
    inline  ListContainerStruct (const ListContainerStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ListContainerStruct (const ::std::string& Text1_, const ::std::string& Text2_, uint16 AbsoluteIndex_, bool IsSelectedLanguage_, entFileType FileType_);

    /**
     * Destructor
     */
    inline  ~ListContainerStruct();

    /**
     * Assignment operator
     */
    inline ListContainerStruct& operator = (const ListContainerStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListContainerStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListContainerStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListContainerStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListContainerStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Text1"

    static const int kText1 = 0;

    /**
     * Clears the field "Text1".
     *
     * The field will be set to its default value. The hasText1()
     * method will return false.
     */
    inline void clearText1();

    /**
     * Checks whether the field "Text1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText1()). Otherwise it will return false.
     */
    inline bool hasText1 () const;

    /**
     * Returns the value of the member "Text1".
     *
     * If the meaning of "Text1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Text1"
     */
    inline const ::std::string& getText1 () const;

    /**
     * Retrieves the value of the field "Text1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text1".
     */
    inline ::std::string& getText1Mutable ();

    /**
     * Sets the value of the member "Text1".
     *
     * If the meaning of "Text1" isn't clear, then there should be a description here.
     *
     * @param Text1 The value which will be set
     */
    inline void setText1 (const ::std::string& Text1_);

    /**
     * Sets the value of the member "Text1".
     *
     * If the meaning of "Text1" isn't clear, then there should be a description here.
     *
     * @param Text1 The value which will be set
     */
    inline void setText1 (const char* Text1_);

    /**
     * Sets the value of the member "Text1".
     *
     * If the meaning of "Text1" isn't clear, then there should be a description here.
     *
     * @param Text1 The value which will be set
     */
    inline void setText1 (const char* value, size_t size);

    // API of field "Text2"

    static const int kText2 = 1;

    /**
     * Clears the field "Text2".
     *
     * The field will be set to its default value. The hasText2()
     * method will return false.
     */
    inline void clearText2();

    /**
     * Checks whether the field "Text2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setText2()). Otherwise it will return false.
     */
    inline bool hasText2 () const;

    /**
     * Returns the value of the member "Text2".
     *
     * If the meaning of "Text2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Text2"
     */
    inline const ::std::string& getText2 () const;

    /**
     * Retrieves the value of the field "Text2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Text2".
     */
    inline ::std::string& getText2Mutable ();

    /**
     * Sets the value of the member "Text2".
     *
     * If the meaning of "Text2" isn't clear, then there should be a description here.
     *
     * @param Text2 The value which will be set
     */
    inline void setText2 (const ::std::string& Text2_);

    /**
     * Sets the value of the member "Text2".
     *
     * If the meaning of "Text2" isn't clear, then there should be a description here.
     *
     * @param Text2 The value which will be set
     */
    inline void setText2 (const char* Text2_);

    /**
     * Sets the value of the member "Text2".
     *
     * If the meaning of "Text2" isn't clear, then there should be a description here.
     *
     * @param Text2 The value which will be set
     */
    inline void setText2 (const char* value, size_t size);

    // API of field "AbsoluteIndex"

    static const int kAbsoluteIndex = 2;

    /**
     * Clears the field "AbsoluteIndex".
     *
     * The field will be set to its default value. The hasAbsoluteIndex()
     * method will return false.
     */
    inline void clearAbsoluteIndex();

    /**
     * Checks whether the field "AbsoluteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbsoluteIndex()). Otherwise it will return false.
     */
    inline bool hasAbsoluteIndex () const;

    /**
     * Returns the value of the member "AbsoluteIndex".
     *
     * If the meaning of "AbsoluteIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AbsoluteIndex"
     */
    inline uint16 getAbsoluteIndex () const;

    /**
     * Sets the value of the member "AbsoluteIndex".
     *
     * If the meaning of "AbsoluteIndex" isn't clear, then there should be a description here.
     *
     * @param AbsoluteIndex The value which will be set
     */
    inline void setAbsoluteIndex (uint16 AbsoluteIndex_);

    // API of field "IsSelectedLanguage"

    static const int kIsSelectedLanguage = 3;

    /**
     * Clears the field "IsSelectedLanguage".
     *
     * The field will be set to its default value. The hasIsSelectedLanguage()
     * method will return false.
     */
    inline void clearIsSelectedLanguage();

    /**
     * Checks whether the field "IsSelectedLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSelectedLanguage()). Otherwise it will return false.
     */
    inline bool hasIsSelectedLanguage () const;

    /**
     * Returns the value of the member "IsSelectedLanguage".
     *
     * If the meaning of "IsSelectedLanguage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "IsSelectedLanguage"
     */
    inline bool getIsSelectedLanguage () const;

    /**
     * Sets the value of the member "IsSelectedLanguage".
     *
     * If the meaning of "IsSelectedLanguage" isn't clear, then there should be a description here.
     *
     * @param IsSelectedLanguage The value which will be set
     */
    inline void setIsSelectedLanguage (bool IsSelectedLanguage_);

    // API of field "FileType"

    static const int kFileType = 4;

    /**
     * Clears the field "FileType".
     *
     * The field will be set to its default value. The hasFileType()
     * method will return false.
     */
    inline void clearFileType();

    /**
     * Checks whether the field "FileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFileType()). Otherwise it will return false.
     */
    inline bool hasFileType () const;

    /**
     * Returns the value of the member "FileType".
     *
     * If the meaning of "FileType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FileType"
     */
    inline entFileType getFileType () const;

    /**
     * Sets the value of the member "FileType".
     *
     * If the meaning of "FileType" isn't clear, then there should be a description here.
     *
     * @param FileType The value which will be set
     */
    inline void setFileType (entFileType FileType_);

    static const ListContainerStruct &getDefaultInstance();

private:

    inline void set_has_Text1 ();

    inline void clear_has_Text1 ();

    inline void set_has_Text2 ();

    inline void clear_has_Text2 ();

    inline void set_has_AbsoluteIndex ();

    inline void clear_has_AbsoluteIndex ();

    inline void set_has_IsSelectedLanguage ();

    inline void clear_has_IsSelectedLanguage ();

    inline void set_has_FileType ();

    inline void clear_has_FileType ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _Text1;

    ::std::string _Text2;

    uint16 _AbsoluteIndex;

    bool _IsSelectedLanguage;

    entFileType _FileType;

};

/**
 * If the meaning of "ListSizeStruct" isn't clear, then there should be a description here.
 */
class ListSizeStruct {
public:

    /**
     * Default constructor
     */
    inline  ListSizeStruct ();

    /**
     * Copy constructor
     */
    inline  ListSizeStruct (const ListSizeStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ListSizeStruct (uint32 Count_, entListType ListType_, entSourceType SourceType_, uint8 Region_);

    /**
     * Destructor
     */
    inline  ~ListSizeStruct();

    /**
     * Assignment operator
     */
    inline ListSizeStruct& operator = (const ListSizeStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListSizeStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListSizeStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListSizeStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListSizeStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Count"

    static const int kCount = 0;

    /**
     * Clears the field "Count".
     *
     * The field will be set to its default value. The hasCount()
     * method will return false.
     */
    inline void clearCount();

    /**
     * Checks whether the field "Count" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCount()). Otherwise it will return false.
     */
    inline bool hasCount () const;

    /**
     * Returns the value of the member "Count".
     *
     * If the meaning of "Count" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Count"
     */
    inline uint32 getCount () const;

    /**
     * Sets the value of the member "Count".
     *
     * If the meaning of "Count" isn't clear, then there should be a description here.
     *
     * @param Count The value which will be set
     */
    inline void setCount (uint32 Count_);

    // API of field "ListType"

    static const int kListType = 1;

    /**
     * Clears the field "ListType".
     *
     * The field will be set to its default value. The hasListType()
     * method will return false.
     */
    inline void clearListType();

    /**
     * Checks whether the field "ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListType()). Otherwise it will return false.
     */
    inline bool hasListType () const;

    /**
     * Returns the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListType"
     */
    inline entListType getListType () const;

    /**
     * Sets the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param ListType The value which will be set
     */
    inline void setListType (entListType ListType_);

    // API of field "SourceType"

    static const int kSourceType = 2;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 3;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    static const ListSizeStruct &getDefaultInstance();

private:

    inline void set_has_Count ();

    inline void clear_has_Count ();

    inline void set_has_ListType ();

    inline void clear_has_ListType ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _Count;

    entListType _ListType;

    entSourceType _SourceType;

    uint8 _Region;

};

/**
 * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
 */
class ReqCreateMediaPlayerListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCreateMediaPlayerListRequest ();

    /**
     * Copy constructor
     */
    inline  ReqCreateMediaPlayerListRequest (const ReqCreateMediaPlayerListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCreateMediaPlayerListRequest (entListType ListType_, entSourceType SourceType_, uint8 Region_, uint16 AbsoluteIndex_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCreateMediaPlayerListRequest();

    /**
     * Assignment operator
     */
    inline ReqCreateMediaPlayerListRequest& operator = (const ReqCreateMediaPlayerListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCreateMediaPlayerListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCreateMediaPlayerListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCreateMediaPlayerListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCreateMediaPlayerListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListType"

    static const int kListType = 0;

    /**
     * Clears the field "ListType".
     *
     * The field will be set to its default value. The hasListType()
     * method will return false.
     */
    inline void clearListType();

    /**
     * Checks whether the field "ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListType()). Otherwise it will return false.
     */
    inline bool hasListType () const;

    /**
     * Returns the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListType"
     */
    inline entListType getListType () const;

    /**
     * Sets the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param ListType The value which will be set
     */
    inline void setListType (entListType ListType_);

    // API of field "SourceType"

    static const int kSourceType = 1;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 2;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "AbsoluteIndex"

    static const int kAbsoluteIndex = 3;

    /**
     * Clears the field "AbsoluteIndex".
     *
     * The field will be set to its default value. The hasAbsoluteIndex()
     * method will return false.
     */
    inline void clearAbsoluteIndex();

    /**
     * Checks whether the field "AbsoluteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAbsoluteIndex()). Otherwise it will return false.
     */
    inline bool hasAbsoluteIndex () const;

    /**
     * Returns the value of the member "AbsoluteIndex".
     *
     * If the meaning of "AbsoluteIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AbsoluteIndex"
     */
    inline uint16 getAbsoluteIndex () const;

    /**
     * Sets the value of the member "AbsoluteIndex".
     *
     * If the meaning of "AbsoluteIndex" isn't clear, then there should be a description here.
     *
     * @param AbsoluteIndex The value which will be set
     */
    inline void setAbsoluteIndex (uint16 AbsoluteIndex_);

    static const ReqCreateMediaPlayerListRequest &getDefaultInstance();

private:

    inline void set_has_ListType ();

    inline void clear_has_ListType ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_AbsoluteIndex ();

    inline void clear_has_AbsoluteIndex ();

    uint32 _has_bits_[ (4 + 31) / 32];

    entListType _ListType;

    entSourceType _SourceType;

    uint8 _Region;

    uint16 _AbsoluteIndex;

};

/**
 * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
 */
class ReqCreateMediaPlayerListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCreateMediaPlayerListResponse ();

    /**
     * Copy constructor
     */
    inline  ReqCreateMediaPlayerListResponse (const ReqCreateMediaPlayerListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCreateMediaPlayerListResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCreateMediaPlayerListResponse();

    /**
     * Assignment operator
     */
    inline ReqCreateMediaPlayerListResponse& operator = (const ReqCreateMediaPlayerListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCreateMediaPlayerListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCreateMediaPlayerListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCreateMediaPlayerListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCreateMediaPlayerListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqCreateMediaPlayerListResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
 */
class ReqMediaPlayerListSliceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqMediaPlayerListSliceRequest ();

    /**
     * Copy constructor
     */
    inline  ReqMediaPlayerListSliceRequest (const ReqMediaPlayerListSliceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqMediaPlayerListSliceRequest (entListType ListType_, entSourceType SourceType_, uint8 Region_, uint16 StartingIndex_, uint8 WindowSize_);

    /**
     * Destructor
     */
    inline virtual  ~ReqMediaPlayerListSliceRequest();

    /**
     * Assignment operator
     */
    inline ReqMediaPlayerListSliceRequest& operator = (const ReqMediaPlayerListSliceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqMediaPlayerListSliceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqMediaPlayerListSliceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqMediaPlayerListSliceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqMediaPlayerListSliceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListType"

    static const int kListType = 0;

    /**
     * Clears the field "ListType".
     *
     * The field will be set to its default value. The hasListType()
     * method will return false.
     */
    inline void clearListType();

    /**
     * Checks whether the field "ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListType()). Otherwise it will return false.
     */
    inline bool hasListType () const;

    /**
     * Returns the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListType"
     */
    inline entListType getListType () const;

    /**
     * Sets the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param ListType The value which will be set
     */
    inline void setListType (entListType ListType_);

    // API of field "SourceType"

    static const int kSourceType = 1;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 2;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "StartingIndex"

    static const int kStartingIndex = 3;

    /**
     * Clears the field "StartingIndex".
     *
     * The field will be set to its default value. The hasStartingIndex()
     * method will return false.
     */
    inline void clearStartingIndex();

    /**
     * Checks whether the field "StartingIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartingIndex()). Otherwise it will return false.
     */
    inline bool hasStartingIndex () const;

    /**
     * Returns the value of the member "StartingIndex".
     *
     * If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StartingIndex"
     */
    inline uint16 getStartingIndex () const;

    /**
     * Sets the value of the member "StartingIndex".
     *
     * If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @param StartingIndex The value which will be set
     */
    inline void setStartingIndex (uint16 StartingIndex_);

    // API of field "WindowSize"

    static const int kWindowSize = 4;

    /**
     * Clears the field "WindowSize".
     *
     * The field will be set to its default value. The hasWindowSize()
     * method will return false.
     */
    inline void clearWindowSize();

    /**
     * Checks whether the field "WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindowSize()). Otherwise it will return false.
     */
    inline bool hasWindowSize () const;

    /**
     * Returns the value of the member "WindowSize".
     *
     * If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WindowSize"
     */
    inline uint8 getWindowSize () const;

    /**
     * Sets the value of the member "WindowSize".
     *
     * If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @param WindowSize The value which will be set
     */
    inline void setWindowSize (uint8 WindowSize_);

    static const ReqMediaPlayerListSliceRequest &getDefaultInstance();

private:

    inline void set_has_ListType ();

    inline void clear_has_ListType ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_StartingIndex ();

    inline void clear_has_StartingIndex ();

    inline void set_has_WindowSize ();

    inline void clear_has_WindowSize ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entListType _ListType;

    entSourceType _SourceType;

    uint8 _Region;

    uint16 _StartingIndex;

    uint8 _WindowSize;

};

/**
 * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
 */
class ReqMediaPlayerListSliceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqMediaPlayerListSliceResponse ();

    /**
     * Copy constructor
     */
    inline  ReqMediaPlayerListSliceResponse (const ReqMediaPlayerListSliceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqMediaPlayerListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer_);

    /**
     * Destructor
     */
    inline virtual  ~ReqMediaPlayerListSliceResponse();

    /**
     * Assignment operator
     */
    inline ReqMediaPlayerListSliceResponse& operator = (const ReqMediaPlayerListSliceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqMediaPlayerListSliceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqMediaPlayerListSliceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqMediaPlayerListSliceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqMediaPlayerListSliceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mArrayListContainer"

    static const int kMArrayListContainer = 0;

    /**
     * Clears the field "mArrayListContainer".
     *
     * The field will be set to its default value. The hasMArrayListContainer()
     * method will return false.
     */
    inline void clearMArrayListContainer();

    /**
     * Checks whether the field "mArrayListContainer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMArrayListContainer()). Otherwise it will return false.
     */
    inline bool hasMArrayListContainer () const;

    /**
     * Returns the value of the member "mArrayListContainer".
     *
     * If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mArrayListContainer"
     */
    inline const ::std::vector< ListContainerStruct >& getMArrayListContainer () const;

    /**
     * Retrieves the value of the field "mArrayListContainer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mArrayListContainer".
     */
    inline ::std::vector< ListContainerStruct >& getMArrayListContainerMutable ();

    /**
     * Sets the value of the member "mArrayListContainer".
     *
     * If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @param mArrayListContainer The value which will be set
     */
    inline void setMArrayListContainer (const ::std::vector< ListContainerStruct >& mArrayListContainer_);

    static const ReqMediaPlayerListSliceResponse &getDefaultInstance();

private:

    static const ::std::vector< ListContainerStruct >& getListContainerStructList_DefaultInstance ();

    inline void set_has_mArrayListContainer ();

    inline void clear_has_mArrayListContainer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ListContainerStruct > _mArrayListContainer;

};

/**
 * ReqDBDownload = Method to Request DB Download
 */
class ReqDBDownloadRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqDBDownloadRequest ();

    /**
     * Copy constructor
     */
    inline  ReqDBDownloadRequest (const ReqDBDownloadRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqDBDownloadRequest (entSourceType SourceType_);

    /**
     * Destructor
     */
    inline virtual  ~ReqDBDownloadRequest();

    /**
     * Assignment operator
     */
    inline ReqDBDownloadRequest& operator = (const ReqDBDownloadRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqDBDownloadRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqDBDownloadRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqDBDownloadRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqDBDownloadRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceType"

    static const int kSourceType = 0;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    static const ReqDBDownloadRequest &getDefaultInstance();

private:

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    entSourceType _SourceType;

};

/**
 * ReqDBDownload = Method to Request DB Download
 */
class ReqDBDownloadResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqDBDownloadResponse ();

    /**
     * Copy constructor
     */
    inline  ReqDBDownloadResponse (const ReqDBDownloadResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqDBDownloadResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ReqDBDownloadResponse();

    /**
     * Assignment operator
     */
    inline ReqDBDownloadResponse& operator = (const ReqDBDownloadResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqDBDownloadResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqDBDownloadResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqDBDownloadResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqDBDownloadResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ReqDBDownloadResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
 */
class ReqCreateMediaPlayerFolderListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCreateMediaPlayerFolderListRequest ();

    /**
     * Copy constructor
     */
    inline  ReqCreateMediaPlayerFolderListRequest (const ReqCreateMediaPlayerFolderListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCreateMediaPlayerFolderListRequest (entSourceType SourceType_, uint8 Region_, const ::std::string& FolderPath_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCreateMediaPlayerFolderListRequest();

    /**
     * Assignment operator
     */
    inline ReqCreateMediaPlayerFolderListRequest& operator = (const ReqCreateMediaPlayerFolderListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCreateMediaPlayerFolderListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCreateMediaPlayerFolderListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCreateMediaPlayerFolderListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCreateMediaPlayerFolderListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceType"

    static const int kSourceType = 0;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 1;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "FolderPath"

    static const int kFolderPath = 2;

    /**
     * Clears the field "FolderPath".
     *
     * The field will be set to its default value. The hasFolderPath()
     * method will return false.
     */
    inline void clearFolderPath();

    /**
     * Checks whether the field "FolderPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderPath()). Otherwise it will return false.
     */
    inline bool hasFolderPath () const;

    /**
     * Returns the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FolderPath"
     */
    inline const ::std::string& getFolderPath () const;

    /**
     * Retrieves the value of the field "FolderPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FolderPath".
     */
    inline ::std::string& getFolderPathMutable ();

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const ::std::string& FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* value, size_t size);

    static const ReqCreateMediaPlayerFolderListRequest &getDefaultInstance();

private:

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_FolderPath ();

    inline void clear_has_FolderPath ();

    uint32 _has_bits_[ (3 + 31) / 32];

    entSourceType _SourceType;

    uint8 _Region;

    ::std::string _FolderPath;

};

/**
 * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
 */
class ReqCreateMediaPlayerFolderListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqCreateMediaPlayerFolderListResponse ();

    /**
     * Copy constructor
     */
    inline  ReqCreateMediaPlayerFolderListResponse (const ReqCreateMediaPlayerFolderListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqCreateMediaPlayerFolderListResponse (uint16 ListCount_);

    /**
     * Destructor
     */
    inline virtual  ~ReqCreateMediaPlayerFolderListResponse();

    /**
     * Assignment operator
     */
    inline ReqCreateMediaPlayerFolderListResponse& operator = (const ReqCreateMediaPlayerFolderListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqCreateMediaPlayerFolderListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqCreateMediaPlayerFolderListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqCreateMediaPlayerFolderListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqCreateMediaPlayerFolderListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListCount"

    static const int kListCount = 0;

    /**
     * Clears the field "ListCount".
     *
     * The field will be set to its default value. The hasListCount()
     * method will return false.
     */
    inline void clearListCount();

    /**
     * Checks whether the field "ListCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListCount()). Otherwise it will return false.
     */
    inline bool hasListCount () const;

    /**
     * Returns the value of the member "ListCount".
     *
     * If the meaning of "ListCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListCount"
     */
    inline uint16 getListCount () const;

    /**
     * Sets the value of the member "ListCount".
     *
     * If the meaning of "ListCount" isn't clear, then there should be a description here.
     *
     * @param ListCount The value which will be set
     */
    inline void setListCount (uint16 ListCount_);

    static const ReqCreateMediaPlayerFolderListResponse &getDefaultInstance();

private:

    inline void set_has_ListCount ();

    inline void clear_has_ListCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _ListCount;

};

/**
 * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
 */
class ReqMediaPlayerFolderListSliceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqMediaPlayerFolderListSliceRequest ();

    /**
     * Copy constructor
     */
    inline  ReqMediaPlayerFolderListSliceRequest (const ReqMediaPlayerFolderListSliceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ReqMediaPlayerFolderListSliceRequest (entSourceType SourceType_, uint8 Region_, uint16 StartingIndex_, uint8 WindowSize_, const ::std::string& FolderPath_);

    /**
     * Destructor
     */
    inline virtual  ~ReqMediaPlayerFolderListSliceRequest();

    /**
     * Assignment operator
     */
    inline ReqMediaPlayerFolderListSliceRequest& operator = (const ReqMediaPlayerFolderListSliceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqMediaPlayerFolderListSliceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqMediaPlayerFolderListSliceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqMediaPlayerFolderListSliceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqMediaPlayerFolderListSliceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceType"

    static const int kSourceType = 0;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 1;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "StartingIndex"

    static const int kStartingIndex = 2;

    /**
     * Clears the field "StartingIndex".
     *
     * The field will be set to its default value. The hasStartingIndex()
     * method will return false.
     */
    inline void clearStartingIndex();

    /**
     * Checks whether the field "StartingIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartingIndex()). Otherwise it will return false.
     */
    inline bool hasStartingIndex () const;

    /**
     * Returns the value of the member "StartingIndex".
     *
     * If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StartingIndex"
     */
    inline uint16 getStartingIndex () const;

    /**
     * Sets the value of the member "StartingIndex".
     *
     * If the meaning of "StartingIndex" isn't clear, then there should be a description here.
     *
     * @param StartingIndex The value which will be set
     */
    inline void setStartingIndex (uint16 StartingIndex_);

    // API of field "WindowSize"

    static const int kWindowSize = 3;

    /**
     * Clears the field "WindowSize".
     *
     * The field will be set to its default value. The hasWindowSize()
     * method will return false.
     */
    inline void clearWindowSize();

    /**
     * Checks whether the field "WindowSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWindowSize()). Otherwise it will return false.
     */
    inline bool hasWindowSize () const;

    /**
     * Returns the value of the member "WindowSize".
     *
     * If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WindowSize"
     */
    inline uint8 getWindowSize () const;

    /**
     * Sets the value of the member "WindowSize".
     *
     * If the meaning of "WindowSize" isn't clear, then there should be a description here.
     *
     * @param WindowSize The value which will be set
     */
    inline void setWindowSize (uint8 WindowSize_);

    // API of field "FolderPath"

    static const int kFolderPath = 4;

    /**
     * Clears the field "FolderPath".
     *
     * The field will be set to its default value. The hasFolderPath()
     * method will return false.
     */
    inline void clearFolderPath();

    /**
     * Checks whether the field "FolderPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderPath()). Otherwise it will return false.
     */
    inline bool hasFolderPath () const;

    /**
     * Returns the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FolderPath"
     */
    inline const ::std::string& getFolderPath () const;

    /**
     * Retrieves the value of the field "FolderPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FolderPath".
     */
    inline ::std::string& getFolderPathMutable ();

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const ::std::string& FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* value, size_t size);

    static const ReqMediaPlayerFolderListSliceRequest &getDefaultInstance();

private:

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_StartingIndex ();

    inline void clear_has_StartingIndex ();

    inline void set_has_WindowSize ();

    inline void clear_has_WindowSize ();

    inline void set_has_FolderPath ();

    inline void clear_has_FolderPath ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entSourceType _SourceType;

    uint8 _Region;

    uint16 _StartingIndex;

    uint8 _WindowSize;

    ::std::string _FolderPath;

};

/**
 * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
 */
class ReqMediaPlayerFolderListSliceResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReqMediaPlayerFolderListSliceResponse ();

    /**
     * Copy constructor
     */
    inline  ReqMediaPlayerFolderListSliceResponse (const ReqMediaPlayerFolderListSliceResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ReqMediaPlayerFolderListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer_);

    /**
     * Destructor
     */
    inline virtual  ~ReqMediaPlayerFolderListSliceResponse();

    /**
     * Assignment operator
     */
    inline ReqMediaPlayerFolderListSliceResponse& operator = (const ReqMediaPlayerFolderListSliceResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReqMediaPlayerFolderListSliceResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReqMediaPlayerFolderListSliceResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReqMediaPlayerFolderListSliceResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReqMediaPlayerFolderListSliceResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "mArrayListContainer"

    static const int kMArrayListContainer = 0;

    /**
     * Clears the field "mArrayListContainer".
     *
     * The field will be set to its default value. The hasMArrayListContainer()
     * method will return false.
     */
    inline void clearMArrayListContainer();

    /**
     * Checks whether the field "mArrayListContainer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMArrayListContainer()). Otherwise it will return false.
     */
    inline bool hasMArrayListContainer () const;

    /**
     * Returns the value of the member "mArrayListContainer".
     *
     * If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mArrayListContainer"
     */
    inline const ::std::vector< ListContainerStruct >& getMArrayListContainer () const;

    /**
     * Retrieves the value of the field "mArrayListContainer" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "mArrayListContainer".
     */
    inline ::std::vector< ListContainerStruct >& getMArrayListContainerMutable ();

    /**
     * Sets the value of the member "mArrayListContainer".
     *
     * If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @param mArrayListContainer The value which will be set
     */
    inline void setMArrayListContainer (const ::std::vector< ListContainerStruct >& mArrayListContainer_);

    static const ReqMediaPlayerFolderListSliceResponse &getDefaultInstance();

private:

    static const ::std::vector< ListContainerStruct >& getListContainerStructList_DefaultInstance ();

    inline void set_has_mArrayListContainer ();

    inline void clear_has_mArrayListContainer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ListContainerStruct > _mArrayListContainer;

};

/**
 * SetMediaVideoLanguagesList = Method to update list of selected languages
 */
class SetMediaVideoLanguagesListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMediaVideoLanguagesListRequest ();

    /**
     * Copy constructor
     */
    inline  SetMediaVideoLanguagesListRequest (const SetMediaVideoLanguagesListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetMediaVideoLanguagesListRequest (entSourceType SourceType_, uint8 Region_, const ::std::vector< uint16 >& VideoLanguageIds_);

    /**
     * Destructor
     */
    inline virtual  ~SetMediaVideoLanguagesListRequest();

    /**
     * Assignment operator
     */
    inline SetMediaVideoLanguagesListRequest& operator = (const SetMediaVideoLanguagesListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMediaVideoLanguagesListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMediaVideoLanguagesListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMediaVideoLanguagesListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMediaVideoLanguagesListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceType"

    static const int kSourceType = 0;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "Region"

    static const int kRegion = 1;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "VideoLanguageIds"

    static const int kVideoLanguageIds = 2;

    /**
     * Clears the field "VideoLanguageIds".
     *
     * The field will be set to its default value. The hasVideoLanguageIds()
     * method will return false.
     */
    inline void clearVideoLanguageIds();

    /**
     * Checks whether the field "VideoLanguageIds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoLanguageIds()). Otherwise it will return false.
     */
    inline bool hasVideoLanguageIds () const;

    /**
     * Returns the value of the member "VideoLanguageIds".
     *
     * If the meaning of "VideoLanguageIds" isn't clear, then there should be a description here.
     *
     * @return The value of the field "VideoLanguageIds"
     */
    inline const ::std::vector< uint16 >& getVideoLanguageIds () const;

    /**
     * Retrieves the value of the field "VideoLanguageIds" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VideoLanguageIds".
     */
    inline ::std::vector< uint16 >& getVideoLanguageIdsMutable ();

    /**
     * Sets the value of the member "VideoLanguageIds".
     *
     * If the meaning of "VideoLanguageIds" isn't clear, then there should be a description here.
     *
     * @param VideoLanguageIds The value which will be set
     */
    inline void setVideoLanguageIds (const ::std::vector< uint16 >& VideoLanguageIds_);

    static const SetMediaVideoLanguagesListRequest &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_VideoLanguageIds ();

    inline void clear_has_VideoLanguageIds ();

    uint32 _has_bits_[ (3 + 31) / 32];

    entSourceType _SourceType;

    uint8 _Region;

    ::std::vector< uint16 > _VideoLanguageIds;

};

/**
 * SetMediaVideoLanguagesList = Method to update list of selected languages
 */
class SetMediaVideoLanguagesListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMediaVideoLanguagesListResponse ();

    /**
     * Copy constructor
     */
    inline  SetMediaVideoLanguagesListResponse (const SetMediaVideoLanguagesListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetMediaVideoLanguagesListResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~SetMediaVideoLanguagesListResponse();

    /**
     * Assignment operator
     */
    inline SetMediaVideoLanguagesListResponse& operator = (const SetMediaVideoLanguagesListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMediaVideoLanguagesListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMediaVideoLanguagesListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMediaVideoLanguagesListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMediaVideoLanguagesListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const SetMediaVideoLanguagesListResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * Attribute to get List size
 */
class ListSizeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListSizeUpdate ();

    /**
     * Copy constructor
     */
    inline  ListSizeUpdate (const ListSizeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ListSizeUpdate (const ListSizeStruct& listSize_);

    /**
     * Destructor
     */
    inline virtual  ~ListSizeUpdate();

    /**
     * Assignment operator
     */
    inline ListSizeUpdate& operator = (const ListSizeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListSizeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListSizeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListSizeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListSizeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "listSize"

    static const int kListSize = 0;

    /**
     * Clears the field "listSize".
     *
     * The field will be set to its default value. The hasListSize()
     * method will return false.
     */
    inline void clearListSize();

    /**
     * Checks whether the field "listSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSize()). Otherwise it will return false.
     */
    inline bool hasListSize () const;

    /**
     * Returns the value of the member "listSize".
     *
     * Attribute to get List size
     *
     * @return The value of the field "listSize"
     */
    inline const ListSizeStruct& getListSize () const;

    /**
     * Retrieves the value of the field "listSize" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSize".
     */
    inline ListSizeStruct& getListSizeMutable ();

    /**
     * Sets the value of the member "listSize".
     *
     * Attribute to get List size
     *
     * @param listSize The value which will be set
     */
    inline void setListSize (const ListSizeStruct& listSize_);

    static const ListSizeUpdate &getDefaultInstance();

private:

    inline void set_has_listSize ();

    inline void clear_has_listSize ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ListSizeStruct _listSize;

};

/**
 * Attribute to get List size
 */
class ListSizeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListSizeRegister ();

    /**
     * Copy constructor
     */
    inline  ListSizeRegister (const ListSizeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ListSizeRegister();

    /**
     * Assignment operator
     */
    inline ListSizeRegister& operator = (const ListSizeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListSizeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListSizeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListSizeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListSizeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ListSizeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * sig_DBState =  DB download state
 */
class Sig_DBStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_DBStateSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_DBStateSignal (const Sig_DBStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_DBStateSignal (entDownloadState DownloadState_, entSourceType SourceType_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_DBStateSignal();

    /**
     * Assignment operator
     */
    inline Sig_DBStateSignal& operator = (const Sig_DBStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_DBStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_DBStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_DBStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_DBStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DownloadState"

    static const int kDownloadState = 0;

    /**
     * Clears the field "DownloadState".
     *
     * The field will be set to its default value. The hasDownloadState()
     * method will return false.
     */
    inline void clearDownloadState();

    /**
     * Checks whether the field "DownloadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadState()). Otherwise it will return false.
     */
    inline bool hasDownloadState () const;

    /**
     * Returns the value of the member "DownloadState".
     *
     * If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DownloadState"
     */
    inline entDownloadState getDownloadState () const;

    /**
     * Sets the value of the member "DownloadState".
     *
     * If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @param DownloadState The value which will be set
     */
    inline void setDownloadState (entDownloadState DownloadState_);

    // API of field "SourceType"

    static const int kSourceType = 1;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    static const Sig_DBStateSignal &getDefaultInstance();

private:

    inline void set_has_DownloadState ();

    inline void clear_has_DownloadState ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    entDownloadState _DownloadState;

    entSourceType _SourceType;

};

/**
 * sig_AlbumArtState =  AlbumArt download state
 */
class Sig_AlbumArtStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_AlbumArtStateSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_AlbumArtStateSignal (const Sig_AlbumArtStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_AlbumArtStateSignal (entDownloadState DownloadState_, uint16 SongId_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_AlbumArtStateSignal();

    /**
     * Assignment operator
     */
    inline Sig_AlbumArtStateSignal& operator = (const Sig_AlbumArtStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_AlbumArtStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_AlbumArtStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_AlbumArtStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_AlbumArtStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DownloadState"

    static const int kDownloadState = 0;

    /**
     * Clears the field "DownloadState".
     *
     * The field will be set to its default value. The hasDownloadState()
     * method will return false.
     */
    inline void clearDownloadState();

    /**
     * Checks whether the field "DownloadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadState()). Otherwise it will return false.
     */
    inline bool hasDownloadState () const;

    /**
     * Returns the value of the member "DownloadState".
     *
     * If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DownloadState"
     */
    inline entDownloadState getDownloadState () const;

    /**
     * Sets the value of the member "DownloadState".
     *
     * If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @param DownloadState The value which will be set
     */
    inline void setDownloadState (entDownloadState DownloadState_);

    // API of field "SongId"

    static const int kSongId = 1;

    /**
     * Clears the field "SongId".
     *
     * The field will be set to its default value. The hasSongId()
     * method will return false.
     */
    inline void clearSongId();

    /**
     * Checks whether the field "SongId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongId()). Otherwise it will return false.
     */
    inline bool hasSongId () const;

    /**
     * Returns the value of the member "SongId".
     *
     * If the meaning of "SongId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SongId"
     */
    inline uint16 getSongId () const;

    /**
     * Sets the value of the member "SongId".
     *
     * If the meaning of "SongId" isn't clear, then there should be a description here.
     *
     * @param SongId The value which will be set
     */
    inline void setSongId (uint16 SongId_);

    static const Sig_AlbumArtStateSignal &getDefaultInstance();

private:

    inline void set_has_DownloadState ();

    inline void clear_has_DownloadState ();

    inline void set_has_SongId ();

    inline void clear_has_SongId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    entDownloadState _DownloadState;

    uint16 _SongId;

};

/**
 * sig_PlayableFlag =  playable content in USB
 */
class Sig_PlayableFlagSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_PlayableFlagSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_PlayableFlagSignal (const Sig_PlayableFlagSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_PlayableFlagSignal (bool isPlayableAudio_, bool isPlayableVideo_, entSourceType SourceType_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_PlayableFlagSignal();

    /**
     * Assignment operator
     */
    inline Sig_PlayableFlagSignal& operator = (const Sig_PlayableFlagSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_PlayableFlagSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_PlayableFlagSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_PlayableFlagSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_PlayableFlagSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "isPlayableAudio"

    static const int kIsPlayableAudio = 0;

    /**
     * Clears the field "isPlayableAudio".
     *
     * The field will be set to its default value. The hasIsPlayableAudio()
     * method will return false.
     */
    inline void clearIsPlayableAudio();

    /**
     * Checks whether the field "isPlayableAudio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsPlayableAudio()). Otherwise it will return false.
     */
    inline bool hasIsPlayableAudio () const;

    /**
     * Returns the value of the member "isPlayableAudio".
     *
     * If the meaning of "isPlayableAudio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isPlayableAudio"
     */
    inline bool getIsPlayableAudio () const;

    /**
     * Sets the value of the member "isPlayableAudio".
     *
     * If the meaning of "isPlayableAudio" isn't clear, then there should be a description here.
     *
     * @param isPlayableAudio The value which will be set
     */
    inline void setIsPlayableAudio (bool isPlayableAudio_);

    // API of field "isPlayableVideo"

    static const int kIsPlayableVideo = 1;

    /**
     * Clears the field "isPlayableVideo".
     *
     * The field will be set to its default value. The hasIsPlayableVideo()
     * method will return false.
     */
    inline void clearIsPlayableVideo();

    /**
     * Checks whether the field "isPlayableVideo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsPlayableVideo()). Otherwise it will return false.
     */
    inline bool hasIsPlayableVideo () const;

    /**
     * Returns the value of the member "isPlayableVideo".
     *
     * If the meaning of "isPlayableVideo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "isPlayableVideo"
     */
    inline bool getIsPlayableVideo () const;

    /**
     * Sets the value of the member "isPlayableVideo".
     *
     * If the meaning of "isPlayableVideo" isn't clear, then there should be a description here.
     *
     * @param isPlayableVideo The value which will be set
     */
    inline void setIsPlayableVideo (bool isPlayableVideo_);

    // API of field "SourceType"

    static const int kSourceType = 2;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    static const Sig_PlayableFlagSignal &getDefaultInstance();

private:

    inline void set_has_isPlayableAudio ();

    inline void clear_has_isPlayableAudio ();

    inline void set_has_isPlayableVideo ();

    inline void clear_has_isPlayableVideo ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _isPlayableAudio;

    bool _isPlayableVideo;

    entSourceType _SourceType;

};

/**
 * If the meaning of "sig_CurrentTrackInfo" isn't clear, then there should be a description here.
 */
class Sig_CurrentTrackInfoSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_CurrentTrackInfoSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_CurrentTrackInfoSignal (const Sig_CurrentTrackInfoSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_CurrentTrackInfoSignal (entSourceType SourceType_, entListType ListType_, uint8 Region_, uint16 SongId_, const ::std::string& FolderPath_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_CurrentTrackInfoSignal();

    /**
     * Assignment operator
     */
    inline Sig_CurrentTrackInfoSignal& operator = (const Sig_CurrentTrackInfoSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_CurrentTrackInfoSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_CurrentTrackInfoSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_CurrentTrackInfoSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_CurrentTrackInfoSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SourceType"

    static const int kSourceType = 0;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline entSourceType getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (entSourceType SourceType_);

    // API of field "ListType"

    static const int kListType = 1;

    /**
     * Clears the field "ListType".
     *
     * The field will be set to its default value. The hasListType()
     * method will return false.
     */
    inline void clearListType();

    /**
     * Checks whether the field "ListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListType()). Otherwise it will return false.
     */
    inline bool hasListType () const;

    /**
     * Returns the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListType"
     */
    inline entListType getListType () const;

    /**
     * Sets the value of the member "ListType".
     *
     * If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param ListType The value which will be set
     */
    inline void setListType (entListType ListType_);

    // API of field "Region"

    static const int kRegion = 2;

    /**
     * Clears the field "Region".
     *
     * The field will be set to its default value. The hasRegion()
     * method will return false.
     */
    inline void clearRegion();

    /**
     * Checks whether the field "Region" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegion()). Otherwise it will return false.
     */
    inline bool hasRegion () const;

    /**
     * Returns the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Region"
     */
    inline uint8 getRegion () const;

    /**
     * Sets the value of the member "Region".
     *
     * If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param Region The value which will be set
     */
    inline void setRegion (uint8 Region_);

    // API of field "SongId"

    static const int kSongId = 3;

    /**
     * Clears the field "SongId".
     *
     * The field will be set to its default value. The hasSongId()
     * method will return false.
     */
    inline void clearSongId();

    /**
     * Checks whether the field "SongId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSongId()). Otherwise it will return false.
     */
    inline bool hasSongId () const;

    /**
     * Returns the value of the member "SongId".
     *
     * If the meaning of "SongId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SongId"
     */
    inline uint16 getSongId () const;

    /**
     * Sets the value of the member "SongId".
     *
     * If the meaning of "SongId" isn't clear, then there should be a description here.
     *
     * @param SongId The value which will be set
     */
    inline void setSongId (uint16 SongId_);

    // API of field "FolderPath"

    static const int kFolderPath = 4;

    /**
     * Clears the field "FolderPath".
     *
     * The field will be set to its default value. The hasFolderPath()
     * method will return false.
     */
    inline void clearFolderPath();

    /**
     * Checks whether the field "FolderPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFolderPath()). Otherwise it will return false.
     */
    inline bool hasFolderPath () const;

    /**
     * Returns the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FolderPath"
     */
    inline const ::std::string& getFolderPath () const;

    /**
     * Retrieves the value of the field "FolderPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FolderPath".
     */
    inline ::std::string& getFolderPathMutable ();

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const ::std::string& FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* FolderPath_);

    /**
     * Sets the value of the member "FolderPath".
     *
     * If the meaning of "FolderPath" isn't clear, then there should be a description here.
     *
     * @param FolderPath The value which will be set
     */
    inline void setFolderPath (const char* value, size_t size);

    static const Sig_CurrentTrackInfoSignal &getDefaultInstance();

private:

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    inline void set_has_ListType ();

    inline void clear_has_ListType ();

    inline void set_has_Region ();

    inline void clear_has_Region ();

    inline void set_has_SongId ();

    inline void clear_has_SongId ();

    inline void set_has_FolderPath ();

    inline void clear_has_FolderPath ();

    uint32 _has_bits_[ (5 + 31) / 32];

    entSourceType _SourceType;

    entListType _ListType;

    uint8 _Region;

    uint16 _SongId;

    ::std::string _FolderPath;

};

inline  ListContainerStruct::ListContainerStruct ()  :
    _Text1 (),
    _Text2 (),
    _AbsoluteIndex (0u),
    _IsSelectedLanguage (false),
    _FileType (::bosch::cm::di::HmiEmpListInterface::entFileType__entFileType_unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListContainerStruct::ListContainerStruct (const ListContainerStruct &rhs)  :
    _Text1 (),
    _Text2 (),
    _AbsoluteIndex (0u),
    _IsSelectedLanguage (false),
    _FileType (::bosch::cm::di::HmiEmpListInterface::entFileType__entFileType_unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListContainerStruct::ListContainerStruct (const ::std::string& Text1_, const ::std::string& Text2_, uint16 AbsoluteIndex_, bool IsSelectedLanguage_, entFileType FileType_)  :
    _Text1 (Text1_),
    _Text2 (Text2_),
    _AbsoluteIndex (AbsoluteIndex_),
    _IsSelectedLanguage (IsSelectedLanguage_),
    _FileType (FileType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text1_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text2_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(entFileType_IsValid(FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FileType_, "entFileType", "FileType", "ListContainerStruct");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListContainerStruct::~ListContainerStruct() {
}

inline ListContainerStruct& ListContainerStruct::operator = (const ListContainerStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasText1()) {
            setText1(rhs.getText1());
        } else {
            clearText1();
        }
        if (rhs.hasText2()) {
            setText2(rhs.getText2());
        } else {
            clearText2();
        }
        if (rhs.hasAbsoluteIndex()) {
            setAbsoluteIndex(rhs.getAbsoluteIndex());
        } else {
            clearAbsoluteIndex();
        }
        if (rhs.hasIsSelectedLanguage()) {
            setIsSelectedLanguage(rhs.getIsSelectedLanguage());
        } else {
            clearIsSelectedLanguage();
        }
        if (rhs.hasFileType()) {
            setFileType(rhs.getFileType());
        } else {
            clearFileType();
        }
    }
    return *this;
}

inline bool ListContainerStruct::operator == (const ListContainerStruct& rhs) const {
    return (((!hasText1() && !rhs.hasText1()) || getText1() == rhs.getText1()) &&
        ((!hasText2() && !rhs.hasText2()) || getText2() == rhs.getText2()) &&
        ((!hasAbsoluteIndex() && !rhs.hasAbsoluteIndex()) || getAbsoluteIndex() == rhs.getAbsoluteIndex()) &&
        ((!hasIsSelectedLanguage() && !rhs.hasIsSelectedLanguage()) || getIsSelectedLanguage() == rhs.getIsSelectedLanguage()) &&
        ((!hasFileType() && !rhs.hasFileType()) || getFileType() == rhs.getFileType()));
}

inline bool ListContainerStruct::operator != (const ListContainerStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ListContainerStruct::operator < (const ListContainerStruct& rhs) const {
    if (hasText1() || rhs.hasText1()) {
        if (getText1() < rhs.getText1()) return true;
        if (getText1() > rhs.getText1()) return false;
    }
    if (hasText2() || rhs.hasText2()) {
        if (getText2() < rhs.getText2()) return true;
        if (getText2() > rhs.getText2()) return false;
    }
    if (hasAbsoluteIndex() || rhs.hasAbsoluteIndex()) {
        if (getAbsoluteIndex() < rhs.getAbsoluteIndex()) return true;
        if (getAbsoluteIndex() > rhs.getAbsoluteIndex()) return false;
    }
    if (hasIsSelectedLanguage() || rhs.hasIsSelectedLanguage()) {
        if (getIsSelectedLanguage() < rhs.getIsSelectedLanguage()) return true;
        if (getIsSelectedLanguage() > rhs.getIsSelectedLanguage()) return false;
    }
    if (hasFileType() || rhs.hasFileType()) {
        if ((uint32)getFileType() < (uint32)rhs.getFileType()) return true;
        if ((uint32)getFileType() > (uint32)rhs.getFileType()) return false;
    }
    return false;
}

inline bool ListContainerStruct::operator > (const ListContainerStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListContainerStruct::clear() {
    clearText1();
    clearText2();
    clearAbsoluteIndex();
    clearIsSelectedLanguage();
    clearFileType();
}

inline void ListContainerStruct::clearText1() {
    if (hasText1()) {
         clear_has_Text1();
        _Text1.clear();
     }
}

inline bool ListContainerStruct::hasText1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ListContainerStruct::getText1 () const {
    return _Text1;
}

inline ::std::string& ListContainerStruct::getText1Mutable () {
    set_has_Text1();
    return _Text1;
}

inline void ListContainerStruct::setText1 (const ::std::string& Text1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text1();
    this->_Text1 = Text1_;
}

inline void ListContainerStruct::setText1 (const char* Text1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text1();
    this->_Text1.assign(Text1_);
}

inline void ListContainerStruct::setText1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text1();
    this->_Text1.assign(value, size);
}

inline void ListContainerStruct::clearText2() {
    if (hasText2()) {
         clear_has_Text2();
        _Text2.clear();
     }
}

inline bool ListContainerStruct::hasText2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ListContainerStruct::getText2 () const {
    return _Text2;
}

inline ::std::string& ListContainerStruct::getText2Mutable () {
    set_has_Text2();
    return _Text2;
}

inline void ListContainerStruct::setText2 (const ::std::string& Text2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text2();
    this->_Text2 = Text2_;
}

inline void ListContainerStruct::setText2 (const char* Text2_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Text2_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text2();
    this->_Text2.assign(Text2_);
}

inline void ListContainerStruct::setText2 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Text2();
    this->_Text2.assign(value, size);
}

inline void ListContainerStruct::clearAbsoluteIndex() {
    if (hasAbsoluteIndex()) {
         clear_has_AbsoluteIndex();
        _AbsoluteIndex = 0u;
     }
}

inline bool ListContainerStruct::hasAbsoluteIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ListContainerStruct::getAbsoluteIndex () const {
    return _AbsoluteIndex;
}

inline void ListContainerStruct::setAbsoluteIndex (uint16 AbsoluteIndex_) {
    set_has_AbsoluteIndex();
    this->_AbsoluteIndex = AbsoluteIndex_;
}

inline void ListContainerStruct::clearIsSelectedLanguage() {
    if (hasIsSelectedLanguage()) {
         clear_has_IsSelectedLanguage();
        _IsSelectedLanguage = false;
     }
}

inline bool ListContainerStruct::hasIsSelectedLanguage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool ListContainerStruct::getIsSelectedLanguage () const {
    return _IsSelectedLanguage;
}

inline void ListContainerStruct::setIsSelectedLanguage (bool IsSelectedLanguage_) {
    set_has_IsSelectedLanguage();
    this->_IsSelectedLanguage = IsSelectedLanguage_;
}

inline void ListContainerStruct::clearFileType() {
    if (hasFileType()) {
         clear_has_FileType();
        _FileType = ::bosch::cm::di::HmiEmpListInterface::entFileType__entFileType_unknown;
     }
}

inline bool ListContainerStruct::hasFileType () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline entFileType ListContainerStruct::getFileType () const {
    return _FileType;
}

inline void ListContainerStruct::setFileType (entFileType FileType_) {
    #ifndef NDEBUG
    if (!(entFileType_IsValid(FileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FileType_, "entFileType", "FileType", "ListContainerStruct");
    }
    #endif
    set_has_FileType();
    this->_FileType = FileType_;
}

inline void ListContainerStruct::set_has_Text1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListContainerStruct::clear_has_Text1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ListContainerStruct::set_has_Text2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ListContainerStruct::clear_has_Text2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ListContainerStruct::set_has_AbsoluteIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void ListContainerStruct::clear_has_AbsoluteIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ListContainerStruct::set_has_IsSelectedLanguage () {
    _has_bits_[0] |= 1u << 3;
}

inline void ListContainerStruct::clear_has_IsSelectedLanguage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ListContainerStruct::set_has_FileType () {
    _has_bits_[0] |= 1u << 4;
}

inline void ListContainerStruct::clear_has_FileType () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ListSizeStruct::ListSizeStruct ()  :
    _Count (0u),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListSizeStruct::ListSizeStruct (const ListSizeStruct &rhs)  :
    _Count (0u),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListSizeStruct::ListSizeStruct (uint32 Count_, entListType ListType_, entSourceType SourceType_, uint8 Region_)  :
    _Count (Count_),
    _ListType (ListType_),
    _SourceType (SourceType_),
    _Region (Region_)
{
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ListSizeStruct");
    }
    #endif
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ListSizeStruct");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListSizeStruct::~ListSizeStruct() {
}

inline ListSizeStruct& ListSizeStruct::operator = (const ListSizeStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCount()) {
            setCount(rhs.getCount());
        } else {
            clearCount();
        }
        if (rhs.hasListType()) {
            setListType(rhs.getListType());
        } else {
            clearListType();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
    }
    return *this;
}

inline bool ListSizeStruct::operator == (const ListSizeStruct& rhs) const {
    return (((!hasCount() && !rhs.hasCount()) || getCount() == rhs.getCount()) &&
        ((!hasListType() && !rhs.hasListType()) || getListType() == rhs.getListType()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()));
}

inline bool ListSizeStruct::operator != (const ListSizeStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ListSizeStruct::operator < (const ListSizeStruct& rhs) const {
    if (hasCount() || rhs.hasCount()) {
        if (getCount() < rhs.getCount()) return true;
        if (getCount() > rhs.getCount()) return false;
    }
    if (hasListType() || rhs.hasListType()) {
        if ((uint32)getListType() < (uint32)rhs.getListType()) return true;
        if ((uint32)getListType() > (uint32)rhs.getListType()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    return false;
}

inline bool ListSizeStruct::operator > (const ListSizeStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListSizeStruct::clear() {
    clearCount();
    clearListType();
    clearSourceType();
    clearRegion();
}

inline void ListSizeStruct::clearCount() {
    if (hasCount()) {
         clear_has_Count();
        _Count = 0u;
     }
}

inline bool ListSizeStruct::hasCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ListSizeStruct::getCount () const {
    return _Count;
}

inline void ListSizeStruct::setCount (uint32 Count_) {
    set_has_Count();
    this->_Count = Count_;
}

inline void ListSizeStruct::clearListType() {
    if (hasListType()) {
         clear_has_ListType();
        _ListType = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
     }
}

inline bool ListSizeStruct::hasListType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entListType ListSizeStruct::getListType () const {
    return _ListType;
}

inline void ListSizeStruct::setListType (entListType ListType_) {
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ListSizeStruct");
    }
    #endif
    set_has_ListType();
    this->_ListType = ListType_;
}

inline void ListSizeStruct::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ListSizeStruct::hasSourceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline entSourceType ListSizeStruct::getSourceType () const {
    return _SourceType;
}

inline void ListSizeStruct::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ListSizeStruct");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ListSizeStruct::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool ListSizeStruct::hasRegion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ListSizeStruct::getRegion () const {
    return _Region;
}

inline void ListSizeStruct::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void ListSizeStruct::set_has_Count () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListSizeStruct::clear_has_Count () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ListSizeStruct::set_has_ListType () {
    _has_bits_[0] |= 1u << 1;
}

inline void ListSizeStruct::clear_has_ListType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ListSizeStruct::set_has_SourceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void ListSizeStruct::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ListSizeStruct::set_has_Region () {
    _has_bits_[0] |= 1u << 3;
}

inline void ListSizeStruct::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqCreateMediaPlayerListRequest::ReqCreateMediaPlayerListRequest ()  :
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _AbsoluteIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerListRequest::ReqCreateMediaPlayerListRequest (const ReqCreateMediaPlayerListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _AbsoluteIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCreateMediaPlayerListRequest::ReqCreateMediaPlayerListRequest (entListType ListType_, entSourceType SourceType_, uint8 Region_, uint16 AbsoluteIndex_)  :
    _ListType (ListType_),
    _SourceType (SourceType_),
    _Region (Region_),
    _AbsoluteIndex (AbsoluteIndex_)
{
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ReqCreateMediaPlayerListRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqCreateMediaPlayerListRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerListRequest::~ReqCreateMediaPlayerListRequest() {
}

inline ReqCreateMediaPlayerListRequest& ReqCreateMediaPlayerListRequest::operator = (const ReqCreateMediaPlayerListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListType()) {
            setListType(rhs.getListType());
        } else {
            clearListType();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasAbsoluteIndex()) {
            setAbsoluteIndex(rhs.getAbsoluteIndex());
        } else {
            clearAbsoluteIndex();
        }
    }
    return *this;
}

inline bool ReqCreateMediaPlayerListRequest::operator == (const ReqCreateMediaPlayerListRequest& rhs) const {
    return (((!hasListType() && !rhs.hasListType()) || getListType() == rhs.getListType()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasAbsoluteIndex() && !rhs.hasAbsoluteIndex()) || getAbsoluteIndex() == rhs.getAbsoluteIndex()));
}

inline bool ReqCreateMediaPlayerListRequest::operator != (const ReqCreateMediaPlayerListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCreateMediaPlayerListRequest::operator < (const ReqCreateMediaPlayerListRequest& rhs) const {
    if (hasListType() || rhs.hasListType()) {
        if ((uint32)getListType() < (uint32)rhs.getListType()) return true;
        if ((uint32)getListType() > (uint32)rhs.getListType()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasAbsoluteIndex() || rhs.hasAbsoluteIndex()) {
        if (getAbsoluteIndex() < rhs.getAbsoluteIndex()) return true;
        if (getAbsoluteIndex() > rhs.getAbsoluteIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCreateMediaPlayerListRequest::clone() {
    return new ReqCreateMediaPlayerListRequest(*this);
}

inline bool ReqCreateMediaPlayerListRequest::operator > (const ReqCreateMediaPlayerListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCreateMediaPlayerListRequest::clear() {
    clearListType();
    clearSourceType();
    clearRegion();
    clearAbsoluteIndex();
}

inline void ReqCreateMediaPlayerListRequest::clearListType() {
    if (hasListType()) {
         clear_has_ListType();
        _ListType = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
     }
}

inline bool ReqCreateMediaPlayerListRequest::hasListType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entListType ReqCreateMediaPlayerListRequest::getListType () const {
    return _ListType;
}

inline void ReqCreateMediaPlayerListRequest::setListType (entListType ListType_) {
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ReqCreateMediaPlayerListRequest");
    }
    #endif
    set_has_ListType();
    this->_ListType = ListType_;
}

inline void ReqCreateMediaPlayerListRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ReqCreateMediaPlayerListRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entSourceType ReqCreateMediaPlayerListRequest::getSourceType () const {
    return _SourceType;
}

inline void ReqCreateMediaPlayerListRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqCreateMediaPlayerListRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ReqCreateMediaPlayerListRequest::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool ReqCreateMediaPlayerListRequest::hasRegion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqCreateMediaPlayerListRequest::getRegion () const {
    return _Region;
}

inline void ReqCreateMediaPlayerListRequest::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void ReqCreateMediaPlayerListRequest::clearAbsoluteIndex() {
    if (hasAbsoluteIndex()) {
         clear_has_AbsoluteIndex();
        _AbsoluteIndex = 0u;
     }
}

inline bool ReqCreateMediaPlayerListRequest::hasAbsoluteIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqCreateMediaPlayerListRequest::getAbsoluteIndex () const {
    return _AbsoluteIndex;
}

inline void ReqCreateMediaPlayerListRequest::setAbsoluteIndex (uint16 AbsoluteIndex_) {
    set_has_AbsoluteIndex();
    this->_AbsoluteIndex = AbsoluteIndex_;
}

inline void ReqCreateMediaPlayerListRequest::set_has_ListType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCreateMediaPlayerListRequest::clear_has_ListType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqCreateMediaPlayerListRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqCreateMediaPlayerListRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqCreateMediaPlayerListRequest::set_has_Region () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqCreateMediaPlayerListRequest::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqCreateMediaPlayerListRequest::set_has_AbsoluteIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqCreateMediaPlayerListRequest::clear_has_AbsoluteIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ReqCreateMediaPlayerListResponse::ReqCreateMediaPlayerListResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerListResponse::ReqCreateMediaPlayerListResponse (const ReqCreateMediaPlayerListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCreateMediaPlayerListResponse::ReqCreateMediaPlayerListResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerListResponse::~ReqCreateMediaPlayerListResponse() {
}

inline ReqCreateMediaPlayerListResponse& ReqCreateMediaPlayerListResponse::operator = (const ReqCreateMediaPlayerListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqCreateMediaPlayerListResponse::operator == (const ReqCreateMediaPlayerListResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqCreateMediaPlayerListResponse::operator != (const ReqCreateMediaPlayerListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCreateMediaPlayerListResponse::operator < (const ReqCreateMediaPlayerListResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCreateMediaPlayerListResponse::clone() {
    return new ReqCreateMediaPlayerListResponse(*this);
}

inline bool ReqCreateMediaPlayerListResponse::operator > (const ReqCreateMediaPlayerListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCreateMediaPlayerListResponse::clear() {
    clearResponse();
}

inline void ReqCreateMediaPlayerListResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqCreateMediaPlayerListResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqCreateMediaPlayerListResponse::getResponse () const {
    return _response;
}

inline void ReqCreateMediaPlayerListResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqCreateMediaPlayerListResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCreateMediaPlayerListResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqMediaPlayerListSliceRequest::ReqMediaPlayerListSliceRequest ()  :
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _StartingIndex (0u),
    _WindowSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqMediaPlayerListSliceRequest::ReqMediaPlayerListSliceRequest (const ReqMediaPlayerListSliceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _StartingIndex (0u),
    _WindowSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqMediaPlayerListSliceRequest::ReqMediaPlayerListSliceRequest (entListType ListType_, entSourceType SourceType_, uint8 Region_, uint16 StartingIndex_, uint8 WindowSize_)  :
    _ListType (ListType_),
    _SourceType (SourceType_),
    _Region (Region_),
    _StartingIndex (StartingIndex_),
    _WindowSize (WindowSize_)
{
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ReqMediaPlayerListSliceRequest");
    }
    #endif
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqMediaPlayerListSliceRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqMediaPlayerListSliceRequest::~ReqMediaPlayerListSliceRequest() {
}

inline ReqMediaPlayerListSliceRequest& ReqMediaPlayerListSliceRequest::operator = (const ReqMediaPlayerListSliceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListType()) {
            setListType(rhs.getListType());
        } else {
            clearListType();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasStartingIndex()) {
            setStartingIndex(rhs.getStartingIndex());
        } else {
            clearStartingIndex();
        }
        if (rhs.hasWindowSize()) {
            setWindowSize(rhs.getWindowSize());
        } else {
            clearWindowSize();
        }
    }
    return *this;
}

inline bool ReqMediaPlayerListSliceRequest::operator == (const ReqMediaPlayerListSliceRequest& rhs) const {
    return (((!hasListType() && !rhs.hasListType()) || getListType() == rhs.getListType()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasStartingIndex() && !rhs.hasStartingIndex()) || getStartingIndex() == rhs.getStartingIndex()) &&
        ((!hasWindowSize() && !rhs.hasWindowSize()) || getWindowSize() == rhs.getWindowSize()));
}

inline bool ReqMediaPlayerListSliceRequest::operator != (const ReqMediaPlayerListSliceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqMediaPlayerListSliceRequest::operator < (const ReqMediaPlayerListSliceRequest& rhs) const {
    if (hasListType() || rhs.hasListType()) {
        if ((uint32)getListType() < (uint32)rhs.getListType()) return true;
        if ((uint32)getListType() > (uint32)rhs.getListType()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasStartingIndex() || rhs.hasStartingIndex()) {
        if (getStartingIndex() < rhs.getStartingIndex()) return true;
        if (getStartingIndex() > rhs.getStartingIndex()) return false;
    }
    if (hasWindowSize() || rhs.hasWindowSize()) {
        if (getWindowSize() < rhs.getWindowSize()) return true;
        if (getWindowSize() > rhs.getWindowSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqMediaPlayerListSliceRequest::clone() {
    return new ReqMediaPlayerListSliceRequest(*this);
}

inline bool ReqMediaPlayerListSliceRequest::operator > (const ReqMediaPlayerListSliceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqMediaPlayerListSliceRequest::clear() {
    clearListType();
    clearSourceType();
    clearRegion();
    clearStartingIndex();
    clearWindowSize();
}

inline void ReqMediaPlayerListSliceRequest::clearListType() {
    if (hasListType()) {
         clear_has_ListType();
        _ListType = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
     }
}

inline bool ReqMediaPlayerListSliceRequest::hasListType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entListType ReqMediaPlayerListSliceRequest::getListType () const {
    return _ListType;
}

inline void ReqMediaPlayerListSliceRequest::setListType (entListType ListType_) {
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "ReqMediaPlayerListSliceRequest");
    }
    #endif
    set_has_ListType();
    this->_ListType = ListType_;
}

inline void ReqMediaPlayerListSliceRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ReqMediaPlayerListSliceRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entSourceType ReqMediaPlayerListSliceRequest::getSourceType () const {
    return _SourceType;
}

inline void ReqMediaPlayerListSliceRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqMediaPlayerListSliceRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ReqMediaPlayerListSliceRequest::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool ReqMediaPlayerListSliceRequest::hasRegion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReqMediaPlayerListSliceRequest::getRegion () const {
    return _Region;
}

inline void ReqMediaPlayerListSliceRequest::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void ReqMediaPlayerListSliceRequest::clearStartingIndex() {
    if (hasStartingIndex()) {
         clear_has_StartingIndex();
        _StartingIndex = 0u;
     }
}

inline bool ReqMediaPlayerListSliceRequest::hasStartingIndex () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 ReqMediaPlayerListSliceRequest::getStartingIndex () const {
    return _StartingIndex;
}

inline void ReqMediaPlayerListSliceRequest::setStartingIndex (uint16 StartingIndex_) {
    set_has_StartingIndex();
    this->_StartingIndex = StartingIndex_;
}

inline void ReqMediaPlayerListSliceRequest::clearWindowSize() {
    if (hasWindowSize()) {
         clear_has_WindowSize();
        _WindowSize = 0u;
     }
}

inline bool ReqMediaPlayerListSliceRequest::hasWindowSize () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 ReqMediaPlayerListSliceRequest::getWindowSize () const {
    return _WindowSize;
}

inline void ReqMediaPlayerListSliceRequest::setWindowSize (uint8 WindowSize_) {
    set_has_WindowSize();
    this->_WindowSize = WindowSize_;
}

inline void ReqMediaPlayerListSliceRequest::set_has_ListType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqMediaPlayerListSliceRequest::clear_has_ListType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqMediaPlayerListSliceRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqMediaPlayerListSliceRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqMediaPlayerListSliceRequest::set_has_Region () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqMediaPlayerListSliceRequest::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqMediaPlayerListSliceRequest::set_has_StartingIndex () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqMediaPlayerListSliceRequest::clear_has_StartingIndex () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqMediaPlayerListSliceRequest::set_has_WindowSize () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqMediaPlayerListSliceRequest::clear_has_WindowSize () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqMediaPlayerListSliceResponse::ReqMediaPlayerListSliceResponse ()  :
    _mArrayListContainer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqMediaPlayerListSliceResponse::ReqMediaPlayerListSliceResponse (const ReqMediaPlayerListSliceResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _mArrayListContainer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqMediaPlayerListSliceResponse::ReqMediaPlayerListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer_)  :
    _mArrayListContainer (mArrayListContainer_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqMediaPlayerListSliceResponse::~ReqMediaPlayerListSliceResponse() {
}

inline ReqMediaPlayerListSliceResponse& ReqMediaPlayerListSliceResponse::operator = (const ReqMediaPlayerListSliceResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMArrayListContainer()) {
            setMArrayListContainer(rhs.getMArrayListContainer());
        } else {
            clearMArrayListContainer();
        }
    }
    return *this;
}

inline bool ReqMediaPlayerListSliceResponse::operator == (const ReqMediaPlayerListSliceResponse& rhs) const {
    return (((!hasMArrayListContainer() && !rhs.hasMArrayListContainer()) || getMArrayListContainer() == rhs.getMArrayListContainer()));
}

inline bool ReqMediaPlayerListSliceResponse::operator != (const ReqMediaPlayerListSliceResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqMediaPlayerListSliceResponse::operator < (const ReqMediaPlayerListSliceResponse& rhs) const {
    if (hasMArrayListContainer() || rhs.hasMArrayListContainer()) {
        if (getMArrayListContainer() < rhs.getMArrayListContainer()) return true;
        if (getMArrayListContainer() > rhs.getMArrayListContainer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqMediaPlayerListSliceResponse::clone() {
    return new ReqMediaPlayerListSliceResponse(*this);
}

inline bool ReqMediaPlayerListSliceResponse::operator > (const ReqMediaPlayerListSliceResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqMediaPlayerListSliceResponse::clear() {
    clearMArrayListContainer();
}

inline void ReqMediaPlayerListSliceResponse::clearMArrayListContainer() {
    if (hasMArrayListContainer()) {
         clear_has_mArrayListContainer();
        _mArrayListContainer.clear();
     }
}

inline bool ReqMediaPlayerListSliceResponse::hasMArrayListContainer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ListContainerStruct >& ReqMediaPlayerListSliceResponse::getMArrayListContainer () const {
    return _mArrayListContainer;
}

inline ::std::vector< ListContainerStruct >& ReqMediaPlayerListSliceResponse::getMArrayListContainerMutable () {
    set_has_mArrayListContainer();
    return _mArrayListContainer;
}

inline void ReqMediaPlayerListSliceResponse::setMArrayListContainer (const ::std::vector< ListContainerStruct >& mArrayListContainer_) {
    set_has_mArrayListContainer();
    this->_mArrayListContainer = mArrayListContainer_;
}

inline void ReqMediaPlayerListSliceResponse::set_has_mArrayListContainer () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqMediaPlayerListSliceResponse::clear_has_mArrayListContainer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqDBDownloadRequest::ReqDBDownloadRequest ()  :
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqDBDownloadRequest::ReqDBDownloadRequest (const ReqDBDownloadRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqDBDownloadRequest::ReqDBDownloadRequest (entSourceType SourceType_)  :
    _SourceType (SourceType_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqDBDownloadRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqDBDownloadRequest::~ReqDBDownloadRequest() {
}

inline ReqDBDownloadRequest& ReqDBDownloadRequest::operator = (const ReqDBDownloadRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
    }
    return *this;
}

inline bool ReqDBDownloadRequest::operator == (const ReqDBDownloadRequest& rhs) const {
    return (((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()));
}

inline bool ReqDBDownloadRequest::operator != (const ReqDBDownloadRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqDBDownloadRequest::operator < (const ReqDBDownloadRequest& rhs) const {
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqDBDownloadRequest::clone() {
    return new ReqDBDownloadRequest(*this);
}

inline bool ReqDBDownloadRequest::operator > (const ReqDBDownloadRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqDBDownloadRequest::clear() {
    clearSourceType();
}

inline void ReqDBDownloadRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ReqDBDownloadRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSourceType ReqDBDownloadRequest::getSourceType () const {
    return _SourceType;
}

inline void ReqDBDownloadRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqDBDownloadRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ReqDBDownloadRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqDBDownloadRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqDBDownloadResponse::ReqDBDownloadResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqDBDownloadResponse::ReqDBDownloadResponse (const ReqDBDownloadResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqDBDownloadResponse::ReqDBDownloadResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqDBDownloadResponse::~ReqDBDownloadResponse() {
}

inline ReqDBDownloadResponse& ReqDBDownloadResponse::operator = (const ReqDBDownloadResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ReqDBDownloadResponse::operator == (const ReqDBDownloadResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ReqDBDownloadResponse::operator != (const ReqDBDownloadResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqDBDownloadResponse::operator < (const ReqDBDownloadResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqDBDownloadResponse::clone() {
    return new ReqDBDownloadResponse(*this);
}

inline bool ReqDBDownloadResponse::operator > (const ReqDBDownloadResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqDBDownloadResponse::clear() {
    clearResponse();
}

inline void ReqDBDownloadResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ReqDBDownloadResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ReqDBDownloadResponse::getResponse () const {
    return _response;
}

inline void ReqDBDownloadResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ReqDBDownloadResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqDBDownloadResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqCreateMediaPlayerFolderListRequest::ReqCreateMediaPlayerFolderListRequest ()  :
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerFolderListRequest::ReqCreateMediaPlayerFolderListRequest (const ReqCreateMediaPlayerFolderListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCreateMediaPlayerFolderListRequest::ReqCreateMediaPlayerFolderListRequest (entSourceType SourceType_, uint8 Region_, const ::std::string& FolderPath_)  :
    _SourceType (SourceType_),
    _Region (Region_),
    _FolderPath (FolderPath_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqCreateMediaPlayerFolderListRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerFolderListRequest::~ReqCreateMediaPlayerFolderListRequest() {
}

inline ReqCreateMediaPlayerFolderListRequest& ReqCreateMediaPlayerFolderListRequest::operator = (const ReqCreateMediaPlayerFolderListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasFolderPath()) {
            setFolderPath(rhs.getFolderPath());
        } else {
            clearFolderPath();
        }
    }
    return *this;
}

inline bool ReqCreateMediaPlayerFolderListRequest::operator == (const ReqCreateMediaPlayerFolderListRequest& rhs) const {
    return (((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasFolderPath() && !rhs.hasFolderPath()) || getFolderPath() == rhs.getFolderPath()));
}

inline bool ReqCreateMediaPlayerFolderListRequest::operator != (const ReqCreateMediaPlayerFolderListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCreateMediaPlayerFolderListRequest::operator < (const ReqCreateMediaPlayerFolderListRequest& rhs) const {
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasFolderPath() || rhs.hasFolderPath()) {
        if (getFolderPath() < rhs.getFolderPath()) return true;
        if (getFolderPath() > rhs.getFolderPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCreateMediaPlayerFolderListRequest::clone() {
    return new ReqCreateMediaPlayerFolderListRequest(*this);
}

inline bool ReqCreateMediaPlayerFolderListRequest::operator > (const ReqCreateMediaPlayerFolderListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCreateMediaPlayerFolderListRequest::clear() {
    clearSourceType();
    clearRegion();
    clearFolderPath();
}

inline void ReqCreateMediaPlayerFolderListRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ReqCreateMediaPlayerFolderListRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSourceType ReqCreateMediaPlayerFolderListRequest::getSourceType () const {
    return _SourceType;
}

inline void ReqCreateMediaPlayerFolderListRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqCreateMediaPlayerFolderListRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ReqCreateMediaPlayerFolderListRequest::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool ReqCreateMediaPlayerFolderListRequest::hasRegion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqCreateMediaPlayerFolderListRequest::getRegion () const {
    return _Region;
}

inline void ReqCreateMediaPlayerFolderListRequest::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void ReqCreateMediaPlayerFolderListRequest::clearFolderPath() {
    if (hasFolderPath()) {
         clear_has_FolderPath();
        _FolderPath.clear();
     }
}

inline bool ReqCreateMediaPlayerFolderListRequest::hasFolderPath () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& ReqCreateMediaPlayerFolderListRequest::getFolderPath () const {
    return _FolderPath;
}

inline ::std::string& ReqCreateMediaPlayerFolderListRequest::getFolderPathMutable () {
    set_has_FolderPath();
    return _FolderPath;
}

inline void ReqCreateMediaPlayerFolderListRequest::setFolderPath (const ::std::string& FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath = FolderPath_;
}

inline void ReqCreateMediaPlayerFolderListRequest::setFolderPath (const char* FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(FolderPath_);
}

inline void ReqCreateMediaPlayerFolderListRequest::setFolderPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(value, size);
}

inline void ReqCreateMediaPlayerFolderListRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCreateMediaPlayerFolderListRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqCreateMediaPlayerFolderListRequest::set_has_Region () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqCreateMediaPlayerFolderListRequest::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqCreateMediaPlayerFolderListRequest::set_has_FolderPath () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqCreateMediaPlayerFolderListRequest::clear_has_FolderPath () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ReqCreateMediaPlayerFolderListResponse::ReqCreateMediaPlayerFolderListResponse ()  :
    _ListCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerFolderListResponse::ReqCreateMediaPlayerFolderListResponse (const ReqCreateMediaPlayerFolderListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ListCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqCreateMediaPlayerFolderListResponse::ReqCreateMediaPlayerFolderListResponse (uint16 ListCount_)  :
    _ListCount (ListCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqCreateMediaPlayerFolderListResponse::~ReqCreateMediaPlayerFolderListResponse() {
}

inline ReqCreateMediaPlayerFolderListResponse& ReqCreateMediaPlayerFolderListResponse::operator = (const ReqCreateMediaPlayerFolderListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListCount()) {
            setListCount(rhs.getListCount());
        } else {
            clearListCount();
        }
    }
    return *this;
}

inline bool ReqCreateMediaPlayerFolderListResponse::operator == (const ReqCreateMediaPlayerFolderListResponse& rhs) const {
    return (((!hasListCount() && !rhs.hasListCount()) || getListCount() == rhs.getListCount()));
}

inline bool ReqCreateMediaPlayerFolderListResponse::operator != (const ReqCreateMediaPlayerFolderListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqCreateMediaPlayerFolderListResponse::operator < (const ReqCreateMediaPlayerFolderListResponse& rhs) const {
    if (hasListCount() || rhs.hasListCount()) {
        if (getListCount() < rhs.getListCount()) return true;
        if (getListCount() > rhs.getListCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqCreateMediaPlayerFolderListResponse::clone() {
    return new ReqCreateMediaPlayerFolderListResponse(*this);
}

inline bool ReqCreateMediaPlayerFolderListResponse::operator > (const ReqCreateMediaPlayerFolderListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqCreateMediaPlayerFolderListResponse::clear() {
    clearListCount();
}

inline void ReqCreateMediaPlayerFolderListResponse::clearListCount() {
    if (hasListCount()) {
         clear_has_ListCount();
        _ListCount = 0u;
     }
}

inline bool ReqCreateMediaPlayerFolderListResponse::hasListCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ReqCreateMediaPlayerFolderListResponse::getListCount () const {
    return _ListCount;
}

inline void ReqCreateMediaPlayerFolderListResponse::setListCount (uint16 ListCount_) {
    set_has_ListCount();
    this->_ListCount = ListCount_;
}

inline void ReqCreateMediaPlayerFolderListResponse::set_has_ListCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqCreateMediaPlayerFolderListResponse::clear_has_ListCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReqMediaPlayerFolderListSliceRequest::ReqMediaPlayerFolderListSliceRequest ()  :
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _StartingIndex (0u),
    _WindowSize (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqMediaPlayerFolderListSliceRequest::ReqMediaPlayerFolderListSliceRequest (const ReqMediaPlayerFolderListSliceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _StartingIndex (0u),
    _WindowSize (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqMediaPlayerFolderListSliceRequest::ReqMediaPlayerFolderListSliceRequest (entSourceType SourceType_, uint8 Region_, uint16 StartingIndex_, uint8 WindowSize_, const ::std::string& FolderPath_)  :
    _SourceType (SourceType_),
    _Region (Region_),
    _StartingIndex (StartingIndex_),
    _WindowSize (WindowSize_),
    _FolderPath (FolderPath_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqMediaPlayerFolderListSliceRequest");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqMediaPlayerFolderListSliceRequest::~ReqMediaPlayerFolderListSliceRequest() {
}

inline ReqMediaPlayerFolderListSliceRequest& ReqMediaPlayerFolderListSliceRequest::operator = (const ReqMediaPlayerFolderListSliceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasStartingIndex()) {
            setStartingIndex(rhs.getStartingIndex());
        } else {
            clearStartingIndex();
        }
        if (rhs.hasWindowSize()) {
            setWindowSize(rhs.getWindowSize());
        } else {
            clearWindowSize();
        }
        if (rhs.hasFolderPath()) {
            setFolderPath(rhs.getFolderPath());
        } else {
            clearFolderPath();
        }
    }
    return *this;
}

inline bool ReqMediaPlayerFolderListSliceRequest::operator == (const ReqMediaPlayerFolderListSliceRequest& rhs) const {
    return (((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasStartingIndex() && !rhs.hasStartingIndex()) || getStartingIndex() == rhs.getStartingIndex()) &&
        ((!hasWindowSize() && !rhs.hasWindowSize()) || getWindowSize() == rhs.getWindowSize()) &&
        ((!hasFolderPath() && !rhs.hasFolderPath()) || getFolderPath() == rhs.getFolderPath()));
}

inline bool ReqMediaPlayerFolderListSliceRequest::operator != (const ReqMediaPlayerFolderListSliceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqMediaPlayerFolderListSliceRequest::operator < (const ReqMediaPlayerFolderListSliceRequest& rhs) const {
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasStartingIndex() || rhs.hasStartingIndex()) {
        if (getStartingIndex() < rhs.getStartingIndex()) return true;
        if (getStartingIndex() > rhs.getStartingIndex()) return false;
    }
    if (hasWindowSize() || rhs.hasWindowSize()) {
        if (getWindowSize() < rhs.getWindowSize()) return true;
        if (getWindowSize() > rhs.getWindowSize()) return false;
    }
    if (hasFolderPath() || rhs.hasFolderPath()) {
        if (getFolderPath() < rhs.getFolderPath()) return true;
        if (getFolderPath() > rhs.getFolderPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqMediaPlayerFolderListSliceRequest::clone() {
    return new ReqMediaPlayerFolderListSliceRequest(*this);
}

inline bool ReqMediaPlayerFolderListSliceRequest::operator > (const ReqMediaPlayerFolderListSliceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqMediaPlayerFolderListSliceRequest::clear() {
    clearSourceType();
    clearRegion();
    clearStartingIndex();
    clearWindowSize();
    clearFolderPath();
}

inline void ReqMediaPlayerFolderListSliceRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool ReqMediaPlayerFolderListSliceRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSourceType ReqMediaPlayerFolderListSliceRequest::getSourceType () const {
    return _SourceType;
}

inline void ReqMediaPlayerFolderListSliceRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "ReqMediaPlayerFolderListSliceRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void ReqMediaPlayerFolderListSliceRequest::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool ReqMediaPlayerFolderListSliceRequest::hasRegion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReqMediaPlayerFolderListSliceRequest::getRegion () const {
    return _Region;
}

inline void ReqMediaPlayerFolderListSliceRequest::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void ReqMediaPlayerFolderListSliceRequest::clearStartingIndex() {
    if (hasStartingIndex()) {
         clear_has_StartingIndex();
        _StartingIndex = 0u;
     }
}

inline bool ReqMediaPlayerFolderListSliceRequest::hasStartingIndex () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReqMediaPlayerFolderListSliceRequest::getStartingIndex () const {
    return _StartingIndex;
}

inline void ReqMediaPlayerFolderListSliceRequest::setStartingIndex (uint16 StartingIndex_) {
    set_has_StartingIndex();
    this->_StartingIndex = StartingIndex_;
}

inline void ReqMediaPlayerFolderListSliceRequest::clearWindowSize() {
    if (hasWindowSize()) {
         clear_has_WindowSize();
        _WindowSize = 0u;
     }
}

inline bool ReqMediaPlayerFolderListSliceRequest::hasWindowSize () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 ReqMediaPlayerFolderListSliceRequest::getWindowSize () const {
    return _WindowSize;
}

inline void ReqMediaPlayerFolderListSliceRequest::setWindowSize (uint8 WindowSize_) {
    set_has_WindowSize();
    this->_WindowSize = WindowSize_;
}

inline void ReqMediaPlayerFolderListSliceRequest::clearFolderPath() {
    if (hasFolderPath()) {
         clear_has_FolderPath();
        _FolderPath.clear();
     }
}

inline bool ReqMediaPlayerFolderListSliceRequest::hasFolderPath () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& ReqMediaPlayerFolderListSliceRequest::getFolderPath () const {
    return _FolderPath;
}

inline ::std::string& ReqMediaPlayerFolderListSliceRequest::getFolderPathMutable () {
    set_has_FolderPath();
    return _FolderPath;
}

inline void ReqMediaPlayerFolderListSliceRequest::setFolderPath (const ::std::string& FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath = FolderPath_;
}

inline void ReqMediaPlayerFolderListSliceRequest::setFolderPath (const char* FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(FolderPath_);
}

inline void ReqMediaPlayerFolderListSliceRequest::setFolderPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(value, size);
}

inline void ReqMediaPlayerFolderListSliceRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqMediaPlayerFolderListSliceRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReqMediaPlayerFolderListSliceRequest::set_has_Region () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReqMediaPlayerFolderListSliceRequest::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReqMediaPlayerFolderListSliceRequest::set_has_StartingIndex () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReqMediaPlayerFolderListSliceRequest::clear_has_StartingIndex () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReqMediaPlayerFolderListSliceRequest::set_has_WindowSize () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReqMediaPlayerFolderListSliceRequest::clear_has_WindowSize () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReqMediaPlayerFolderListSliceRequest::set_has_FolderPath () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReqMediaPlayerFolderListSliceRequest::clear_has_FolderPath () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  ReqMediaPlayerFolderListSliceResponse::ReqMediaPlayerFolderListSliceResponse ()  :
    _mArrayListContainer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReqMediaPlayerFolderListSliceResponse::ReqMediaPlayerFolderListSliceResponse (const ReqMediaPlayerFolderListSliceResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _mArrayListContainer ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReqMediaPlayerFolderListSliceResponse::ReqMediaPlayerFolderListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer_)  :
    _mArrayListContainer (mArrayListContainer_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReqMediaPlayerFolderListSliceResponse::~ReqMediaPlayerFolderListSliceResponse() {
}

inline ReqMediaPlayerFolderListSliceResponse& ReqMediaPlayerFolderListSliceResponse::operator = (const ReqMediaPlayerFolderListSliceResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMArrayListContainer()) {
            setMArrayListContainer(rhs.getMArrayListContainer());
        } else {
            clearMArrayListContainer();
        }
    }
    return *this;
}

inline bool ReqMediaPlayerFolderListSliceResponse::operator == (const ReqMediaPlayerFolderListSliceResponse& rhs) const {
    return (((!hasMArrayListContainer() && !rhs.hasMArrayListContainer()) || getMArrayListContainer() == rhs.getMArrayListContainer()));
}

inline bool ReqMediaPlayerFolderListSliceResponse::operator != (const ReqMediaPlayerFolderListSliceResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ReqMediaPlayerFolderListSliceResponse::operator < (const ReqMediaPlayerFolderListSliceResponse& rhs) const {
    if (hasMArrayListContainer() || rhs.hasMArrayListContainer()) {
        if (getMArrayListContainer() < rhs.getMArrayListContainer()) return true;
        if (getMArrayListContainer() > rhs.getMArrayListContainer()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReqMediaPlayerFolderListSliceResponse::clone() {
    return new ReqMediaPlayerFolderListSliceResponse(*this);
}

inline bool ReqMediaPlayerFolderListSliceResponse::operator > (const ReqMediaPlayerFolderListSliceResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReqMediaPlayerFolderListSliceResponse::clear() {
    clearMArrayListContainer();
}

inline void ReqMediaPlayerFolderListSliceResponse::clearMArrayListContainer() {
    if (hasMArrayListContainer()) {
         clear_has_mArrayListContainer();
        _mArrayListContainer.clear();
     }
}

inline bool ReqMediaPlayerFolderListSliceResponse::hasMArrayListContainer () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ListContainerStruct >& ReqMediaPlayerFolderListSliceResponse::getMArrayListContainer () const {
    return _mArrayListContainer;
}

inline ::std::vector< ListContainerStruct >& ReqMediaPlayerFolderListSliceResponse::getMArrayListContainerMutable () {
    set_has_mArrayListContainer();
    return _mArrayListContainer;
}

inline void ReqMediaPlayerFolderListSliceResponse::setMArrayListContainer (const ::std::vector< ListContainerStruct >& mArrayListContainer_) {
    set_has_mArrayListContainer();
    this->_mArrayListContainer = mArrayListContainer_;
}

inline void ReqMediaPlayerFolderListSliceResponse::set_has_mArrayListContainer () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReqMediaPlayerFolderListSliceResponse::clear_has_mArrayListContainer () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetMediaVideoLanguagesListRequest::SetMediaVideoLanguagesListRequest ()  :
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _VideoLanguageIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMediaVideoLanguagesListRequest::SetMediaVideoLanguagesListRequest (const SetMediaVideoLanguagesListRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _Region (0u),
    _VideoLanguageIds ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMediaVideoLanguagesListRequest::SetMediaVideoLanguagesListRequest (entSourceType SourceType_, uint8 Region_, const ::std::vector< uint16 >& VideoLanguageIds_)  :
    _SourceType (SourceType_),
    _Region (Region_),
    _VideoLanguageIds (VideoLanguageIds_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "SetMediaVideoLanguagesListRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMediaVideoLanguagesListRequest::~SetMediaVideoLanguagesListRequest() {
}

inline SetMediaVideoLanguagesListRequest& SetMediaVideoLanguagesListRequest::operator = (const SetMediaVideoLanguagesListRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasVideoLanguageIds()) {
            setVideoLanguageIds(rhs.getVideoLanguageIds());
        } else {
            clearVideoLanguageIds();
        }
    }
    return *this;
}

inline bool SetMediaVideoLanguagesListRequest::operator == (const SetMediaVideoLanguagesListRequest& rhs) const {
    return (((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasVideoLanguageIds() && !rhs.hasVideoLanguageIds()) || getVideoLanguageIds() == rhs.getVideoLanguageIds()));
}

inline bool SetMediaVideoLanguagesListRequest::operator != (const SetMediaVideoLanguagesListRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMediaVideoLanguagesListRequest::operator < (const SetMediaVideoLanguagesListRequest& rhs) const {
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasVideoLanguageIds() || rhs.hasVideoLanguageIds()) {
        if (getVideoLanguageIds() < rhs.getVideoLanguageIds()) return true;
        if (getVideoLanguageIds() > rhs.getVideoLanguageIds()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMediaVideoLanguagesListRequest::clone() {
    return new SetMediaVideoLanguagesListRequest(*this);
}

inline bool SetMediaVideoLanguagesListRequest::operator > (const SetMediaVideoLanguagesListRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMediaVideoLanguagesListRequest::clear() {
    clearSourceType();
    clearRegion();
    clearVideoLanguageIds();
}

inline void SetMediaVideoLanguagesListRequest::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool SetMediaVideoLanguagesListRequest::hasSourceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSourceType SetMediaVideoLanguagesListRequest::getSourceType () const {
    return _SourceType;
}

inline void SetMediaVideoLanguagesListRequest::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "SetMediaVideoLanguagesListRequest");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void SetMediaVideoLanguagesListRequest::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool SetMediaVideoLanguagesListRequest::hasRegion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SetMediaVideoLanguagesListRequest::getRegion () const {
    return _Region;
}

inline void SetMediaVideoLanguagesListRequest::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void SetMediaVideoLanguagesListRequest::clearVideoLanguageIds() {
    if (hasVideoLanguageIds()) {
         clear_has_VideoLanguageIds();
        _VideoLanguageIds.clear();
     }
}

inline bool SetMediaVideoLanguagesListRequest::hasVideoLanguageIds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint16 >& SetMediaVideoLanguagesListRequest::getVideoLanguageIds () const {
    return _VideoLanguageIds;
}

inline ::std::vector< uint16 >& SetMediaVideoLanguagesListRequest::getVideoLanguageIdsMutable () {
    set_has_VideoLanguageIds();
    return _VideoLanguageIds;
}

inline void SetMediaVideoLanguagesListRequest::setVideoLanguageIds (const ::std::vector< uint16 >& VideoLanguageIds_) {
    set_has_VideoLanguageIds();
    this->_VideoLanguageIds = VideoLanguageIds_;
}

inline void SetMediaVideoLanguagesListRequest::set_has_SourceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMediaVideoLanguagesListRequest::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetMediaVideoLanguagesListRequest::set_has_Region () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetMediaVideoLanguagesListRequest::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetMediaVideoLanguagesListRequest::set_has_VideoLanguageIds () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetMediaVideoLanguagesListRequest::clear_has_VideoLanguageIds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SetMediaVideoLanguagesListResponse::SetMediaVideoLanguagesListResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetMediaVideoLanguagesListResponse::SetMediaVideoLanguagesListResponse (const SetMediaVideoLanguagesListResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetMediaVideoLanguagesListResponse::SetMediaVideoLanguagesListResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetMediaVideoLanguagesListResponse::~SetMediaVideoLanguagesListResponse() {
}

inline SetMediaVideoLanguagesListResponse& SetMediaVideoLanguagesListResponse::operator = (const SetMediaVideoLanguagesListResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SetMediaVideoLanguagesListResponse::operator == (const SetMediaVideoLanguagesListResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SetMediaVideoLanguagesListResponse::operator != (const SetMediaVideoLanguagesListResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetMediaVideoLanguagesListResponse::operator < (const SetMediaVideoLanguagesListResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetMediaVideoLanguagesListResponse::clone() {
    return new SetMediaVideoLanguagesListResponse(*this);
}

inline bool SetMediaVideoLanguagesListResponse::operator > (const SetMediaVideoLanguagesListResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetMediaVideoLanguagesListResponse::clear() {
    clearResponse();
}

inline void SetMediaVideoLanguagesListResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool SetMediaVideoLanguagesListResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetMediaVideoLanguagesListResponse::getResponse () const {
    return _response;
}

inline void SetMediaVideoLanguagesListResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void SetMediaVideoLanguagesListResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetMediaVideoLanguagesListResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListSizeUpdate::ListSizeUpdate ()  :
    _listSize ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListSizeUpdate::ListSizeUpdate (const ListSizeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _listSize ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListSizeUpdate::ListSizeUpdate (const ListSizeStruct& listSize_)  :
    _listSize (listSize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListSizeUpdate::~ListSizeUpdate() {
}

inline ListSizeUpdate& ListSizeUpdate::operator = (const ListSizeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListSize()) {
            setListSize(rhs.getListSize());
        } else {
            clearListSize();
        }
    }
    return *this;
}

inline bool ListSizeUpdate::operator == (const ListSizeUpdate& rhs) const {
    return (((!hasListSize() && !rhs.hasListSize()) || getListSize() == rhs.getListSize()));
}

inline bool ListSizeUpdate::operator != (const ListSizeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ListSizeUpdate::operator < (const ListSizeUpdate& rhs) const {
    if (hasListSize() || rhs.hasListSize()) {
        if (getListSize() < rhs.getListSize()) return true;
        if (getListSize() > rhs.getListSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListSizeUpdate::clone() {
    return new ListSizeUpdate(*this);
}

inline bool ListSizeUpdate::operator > (const ListSizeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListSizeUpdate::clear() {
    clearListSize();
}

inline void ListSizeUpdate::clearListSize() {
    if (hasListSize()) {
         clear_has_listSize();
        _listSize.clear();
     }
}

inline bool ListSizeUpdate::hasListSize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ListSizeStruct& ListSizeUpdate::getListSize () const {
    return _listSize;
}

inline ListSizeStruct& ListSizeUpdate::getListSizeMutable () {
    set_has_listSize();
    return _listSize;
}

inline void ListSizeUpdate::setListSize (const ListSizeStruct& listSize_) {
    set_has_listSize();
    this->_listSize = listSize_;
}

inline void ListSizeUpdate::set_has_listSize () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListSizeUpdate::clear_has_listSize () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListSizeRegister::ListSizeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListSizeRegister::ListSizeRegister (const ListSizeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListSizeRegister::~ListSizeRegister() {
}

inline ListSizeRegister& ListSizeRegister::operator = (const ListSizeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ListSizeRegister::operator == (const ListSizeRegister& ) const {
    return true;
}

inline bool ListSizeRegister::operator != (const ListSizeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ListSizeRegister::operator < (const ListSizeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ListSizeRegister::clone() {
    return new ListSizeRegister(*this);
}

inline bool ListSizeRegister::operator > (const ListSizeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListSizeRegister::clear() {
}

inline  Sig_DBStateSignal::Sig_DBStateSignal ()  :
    _DownloadState (::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_DBStateSignal::Sig_DBStateSignal (const Sig_DBStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DownloadState (::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_DBStateSignal::Sig_DBStateSignal (entDownloadState DownloadState_, entSourceType SourceType_)  :
    _DownloadState (DownloadState_),
    _SourceType (SourceType_)
{
    #ifndef NDEBUG
    if (!(entDownloadState_IsValid(DownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DownloadState_, "entDownloadState", "DownloadState", "Sig_DBStateSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_DBStateSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_DBStateSignal::~Sig_DBStateSignal() {
}

inline Sig_DBStateSignal& Sig_DBStateSignal::operator = (const Sig_DBStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDownloadState()) {
            setDownloadState(rhs.getDownloadState());
        } else {
            clearDownloadState();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
    }
    return *this;
}

inline bool Sig_DBStateSignal::operator == (const Sig_DBStateSignal& rhs) const {
    return (((!hasDownloadState() && !rhs.hasDownloadState()) || getDownloadState() == rhs.getDownloadState()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()));
}

inline bool Sig_DBStateSignal::operator != (const Sig_DBStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_DBStateSignal::operator < (const Sig_DBStateSignal& rhs) const {
    if (hasDownloadState() || rhs.hasDownloadState()) {
        if ((uint32)getDownloadState() < (uint32)rhs.getDownloadState()) return true;
        if ((uint32)getDownloadState() > (uint32)rhs.getDownloadState()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_DBStateSignal::clone() {
    return new Sig_DBStateSignal(*this);
}

inline bool Sig_DBStateSignal::operator > (const Sig_DBStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_DBStateSignal::clear() {
    clearDownloadState();
    clearSourceType();
}

inline void Sig_DBStateSignal::clearDownloadState() {
    if (hasDownloadState()) {
         clear_has_DownloadState();
        _DownloadState = ::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError;
     }
}

inline bool Sig_DBStateSignal::hasDownloadState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entDownloadState Sig_DBStateSignal::getDownloadState () const {
    return _DownloadState;
}

inline void Sig_DBStateSignal::setDownloadState (entDownloadState DownloadState_) {
    #ifndef NDEBUG
    if (!(entDownloadState_IsValid(DownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DownloadState_, "entDownloadState", "DownloadState", "Sig_DBStateSignal");
    }
    #endif
    set_has_DownloadState();
    this->_DownloadState = DownloadState_;
}

inline void Sig_DBStateSignal::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool Sig_DBStateSignal::hasSourceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entSourceType Sig_DBStateSignal::getSourceType () const {
    return _SourceType;
}

inline void Sig_DBStateSignal::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_DBStateSignal");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void Sig_DBStateSignal::set_has_DownloadState () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_DBStateSignal::clear_has_DownloadState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_DBStateSignal::set_has_SourceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_DBStateSignal::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_AlbumArtStateSignal::Sig_AlbumArtStateSignal ()  :
    _DownloadState (::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError),
    _SongId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_AlbumArtStateSignal::Sig_AlbumArtStateSignal (const Sig_AlbumArtStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DownloadState (::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError),
    _SongId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_AlbumArtStateSignal::Sig_AlbumArtStateSignal (entDownloadState DownloadState_, uint16 SongId_)  :
    _DownloadState (DownloadState_),
    _SongId (SongId_)
{
    #ifndef NDEBUG
    if (!(entDownloadState_IsValid(DownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DownloadState_, "entDownloadState", "DownloadState", "Sig_AlbumArtStateSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_AlbumArtStateSignal::~Sig_AlbumArtStateSignal() {
}

inline Sig_AlbumArtStateSignal& Sig_AlbumArtStateSignal::operator = (const Sig_AlbumArtStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDownloadState()) {
            setDownloadState(rhs.getDownloadState());
        } else {
            clearDownloadState();
        }
        if (rhs.hasSongId()) {
            setSongId(rhs.getSongId());
        } else {
            clearSongId();
        }
    }
    return *this;
}

inline bool Sig_AlbumArtStateSignal::operator == (const Sig_AlbumArtStateSignal& rhs) const {
    return (((!hasDownloadState() && !rhs.hasDownloadState()) || getDownloadState() == rhs.getDownloadState()) &&
        ((!hasSongId() && !rhs.hasSongId()) || getSongId() == rhs.getSongId()));
}

inline bool Sig_AlbumArtStateSignal::operator != (const Sig_AlbumArtStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_AlbumArtStateSignal::operator < (const Sig_AlbumArtStateSignal& rhs) const {
    if (hasDownloadState() || rhs.hasDownloadState()) {
        if ((uint32)getDownloadState() < (uint32)rhs.getDownloadState()) return true;
        if ((uint32)getDownloadState() > (uint32)rhs.getDownloadState()) return false;
    }
    if (hasSongId() || rhs.hasSongId()) {
        if (getSongId() < rhs.getSongId()) return true;
        if (getSongId() > rhs.getSongId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_AlbumArtStateSignal::clone() {
    return new Sig_AlbumArtStateSignal(*this);
}

inline bool Sig_AlbumArtStateSignal::operator > (const Sig_AlbumArtStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_AlbumArtStateSignal::clear() {
    clearDownloadState();
    clearSongId();
}

inline void Sig_AlbumArtStateSignal::clearDownloadState() {
    if (hasDownloadState()) {
         clear_has_DownloadState();
        _DownloadState = ::bosch::cm::di::HmiEmpListInterface::entDownloadState__entDownloadState_DownloadError;
     }
}

inline bool Sig_AlbumArtStateSignal::hasDownloadState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entDownloadState Sig_AlbumArtStateSignal::getDownloadState () const {
    return _DownloadState;
}

inline void Sig_AlbumArtStateSignal::setDownloadState (entDownloadState DownloadState_) {
    #ifndef NDEBUG
    if (!(entDownloadState_IsValid(DownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DownloadState_, "entDownloadState", "DownloadState", "Sig_AlbumArtStateSignal");
    }
    #endif
    set_has_DownloadState();
    this->_DownloadState = DownloadState_;
}

inline void Sig_AlbumArtStateSignal::clearSongId() {
    if (hasSongId()) {
         clear_has_SongId();
        _SongId = 0u;
     }
}

inline bool Sig_AlbumArtStateSignal::hasSongId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 Sig_AlbumArtStateSignal::getSongId () const {
    return _SongId;
}

inline void Sig_AlbumArtStateSignal::setSongId (uint16 SongId_) {
    set_has_SongId();
    this->_SongId = SongId_;
}

inline void Sig_AlbumArtStateSignal::set_has_DownloadState () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_AlbumArtStateSignal::clear_has_DownloadState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_AlbumArtStateSignal::set_has_SongId () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_AlbumArtStateSignal::clear_has_SongId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_PlayableFlagSignal::Sig_PlayableFlagSignal ()  :
    _isPlayableAudio (false),
    _isPlayableVideo (false),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_PlayableFlagSignal::Sig_PlayableFlagSignal (const Sig_PlayableFlagSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _isPlayableAudio (false),
    _isPlayableVideo (false),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_PlayableFlagSignal::Sig_PlayableFlagSignal (bool isPlayableAudio_, bool isPlayableVideo_, entSourceType SourceType_)  :
    _isPlayableAudio (isPlayableAudio_),
    _isPlayableVideo (isPlayableVideo_),
    _SourceType (SourceType_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_PlayableFlagSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_PlayableFlagSignal::~Sig_PlayableFlagSignal() {
}

inline Sig_PlayableFlagSignal& Sig_PlayableFlagSignal::operator = (const Sig_PlayableFlagSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIsPlayableAudio()) {
            setIsPlayableAudio(rhs.getIsPlayableAudio());
        } else {
            clearIsPlayableAudio();
        }
        if (rhs.hasIsPlayableVideo()) {
            setIsPlayableVideo(rhs.getIsPlayableVideo());
        } else {
            clearIsPlayableVideo();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
    }
    return *this;
}

inline bool Sig_PlayableFlagSignal::operator == (const Sig_PlayableFlagSignal& rhs) const {
    return (((!hasIsPlayableAudio() && !rhs.hasIsPlayableAudio()) || getIsPlayableAudio() == rhs.getIsPlayableAudio()) &&
        ((!hasIsPlayableVideo() && !rhs.hasIsPlayableVideo()) || getIsPlayableVideo() == rhs.getIsPlayableVideo()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()));
}

inline bool Sig_PlayableFlagSignal::operator != (const Sig_PlayableFlagSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_PlayableFlagSignal::operator < (const Sig_PlayableFlagSignal& rhs) const {
    if (hasIsPlayableAudio() || rhs.hasIsPlayableAudio()) {
        if (getIsPlayableAudio() < rhs.getIsPlayableAudio()) return true;
        if (getIsPlayableAudio() > rhs.getIsPlayableAudio()) return false;
    }
    if (hasIsPlayableVideo() || rhs.hasIsPlayableVideo()) {
        if (getIsPlayableVideo() < rhs.getIsPlayableVideo()) return true;
        if (getIsPlayableVideo() > rhs.getIsPlayableVideo()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_PlayableFlagSignal::clone() {
    return new Sig_PlayableFlagSignal(*this);
}

inline bool Sig_PlayableFlagSignal::operator > (const Sig_PlayableFlagSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_PlayableFlagSignal::clear() {
    clearIsPlayableAudio();
    clearIsPlayableVideo();
    clearSourceType();
}

inline void Sig_PlayableFlagSignal::clearIsPlayableAudio() {
    if (hasIsPlayableAudio()) {
         clear_has_isPlayableAudio();
        _isPlayableAudio = false;
     }
}

inline bool Sig_PlayableFlagSignal::hasIsPlayableAudio () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_PlayableFlagSignal::getIsPlayableAudio () const {
    return _isPlayableAudio;
}

inline void Sig_PlayableFlagSignal::setIsPlayableAudio (bool isPlayableAudio_) {
    set_has_isPlayableAudio();
    this->_isPlayableAudio = isPlayableAudio_;
}

inline void Sig_PlayableFlagSignal::clearIsPlayableVideo() {
    if (hasIsPlayableVideo()) {
         clear_has_isPlayableVideo();
        _isPlayableVideo = false;
     }
}

inline bool Sig_PlayableFlagSignal::hasIsPlayableVideo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Sig_PlayableFlagSignal::getIsPlayableVideo () const {
    return _isPlayableVideo;
}

inline void Sig_PlayableFlagSignal::setIsPlayableVideo (bool isPlayableVideo_) {
    set_has_isPlayableVideo();
    this->_isPlayableVideo = isPlayableVideo_;
}

inline void Sig_PlayableFlagSignal::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool Sig_PlayableFlagSignal::hasSourceType () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline entSourceType Sig_PlayableFlagSignal::getSourceType () const {
    return _SourceType;
}

inline void Sig_PlayableFlagSignal::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_PlayableFlagSignal");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void Sig_PlayableFlagSignal::set_has_isPlayableAudio () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_PlayableFlagSignal::clear_has_isPlayableAudio () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_PlayableFlagSignal::set_has_isPlayableVideo () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_PlayableFlagSignal::clear_has_isPlayableVideo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_PlayableFlagSignal::set_has_SourceType () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_PlayableFlagSignal::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_CurrentTrackInfoSignal::Sig_CurrentTrackInfoSignal ()  :
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _Region (0u),
    _SongId (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_CurrentTrackInfoSignal::Sig_CurrentTrackInfoSignal (const Sig_CurrentTrackInfoSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _SourceType (::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT),
    _ListType (::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre),
    _Region (0u),
    _SongId (0u),
    _FolderPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_CurrentTrackInfoSignal::Sig_CurrentTrackInfoSignal (entSourceType SourceType_, entListType ListType_, uint8 Region_, uint16 SongId_, const ::std::string& FolderPath_)  :
    _SourceType (SourceType_),
    _ListType (ListType_),
    _Region (Region_),
    _SongId (SongId_),
    _FolderPath (FolderPath_)
{
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_CurrentTrackInfoSignal");
    }
    #endif
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "Sig_CurrentTrackInfoSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_CurrentTrackInfoSignal::~Sig_CurrentTrackInfoSignal() {
}

inline Sig_CurrentTrackInfoSignal& Sig_CurrentTrackInfoSignal::operator = (const Sig_CurrentTrackInfoSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
        if (rhs.hasListType()) {
            setListType(rhs.getListType());
        } else {
            clearListType();
        }
        if (rhs.hasRegion()) {
            setRegion(rhs.getRegion());
        } else {
            clearRegion();
        }
        if (rhs.hasSongId()) {
            setSongId(rhs.getSongId());
        } else {
            clearSongId();
        }
        if (rhs.hasFolderPath()) {
            setFolderPath(rhs.getFolderPath());
        } else {
            clearFolderPath();
        }
    }
    return *this;
}

inline bool Sig_CurrentTrackInfoSignal::operator == (const Sig_CurrentTrackInfoSignal& rhs) const {
    return (((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()) &&
        ((!hasListType() && !rhs.hasListType()) || getListType() == rhs.getListType()) &&
        ((!hasRegion() && !rhs.hasRegion()) || getRegion() == rhs.getRegion()) &&
        ((!hasSongId() && !rhs.hasSongId()) || getSongId() == rhs.getSongId()) &&
        ((!hasFolderPath() && !rhs.hasFolderPath()) || getFolderPath() == rhs.getFolderPath()));
}

inline bool Sig_CurrentTrackInfoSignal::operator != (const Sig_CurrentTrackInfoSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_CurrentTrackInfoSignal::operator < (const Sig_CurrentTrackInfoSignal& rhs) const {
    if (hasSourceType() || rhs.hasSourceType()) {
        if ((uint32)getSourceType() < (uint32)rhs.getSourceType()) return true;
        if ((uint32)getSourceType() > (uint32)rhs.getSourceType()) return false;
    }
    if (hasListType() || rhs.hasListType()) {
        if ((uint32)getListType() < (uint32)rhs.getListType()) return true;
        if ((uint32)getListType() > (uint32)rhs.getListType()) return false;
    }
    if (hasRegion() || rhs.hasRegion()) {
        if (getRegion() < rhs.getRegion()) return true;
        if (getRegion() > rhs.getRegion()) return false;
    }
    if (hasSongId() || rhs.hasSongId()) {
        if (getSongId() < rhs.getSongId()) return true;
        if (getSongId() > rhs.getSongId()) return false;
    }
    if (hasFolderPath() || rhs.hasFolderPath()) {
        if (getFolderPath() < rhs.getFolderPath()) return true;
        if (getFolderPath() > rhs.getFolderPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_CurrentTrackInfoSignal::clone() {
    return new Sig_CurrentTrackInfoSignal(*this);
}

inline bool Sig_CurrentTrackInfoSignal::operator > (const Sig_CurrentTrackInfoSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_CurrentTrackInfoSignal::clear() {
    clearSourceType();
    clearListType();
    clearRegion();
    clearSongId();
    clearFolderPath();
}

inline void Sig_CurrentTrackInfoSignal::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = ::bosch::cm::di::HmiEmpListInterface::entSourceType__entSourceType_DEFAULT;
     }
}

inline bool Sig_CurrentTrackInfoSignal::hasSourceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline entSourceType Sig_CurrentTrackInfoSignal::getSourceType () const {
    return _SourceType;
}

inline void Sig_CurrentTrackInfoSignal::setSourceType (entSourceType SourceType_) {
    #ifndef NDEBUG
    if (!(entSourceType_IsValid(SourceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SourceType_, "entSourceType", "SourceType", "Sig_CurrentTrackInfoSignal");
    }
    #endif
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void Sig_CurrentTrackInfoSignal::clearListType() {
    if (hasListType()) {
         clear_has_ListType();
        _ListType = ::bosch::cm::di::HmiEmpListInterface::entListType__entListType_Genre;
     }
}

inline bool Sig_CurrentTrackInfoSignal::hasListType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline entListType Sig_CurrentTrackInfoSignal::getListType () const {
    return _ListType;
}

inline void Sig_CurrentTrackInfoSignal::setListType (entListType ListType_) {
    #ifndef NDEBUG
    if (!(entListType_IsValid(ListType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ListType_, "entListType", "ListType", "Sig_CurrentTrackInfoSignal");
    }
    #endif
    set_has_ListType();
    this->_ListType = ListType_;
}

inline void Sig_CurrentTrackInfoSignal::clearRegion() {
    if (hasRegion()) {
         clear_has_Region();
        _Region = 0u;
     }
}

inline bool Sig_CurrentTrackInfoSignal::hasRegion () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Sig_CurrentTrackInfoSignal::getRegion () const {
    return _Region;
}

inline void Sig_CurrentTrackInfoSignal::setRegion (uint8 Region_) {
    set_has_Region();
    this->_Region = Region_;
}

inline void Sig_CurrentTrackInfoSignal::clearSongId() {
    if (hasSongId()) {
         clear_has_SongId();
        _SongId = 0u;
     }
}

inline bool Sig_CurrentTrackInfoSignal::hasSongId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_CurrentTrackInfoSignal::getSongId () const {
    return _SongId;
}

inline void Sig_CurrentTrackInfoSignal::setSongId (uint16 SongId_) {
    set_has_SongId();
    this->_SongId = SongId_;
}

inline void Sig_CurrentTrackInfoSignal::clearFolderPath() {
    if (hasFolderPath()) {
         clear_has_FolderPath();
        _FolderPath.clear();
     }
}

inline bool Sig_CurrentTrackInfoSignal::hasFolderPath () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& Sig_CurrentTrackInfoSignal::getFolderPath () const {
    return _FolderPath;
}

inline ::std::string& Sig_CurrentTrackInfoSignal::getFolderPathMutable () {
    set_has_FolderPath();
    return _FolderPath;
}

inline void Sig_CurrentTrackInfoSignal::setFolderPath (const ::std::string& FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath = FolderPath_;
}

inline void Sig_CurrentTrackInfoSignal::setFolderPath (const char* FolderPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FolderPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(FolderPath_);
}

inline void Sig_CurrentTrackInfoSignal::setFolderPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FolderPath();
    this->_FolderPath.assign(value, size);
}

inline void Sig_CurrentTrackInfoSignal::set_has_SourceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_CurrentTrackInfoSignal::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_CurrentTrackInfoSignal::set_has_ListType () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_CurrentTrackInfoSignal::clear_has_ListType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_CurrentTrackInfoSignal::set_has_Region () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_CurrentTrackInfoSignal::clear_has_Region () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_CurrentTrackInfoSignal::set_has_SongId () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_CurrentTrackInfoSignal::clear_has_SongId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_CurrentTrackInfoSignal::set_has_FolderPath () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_CurrentTrackInfoSignal::clear_has_FolderPath () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_HMIEMPLISTINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
