/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERPROXY_H
#define COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERPROXY_H

#include "CourierTunnelService/CourierMessageReceiverJson.h"
#include "CourierTunnelService/CourierMessageReceiverProxyStreamerCmsBin.h"
#include "CourierTunnelService/CourierMessageReceiverProxyStreamerJson.h"
#include "asf/cms/CmsProxyDelegate.h"
#include "asf/cms/CmsTypesJson.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"

namespace CourierTunnelService {
namespace CourierMessageReceiver {

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 */



class CourierMessageReceiverProxy;

class CourierMessageReceiverClientBase
{
public:

    virtual ~CourierMessageReceiverClientBase() {}


private:

    DECLARE_CLASS_LOGGER();
};

/**
 * CourierMessageReceiverProxy is the client side representation of the
 * 'CourierMessageReceiver' Car Multimedia Service. The interface is
 * specified in the file 'CourierMessageReceiver.cms'.
 */
class CourierMessageReceiverProxy : public ::asf::cms::CmsProxy
{
public:

    /**
     * Create a new instance of CourierMessageReceiverProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description. Additionally it is necessary to pass a reference on a
     * implementation of the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< CourierMessageReceiverProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of CourierMessageReceiverProxy. The caller has to
     * pass the port name and the address of the service (e.g.
     * cms-json://localhost:12345). It is only possible to use this function
     * if the port is defined in the CMC model as "wired at runtime"-port.
     * Additionally it is necessary to pass a reference on a implementation of
     * the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< CourierMessageReceiverProxy > createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of CourierMessageReceiverProxy. The destructor will send
     * messages for all existing property notifications. Additionally it will
     * call the error callback of all pending method invocations.
     */
    virtual ~CourierMessageReceiverProxy();

    // Request 'receiveCourierMessage'

    /**
     * Call the Request 'receiveCourierMessage'. This method sends a Request
     * message to the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'receiveCourierMessage'</b>:
     *
     * Sends a courier message from the client to the service provider
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReceiveCourierMessageRequest();

    ::asf::cms::CmsServiceStreamer* getStreamer();

private:

    CourierMessageReceiverProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);


    CourierMessageReceiverProxyStreamerJson _streamerJson;

    CourierMessageReceiverProxyStreamerCmsBin _streamerCmsBin;

    DECLARE_CLASS_LOGGER();
};

} // namespace CourierMessageReceiver
} // namespace CourierTunnelService

#endif // COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERPROXY_H
