/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGERSTUB_H
#define NET_CONNMAN_MANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Manager.h"
#include <string>
#include <vector>

namespace net {
namespace connman {
namespace Manager {

class ManagerStubDelegate;

class ManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ManagerStub (const std::string& portName);

    /**
     * Create an instance of the ManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ManagerStub();

    // signal 'ServicesChanged'

    /**
     * Raise the signal 'ServicesChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     */
    void sendServicesChangedSignal(const ::std::vector< ServicesChangedSignalChangedStruct >& changed, const ::std::vector< ::std::string >& removed);

    // method 'CreateSession'

    /**
     * The method onCreateSession() is called by ASF when a client invokes the
     * method 'CreateSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendCreateSession()
     * or sendCreateSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateSessionRequest (const ::boost::shared_ptr< CreateSessionRequest >& request) = 0;

    /**
     * The method sendCreateSessionResponse() sends a response of a previous
     * method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateSessionResponse (const ::std::string& session, act_t act = 0);

    /**
     * The method sendCreateSessionError() sends an error response of a
     * previous method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DestroySession'

    /**
     * The method onDestroySession() is called by ASF when a client invokes
     * the method 'DestroySession'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDestroySession() or sendDestroySessionError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDestroySessionRequest (const ::boost::shared_ptr< DestroySessionRequest >& request) = 0;

    /**
     * The method sendDestroySessionResponse() sends a response of a previous
     * method invocation of 'DestroySession' back to the client.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDestroySession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDestroySessionResponse (act_t act = 0);

    /**
     * The method sendDestroySessionError() sends an error response of a
     * previous method invocation of 'DestroySession' back to the client.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDestroySession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDestroySessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGERSTUB_H
