/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigManagement.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementConst.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementDBus.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementJson.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigManagement {

DEFINE_CLASS_LOGGER("/de/bosch/cm/ConfigManager/de/bosch/cm/ConfigManager/ConfigManagement", ConfigManagementStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "getPublicItem", 5 },
    { 13, "setPublicItem", 4 },
    { 18, "RegisterPublicItem", 2 },
    { 19, "RegisterPrivateItem", 0 },
    { 20, "UnregisterPublicItem", 3 },
    { 21, "UnregisterPrivateItem", 1 },
};


class ConfigManagementStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ConfigManagementStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ConfigManagementStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ConfigManagementStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "de.bosch.cm.ConfigManager.ConfigManagement"),
          _logger(logger) {}

    virtual ~ConfigManagementStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ConfigManagementStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'RegisterPrivateItem'

            LOG_DEBUG_STUB("process method '%s'", "RegisterPrivateItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPrivateItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterPrivateItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterPrivateItemRequest > payload = ::boost::static_pointer_cast<RegisterPrivateItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onRegisterPrivateItemRequest(payload);
            return;
        }
        case 1: {

            // method 'UnregisterPrivateItem'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterPrivateItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPrivateItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterPrivateItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterPrivateItemRequest > payload = ::boost::static_pointer_cast<UnregisterPrivateItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onUnregisterPrivateItemRequest(payload);
            return;
        }
        case 2: {

            // method 'RegisterPublicItem'

            LOG_DEBUG_STUB("process method '%s'", "RegisterPublicItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPublicItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterPublicItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterPublicItemRequest > payload = ::boost::static_pointer_cast<RegisterPublicItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onRegisterPublicItemRequest(payload);
            return;
        }
        case 3: {

            // method 'UnregisterPublicItem'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterPublicItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPublicItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterPublicItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterPublicItemRequest > payload = ::boost::static_pointer_cast<UnregisterPublicItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onUnregisterPublicItemRequest(payload);
            return;
        }
        case 4: {

            // method 'setPublicItem'

            LOG_DEBUG_STUB("process method '%s'", "setPublicItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPublicItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetPublicItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPublicItemRequest > payload = ::boost::static_pointer_cast<SetPublicItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onSetPublicItemRequest(payload);
            return;
        }
        case 5: {

            // method 'getPublicItem'

            LOG_DEBUG_STUB("process method '%s'", "getPublicItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPublicItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPublicItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPublicItemRequest > payload = ::boost::static_pointer_cast<GetPublicItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigManagementStub*>(getStub())->onGetPublicItemRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ConfigManagementStubDelegate::introspect() const {
    return     "<interface name=\"de.bosch.cm.ConfigManager.ConfigManagement\">\n"
            "    <method name=\"RegisterPrivateItem\">\n"
            "      <doc>\n"
            "        <line>RegisterPrivateItem = Method to register an application in CfgMgr for private config items.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"privateItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemName = is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"clientDBusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientDBusName = is the Name of DBUS used for proxy creation for a particular component</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"dataFormat\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>dataFormat (of type EnItemFormats) = requested data format [Default, XML, ...]</line>\n"
            "          <line>enum[Default (0x00), XML (0x01)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status = return result of register operation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnregisterPrivateItem\">\n"
            "      <doc>\n"
            "        <line>UnregisterPrivateItem = Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.</line>\n"
            "        <line>Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional</line>\n"
            "        <line>unregistrations by others clients, as they first need to know the dbus name.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"privateItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemName = is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"clientDBusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientDBusName = is the Name of DBUS used for proxy creation for a particular component</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status = return result of unregister operation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RegisterPublicItem\">\n"
            "      <doc>\n"
            "        <line>RegisterPublicItem = Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"publicItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>publicItemName = is the generic configuration data that applications are interested in</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"clientDBusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientDBusName = is the Name of DBUS used for proxy creation for a particular component</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"dataFormat\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>dataFormat (of type EnItemFormats) = requested data format [Default, ...]. At the moment, only &quot;default&quot; is supported.</line>\n"
            "          <line>enum[Default (0x00), XML (0x01)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status = return result of register operation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UnregisterPublicItem\">\n"
            "      <doc>\n"
            "        <line>UnregisterPublicItem = Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"publicItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>publicItemName = is the generic configuration data that applications are interested in</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"clientDBusName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientDBusName = is the Name of DBUS used for proxy creation for a particular component</line>\n"
            "          <line>Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional</line>\n"
            "          <line>unregistrations by others clients, as they first need to know the dbus name.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status = return result of unregister operation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setPublicItem\">\n"
            "      <doc>\n"
            "        <line>setPublicItem = Method for HMI to update the local public items in config manager (ex: privacy mode).</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"publicItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>publicItemName = is the generic configuration data got from HMI</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"publicItem\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>publicItem (of type ConfigItem) = is an array of (key,value) pairs obtained for the respective SettingsGroupName</line>\n"
            "          <line>ConfigItem = array[ConfigData]</line>\n"
            "          <line>ConfigData struct[key, value] = Struct PrivateData contains key value pair for one application</line>\n"
            "          <line>0: ConfigData.key ('s') = Description missing</line>\n"
            "          <line>1: ConfigData.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemStatus) = return result of operation</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getPublicItem\">\n"
            "      <doc>\n"
            "        <line>getPublicItem = Method for Applications to get Public configuration data from ConfigManager.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"publicItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>publicItemName = is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"publicItem\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>publicItem (of type ConfigItem) = is an array of (key,value) pairs obtained for the respective SettingsGroupName</line>\n"
            "          <line>ConfigItem = array[ConfigData]</line>\n"
            "          <line>ConfigData struct[key, value] = Struct PrivateData contains key value pair for one application</line>\n"
            "          <line>0: ConfigData.key ('s') = Description missing</line>\n"
            "          <line>1: ConfigData.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemStatus) = return result of operation</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void ConfigManagementStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ConfigManagementStub*>(getStub()))->onGetAll (properties);
}

void ConfigManagementStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ConfigManagementStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ConfigManagementStub::ConfigManagementStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConfigManagementStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConfigManagementStub::ConfigManagementStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConfigManagementStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConfigManagementStub::~ConfigManagementStub() {
    delete _stubDelegate;
}

void  ConfigManagementStub::sendRegisterPrivateItemResponse (EnRegisterStatus status, act_t act) {
    RegisterPrivateItemResponse* payload = new RegisterPrivateItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterPrivateItem", RegisterPrivateItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendRegisterPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterPrivateItemError* payload = new RegisterPrivateItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterPrivateItem", RegisterPrivateItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendUnregisterPrivateItemResponse (EnRegisterStatus status, act_t act) {
    UnregisterPrivateItemResponse* payload = new UnregisterPrivateItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterPrivateItem", UnregisterPrivateItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendUnregisterPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterPrivateItemError* payload = new UnregisterPrivateItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterPrivateItem", UnregisterPrivateItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendRegisterPublicItemResponse (EnRegisterStatus status, act_t act) {
    RegisterPublicItemResponse* payload = new RegisterPublicItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterPublicItem", RegisterPublicItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendRegisterPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterPublicItemError* payload = new RegisterPublicItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterPublicItem", RegisterPublicItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendUnregisterPublicItemResponse (EnRegisterStatus status, act_t act) {
    UnregisterPublicItemResponse* payload = new UnregisterPublicItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterPublicItem", UnregisterPublicItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendUnregisterPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterPublicItemError* payload = new UnregisterPublicItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterPublicItem", UnregisterPublicItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendSetPublicItemResponse (EnItemStatus status, act_t act) {
    SetPublicItemResponse* payload = new SetPublicItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "setPublicItem", SetPublicItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendSetPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPublicItemError* payload = new SetPublicItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setPublicItem", SetPublicItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendGetPublicItemResponse (const ::std::vector< ConfigData >& publicItem, EnItemStatus status, act_t act) {
    GetPublicItemResponse* payload = new GetPublicItemResponse(publicItem, status);
    DBUS_MESSAGE_REPLY(dbusMessage, "getPublicItem", GetPublicItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigManagementStub::sendGetPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPublicItemError* payload = new GetPublicItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getPublicItem", GetPublicItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetPublicItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ConfigManagementStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace ConfigManagement
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de
