#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENT_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * This is the configuration manager control interface. It allows other applications (clients) to un-/register for properties and set/get of
 * 	public config items, handled by config manager.
 */

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigManagement {

// method IDs
static const uint16 ID_RegisterPrivateItem = 0;
static const uint16 ID_UnregisterPrivateItem = 1;
static const uint16 ID_RegisterPublicItem = 2;
static const uint16 ID_UnregisterPublicItem = 3;
static const uint16 ID_setPublicItem = 4;
static const uint16 ID_getPublicItem = 5;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class ConfigData;

class RegisterPrivateItemRequest;

class RegisterPrivateItemResponse;

class UnregisterPrivateItemRequest;

class UnregisterPrivateItemResponse;

class RegisterPublicItemRequest;

class RegisterPublicItemResponse;

class UnregisterPublicItemRequest;

class UnregisterPublicItemResponse;

class SetPublicItemRequest;

class SetPublicItemResponse;

class GetPublicItemRequest;

class GetPublicItemResponse;

// type definitions
/**
 * If the meaning of "RegisterPrivateItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterPrivateItemError;

/**
 * If the meaning of "UnregisterPrivateItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterPrivateItemError;

/**
 * If the meaning of "RegisterPublicItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RegisterPublicItemError;

/**
 * If the meaning of "UnregisterPublicItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnregisterPublicItemError;

/**
 * If the meaning of "SetPublicItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPublicItemError;

/**
 * If the meaning of "GetPublicItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPublicItemError;


/**
 * Struct PrivateData contains key value pair for one application
 */
class ConfigData {
public:

    /**
     * Default constructor
     */
    inline  ConfigData ();

    /**
     * Copy constructor
     */
    inline  ConfigData (const ConfigData &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigData (const ::std::string& key_, const ::std::string& value_);

    /**
     * Destructor
     */
    inline  ~ConfigData();

    /**
     * Assignment operator
     */
    inline ConfigData& operator = (const ConfigData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "key"

    static const int kKey = 0;

    /**
     * Clears the field "key".
     *
     * The field will be set to its default value. The hasKey()
     * method will return false.
     */
    inline void clearKey();

    /**
     * Checks whether the field "key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKey()). Otherwise it will return false.
     */
    inline bool hasKey () const;

    /**
     * Returns the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @return The value of the field "key"
     */
    inline const ::std::string& getKey () const;

    /**
     * Retrieves the value of the field "key" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "key".
     */
    inline ::std::string& getKeyMutable ();

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const ::std::string& key_);

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* key_);

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::std::string& value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const ConfigData &getDefaultInstance();

private:

    inline void set_has_key ();

    inline void clear_has_key ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _key;

    ::std::string _value;

};

/**
 * Method to register an application in CfgMgr for private config items.
 */
class RegisterPrivateItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterPrivateItemRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterPrivateItemRequest (const RegisterPrivateItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterPrivateItemRequest (const ::std::string& privateItemName_, const ::std::string& clientDBusName_, EnItemFormats dataFormat_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterPrivateItemRequest();

    /**
     * Assignment operator
     */
    inline RegisterPrivateItemRequest& operator = (const RegisterPrivateItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterPrivateItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterPrivateItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterPrivateItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterPrivateItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItemName"

    static const int kPrivateItemName = 0;

    /**
     * Clears the field "privateItemName".
     *
     * The field will be set to its default value. The hasPrivateItemName()
     * method will return false.
     */
    inline void clearPrivateItemName();

    /**
     * Checks whether the field "privateItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemName()). Otherwise it will return false.
     */
    inline bool hasPrivateItemName () const;

    /**
     * Returns the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @return The value of the field "privateItemName"
     */
    inline const ::std::string& getPrivateItemName () const;

    /**
     * Retrieves the value of the field "privateItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemName".
     */
    inline ::std::string& getPrivateItemNameMutable ();

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const ::std::string& privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* value, size_t size);

    // API of field "clientDBusName"

    static const int kClientDBusName = 1;

    /**
     * Clears the field "clientDBusName".
     *
     * The field will be set to its default value. The hasClientDBusName()
     * method will return false.
     */
    inline void clearClientDBusName();

    /**
     * Checks whether the field "clientDBusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientDBusName()). Otherwise it will return false.
     */
    inline bool hasClientDBusName () const;

    /**
     * Returns the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @return The value of the field "clientDBusName"
     */
    inline const ::std::string& getClientDBusName () const;

    /**
     * Retrieves the value of the field "clientDBusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientDBusName".
     */
    inline ::std::string& getClientDBusNameMutable ();

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const ::std::string& clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* value, size_t size);

    // API of field "dataFormat"

    static const int kDataFormat = 2;

    /**
     * Clears the field "dataFormat".
     *
     * The field will be set to its default value. The hasDataFormat()
     * method will return false.
     */
    inline void clearDataFormat();

    /**
     * Checks whether the field "dataFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataFormat()). Otherwise it will return false.
     */
    inline bool hasDataFormat () const;

    /**
     * Returns the value of the member "dataFormat".
     *
     * requested data format [Default, XML, ...]
     *
     * @return The value of the field "dataFormat"
     */
    inline EnItemFormats getDataFormat () const;

    /**
     * Sets the value of the member "dataFormat".
     *
     * requested data format [Default, XML, ...]
     *
     * @param dataFormat The value which will be set
     */
    inline void setDataFormat (EnItemFormats dataFormat_);

    static const RegisterPrivateItemRequest &getDefaultInstance();

private:

    inline void set_has_privateItemName ();

    inline void clear_has_privateItemName ();

    inline void set_has_clientDBusName ();

    inline void clear_has_clientDBusName ();

    inline void set_has_dataFormat ();

    inline void clear_has_dataFormat ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _privateItemName;

    ::std::string _clientDBusName;

    EnItemFormats _dataFormat;

};

/**
 * Method to register an application in CfgMgr for private config items.
 */
class RegisterPrivateItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterPrivateItemResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterPrivateItemResponse (const RegisterPrivateItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterPrivateItemResponse (EnRegisterStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterPrivateItemResponse();

    /**
     * Assignment operator
     */
    inline RegisterPrivateItemResponse& operator = (const RegisterPrivateItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterPrivateItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterPrivateItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterPrivateItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterPrivateItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of register operation
     *
     * @return The value of the field "status"
     */
    inline EnRegisterStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of register operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnRegisterStatus status_);

    static const RegisterPrivateItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnRegisterStatus _status;

};

/**
 * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
 * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
 * 				   unregistrations by others clients, as they first need to know the dbus name.
 */
class UnregisterPrivateItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterPrivateItemRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterPrivateItemRequest (const UnregisterPrivateItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterPrivateItemRequest (const ::std::string& privateItemName_, const ::std::string& clientDBusName_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterPrivateItemRequest();

    /**
     * Assignment operator
     */
    inline UnregisterPrivateItemRequest& operator = (const UnregisterPrivateItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterPrivateItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterPrivateItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterPrivateItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterPrivateItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItemName"

    static const int kPrivateItemName = 0;

    /**
     * Clears the field "privateItemName".
     *
     * The field will be set to its default value. The hasPrivateItemName()
     * method will return false.
     */
    inline void clearPrivateItemName();

    /**
     * Checks whether the field "privateItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemName()). Otherwise it will return false.
     */
    inline bool hasPrivateItemName () const;

    /**
     * Returns the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @return The value of the field "privateItemName"
     */
    inline const ::std::string& getPrivateItemName () const;

    /**
     * Retrieves the value of the field "privateItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemName".
     */
    inline ::std::string& getPrivateItemNameMutable ();

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const ::std::string& privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* value, size_t size);

    // API of field "clientDBusName"

    static const int kClientDBusName = 1;

    /**
     * Clears the field "clientDBusName".
     *
     * The field will be set to its default value. The hasClientDBusName()
     * method will return false.
     */
    inline void clearClientDBusName();

    /**
     * Checks whether the field "clientDBusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientDBusName()). Otherwise it will return false.
     */
    inline bool hasClientDBusName () const;

    /**
     * Returns the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @return The value of the field "clientDBusName"
     */
    inline const ::std::string& getClientDBusName () const;

    /**
     * Retrieves the value of the field "clientDBusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientDBusName".
     */
    inline ::std::string& getClientDBusNameMutable ();

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const ::std::string& clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* value, size_t size);

    static const UnregisterPrivateItemRequest &getDefaultInstance();

private:

    inline void set_has_privateItemName ();

    inline void clear_has_privateItemName ();

    inline void set_has_clientDBusName ();

    inline void clear_has_clientDBusName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _privateItemName;

    ::std::string _clientDBusName;

};

/**
 * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
 * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
 * 				   unregistrations by others clients, as they first need to know the dbus name.
 */
class UnregisterPrivateItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterPrivateItemResponse ();

    /**
     * Copy constructor
     */
    inline  UnregisterPrivateItemResponse (const UnregisterPrivateItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterPrivateItemResponse (EnRegisterStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterPrivateItemResponse();

    /**
     * Assignment operator
     */
    inline UnregisterPrivateItemResponse& operator = (const UnregisterPrivateItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterPrivateItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterPrivateItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterPrivateItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterPrivateItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of unregister operation
     *
     * @return The value of the field "status"
     */
    inline EnRegisterStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of unregister operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnRegisterStatus status_);

    static const UnregisterPrivateItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnRegisterStatus _status;

};

/**
 * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
 */
class RegisterPublicItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterPublicItemRequest ();

    /**
     * Copy constructor
     */
    inline  RegisterPublicItemRequest (const RegisterPublicItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterPublicItemRequest (const ::std::string& publicItemName_, const ::std::string& clientDBusName_, EnItemFormats dataFormat_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterPublicItemRequest();

    /**
     * Assignment operator
     */
    inline RegisterPublicItemRequest& operator = (const RegisterPublicItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterPublicItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterPublicItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterPublicItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterPublicItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItemName"

    static const int kPublicItemName = 0;

    /**
     * Clears the field "publicItemName".
     *
     * The field will be set to its default value. The hasPublicItemName()
     * method will return false.
     */
    inline void clearPublicItemName();

    /**
     * Checks whether the field "publicItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItemName()). Otherwise it will return false.
     */
    inline bool hasPublicItemName () const;

    /**
     * Returns the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @return The value of the field "publicItemName"
     */
    inline const ::std::string& getPublicItemName () const;

    /**
     * Retrieves the value of the field "publicItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItemName".
     */
    inline ::std::string& getPublicItemNameMutable ();

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const ::std::string& publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* value, size_t size);

    // API of field "clientDBusName"

    static const int kClientDBusName = 1;

    /**
     * Clears the field "clientDBusName".
     *
     * The field will be set to its default value. The hasClientDBusName()
     * method will return false.
     */
    inline void clearClientDBusName();

    /**
     * Checks whether the field "clientDBusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientDBusName()). Otherwise it will return false.
     */
    inline bool hasClientDBusName () const;

    /**
     * Returns the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @return The value of the field "clientDBusName"
     */
    inline const ::std::string& getClientDBusName () const;

    /**
     * Retrieves the value of the field "clientDBusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientDBusName".
     */
    inline ::std::string& getClientDBusNameMutable ();

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const ::std::string& clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* value, size_t size);

    // API of field "dataFormat"

    static const int kDataFormat = 2;

    /**
     * Clears the field "dataFormat".
     *
     * The field will be set to its default value. The hasDataFormat()
     * method will return false.
     */
    inline void clearDataFormat();

    /**
     * Checks whether the field "dataFormat" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataFormat()). Otherwise it will return false.
     */
    inline bool hasDataFormat () const;

    /**
     * Returns the value of the member "dataFormat".
     *
     * requested data format [Default, ...]. At the moment, only "default" is supported.
     *
     * @return The value of the field "dataFormat"
     */
    inline EnItemFormats getDataFormat () const;

    /**
     * Sets the value of the member "dataFormat".
     *
     * requested data format [Default, ...]. At the moment, only "default" is supported.
     *
     * @param dataFormat The value which will be set
     */
    inline void setDataFormat (EnItemFormats dataFormat_);

    static const RegisterPublicItemRequest &getDefaultInstance();

private:

    inline void set_has_publicItemName ();

    inline void clear_has_publicItemName ();

    inline void set_has_clientDBusName ();

    inline void clear_has_clientDBusName ();

    inline void set_has_dataFormat ();

    inline void clear_has_dataFormat ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _publicItemName;

    ::std::string _clientDBusName;

    EnItemFormats _dataFormat;

};

/**
 * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
 */
class RegisterPublicItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RegisterPublicItemResponse ();

    /**
     * Copy constructor
     */
    inline  RegisterPublicItemResponse (const RegisterPublicItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RegisterPublicItemResponse (EnRegisterStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~RegisterPublicItemResponse();

    /**
     * Assignment operator
     */
    inline RegisterPublicItemResponse& operator = (const RegisterPublicItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegisterPublicItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegisterPublicItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegisterPublicItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegisterPublicItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of register operation
     *
     * @return The value of the field "status"
     */
    inline EnRegisterStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of register operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnRegisterStatus status_);

    static const RegisterPublicItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnRegisterStatus _status;

};

/**
 * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
 */
class UnregisterPublicItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterPublicItemRequest ();

    /**
     * Copy constructor
     */
    inline  UnregisterPublicItemRequest (const UnregisterPublicItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterPublicItemRequest (const ::std::string& publicItemName_, const ::std::string& clientDBusName_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterPublicItemRequest();

    /**
     * Assignment operator
     */
    inline UnregisterPublicItemRequest& operator = (const UnregisterPublicItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterPublicItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterPublicItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterPublicItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterPublicItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItemName"

    static const int kPublicItemName = 0;

    /**
     * Clears the field "publicItemName".
     *
     * The field will be set to its default value. The hasPublicItemName()
     * method will return false.
     */
    inline void clearPublicItemName();

    /**
     * Checks whether the field "publicItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItemName()). Otherwise it will return false.
     */
    inline bool hasPublicItemName () const;

    /**
     * Returns the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @return The value of the field "publicItemName"
     */
    inline const ::std::string& getPublicItemName () const;

    /**
     * Retrieves the value of the field "publicItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItemName".
     */
    inline ::std::string& getPublicItemNameMutable ();

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const ::std::string& publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* value, size_t size);

    // API of field "clientDBusName"

    static const int kClientDBusName = 1;

    /**
     * Clears the field "clientDBusName".
     *
     * The field will be set to its default value. The hasClientDBusName()
     * method will return false.
     */
    inline void clearClientDBusName();

    /**
     * Checks whether the field "clientDBusName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClientDBusName()). Otherwise it will return false.
     */
    inline bool hasClientDBusName () const;

    /**
     * Returns the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     * 								Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 								unregistrations by others clients, as they first need to know the dbus name.
     *
     * @return The value of the field "clientDBusName"
     */
    inline const ::std::string& getClientDBusName () const;

    /**
     * Retrieves the value of the field "clientDBusName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "clientDBusName".
     */
    inline ::std::string& getClientDBusNameMutable ();

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     * 								Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 								unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const ::std::string& clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     * 								Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 								unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* clientDBusName_);

    /**
     * Sets the value of the member "clientDBusName".
     *
     * is the Name of DBUS used for proxy creation for a particular component
     * 								Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 								unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param clientDBusName The value which will be set
     */
    inline void setClientDBusName (const char* value, size_t size);

    static const UnregisterPublicItemRequest &getDefaultInstance();

private:

    inline void set_has_publicItemName ();

    inline void clear_has_publicItemName ();

    inline void set_has_clientDBusName ();

    inline void clear_has_clientDBusName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _publicItemName;

    ::std::string _clientDBusName;

};

/**
 * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
 */
class UnregisterPublicItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnregisterPublicItemResponse ();

    /**
     * Copy constructor
     */
    inline  UnregisterPublicItemResponse (const UnregisterPublicItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnregisterPublicItemResponse (EnRegisterStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~UnregisterPublicItemResponse();

    /**
     * Assignment operator
     */
    inline UnregisterPublicItemResponse& operator = (const UnregisterPublicItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnregisterPublicItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnregisterPublicItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnregisterPublicItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnregisterPublicItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of unregister operation
     *
     * @return The value of the field "status"
     */
    inline EnRegisterStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of unregister operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnRegisterStatus status_);

    static const UnregisterPublicItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnRegisterStatus _status;

};

/**
 * Method for HMI to update the local public items in config manager (ex: privacy mode).
 */
class SetPublicItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPublicItemRequest ();

    /**
     * Copy constructor
     */
    inline  SetPublicItemRequest (const SetPublicItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPublicItemRequest (const ::std::string& publicItemName_, const ::std::vector< ConfigData >& publicItem_);

    /**
     * Destructor
     */
    inline virtual  ~SetPublicItemRequest();

    /**
     * Assignment operator
     */
    inline SetPublicItemRequest& operator = (const SetPublicItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPublicItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPublicItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPublicItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPublicItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItemName"

    static const int kPublicItemName = 0;

    /**
     * Clears the field "publicItemName".
     *
     * The field will be set to its default value. The hasPublicItemName()
     * method will return false.
     */
    inline void clearPublicItemName();

    /**
     * Checks whether the field "publicItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItemName()). Otherwise it will return false.
     */
    inline bool hasPublicItemName () const;

    /**
     * Returns the value of the member "publicItemName".
     *
     * is the generic configuration data got from HMI
     *
     * @return The value of the field "publicItemName"
     */
    inline const ::std::string& getPublicItemName () const;

    /**
     * Retrieves the value of the field "publicItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItemName".
     */
    inline ::std::string& getPublicItemNameMutable ();

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data got from HMI
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const ::std::string& publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data got from HMI
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data got from HMI
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* value, size_t size);

    // API of field "publicItem"

    static const int kPublicItem = 1;

    /**
     * Clears the field "publicItem".
     *
     * The field will be set to its default value. The hasPublicItem()
     * method will return false.
     */
    inline void clearPublicItem();

    /**
     * Checks whether the field "publicItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItem()). Otherwise it will return false.
     */
    inline bool hasPublicItem () const;

    /**
     * Returns the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @return The value of the field "publicItem"
     */
    inline const ::std::vector< ConfigData >& getPublicItem () const;

    /**
     * Retrieves the value of the field "publicItem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItem".
     */
    inline ::std::vector< ConfigData >& getPublicItemMutable ();

    /**
     * Sets the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @param publicItem The value which will be set
     */
    inline void setPublicItem (const ::std::vector< ConfigData >& publicItem_);

    static const SetPublicItemRequest &getDefaultInstance();

private:

    static const ::std::vector< ConfigData >& getConfigDataList_DefaultInstance ();

    inline void set_has_publicItemName ();

    inline void clear_has_publicItemName ();

    inline void set_has_publicItem ();

    inline void clear_has_publicItem ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _publicItemName;

    ::std::vector< ConfigData > _publicItem;

};

/**
 * Method for HMI to update the local public items in config manager (ex: privacy mode).
 */
class SetPublicItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPublicItemResponse ();

    /**
     * Copy constructor
     */
    inline  SetPublicItemResponse (const SetPublicItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetPublicItemResponse (EnItemStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~SetPublicItemResponse();

    /**
     * Assignment operator
     */
    inline SetPublicItemResponse& operator = (const SetPublicItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPublicItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPublicItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPublicItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPublicItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of operation
     *
     * @return The value of the field "status"
     */
    inline EnItemStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemStatus status_);

    static const SetPublicItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnItemStatus _status;

};

/**
 * Method for Applications to get Public configuration data from ConfigManager.
 */
class GetPublicItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPublicItemRequest ();

    /**
     * Copy constructor
     */
    inline  GetPublicItemRequest (const GetPublicItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetPublicItemRequest (const ::std::string& publicItemName_);

    /**
     * Destructor
     */
    inline virtual  ~GetPublicItemRequest();

    /**
     * Assignment operator
     */
    inline GetPublicItemRequest& operator = (const GetPublicItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPublicItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPublicItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPublicItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPublicItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItemName"

    static const int kPublicItemName = 0;

    /**
     * Clears the field "publicItemName".
     *
     * The field will be set to its default value. The hasPublicItemName()
     * method will return false.
     */
    inline void clearPublicItemName();

    /**
     * Checks whether the field "publicItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItemName()). Otherwise it will return false.
     */
    inline bool hasPublicItemName () const;

    /**
     * Returns the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName
     *
     * @return The value of the field "publicItemName"
     */
    inline const ::std::string& getPublicItemName () const;

    /**
     * Retrieves the value of the field "publicItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItemName".
     */
    inline ::std::string& getPublicItemNameMutable ();

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const ::std::string& publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* value, size_t size);

    static const GetPublicItemRequest &getDefaultInstance();

private:

    inline void set_has_publicItemName ();

    inline void clear_has_publicItemName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _publicItemName;

};

/**
 * Method for Applications to get Public configuration data from ConfigManager.
 */
class GetPublicItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPublicItemResponse ();

    /**
     * Copy constructor
     */
    inline  GetPublicItemResponse (const GetPublicItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPublicItemResponse (const ::std::vector< ConfigData >& publicItem_, EnItemStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~GetPublicItemResponse();

    /**
     * Assignment operator
     */
    inline GetPublicItemResponse& operator = (const GetPublicItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPublicItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPublicItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPublicItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPublicItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItem"

    static const int kPublicItem = 0;

    /**
     * Clears the field "publicItem".
     *
     * The field will be set to its default value. The hasPublicItem()
     * method will return false.
     */
    inline void clearPublicItem();

    /**
     * Checks whether the field "publicItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItem()). Otherwise it will return false.
     */
    inline bool hasPublicItem () const;

    /**
     * Returns the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @return The value of the field "publicItem"
     */
    inline const ::std::vector< ConfigData >& getPublicItem () const;

    /**
     * Retrieves the value of the field "publicItem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItem".
     */
    inline ::std::vector< ConfigData >& getPublicItemMutable ();

    /**
     * Sets the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @param publicItem The value which will be set
     */
    inline void setPublicItem (const ::std::vector< ConfigData >& publicItem_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return result of operation
     *
     * @return The value of the field "status"
     */
    inline EnItemStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return result of operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemStatus status_);

    static const GetPublicItemResponse &getDefaultInstance();

private:

    static const ::std::vector< ConfigData >& getConfigDataList_DefaultInstance ();

    inline void set_has_publicItem ();

    inline void clear_has_publicItem ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ConfigData > _publicItem;

    EnItemStatus _status;

};

inline  ConfigData::ConfigData ()  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigData::ConfigData (const ConfigData &rhs)  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigData::ConfigData (const ::std::string& key_, const ::std::string& value_)  :
    _key (key_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigData::~ConfigData() {
}

inline ConfigData& ConfigData::operator = (const ConfigData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasKey()) {
            setKey(rhs.getKey());
        } else {
            clearKey();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool ConfigData::operator == (const ConfigData& rhs) const {
    return (((!hasKey() && !rhs.hasKey()) || getKey() == rhs.getKey()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool ConfigData::operator != (const ConfigData& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigData::operator < (const ConfigData& rhs) const {
    if (hasKey() || rhs.hasKey()) {
        if (getKey() < rhs.getKey()) return true;
        if (getKey() > rhs.getKey()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool ConfigData::operator > (const ConfigData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigData::clear() {
    clearKey();
    clearValue();
}

inline void ConfigData::clearKey() {
    if (hasKey()) {
         clear_has_key();
        _key.clear();
     }
}

inline bool ConfigData::hasKey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ConfigData::getKey () const {
    return _key;
}

inline ::std::string& ConfigData::getKeyMutable () {
    set_has_key();
    return _key;
}

inline void ConfigData::setKey (const ::std::string& key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key = key_;
}

inline void ConfigData::setKey (const char* key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(key_);
}

inline void ConfigData::setKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(value, size);
}

inline void ConfigData::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value.clear();
     }
}

inline bool ConfigData::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ConfigData::getValue () const {
    return _value;
}

inline ::std::string& ConfigData::getValueMutable () {
    set_has_value();
    return _value;
}

inline void ConfigData::setValue (const ::std::string& value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value = value_;
}

inline void ConfigData::setValue (const char* value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value_);
}

inline void ConfigData::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value, size);
}

inline void ConfigData::set_has_key () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigData::clear_has_key () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConfigData::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConfigData::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RegisterPrivateItemRequest::RegisterPrivateItemRequest ()  :
    _privateItemName (),
    _clientDBusName (),
    _dataFormat (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterPrivateItemRequest::RegisterPrivateItemRequest (const RegisterPrivateItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItemName (),
    _clientDBusName (),
    _dataFormat (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterPrivateItemRequest::RegisterPrivateItemRequest (const ::std::string& privateItemName_, const ::std::string& clientDBusName_, EnItemFormats dataFormat_)  :
    _privateItemName (privateItemName_),
    _clientDBusName (clientDBusName_),
    _dataFormat (dataFormat_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemFormats_IsValid(dataFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataFormat_, "EnItemFormats", "dataFormat", "RegisterPrivateItemRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterPrivateItemRequest::~RegisterPrivateItemRequest() {
}

inline RegisterPrivateItemRequest& RegisterPrivateItemRequest::operator = (const RegisterPrivateItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItemName()) {
            setPrivateItemName(rhs.getPrivateItemName());
        } else {
            clearPrivateItemName();
        }
        if (rhs.hasClientDBusName()) {
            setClientDBusName(rhs.getClientDBusName());
        } else {
            clearClientDBusName();
        }
        if (rhs.hasDataFormat()) {
            setDataFormat(rhs.getDataFormat());
        } else {
            clearDataFormat();
        }
    }
    return *this;
}

inline bool RegisterPrivateItemRequest::operator == (const RegisterPrivateItemRequest& rhs) const {
    return (((!hasPrivateItemName() && !rhs.hasPrivateItemName()) || getPrivateItemName() == rhs.getPrivateItemName()) &&
        ((!hasClientDBusName() && !rhs.hasClientDBusName()) || getClientDBusName() == rhs.getClientDBusName()) &&
        ((!hasDataFormat() && !rhs.hasDataFormat()) || getDataFormat() == rhs.getDataFormat()));
}

inline bool RegisterPrivateItemRequest::operator != (const RegisterPrivateItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterPrivateItemRequest::operator < (const RegisterPrivateItemRequest& rhs) const {
    if (hasPrivateItemName() || rhs.hasPrivateItemName()) {
        if (getPrivateItemName() < rhs.getPrivateItemName()) return true;
        if (getPrivateItemName() > rhs.getPrivateItemName()) return false;
    }
    if (hasClientDBusName() || rhs.hasClientDBusName()) {
        if (getClientDBusName() < rhs.getClientDBusName()) return true;
        if (getClientDBusName() > rhs.getClientDBusName()) return false;
    }
    if (hasDataFormat() || rhs.hasDataFormat()) {
        if ((uint32)getDataFormat() < (uint32)rhs.getDataFormat()) return true;
        if ((uint32)getDataFormat() > (uint32)rhs.getDataFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterPrivateItemRequest::clone() {
    return new RegisterPrivateItemRequest(*this);
}

inline bool RegisterPrivateItemRequest::operator > (const RegisterPrivateItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterPrivateItemRequest::clear() {
    clearPrivateItemName();
    clearClientDBusName();
    clearDataFormat();
}

inline void RegisterPrivateItemRequest::clearPrivateItemName() {
    if (hasPrivateItemName()) {
         clear_has_privateItemName();
        _privateItemName.clear();
     }
}

inline bool RegisterPrivateItemRequest::hasPrivateItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterPrivateItemRequest::getPrivateItemName () const {
    return _privateItemName;
}

inline ::std::string& RegisterPrivateItemRequest::getPrivateItemNameMutable () {
    set_has_privateItemName();
    return _privateItemName;
}

inline void RegisterPrivateItemRequest::setPrivateItemName (const ::std::string& privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName = privateItemName_;
}

inline void RegisterPrivateItemRequest::setPrivateItemName (const char* privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(privateItemName_);
}

inline void RegisterPrivateItemRequest::setPrivateItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(value, size);
}

inline void RegisterPrivateItemRequest::clearClientDBusName() {
    if (hasClientDBusName()) {
         clear_has_clientDBusName();
        _clientDBusName.clear();
     }
}

inline bool RegisterPrivateItemRequest::hasClientDBusName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegisterPrivateItemRequest::getClientDBusName () const {
    return _clientDBusName;
}

inline ::std::string& RegisterPrivateItemRequest::getClientDBusNameMutable () {
    set_has_clientDBusName();
    return _clientDBusName;
}

inline void RegisterPrivateItemRequest::setClientDBusName (const ::std::string& clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName = clientDBusName_;
}

inline void RegisterPrivateItemRequest::setClientDBusName (const char* clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(clientDBusName_);
}

inline void RegisterPrivateItemRequest::setClientDBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(value, size);
}

inline void RegisterPrivateItemRequest::clearDataFormat() {
    if (hasDataFormat()) {
         clear_has_dataFormat();
        _dataFormat = ::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default;
     }
}

inline bool RegisterPrivateItemRequest::hasDataFormat () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline EnItemFormats RegisterPrivateItemRequest::getDataFormat () const {
    return _dataFormat;
}

inline void RegisterPrivateItemRequest::setDataFormat (EnItemFormats dataFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemFormats_IsValid(dataFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataFormat_, "EnItemFormats", "dataFormat", "RegisterPrivateItemRequest");
    }
    set_has_dataFormat();
    this->_dataFormat = dataFormat_;
}

inline void RegisterPrivateItemRequest::set_has_privateItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterPrivateItemRequest::clear_has_privateItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterPrivateItemRequest::set_has_clientDBusName () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterPrivateItemRequest::clear_has_clientDBusName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegisterPrivateItemRequest::set_has_dataFormat () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegisterPrivateItemRequest::clear_has_dataFormat () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RegisterPrivateItemResponse::RegisterPrivateItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterPrivateItemResponse::RegisterPrivateItemResponse (const RegisterPrivateItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterPrivateItemResponse::RegisterPrivateItemResponse (EnRegisterStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "RegisterPrivateItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterPrivateItemResponse::~RegisterPrivateItemResponse() {
}

inline RegisterPrivateItemResponse& RegisterPrivateItemResponse::operator = (const RegisterPrivateItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RegisterPrivateItemResponse::operator == (const RegisterPrivateItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RegisterPrivateItemResponse::operator != (const RegisterPrivateItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterPrivateItemResponse::operator < (const RegisterPrivateItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterPrivateItemResponse::clone() {
    return new RegisterPrivateItemResponse(*this);
}

inline bool RegisterPrivateItemResponse::operator > (const RegisterPrivateItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterPrivateItemResponse::clear() {
    clearStatus();
}

inline void RegisterPrivateItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS;
     }
}

inline bool RegisterPrivateItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnRegisterStatus RegisterPrivateItemResponse::getStatus () const {
    return _status;
}

inline void RegisterPrivateItemResponse::setStatus (EnRegisterStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "RegisterPrivateItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void RegisterPrivateItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterPrivateItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnregisterPrivateItemRequest::UnregisterPrivateItemRequest ()  :
    _privateItemName (),
    _clientDBusName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterPrivateItemRequest::UnregisterPrivateItemRequest (const UnregisterPrivateItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItemName (),
    _clientDBusName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterPrivateItemRequest::UnregisterPrivateItemRequest (const ::std::string& privateItemName_, const ::std::string& clientDBusName_)  :
    _privateItemName (privateItemName_),
    _clientDBusName (clientDBusName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterPrivateItemRequest::~UnregisterPrivateItemRequest() {
}

inline UnregisterPrivateItemRequest& UnregisterPrivateItemRequest::operator = (const UnregisterPrivateItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItemName()) {
            setPrivateItemName(rhs.getPrivateItemName());
        } else {
            clearPrivateItemName();
        }
        if (rhs.hasClientDBusName()) {
            setClientDBusName(rhs.getClientDBusName());
        } else {
            clearClientDBusName();
        }
    }
    return *this;
}

inline bool UnregisterPrivateItemRequest::operator == (const UnregisterPrivateItemRequest& rhs) const {
    return (((!hasPrivateItemName() && !rhs.hasPrivateItemName()) || getPrivateItemName() == rhs.getPrivateItemName()) &&
        ((!hasClientDBusName() && !rhs.hasClientDBusName()) || getClientDBusName() == rhs.getClientDBusName()));
}

inline bool UnregisterPrivateItemRequest::operator != (const UnregisterPrivateItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterPrivateItemRequest::operator < (const UnregisterPrivateItemRequest& rhs) const {
    if (hasPrivateItemName() || rhs.hasPrivateItemName()) {
        if (getPrivateItemName() < rhs.getPrivateItemName()) return true;
        if (getPrivateItemName() > rhs.getPrivateItemName()) return false;
    }
    if (hasClientDBusName() || rhs.hasClientDBusName()) {
        if (getClientDBusName() < rhs.getClientDBusName()) return true;
        if (getClientDBusName() > rhs.getClientDBusName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterPrivateItemRequest::clone() {
    return new UnregisterPrivateItemRequest(*this);
}

inline bool UnregisterPrivateItemRequest::operator > (const UnregisterPrivateItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterPrivateItemRequest::clear() {
    clearPrivateItemName();
    clearClientDBusName();
}

inline void UnregisterPrivateItemRequest::clearPrivateItemName() {
    if (hasPrivateItemName()) {
         clear_has_privateItemName();
        _privateItemName.clear();
     }
}

inline bool UnregisterPrivateItemRequest::hasPrivateItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnregisterPrivateItemRequest::getPrivateItemName () const {
    return _privateItemName;
}

inline ::std::string& UnregisterPrivateItemRequest::getPrivateItemNameMutable () {
    set_has_privateItemName();
    return _privateItemName;
}

inline void UnregisterPrivateItemRequest::setPrivateItemName (const ::std::string& privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName = privateItemName_;
}

inline void UnregisterPrivateItemRequest::setPrivateItemName (const char* privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(privateItemName_);
}

inline void UnregisterPrivateItemRequest::setPrivateItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(value, size);
}

inline void UnregisterPrivateItemRequest::clearClientDBusName() {
    if (hasClientDBusName()) {
         clear_has_clientDBusName();
        _clientDBusName.clear();
     }
}

inline bool UnregisterPrivateItemRequest::hasClientDBusName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UnregisterPrivateItemRequest::getClientDBusName () const {
    return _clientDBusName;
}

inline ::std::string& UnregisterPrivateItemRequest::getClientDBusNameMutable () {
    set_has_clientDBusName();
    return _clientDBusName;
}

inline void UnregisterPrivateItemRequest::setClientDBusName (const ::std::string& clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName = clientDBusName_;
}

inline void UnregisterPrivateItemRequest::setClientDBusName (const char* clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(clientDBusName_);
}

inline void UnregisterPrivateItemRequest::setClientDBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(value, size);
}

inline void UnregisterPrivateItemRequest::set_has_privateItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterPrivateItemRequest::clear_has_privateItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UnregisterPrivateItemRequest::set_has_clientDBusName () {
    _has_bits_[0] |= 1u << 1;
}

inline void UnregisterPrivateItemRequest::clear_has_clientDBusName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UnregisterPrivateItemResponse::UnregisterPrivateItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterPrivateItemResponse::UnregisterPrivateItemResponse (const UnregisterPrivateItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterPrivateItemResponse::UnregisterPrivateItemResponse (EnRegisterStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "UnregisterPrivateItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterPrivateItemResponse::~UnregisterPrivateItemResponse() {
}

inline UnregisterPrivateItemResponse& UnregisterPrivateItemResponse::operator = (const UnregisterPrivateItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool UnregisterPrivateItemResponse::operator == (const UnregisterPrivateItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool UnregisterPrivateItemResponse::operator != (const UnregisterPrivateItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterPrivateItemResponse::operator < (const UnregisterPrivateItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterPrivateItemResponse::clone() {
    return new UnregisterPrivateItemResponse(*this);
}

inline bool UnregisterPrivateItemResponse::operator > (const UnregisterPrivateItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterPrivateItemResponse::clear() {
    clearStatus();
}

inline void UnregisterPrivateItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS;
     }
}

inline bool UnregisterPrivateItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnRegisterStatus UnregisterPrivateItemResponse::getStatus () const {
    return _status;
}

inline void UnregisterPrivateItemResponse::setStatus (EnRegisterStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "UnregisterPrivateItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void UnregisterPrivateItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterPrivateItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RegisterPublicItemRequest::RegisterPublicItemRequest ()  :
    _publicItemName (),
    _clientDBusName (),
    _dataFormat (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterPublicItemRequest::RegisterPublicItemRequest (const RegisterPublicItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItemName (),
    _clientDBusName (),
    _dataFormat (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterPublicItemRequest::RegisterPublicItemRequest (const ::std::string& publicItemName_, const ::std::string& clientDBusName_, EnItemFormats dataFormat_)  :
    _publicItemName (publicItemName_),
    _clientDBusName (clientDBusName_),
    _dataFormat (dataFormat_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemFormats_IsValid(dataFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataFormat_, "EnItemFormats", "dataFormat", "RegisterPublicItemRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterPublicItemRequest::~RegisterPublicItemRequest() {
}

inline RegisterPublicItemRequest& RegisterPublicItemRequest::operator = (const RegisterPublicItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItemName()) {
            setPublicItemName(rhs.getPublicItemName());
        } else {
            clearPublicItemName();
        }
        if (rhs.hasClientDBusName()) {
            setClientDBusName(rhs.getClientDBusName());
        } else {
            clearClientDBusName();
        }
        if (rhs.hasDataFormat()) {
            setDataFormat(rhs.getDataFormat());
        } else {
            clearDataFormat();
        }
    }
    return *this;
}

inline bool RegisterPublicItemRequest::operator == (const RegisterPublicItemRequest& rhs) const {
    return (((!hasPublicItemName() && !rhs.hasPublicItemName()) || getPublicItemName() == rhs.getPublicItemName()) &&
        ((!hasClientDBusName() && !rhs.hasClientDBusName()) || getClientDBusName() == rhs.getClientDBusName()) &&
        ((!hasDataFormat() && !rhs.hasDataFormat()) || getDataFormat() == rhs.getDataFormat()));
}

inline bool RegisterPublicItemRequest::operator != (const RegisterPublicItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterPublicItemRequest::operator < (const RegisterPublicItemRequest& rhs) const {
    if (hasPublicItemName() || rhs.hasPublicItemName()) {
        if (getPublicItemName() < rhs.getPublicItemName()) return true;
        if (getPublicItemName() > rhs.getPublicItemName()) return false;
    }
    if (hasClientDBusName() || rhs.hasClientDBusName()) {
        if (getClientDBusName() < rhs.getClientDBusName()) return true;
        if (getClientDBusName() > rhs.getClientDBusName()) return false;
    }
    if (hasDataFormat() || rhs.hasDataFormat()) {
        if ((uint32)getDataFormat() < (uint32)rhs.getDataFormat()) return true;
        if ((uint32)getDataFormat() > (uint32)rhs.getDataFormat()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterPublicItemRequest::clone() {
    return new RegisterPublicItemRequest(*this);
}

inline bool RegisterPublicItemRequest::operator > (const RegisterPublicItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterPublicItemRequest::clear() {
    clearPublicItemName();
    clearClientDBusName();
    clearDataFormat();
}

inline void RegisterPublicItemRequest::clearPublicItemName() {
    if (hasPublicItemName()) {
         clear_has_publicItemName();
        _publicItemName.clear();
     }
}

inline bool RegisterPublicItemRequest::hasPublicItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RegisterPublicItemRequest::getPublicItemName () const {
    return _publicItemName;
}

inline ::std::string& RegisterPublicItemRequest::getPublicItemNameMutable () {
    set_has_publicItemName();
    return _publicItemName;
}

inline void RegisterPublicItemRequest::setPublicItemName (const ::std::string& publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName = publicItemName_;
}

inline void RegisterPublicItemRequest::setPublicItemName (const char* publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(publicItemName_);
}

inline void RegisterPublicItemRequest::setPublicItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(value, size);
}

inline void RegisterPublicItemRequest::clearClientDBusName() {
    if (hasClientDBusName()) {
         clear_has_clientDBusName();
        _clientDBusName.clear();
     }
}

inline bool RegisterPublicItemRequest::hasClientDBusName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RegisterPublicItemRequest::getClientDBusName () const {
    return _clientDBusName;
}

inline ::std::string& RegisterPublicItemRequest::getClientDBusNameMutable () {
    set_has_clientDBusName();
    return _clientDBusName;
}

inline void RegisterPublicItemRequest::setClientDBusName (const ::std::string& clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName = clientDBusName_;
}

inline void RegisterPublicItemRequest::setClientDBusName (const char* clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(clientDBusName_);
}

inline void RegisterPublicItemRequest::setClientDBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(value, size);
}

inline void RegisterPublicItemRequest::clearDataFormat() {
    if (hasDataFormat()) {
         clear_has_dataFormat();
        _dataFormat = ::de::bosch::cm::ConfigManager::ConfigManagement::EnItemFormats__Default;
     }
}

inline bool RegisterPublicItemRequest::hasDataFormat () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline EnItemFormats RegisterPublicItemRequest::getDataFormat () const {
    return _dataFormat;
}

inline void RegisterPublicItemRequest::setDataFormat (EnItemFormats dataFormat_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemFormats_IsValid(dataFormat_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataFormat_, "EnItemFormats", "dataFormat", "RegisterPublicItemRequest");
    }
    set_has_dataFormat();
    this->_dataFormat = dataFormat_;
}

inline void RegisterPublicItemRequest::set_has_publicItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterPublicItemRequest::clear_has_publicItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegisterPublicItemRequest::set_has_clientDBusName () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegisterPublicItemRequest::clear_has_clientDBusName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegisterPublicItemRequest::set_has_dataFormat () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegisterPublicItemRequest::clear_has_dataFormat () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RegisterPublicItemResponse::RegisterPublicItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegisterPublicItemResponse::RegisterPublicItemResponse (const RegisterPublicItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegisterPublicItemResponse::RegisterPublicItemResponse (EnRegisterStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "RegisterPublicItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegisterPublicItemResponse::~RegisterPublicItemResponse() {
}

inline RegisterPublicItemResponse& RegisterPublicItemResponse::operator = (const RegisterPublicItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool RegisterPublicItemResponse::operator == (const RegisterPublicItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool RegisterPublicItemResponse::operator != (const RegisterPublicItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RegisterPublicItemResponse::operator < (const RegisterPublicItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RegisterPublicItemResponse::clone() {
    return new RegisterPublicItemResponse(*this);
}

inline bool RegisterPublicItemResponse::operator > (const RegisterPublicItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegisterPublicItemResponse::clear() {
    clearStatus();
}

inline void RegisterPublicItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS;
     }
}

inline bool RegisterPublicItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnRegisterStatus RegisterPublicItemResponse::getStatus () const {
    return _status;
}

inline void RegisterPublicItemResponse::setStatus (EnRegisterStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "RegisterPublicItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void RegisterPublicItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegisterPublicItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnregisterPublicItemRequest::UnregisterPublicItemRequest ()  :
    _publicItemName (),
    _clientDBusName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterPublicItemRequest::UnregisterPublicItemRequest (const UnregisterPublicItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItemName (),
    _clientDBusName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterPublicItemRequest::UnregisterPublicItemRequest (const ::std::string& publicItemName_, const ::std::string& clientDBusName_)  :
    _publicItemName (publicItemName_),
    _clientDBusName (clientDBusName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterPublicItemRequest::~UnregisterPublicItemRequest() {
}

inline UnregisterPublicItemRequest& UnregisterPublicItemRequest::operator = (const UnregisterPublicItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItemName()) {
            setPublicItemName(rhs.getPublicItemName());
        } else {
            clearPublicItemName();
        }
        if (rhs.hasClientDBusName()) {
            setClientDBusName(rhs.getClientDBusName());
        } else {
            clearClientDBusName();
        }
    }
    return *this;
}

inline bool UnregisterPublicItemRequest::operator == (const UnregisterPublicItemRequest& rhs) const {
    return (((!hasPublicItemName() && !rhs.hasPublicItemName()) || getPublicItemName() == rhs.getPublicItemName()) &&
        ((!hasClientDBusName() && !rhs.hasClientDBusName()) || getClientDBusName() == rhs.getClientDBusName()));
}

inline bool UnregisterPublicItemRequest::operator != (const UnregisterPublicItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterPublicItemRequest::operator < (const UnregisterPublicItemRequest& rhs) const {
    if (hasPublicItemName() || rhs.hasPublicItemName()) {
        if (getPublicItemName() < rhs.getPublicItemName()) return true;
        if (getPublicItemName() > rhs.getPublicItemName()) return false;
    }
    if (hasClientDBusName() || rhs.hasClientDBusName()) {
        if (getClientDBusName() < rhs.getClientDBusName()) return true;
        if (getClientDBusName() > rhs.getClientDBusName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterPublicItemRequest::clone() {
    return new UnregisterPublicItemRequest(*this);
}

inline bool UnregisterPublicItemRequest::operator > (const UnregisterPublicItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterPublicItemRequest::clear() {
    clearPublicItemName();
    clearClientDBusName();
}

inline void UnregisterPublicItemRequest::clearPublicItemName() {
    if (hasPublicItemName()) {
         clear_has_publicItemName();
        _publicItemName.clear();
     }
}

inline bool UnregisterPublicItemRequest::hasPublicItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UnregisterPublicItemRequest::getPublicItemName () const {
    return _publicItemName;
}

inline ::std::string& UnregisterPublicItemRequest::getPublicItemNameMutable () {
    set_has_publicItemName();
    return _publicItemName;
}

inline void UnregisterPublicItemRequest::setPublicItemName (const ::std::string& publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName = publicItemName_;
}

inline void UnregisterPublicItemRequest::setPublicItemName (const char* publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(publicItemName_);
}

inline void UnregisterPublicItemRequest::setPublicItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(value, size);
}

inline void UnregisterPublicItemRequest::clearClientDBusName() {
    if (hasClientDBusName()) {
         clear_has_clientDBusName();
        _clientDBusName.clear();
     }
}

inline bool UnregisterPublicItemRequest::hasClientDBusName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UnregisterPublicItemRequest::getClientDBusName () const {
    return _clientDBusName;
}

inline ::std::string& UnregisterPublicItemRequest::getClientDBusNameMutable () {
    set_has_clientDBusName();
    return _clientDBusName;
}

inline void UnregisterPublicItemRequest::setClientDBusName (const ::std::string& clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName = clientDBusName_;
}

inline void UnregisterPublicItemRequest::setClientDBusName (const char* clientDBusName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (clientDBusName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(clientDBusName_);
}

inline void UnregisterPublicItemRequest::setClientDBusName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_clientDBusName();
    this->_clientDBusName.assign(value, size);
}

inline void UnregisterPublicItemRequest::set_has_publicItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterPublicItemRequest::clear_has_publicItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UnregisterPublicItemRequest::set_has_clientDBusName () {
    _has_bits_[0] |= 1u << 1;
}

inline void UnregisterPublicItemRequest::clear_has_clientDBusName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UnregisterPublicItemResponse::UnregisterPublicItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnregisterPublicItemResponse::UnregisterPublicItemResponse (const UnregisterPublicItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnregisterPublicItemResponse::UnregisterPublicItemResponse (EnRegisterStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "UnregisterPublicItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnregisterPublicItemResponse::~UnregisterPublicItemResponse() {
}

inline UnregisterPublicItemResponse& UnregisterPublicItemResponse::operator = (const UnregisterPublicItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool UnregisterPublicItemResponse::operator == (const UnregisterPublicItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool UnregisterPublicItemResponse::operator != (const UnregisterPublicItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UnregisterPublicItemResponse::operator < (const UnregisterPublicItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnregisterPublicItemResponse::clone() {
    return new UnregisterPublicItemResponse(*this);
}

inline bool UnregisterPublicItemResponse::operator > (const UnregisterPublicItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnregisterPublicItemResponse::clear() {
    clearStatus();
}

inline void UnregisterPublicItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnRegisterStatus__SUCCESS;
     }
}

inline bool UnregisterPublicItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnRegisterStatus UnregisterPublicItemResponse::getStatus () const {
    return _status;
}

inline void UnregisterPublicItemResponse::setStatus (EnRegisterStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnRegisterStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnRegisterStatus", "status", "UnregisterPublicItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void UnregisterPublicItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnregisterPublicItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPublicItemRequest::SetPublicItemRequest ()  :
    _publicItemName (),
    _publicItem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPublicItemRequest::SetPublicItemRequest (const SetPublicItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItemName (),
    _publicItem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPublicItemRequest::SetPublicItemRequest (const ::std::string& publicItemName_, const ::std::vector< ConfigData >& publicItem_)  :
    _publicItemName (publicItemName_),
    _publicItem (publicItem_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPublicItemRequest::~SetPublicItemRequest() {
}

inline SetPublicItemRequest& SetPublicItemRequest::operator = (const SetPublicItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItemName()) {
            setPublicItemName(rhs.getPublicItemName());
        } else {
            clearPublicItemName();
        }
        if (rhs.hasPublicItem()) {
            setPublicItem(rhs.getPublicItem());
        } else {
            clearPublicItem();
        }
    }
    return *this;
}

inline bool SetPublicItemRequest::operator == (const SetPublicItemRequest& rhs) const {
    return (((!hasPublicItemName() && !rhs.hasPublicItemName()) || getPublicItemName() == rhs.getPublicItemName()) &&
        ((!hasPublicItem() && !rhs.hasPublicItem()) || getPublicItem() == rhs.getPublicItem()));
}

inline bool SetPublicItemRequest::operator != (const SetPublicItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPublicItemRequest::operator < (const SetPublicItemRequest& rhs) const {
    if (hasPublicItemName() || rhs.hasPublicItemName()) {
        if (getPublicItemName() < rhs.getPublicItemName()) return true;
        if (getPublicItemName() > rhs.getPublicItemName()) return false;
    }
    if (hasPublicItem() || rhs.hasPublicItem()) {
        if (getPublicItem() < rhs.getPublicItem()) return true;
        if (getPublicItem() > rhs.getPublicItem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPublicItemRequest::clone() {
    return new SetPublicItemRequest(*this);
}

inline bool SetPublicItemRequest::operator > (const SetPublicItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPublicItemRequest::clear() {
    clearPublicItemName();
    clearPublicItem();
}

inline void SetPublicItemRequest::clearPublicItemName() {
    if (hasPublicItemName()) {
         clear_has_publicItemName();
        _publicItemName.clear();
     }
}

inline bool SetPublicItemRequest::hasPublicItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPublicItemRequest::getPublicItemName () const {
    return _publicItemName;
}

inline ::std::string& SetPublicItemRequest::getPublicItemNameMutable () {
    set_has_publicItemName();
    return _publicItemName;
}

inline void SetPublicItemRequest::setPublicItemName (const ::std::string& publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName = publicItemName_;
}

inline void SetPublicItemRequest::setPublicItemName (const char* publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(publicItemName_);
}

inline void SetPublicItemRequest::setPublicItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(value, size);
}

inline void SetPublicItemRequest::clearPublicItem() {
    if (hasPublicItem()) {
         clear_has_publicItem();
        _publicItem.clear();
     }
}

inline bool SetPublicItemRequest::hasPublicItem () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ConfigData >& SetPublicItemRequest::getPublicItem () const {
    return _publicItem;
}

inline ::std::vector< ConfigData >& SetPublicItemRequest::getPublicItemMutable () {
    set_has_publicItem();
    return _publicItem;
}

inline void SetPublicItemRequest::setPublicItem (const ::std::vector< ConfigData >& publicItem_) {
    set_has_publicItem();
    this->_publicItem = publicItem_;
}

inline void SetPublicItemRequest::set_has_publicItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPublicItemRequest::clear_has_publicItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPublicItemRequest::set_has_publicItem () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPublicItemRequest::clear_has_publicItem () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetPublicItemResponse::SetPublicItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPublicItemResponse::SetPublicItemResponse (const SetPublicItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPublicItemResponse::SetPublicItemResponse (EnItemStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemStatus", "status", "SetPublicItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPublicItemResponse::~SetPublicItemResponse() {
}

inline SetPublicItemResponse& SetPublicItemResponse::operator = (const SetPublicItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetPublicItemResponse::operator == (const SetPublicItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetPublicItemResponse::operator != (const SetPublicItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPublicItemResponse::operator < (const SetPublicItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPublicItemResponse::clone() {
    return new SetPublicItemResponse(*this);
}

inline bool SetPublicItemResponse::operator > (const SetPublicItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPublicItemResponse::clear() {
    clearStatus();
}

inline void SetPublicItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS;
     }
}

inline bool SetPublicItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnItemStatus SetPublicItemResponse::getStatus () const {
    return _status;
}

inline void SetPublicItemResponse::setStatus (EnItemStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemStatus", "status", "SetPublicItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void SetPublicItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPublicItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPublicItemRequest::GetPublicItemRequest ()  :
    _publicItemName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPublicItemRequest::GetPublicItemRequest (const GetPublicItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItemName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPublicItemRequest::GetPublicItemRequest (const ::std::string& publicItemName_)  :
    _publicItemName (publicItemName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPublicItemRequest::~GetPublicItemRequest() {
}

inline GetPublicItemRequest& GetPublicItemRequest::operator = (const GetPublicItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItemName()) {
            setPublicItemName(rhs.getPublicItemName());
        } else {
            clearPublicItemName();
        }
    }
    return *this;
}

inline bool GetPublicItemRequest::operator == (const GetPublicItemRequest& rhs) const {
    return (((!hasPublicItemName() && !rhs.hasPublicItemName()) || getPublicItemName() == rhs.getPublicItemName()));
}

inline bool GetPublicItemRequest::operator != (const GetPublicItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPublicItemRequest::operator < (const GetPublicItemRequest& rhs) const {
    if (hasPublicItemName() || rhs.hasPublicItemName()) {
        if (getPublicItemName() < rhs.getPublicItemName()) return true;
        if (getPublicItemName() > rhs.getPublicItemName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPublicItemRequest::clone() {
    return new GetPublicItemRequest(*this);
}

inline bool GetPublicItemRequest::operator > (const GetPublicItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPublicItemRequest::clear() {
    clearPublicItemName();
}

inline void GetPublicItemRequest::clearPublicItemName() {
    if (hasPublicItemName()) {
         clear_has_publicItemName();
        _publicItemName.clear();
     }
}

inline bool GetPublicItemRequest::hasPublicItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetPublicItemRequest::getPublicItemName () const {
    return _publicItemName;
}

inline ::std::string& GetPublicItemRequest::getPublicItemNameMutable () {
    set_has_publicItemName();
    return _publicItemName;
}

inline void GetPublicItemRequest::setPublicItemName (const ::std::string& publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName = publicItemName_;
}

inline void GetPublicItemRequest::setPublicItemName (const char* publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(publicItemName_);
}

inline void GetPublicItemRequest::setPublicItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(value, size);
}

inline void GetPublicItemRequest::set_has_publicItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPublicItemRequest::clear_has_publicItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPublicItemResponse::GetPublicItemResponse ()  :
    _publicItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPublicItemResponse::GetPublicItemResponse (const GetPublicItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPublicItemResponse::GetPublicItemResponse (const ::std::vector< ConfigData >& publicItem_, EnItemStatus status_)  :
    _publicItem (publicItem_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemStatus", "status", "GetPublicItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPublicItemResponse::~GetPublicItemResponse() {
}

inline GetPublicItemResponse& GetPublicItemResponse::operator = (const GetPublicItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItem()) {
            setPublicItem(rhs.getPublicItem());
        } else {
            clearPublicItem();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetPublicItemResponse::operator == (const GetPublicItemResponse& rhs) const {
    return (((!hasPublicItem() && !rhs.hasPublicItem()) || getPublicItem() == rhs.getPublicItem()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetPublicItemResponse::operator != (const GetPublicItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPublicItemResponse::operator < (const GetPublicItemResponse& rhs) const {
    if (hasPublicItem() || rhs.hasPublicItem()) {
        if (getPublicItem() < rhs.getPublicItem()) return true;
        if (getPublicItem() > rhs.getPublicItem()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPublicItemResponse::clone() {
    return new GetPublicItemResponse(*this);
}

inline bool GetPublicItemResponse::operator > (const GetPublicItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPublicItemResponse::clear() {
    clearPublicItem();
    clearStatus();
}

inline void GetPublicItemResponse::clearPublicItem() {
    if (hasPublicItem()) {
         clear_has_publicItem();
        _publicItem.clear();
     }
}

inline bool GetPublicItemResponse::hasPublicItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ConfigData >& GetPublicItemResponse::getPublicItem () const {
    return _publicItem;
}

inline ::std::vector< ConfigData >& GetPublicItemResponse::getPublicItemMutable () {
    set_has_publicItem();
    return _publicItem;
}

inline void GetPublicItemResponse::setPublicItem (const ::std::vector< ConfigData >& publicItem_) {
    set_has_publicItem();
    this->_publicItem = publicItem_;
}

inline void GetPublicItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigManagement::EnItemStatus__SUCCESS;
     }
}

inline bool GetPublicItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline EnItemStatus GetPublicItemResponse::getStatus () const {
    return _status;
}

inline void GetPublicItemResponse::setStatus (EnItemStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemStatus", "status", "GetPublicItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void GetPublicItemResponse::set_has_publicItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPublicItemResponse::clear_has_publicItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPublicItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPublicItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace ConfigManagement
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
