/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigData.h"
#include "de/bosch/cm/ConfigManager/ConfigDataConst.h"
#include "de/bosch/cm/ConfigManager/ConfigDataDBus.h"
#include "de/bosch/cm/ConfigManager/ConfigDataJson.h"
#include "de/bosch/cm/ConfigManager/ConfigDataStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigData {

DEFINE_CLASS_LOGGER("/de/bosch/cm/ConfigManager/de/bosch/cm/ConfigManager/ConfigData", ConfigDataStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 14, "exchangeDESCMO", 2 },
    { 14, "getPrivateItem", 1 },
    { 14, "setPrivateItem", 0 },
    { 22, "updatePublicConfigItem", 3 },
};


class ConfigDataStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ConfigDataStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ConfigDataStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ConfigDataStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "de.bosch.cm.ConfigManager.ConfigData"),
          _logger(logger) {}

    virtual ~ConfigDataStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ConfigDataStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'setPrivateItem'

            LOG_DEBUG_STUB("process method '%s'", "setPrivateItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPrivateItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetPrivateItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPrivateItemRequest > payload = ::boost::static_pointer_cast<SetPrivateItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigDataStub*>(getStub())->onSetPrivateItemRequest(payload);
            return;
        }
        case 1: {

            // method 'getPrivateItem'

            LOG_DEBUG_STUB("process method '%s'", "getPrivateItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPrivateItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPrivateItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPrivateItemRequest > payload = ::boost::static_pointer_cast<GetPrivateItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigDataStub*>(getStub())->onGetPrivateItemRequest(payload);
            return;
        }
        case 2: {

            // method 'exchangeDESCMO'

            LOG_DEBUG_STUB("process method '%s'", "exchangeDESCMO");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExchangeDESCMORequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ExchangeDESCMO", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ExchangeDESCMORequest > payload = ::boost::static_pointer_cast<ExchangeDESCMORequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigDataStub*>(getStub())->onExchangeDESCMORequest(payload);
            return;
        }
        case 3: {

            // method 'updatePublicConfigItem'

            LOG_DEBUG_STUB("process method '%s'", "updatePublicConfigItem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdatePublicConfigItemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdatePublicConfigItem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdatePublicConfigItemRequest > payload = ::boost::static_pointer_cast<UpdatePublicConfigItemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ConfigDataStub*>(getStub())->onUpdatePublicConfigItemRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ConfigDataStubDelegate::introspect() const {
    return     "<interface name=\"de.bosch.cm.ConfigManager.ConfigData\">\n"
            "    <method name=\"setPrivateItem\">\n"
            "      <doc>\n"
            "        <line>setPrivateItem = Method called by CfgMgr to set an private item in the application</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"privateItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemName = the name of the private config item</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"privateItem\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>privateItem (of type ConfigItem) = is an array of (key,value) pairs obtained for the respective private item name</line>\n"
            "          <line>ConfigItem = array[ConfigInfo]</line>\n"
            "          <line>ConfigInfo struct[key, value] = Struct ConfigInfo contains key value pair for one application</line>\n"
            "          <line>0: ConfigInfo.key ('s') = Description missing</line>\n"
            "          <line>1: ConfigInfo.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemsStatus) = Description missing</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03), INAVLID_VALUE (0x04), INVALID_SIGNATURE (0x05)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getPrivateItem\">\n"
            "      <doc>\n"
            "        <line>getPrivateItem = Method called by cfgmgr to get the data of an private config item, stored in application.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"privateItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemName = the name of the private config item</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"privateItem\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>privateItem (of type ConfigItem) = is an array of (key,value) pairs obtained for the respective private item name</line>\n"
            "          <line>ConfigItem = array[ConfigInfo]</line>\n"
            "          <line>ConfigInfo struct[key, value] = Struct ConfigInfo contains key value pair for one application</line>\n"
            "          <line>0: ConfigInfo.key ('s') = Description missing</line>\n"
            "          <line>1: ConfigInfo.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemsStatus) = return value to indicate result of get operation</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03), INAVLID_VALUE (0x04), INVALID_SIGNATURE (0x05)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"exchangeDESCMO\">\n"
            "      <doc>\n"
            "        <line>exchangeDESCMO = Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"privateItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemName = the name of the private config item</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"privateItemXML\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>privateItemXML = the XML encoded private config item data</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"signatureXML\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>signatureXML = the XML encoded signature for the private config item data</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outPrivateItemXML\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>outPrivateItemXML = the XML encoded private config item data returned from application. In case of GET the application has updated the data.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemsStatus) = return value, indicating result of exchange operation</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03), INAVLID_VALUE (0x04), INVALID_SIGNATURE (0x05)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"updatePublicConfigItem\">\n"
            "      <doc>\n"
            "        <line>updatePublicConfigItem = Method for Applications to receive updates of Public configuration data from ConfigManager.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"publicItemName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>publicItemName = is the generic configuration data that applications are interested in</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"publicItem\" type=\"a(ss)\">\n"
            "        <doc>\n"
            "          <line>publicItem (of type ConfigItem) = is an array of (key,value) pairs obtained for the respective SettingsGroupName</line>\n"
            "          <line>ConfigItem = array[ConfigInfo]</line>\n"
            "          <line>ConfigInfo struct[key, value] = Struct ConfigInfo contains key value pair for one application</line>\n"
            "          <line>0: ConfigInfo.key ('s') = Description missing</line>\n"
            "          <line>1: ConfigInfo.value ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status (of type EnItemsStatus) = NOT USED - DO NOT CONSIDER FOR IMPLEMENTATION</line>\n"
            "          <line>enum[SUCCESS (0x00), FAILED (0x01), UNKNOWN_ITEM (0x02), NO_PERMISSION (0x03), INAVLID_VALUE (0x04), INVALID_SIGNATURE (0x05)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void ConfigDataStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ConfigDataStub*>(getStub()))->onGetAll (properties);
}

void ConfigDataStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ConfigDataStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ConfigDataStub::ConfigDataStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConfigDataStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConfigDataStub::ConfigDataStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ConfigDataStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ConfigDataStub::~ConfigDataStub() {
    delete _stubDelegate;
}

void  ConfigDataStub::sendSetPrivateItemResponse (EnItemsStatus status, act_t act) {
    SetPrivateItemResponse* payload = new SetPrivateItemResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "setPrivateItem", SetPrivateItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigDataStub::sendSetPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPrivateItemError* payload = new SetPrivateItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setPrivateItem", SetPrivateItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigDataStub::sendGetPrivateItemResponse (const ::std::vector< ConfigInfo >& privateItem, EnItemsStatus status, act_t act) {
    GetPrivateItemResponse* payload = new GetPrivateItemResponse(privateItem, status);
    DBUS_MESSAGE_REPLY(dbusMessage, "getPrivateItem", GetPrivateItemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigDataStub::sendGetPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPrivateItemError* payload = new GetPrivateItemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getPrivateItem", GetPrivateItemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetPrivateItem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigDataStub::sendExchangeDESCMOResponse (const ::std::string& outPrivateItemXML, EnItemsStatus status, act_t act) {
    ExchangeDESCMOResponse* payload = new ExchangeDESCMOResponse(outPrivateItemXML, status);
    DBUS_MESSAGE_REPLY(dbusMessage, "exchangeDESCMO", ExchangeDESCMOResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ExchangeDESCMO", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ConfigDataStub::sendExchangeDESCMOError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ExchangeDESCMOError* payload = new ExchangeDESCMOError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "exchangeDESCMO", ExchangeDESCMOError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ExchangeDESCMO", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}


void ConfigDataStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace ConfigData
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de
