/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATAPROXY_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATAPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "de/bosch/cm/ConfigManager/ConfigData.h"
#include "de/bosch/cm/ConfigManager/ConfigDataConst.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigData {

class ConfigDataProxy;

class ExchangeDESCMOCallbackIF {
public:
    virtual ~ExchangeDESCMOCallbackIF() {}

    virtual void onExchangeDESCMOError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< ExchangeDESCMOError >& error) = 0;

    virtual void onExchangeDESCMOResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< ExchangeDESCMOResponse >& response) = 0;
};

class GetPrivateItemCallbackIF {
public:
    virtual ~GetPrivateItemCallbackIF() {}

    virtual void onGetPrivateItemError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< GetPrivateItemError >& error) = 0;

    virtual void onGetPrivateItemResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< GetPrivateItemResponse >& response) = 0;
};

class SetPrivateItemCallbackIF {
public:
    virtual ~SetPrivateItemCallbackIF() {}

    virtual void onSetPrivateItemError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< SetPrivateItemError >& error) = 0;

    virtual void onSetPrivateItemResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< SetPrivateItemResponse >& response) = 0;
};


/**
 * ConfigDataProxy is the client side representation of the D-Bus service
 * interface 'de.bosch.cm.ConfigManager.ConfigData' (specified in file
 * cfgmgr_ConfigData_.xml).
 *
 * If the meaning of "de.bosch.cm.ConfigManager.ConfigData" isn't clear, then there should be a description here.
 */
class ConfigDataProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ConfigDataProxy.
     */
    static ::boost::shared_ptr< ConfigDataProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ConfigDataProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ConfigDataProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ConfigDataProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ConfigDataProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ConfigDataProxy > proxyNew(new ConfigDataProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ConfigDataProxy ();




    // Method 'setPrivateItem'

    /**
     * Call the method 'setPrivateItem'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setPrivateItem'</b>:
     *
     * Method called by CfgMgr to set an private item in the application
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param privateItemName the name of the private config item
     *
     * @param privateItem is an array of (key,value) pairs obtained for the respective private item name
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPrivateItemRequest(SetPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::vector< ConfigInfo >& privateItem) const;

    // Method 'getPrivateItem'

    /**
     * Call the method 'getPrivateItem'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getPrivateItem'</b>:
     *
     * Method called by cfgmgr to get the data of an private config item, stored in application.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param privateItemName the name of the private config item
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPrivateItemRequest(GetPrivateItemCallbackIF& cb, const ::std::string& privateItemName) const;

    // Method 'exchangeDESCMO'

    /**
     * Call the method 'exchangeDESCMO'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'exchangeDESCMO'</b>:
     *
     * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param privateItemName the name of the private config item
     *
     * @param privateItemXML the XML encoded private config item data
     *
     * @param signatureXML the XML encoded signature for the private config item data
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendExchangeDESCMORequest(ExchangeDESCMOCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& privateItemXML, const ::std::string& signatureXML) const;

    // Method 'updatePublicConfigItem'

    /**
     * Call the method 'updatePublicConfigItem'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'updatePublicConfigItem'</b>:
     *
     * Method for Applications to receive updates of Public configuration data from ConfigManager.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param publicItemName is the generic configuration data that applications are interested in
     *
     * @param publicItem is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @param status NOT USED - DO NOT CONSIDER FOR IMPLEMENTATION
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdatePublicConfigItemRequest(const ::std::string& publicItemName, const ::std::vector< ConfigInfo >& publicItem, EnItemsStatus status) const;


private:

    ConfigDataProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ConfigDataProxyCallback;
};

} // namespace ConfigData
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATAPROXY_H
