#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATA_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATA_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "de/bosch/cm/ConfigManager/ConfigDataConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "de.bosch.cm.ConfigManager.ConfigData" isn't clear, then there should be a description here.
 */

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigData {

// method IDs
static const uint16 ID_setPrivateItem = 0;
static const uint16 ID_getPrivateItem = 1;
static const uint16 ID_exchangeDESCMO = 2;
static const uint16 ID_updatePublicConfigItem = 3;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class ConfigInfo;

class SetPrivateItemRequest;

class SetPrivateItemResponse;

class GetPrivateItemRequest;

class GetPrivateItemResponse;

class ExchangeDESCMORequest;

class ExchangeDESCMOResponse;

class UpdatePublicConfigItemRequest;

// type definitions
/**
 * If the meaning of "SetPrivateItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPrivateItemError;

/**
 * If the meaning of "GetPrivateItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPrivateItemError;

/**
 * If the meaning of "ExchangeDESCMOError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ExchangeDESCMOError;

/**
 * Method for Applications to receive updates of Public configuration data from ConfigManager.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage UpdatePublicConfigItemResponse;

/**
 * If the meaning of "UpdatePublicConfigItemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdatePublicConfigItemError;


/**
 * Struct ConfigInfo contains key value pair for one application
 */
class ConfigInfo {
public:

    /**
     * Default constructor
     */
    inline  ConfigInfo ();

    /**
     * Copy constructor
     */
    inline  ConfigInfo (const ConfigInfo &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigInfo (const ::std::string& key_, const ::std::string& value_);

    /**
     * Destructor
     */
    inline  ~ConfigInfo();

    /**
     * Assignment operator
     */
    inline ConfigInfo& operator = (const ConfigInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "key"

    static const int kKey = 0;

    /**
     * Clears the field "key".
     *
     * The field will be set to its default value. The hasKey()
     * method will return false.
     */
    inline void clearKey();

    /**
     * Checks whether the field "key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKey()). Otherwise it will return false.
     */
    inline bool hasKey () const;

    /**
     * Returns the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @return The value of the field "key"
     */
    inline const ::std::string& getKey () const;

    /**
     * Retrieves the value of the field "key" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "key".
     */
    inline ::std::string& getKeyMutable ();

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const ::std::string& key_);

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* key_);

    /**
     * Sets the value of the member "key".
     *
     * If the meaning of "key" isn't clear, then there should be a description here.
     *
     * @param key The value which will be set
     */
    inline void setKey (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::std::string& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::std::string& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::std::string& value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value_);

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const char* value, size_t size);

    static const ConfigInfo &getDefaultInstance();

private:

    inline void set_has_key ();

    inline void clear_has_key ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _key;

    ::std::string _value;

};

/**
 * Method called by CfgMgr to set an private item in the application
 */
class SetPrivateItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPrivateItemRequest ();

    /**
     * Copy constructor
     */
    inline  SetPrivateItemRequest (const SetPrivateItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPrivateItemRequest (const ::std::string& privateItemName_, const ::std::vector< ConfigInfo >& privateItem_);

    /**
     * Destructor
     */
    inline virtual  ~SetPrivateItemRequest();

    /**
     * Assignment operator
     */
    inline SetPrivateItemRequest& operator = (const SetPrivateItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPrivateItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPrivateItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPrivateItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPrivateItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItemName"

    static const int kPrivateItemName = 0;

    /**
     * Clears the field "privateItemName".
     *
     * The field will be set to its default value. The hasPrivateItemName()
     * method will return false.
     */
    inline void clearPrivateItemName();

    /**
     * Checks whether the field "privateItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemName()). Otherwise it will return false.
     */
    inline bool hasPrivateItemName () const;

    /**
     * Returns the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @return The value of the field "privateItemName"
     */
    inline const ::std::string& getPrivateItemName () const;

    /**
     * Retrieves the value of the field "privateItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemName".
     */
    inline ::std::string& getPrivateItemNameMutable ();

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const ::std::string& privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* value, size_t size);

    // API of field "privateItem"

    static const int kPrivateItem = 1;

    /**
     * Clears the field "privateItem".
     *
     * The field will be set to its default value. The hasPrivateItem()
     * method will return false.
     */
    inline void clearPrivateItem();

    /**
     * Checks whether the field "privateItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItem()). Otherwise it will return false.
     */
    inline bool hasPrivateItem () const;

    /**
     * Returns the value of the member "privateItem".
     *
     * is an array of (key,value) pairs obtained for the respective private item name
     *
     * @return The value of the field "privateItem"
     */
    inline const ::std::vector< ConfigInfo >& getPrivateItem () const;

    /**
     * Retrieves the value of the field "privateItem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItem".
     */
    inline ::std::vector< ConfigInfo >& getPrivateItemMutable ();

    /**
     * Sets the value of the member "privateItem".
     *
     * is an array of (key,value) pairs obtained for the respective private item name
     *
     * @param privateItem The value which will be set
     */
    inline void setPrivateItem (const ::std::vector< ConfigInfo >& privateItem_);

    static const SetPrivateItemRequest &getDefaultInstance();

private:

    static const ::std::vector< ConfigInfo >& getConfigInfoList_DefaultInstance ();

    inline void set_has_privateItemName ();

    inline void clear_has_privateItemName ();

    inline void set_has_privateItem ();

    inline void clear_has_privateItem ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _privateItemName;

    ::std::vector< ConfigInfo > _privateItem;

};

/**
 * Method called by CfgMgr to set an private item in the application
 */
class SetPrivateItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPrivateItemResponse ();

    /**
     * Copy constructor
     */
    inline  SetPrivateItemResponse (const SetPrivateItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetPrivateItemResponse (EnItemsStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~SetPrivateItemResponse();

    /**
     * Assignment operator
     */
    inline SetPrivateItemResponse& operator = (const SetPrivateItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPrivateItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPrivateItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPrivateItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPrivateItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline EnItemsStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemsStatus status_);

    static const SetPrivateItemResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    EnItemsStatus _status;

};

/**
 * Method called by cfgmgr to get the data of an private config item, stored in application.
 */
class GetPrivateItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPrivateItemRequest ();

    /**
     * Copy constructor
     */
    inline  GetPrivateItemRequest (const GetPrivateItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetPrivateItemRequest (const ::std::string& privateItemName_);

    /**
     * Destructor
     */
    inline virtual  ~GetPrivateItemRequest();

    /**
     * Assignment operator
     */
    inline GetPrivateItemRequest& operator = (const GetPrivateItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPrivateItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPrivateItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPrivateItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPrivateItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItemName"

    static const int kPrivateItemName = 0;

    /**
     * Clears the field "privateItemName".
     *
     * The field will be set to its default value. The hasPrivateItemName()
     * method will return false.
     */
    inline void clearPrivateItemName();

    /**
     * Checks whether the field "privateItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemName()). Otherwise it will return false.
     */
    inline bool hasPrivateItemName () const;

    /**
     * Returns the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @return The value of the field "privateItemName"
     */
    inline const ::std::string& getPrivateItemName () const;

    /**
     * Retrieves the value of the field "privateItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemName".
     */
    inline ::std::string& getPrivateItemNameMutable ();

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const ::std::string& privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* value, size_t size);

    static const GetPrivateItemRequest &getDefaultInstance();

private:

    inline void set_has_privateItemName ();

    inline void clear_has_privateItemName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _privateItemName;

};

/**
 * Method called by cfgmgr to get the data of an private config item, stored in application.
 */
class GetPrivateItemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPrivateItemResponse ();

    /**
     * Copy constructor
     */
    inline  GetPrivateItemResponse (const GetPrivateItemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPrivateItemResponse (const ::std::vector< ConfigInfo >& privateItem_, EnItemsStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~GetPrivateItemResponse();

    /**
     * Assignment operator
     */
    inline GetPrivateItemResponse& operator = (const GetPrivateItemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPrivateItemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPrivateItemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPrivateItemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPrivateItemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItem"

    static const int kPrivateItem = 0;

    /**
     * Clears the field "privateItem".
     *
     * The field will be set to its default value. The hasPrivateItem()
     * method will return false.
     */
    inline void clearPrivateItem();

    /**
     * Checks whether the field "privateItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItem()). Otherwise it will return false.
     */
    inline bool hasPrivateItem () const;

    /**
     * Returns the value of the member "privateItem".
     *
     * is an array of (key,value) pairs obtained for the respective private item name
     *
     * @return The value of the field "privateItem"
     */
    inline const ::std::vector< ConfigInfo >& getPrivateItem () const;

    /**
     * Retrieves the value of the field "privateItem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItem".
     */
    inline ::std::vector< ConfigInfo >& getPrivateItemMutable ();

    /**
     * Sets the value of the member "privateItem".
     *
     * is an array of (key,value) pairs obtained for the respective private item name
     *
     * @param privateItem The value which will be set
     */
    inline void setPrivateItem (const ::std::vector< ConfigInfo >& privateItem_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return value to indicate result of get operation
     *
     * @return The value of the field "status"
     */
    inline EnItemsStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return value to indicate result of get operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemsStatus status_);

    static const GetPrivateItemResponse &getDefaultInstance();

private:

    static const ::std::vector< ConfigInfo >& getConfigInfoList_DefaultInstance ();

    inline void set_has_privateItem ();

    inline void clear_has_privateItem ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ConfigInfo > _privateItem;

    EnItemsStatus _status;

};

/**
 * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
 */
class ExchangeDESCMORequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExchangeDESCMORequest ();

    /**
     * Copy constructor
     */
    inline  ExchangeDESCMORequest (const ExchangeDESCMORequest &rhs);

    /**
     * All fields constructor
     */
    inline  ExchangeDESCMORequest (const ::std::string& privateItemName_, const ::std::string& privateItemXML_, const ::std::string& signatureXML_);

    /**
     * Destructor
     */
    inline virtual  ~ExchangeDESCMORequest();

    /**
     * Assignment operator
     */
    inline ExchangeDESCMORequest& operator = (const ExchangeDESCMORequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExchangeDESCMORequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExchangeDESCMORequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExchangeDESCMORequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExchangeDESCMORequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privateItemName"

    static const int kPrivateItemName = 0;

    /**
     * Clears the field "privateItemName".
     *
     * The field will be set to its default value. The hasPrivateItemName()
     * method will return false.
     */
    inline void clearPrivateItemName();

    /**
     * Checks whether the field "privateItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemName()). Otherwise it will return false.
     */
    inline bool hasPrivateItemName () const;

    /**
     * Returns the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @return The value of the field "privateItemName"
     */
    inline const ::std::string& getPrivateItemName () const;

    /**
     * Retrieves the value of the field "privateItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemName".
     */
    inline ::std::string& getPrivateItemNameMutable ();

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const ::std::string& privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* privateItemName_);

    /**
     * Sets the value of the member "privateItemName".
     *
     * the name of the private config item
     *
     * @param privateItemName The value which will be set
     */
    inline void setPrivateItemName (const char* value, size_t size);

    // API of field "privateItemXML"

    static const int kPrivateItemXML = 1;

    /**
     * Clears the field "privateItemXML".
     *
     * The field will be set to its default value. The hasPrivateItemXML()
     * method will return false.
     */
    inline void clearPrivateItemXML();

    /**
     * Checks whether the field "privateItemXML" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivateItemXML()). Otherwise it will return false.
     */
    inline bool hasPrivateItemXML () const;

    /**
     * Returns the value of the member "privateItemXML".
     *
     * the XML encoded private config item data
     *
     * @return The value of the field "privateItemXML"
     */
    inline const ::std::string& getPrivateItemXML () const;

    /**
     * Retrieves the value of the field "privateItemXML" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "privateItemXML".
     */
    inline ::std::string& getPrivateItemXMLMutable ();

    /**
     * Sets the value of the member "privateItemXML".
     *
     * the XML encoded private config item data
     *
     * @param privateItemXML The value which will be set
     */
    inline void setPrivateItemXML (const ::std::string& privateItemXML_);

    /**
     * Sets the value of the member "privateItemXML".
     *
     * the XML encoded private config item data
     *
     * @param privateItemXML The value which will be set
     */
    inline void setPrivateItemXML (const char* privateItemXML_);

    /**
     * Sets the value of the member "privateItemXML".
     *
     * the XML encoded private config item data
     *
     * @param privateItemXML The value which will be set
     */
    inline void setPrivateItemXML (const char* value, size_t size);

    // API of field "signatureXML"

    static const int kSignatureXML = 2;

    /**
     * Clears the field "signatureXML".
     *
     * The field will be set to its default value. The hasSignatureXML()
     * method will return false.
     */
    inline void clearSignatureXML();

    /**
     * Checks whether the field "signatureXML" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSignatureXML()). Otherwise it will return false.
     */
    inline bool hasSignatureXML () const;

    /**
     * Returns the value of the member "signatureXML".
     *
     * the XML encoded signature for the private config item data
     *
     * @return The value of the field "signatureXML"
     */
    inline const ::std::string& getSignatureXML () const;

    /**
     * Retrieves the value of the field "signatureXML" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "signatureXML".
     */
    inline ::std::string& getSignatureXMLMutable ();

    /**
     * Sets the value of the member "signatureXML".
     *
     * the XML encoded signature for the private config item data
     *
     * @param signatureXML The value which will be set
     */
    inline void setSignatureXML (const ::std::string& signatureXML_);

    /**
     * Sets the value of the member "signatureXML".
     *
     * the XML encoded signature for the private config item data
     *
     * @param signatureXML The value which will be set
     */
    inline void setSignatureXML (const char* signatureXML_);

    /**
     * Sets the value of the member "signatureXML".
     *
     * the XML encoded signature for the private config item data
     *
     * @param signatureXML The value which will be set
     */
    inline void setSignatureXML (const char* value, size_t size);

    static const ExchangeDESCMORequest &getDefaultInstance();

private:

    inline void set_has_privateItemName ();

    inline void clear_has_privateItemName ();

    inline void set_has_privateItemXML ();

    inline void clear_has_privateItemXML ();

    inline void set_has_signatureXML ();

    inline void clear_has_signatureXML ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _privateItemName;

    ::std::string _privateItemXML;

    ::std::string _signatureXML;

};

/**
 * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
 */
class ExchangeDESCMOResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExchangeDESCMOResponse ();

    /**
     * Copy constructor
     */
    inline  ExchangeDESCMOResponse (const ExchangeDESCMOResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ExchangeDESCMOResponse (const ::std::string& outPrivateItemXML_, EnItemsStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~ExchangeDESCMOResponse();

    /**
     * Assignment operator
     */
    inline ExchangeDESCMOResponse& operator = (const ExchangeDESCMOResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExchangeDESCMOResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExchangeDESCMOResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExchangeDESCMOResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExchangeDESCMOResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "outPrivateItemXML"

    static const int kOutPrivateItemXML = 0;

    /**
     * Clears the field "outPrivateItemXML".
     *
     * The field will be set to its default value. The hasOutPrivateItemXML()
     * method will return false.
     */
    inline void clearOutPrivateItemXML();

    /**
     * Checks whether the field "outPrivateItemXML" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutPrivateItemXML()). Otherwise it will return false.
     */
    inline bool hasOutPrivateItemXML () const;

    /**
     * Returns the value of the member "outPrivateItemXML".
     *
     * the XML encoded private config item data returned from application. In case of GET the application has updated the data.
     *
     * @return The value of the field "outPrivateItemXML"
     */
    inline const ::std::string& getOutPrivateItemXML () const;

    /**
     * Retrieves the value of the field "outPrivateItemXML" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outPrivateItemXML".
     */
    inline ::std::string& getOutPrivateItemXMLMutable ();

    /**
     * Sets the value of the member "outPrivateItemXML".
     *
     * the XML encoded private config item data returned from application. In case of GET the application has updated the data.
     *
     * @param outPrivateItemXML The value which will be set
     */
    inline void setOutPrivateItemXML (const ::std::string& outPrivateItemXML_);

    /**
     * Sets the value of the member "outPrivateItemXML".
     *
     * the XML encoded private config item data returned from application. In case of GET the application has updated the data.
     *
     * @param outPrivateItemXML The value which will be set
     */
    inline void setOutPrivateItemXML (const char* outPrivateItemXML_);

    /**
     * Sets the value of the member "outPrivateItemXML".
     *
     * the XML encoded private config item data returned from application. In case of GET the application has updated the data.
     *
     * @param outPrivateItemXML The value which will be set
     */
    inline void setOutPrivateItemXML (const char* value, size_t size);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * return value, indicating result of exchange operation
     *
     * @return The value of the field "status"
     */
    inline EnItemsStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * return value, indicating result of exchange operation
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemsStatus status_);

    static const ExchangeDESCMOResponse &getDefaultInstance();

private:

    inline void set_has_outPrivateItemXML ();

    inline void clear_has_outPrivateItemXML ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _outPrivateItemXML;

    EnItemsStatus _status;

};

/**
 * Method for Applications to receive updates of Public configuration data from ConfigManager.
 */
class UpdatePublicConfigItemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdatePublicConfigItemRequest ();

    /**
     * Copy constructor
     */
    inline  UpdatePublicConfigItemRequest (const UpdatePublicConfigItemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdatePublicConfigItemRequest (const ::std::string& publicItemName_, const ::std::vector< ConfigInfo >& publicItem_, EnItemsStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~UpdatePublicConfigItemRequest();

    /**
     * Assignment operator
     */
    inline UpdatePublicConfigItemRequest& operator = (const UpdatePublicConfigItemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdatePublicConfigItemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdatePublicConfigItemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdatePublicConfigItemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdatePublicConfigItemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "publicItemName"

    static const int kPublicItemName = 0;

    /**
     * Clears the field "publicItemName".
     *
     * The field will be set to its default value. The hasPublicItemName()
     * method will return false.
     */
    inline void clearPublicItemName();

    /**
     * Checks whether the field "publicItemName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItemName()). Otherwise it will return false.
     */
    inline bool hasPublicItemName () const;

    /**
     * Returns the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @return The value of the field "publicItemName"
     */
    inline const ::std::string& getPublicItemName () const;

    /**
     * Retrieves the value of the field "publicItemName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItemName".
     */
    inline ::std::string& getPublicItemNameMutable ();

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const ::std::string& publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* publicItemName_);

    /**
     * Sets the value of the member "publicItemName".
     *
     * is the generic configuration data that applications are interested in
     *
     * @param publicItemName The value which will be set
     */
    inline void setPublicItemName (const char* value, size_t size);

    // API of field "publicItem"

    static const int kPublicItem = 1;

    /**
     * Clears the field "publicItem".
     *
     * The field will be set to its default value. The hasPublicItem()
     * method will return false.
     */
    inline void clearPublicItem();

    /**
     * Checks whether the field "publicItem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPublicItem()). Otherwise it will return false.
     */
    inline bool hasPublicItem () const;

    /**
     * Returns the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @return The value of the field "publicItem"
     */
    inline const ::std::vector< ConfigInfo >& getPublicItem () const;

    /**
     * Retrieves the value of the field "publicItem" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "publicItem".
     */
    inline ::std::vector< ConfigInfo >& getPublicItemMutable ();

    /**
     * Sets the value of the member "publicItem".
     *
     * is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @param publicItem The value which will be set
     */
    inline void setPublicItem (const ::std::vector< ConfigInfo >& publicItem_);

    // API of field "status"

    static const int kStatus = 2;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * NOT USED - DO NOT CONSIDER FOR IMPLEMENTATION
     *
     * @return The value of the field "status"
     */
    inline EnItemsStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * NOT USED - DO NOT CONSIDER FOR IMPLEMENTATION
     *
     * @param status The value which will be set
     */
    inline void setStatus (EnItemsStatus status_);

    static const UpdatePublicConfigItemRequest &getDefaultInstance();

private:

    static const ::std::vector< ConfigInfo >& getConfigInfoList_DefaultInstance ();

    inline void set_has_publicItemName ();

    inline void clear_has_publicItemName ();

    inline void set_has_publicItem ();

    inline void clear_has_publicItem ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _publicItemName;

    ::std::vector< ConfigInfo > _publicItem;

    EnItemsStatus _status;

};

inline  ConfigInfo::ConfigInfo ()  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigInfo::ConfigInfo (const ConfigInfo &rhs)  :
    _key (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigInfo::ConfigInfo (const ::std::string& key_, const ::std::string& value_)  :
    _key (key_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigInfo::~ConfigInfo() {
}

inline ConfigInfo& ConfigInfo::operator = (const ConfigInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasKey()) {
            setKey(rhs.getKey());
        } else {
            clearKey();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool ConfigInfo::operator == (const ConfigInfo& rhs) const {
    return (((!hasKey() && !rhs.hasKey()) || getKey() == rhs.getKey()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool ConfigInfo::operator != (const ConfigInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigInfo::operator < (const ConfigInfo& rhs) const {
    if (hasKey() || rhs.hasKey()) {
        if (getKey() < rhs.getKey()) return true;
        if (getKey() > rhs.getKey()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline bool ConfigInfo::operator > (const ConfigInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigInfo::clear() {
    clearKey();
    clearValue();
}

inline void ConfigInfo::clearKey() {
    if (hasKey()) {
         clear_has_key();
        _key.clear();
     }
}

inline bool ConfigInfo::hasKey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ConfigInfo::getKey () const {
    return _key;
}

inline ::std::string& ConfigInfo::getKeyMutable () {
    set_has_key();
    return _key;
}

inline void ConfigInfo::setKey (const ::std::string& key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key = key_;
}

inline void ConfigInfo::setKey (const char* key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(key_);
}

inline void ConfigInfo::setKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_key();
    this->_key.assign(value, size);
}

inline void ConfigInfo::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value.clear();
     }
}

inline bool ConfigInfo::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ConfigInfo::getValue () const {
    return _value;
}

inline ::std::string& ConfigInfo::getValueMutable () {
    set_has_value();
    return _value;
}

inline void ConfigInfo::setValue (const ::std::string& value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value = value_;
}

inline void ConfigInfo::setValue (const char* value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value_);
}

inline void ConfigInfo::setValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_value();
    this->_value.assign(value, size);
}

inline void ConfigInfo::set_has_key () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigInfo::clear_has_key () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ConfigInfo::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void ConfigInfo::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetPrivateItemRequest::SetPrivateItemRequest ()  :
    _privateItemName (),
    _privateItem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPrivateItemRequest::SetPrivateItemRequest (const SetPrivateItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItemName (),
    _privateItem ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPrivateItemRequest::SetPrivateItemRequest (const ::std::string& privateItemName_, const ::std::vector< ConfigInfo >& privateItem_)  :
    _privateItemName (privateItemName_),
    _privateItem (privateItem_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPrivateItemRequest::~SetPrivateItemRequest() {
}

inline SetPrivateItemRequest& SetPrivateItemRequest::operator = (const SetPrivateItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItemName()) {
            setPrivateItemName(rhs.getPrivateItemName());
        } else {
            clearPrivateItemName();
        }
        if (rhs.hasPrivateItem()) {
            setPrivateItem(rhs.getPrivateItem());
        } else {
            clearPrivateItem();
        }
    }
    return *this;
}

inline bool SetPrivateItemRequest::operator == (const SetPrivateItemRequest& rhs) const {
    return (((!hasPrivateItemName() && !rhs.hasPrivateItemName()) || getPrivateItemName() == rhs.getPrivateItemName()) &&
        ((!hasPrivateItem() && !rhs.hasPrivateItem()) || getPrivateItem() == rhs.getPrivateItem()));
}

inline bool SetPrivateItemRequest::operator != (const SetPrivateItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPrivateItemRequest::operator < (const SetPrivateItemRequest& rhs) const {
    if (hasPrivateItemName() || rhs.hasPrivateItemName()) {
        if (getPrivateItemName() < rhs.getPrivateItemName()) return true;
        if (getPrivateItemName() > rhs.getPrivateItemName()) return false;
    }
    if (hasPrivateItem() || rhs.hasPrivateItem()) {
        if (getPrivateItem() < rhs.getPrivateItem()) return true;
        if (getPrivateItem() > rhs.getPrivateItem()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPrivateItemRequest::clone() {
    return new SetPrivateItemRequest(*this);
}

inline bool SetPrivateItemRequest::operator > (const SetPrivateItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPrivateItemRequest::clear() {
    clearPrivateItemName();
    clearPrivateItem();
}

inline void SetPrivateItemRequest::clearPrivateItemName() {
    if (hasPrivateItemName()) {
         clear_has_privateItemName();
        _privateItemName.clear();
     }
}

inline bool SetPrivateItemRequest::hasPrivateItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPrivateItemRequest::getPrivateItemName () const {
    return _privateItemName;
}

inline ::std::string& SetPrivateItemRequest::getPrivateItemNameMutable () {
    set_has_privateItemName();
    return _privateItemName;
}

inline void SetPrivateItemRequest::setPrivateItemName (const ::std::string& privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName = privateItemName_;
}

inline void SetPrivateItemRequest::setPrivateItemName (const char* privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(privateItemName_);
}

inline void SetPrivateItemRequest::setPrivateItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(value, size);
}

inline void SetPrivateItemRequest::clearPrivateItem() {
    if (hasPrivateItem()) {
         clear_has_privateItem();
        _privateItem.clear();
     }
}

inline bool SetPrivateItemRequest::hasPrivateItem () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ConfigInfo >& SetPrivateItemRequest::getPrivateItem () const {
    return _privateItem;
}

inline ::std::vector< ConfigInfo >& SetPrivateItemRequest::getPrivateItemMutable () {
    set_has_privateItem();
    return _privateItem;
}

inline void SetPrivateItemRequest::setPrivateItem (const ::std::vector< ConfigInfo >& privateItem_) {
    set_has_privateItem();
    this->_privateItem = privateItem_;
}

inline void SetPrivateItemRequest::set_has_privateItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPrivateItemRequest::clear_has_privateItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPrivateItemRequest::set_has_privateItem () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPrivateItemRequest::clear_has_privateItem () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetPrivateItemResponse::SetPrivateItemResponse ()  :
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPrivateItemResponse::SetPrivateItemResponse (const SetPrivateItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPrivateItemResponse::SetPrivateItemResponse (EnItemsStatus status_)  :
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "SetPrivateItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPrivateItemResponse::~SetPrivateItemResponse() {
}

inline SetPrivateItemResponse& SetPrivateItemResponse::operator = (const SetPrivateItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SetPrivateItemResponse::operator == (const SetPrivateItemResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SetPrivateItemResponse::operator != (const SetPrivateItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPrivateItemResponse::operator < (const SetPrivateItemResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPrivateItemResponse::clone() {
    return new SetPrivateItemResponse(*this);
}

inline bool SetPrivateItemResponse::operator > (const SetPrivateItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPrivateItemResponse::clear() {
    clearStatus();
}

inline void SetPrivateItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS;
     }
}

inline bool SetPrivateItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline EnItemsStatus SetPrivateItemResponse::getStatus () const {
    return _status;
}

inline void SetPrivateItemResponse::setStatus (EnItemsStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "SetPrivateItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void SetPrivateItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPrivateItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPrivateItemRequest::GetPrivateItemRequest ()  :
    _privateItemName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPrivateItemRequest::GetPrivateItemRequest (const GetPrivateItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItemName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPrivateItemRequest::GetPrivateItemRequest (const ::std::string& privateItemName_)  :
    _privateItemName (privateItemName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPrivateItemRequest::~GetPrivateItemRequest() {
}

inline GetPrivateItemRequest& GetPrivateItemRequest::operator = (const GetPrivateItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItemName()) {
            setPrivateItemName(rhs.getPrivateItemName());
        } else {
            clearPrivateItemName();
        }
    }
    return *this;
}

inline bool GetPrivateItemRequest::operator == (const GetPrivateItemRequest& rhs) const {
    return (((!hasPrivateItemName() && !rhs.hasPrivateItemName()) || getPrivateItemName() == rhs.getPrivateItemName()));
}

inline bool GetPrivateItemRequest::operator != (const GetPrivateItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPrivateItemRequest::operator < (const GetPrivateItemRequest& rhs) const {
    if (hasPrivateItemName() || rhs.hasPrivateItemName()) {
        if (getPrivateItemName() < rhs.getPrivateItemName()) return true;
        if (getPrivateItemName() > rhs.getPrivateItemName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPrivateItemRequest::clone() {
    return new GetPrivateItemRequest(*this);
}

inline bool GetPrivateItemRequest::operator > (const GetPrivateItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPrivateItemRequest::clear() {
    clearPrivateItemName();
}

inline void GetPrivateItemRequest::clearPrivateItemName() {
    if (hasPrivateItemName()) {
         clear_has_privateItemName();
        _privateItemName.clear();
     }
}

inline bool GetPrivateItemRequest::hasPrivateItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetPrivateItemRequest::getPrivateItemName () const {
    return _privateItemName;
}

inline ::std::string& GetPrivateItemRequest::getPrivateItemNameMutable () {
    set_has_privateItemName();
    return _privateItemName;
}

inline void GetPrivateItemRequest::setPrivateItemName (const ::std::string& privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName = privateItemName_;
}

inline void GetPrivateItemRequest::setPrivateItemName (const char* privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(privateItemName_);
}

inline void GetPrivateItemRequest::setPrivateItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(value, size);
}

inline void GetPrivateItemRequest::set_has_privateItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPrivateItemRequest::clear_has_privateItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetPrivateItemResponse::GetPrivateItemResponse ()  :
    _privateItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPrivateItemResponse::GetPrivateItemResponse (const GetPrivateItemResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPrivateItemResponse::GetPrivateItemResponse (const ::std::vector< ConfigInfo >& privateItem_, EnItemsStatus status_)  :
    _privateItem (privateItem_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "GetPrivateItemResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPrivateItemResponse::~GetPrivateItemResponse() {
}

inline GetPrivateItemResponse& GetPrivateItemResponse::operator = (const GetPrivateItemResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItem()) {
            setPrivateItem(rhs.getPrivateItem());
        } else {
            clearPrivateItem();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetPrivateItemResponse::operator == (const GetPrivateItemResponse& rhs) const {
    return (((!hasPrivateItem() && !rhs.hasPrivateItem()) || getPrivateItem() == rhs.getPrivateItem()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetPrivateItemResponse::operator != (const GetPrivateItemResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPrivateItemResponse::operator < (const GetPrivateItemResponse& rhs) const {
    if (hasPrivateItem() || rhs.hasPrivateItem()) {
        if (getPrivateItem() < rhs.getPrivateItem()) return true;
        if (getPrivateItem() > rhs.getPrivateItem()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPrivateItemResponse::clone() {
    return new GetPrivateItemResponse(*this);
}

inline bool GetPrivateItemResponse::operator > (const GetPrivateItemResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPrivateItemResponse::clear() {
    clearPrivateItem();
    clearStatus();
}

inline void GetPrivateItemResponse::clearPrivateItem() {
    if (hasPrivateItem()) {
         clear_has_privateItem();
        _privateItem.clear();
     }
}

inline bool GetPrivateItemResponse::hasPrivateItem () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ConfigInfo >& GetPrivateItemResponse::getPrivateItem () const {
    return _privateItem;
}

inline ::std::vector< ConfigInfo >& GetPrivateItemResponse::getPrivateItemMutable () {
    set_has_privateItem();
    return _privateItem;
}

inline void GetPrivateItemResponse::setPrivateItem (const ::std::vector< ConfigInfo >& privateItem_) {
    set_has_privateItem();
    this->_privateItem = privateItem_;
}

inline void GetPrivateItemResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS;
     }
}

inline bool GetPrivateItemResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline EnItemsStatus GetPrivateItemResponse::getStatus () const {
    return _status;
}

inline void GetPrivateItemResponse::setStatus (EnItemsStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "GetPrivateItemResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void GetPrivateItemResponse::set_has_privateItem () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPrivateItemResponse::clear_has_privateItem () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetPrivateItemResponse::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetPrivateItemResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ExchangeDESCMORequest::ExchangeDESCMORequest ()  :
    _privateItemName (),
    _privateItemXML (),
    _signatureXML ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExchangeDESCMORequest::ExchangeDESCMORequest (const ExchangeDESCMORequest &rhs)  :
    ::asf::core::Payload(rhs),
    _privateItemName (),
    _privateItemXML (),
    _signatureXML ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExchangeDESCMORequest::ExchangeDESCMORequest (const ::std::string& privateItemName_, const ::std::string& privateItemXML_, const ::std::string& signatureXML_)  :
    _privateItemName (privateItemName_),
    _privateItemXML (privateItemXML_),
    _signatureXML (signatureXML_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signatureXML_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExchangeDESCMORequest::~ExchangeDESCMORequest() {
}

inline ExchangeDESCMORequest& ExchangeDESCMORequest::operator = (const ExchangeDESCMORequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivateItemName()) {
            setPrivateItemName(rhs.getPrivateItemName());
        } else {
            clearPrivateItemName();
        }
        if (rhs.hasPrivateItemXML()) {
            setPrivateItemXML(rhs.getPrivateItemXML());
        } else {
            clearPrivateItemXML();
        }
        if (rhs.hasSignatureXML()) {
            setSignatureXML(rhs.getSignatureXML());
        } else {
            clearSignatureXML();
        }
    }
    return *this;
}

inline bool ExchangeDESCMORequest::operator == (const ExchangeDESCMORequest& rhs) const {
    return (((!hasPrivateItemName() && !rhs.hasPrivateItemName()) || getPrivateItemName() == rhs.getPrivateItemName()) &&
        ((!hasPrivateItemXML() && !rhs.hasPrivateItemXML()) || getPrivateItemXML() == rhs.getPrivateItemXML()) &&
        ((!hasSignatureXML() && !rhs.hasSignatureXML()) || getSignatureXML() == rhs.getSignatureXML()));
}

inline bool ExchangeDESCMORequest::operator != (const ExchangeDESCMORequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ExchangeDESCMORequest::operator < (const ExchangeDESCMORequest& rhs) const {
    if (hasPrivateItemName() || rhs.hasPrivateItemName()) {
        if (getPrivateItemName() < rhs.getPrivateItemName()) return true;
        if (getPrivateItemName() > rhs.getPrivateItemName()) return false;
    }
    if (hasPrivateItemXML() || rhs.hasPrivateItemXML()) {
        if (getPrivateItemXML() < rhs.getPrivateItemXML()) return true;
        if (getPrivateItemXML() > rhs.getPrivateItemXML()) return false;
    }
    if (hasSignatureXML() || rhs.hasSignatureXML()) {
        if (getSignatureXML() < rhs.getSignatureXML()) return true;
        if (getSignatureXML() > rhs.getSignatureXML()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExchangeDESCMORequest::clone() {
    return new ExchangeDESCMORequest(*this);
}

inline bool ExchangeDESCMORequest::operator > (const ExchangeDESCMORequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExchangeDESCMORequest::clear() {
    clearPrivateItemName();
    clearPrivateItemXML();
    clearSignatureXML();
}

inline void ExchangeDESCMORequest::clearPrivateItemName() {
    if (hasPrivateItemName()) {
         clear_has_privateItemName();
        _privateItemName.clear();
     }
}

inline bool ExchangeDESCMORequest::hasPrivateItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ExchangeDESCMORequest::getPrivateItemName () const {
    return _privateItemName;
}

inline ::std::string& ExchangeDESCMORequest::getPrivateItemNameMutable () {
    set_has_privateItemName();
    return _privateItemName;
}

inline void ExchangeDESCMORequest::setPrivateItemName (const ::std::string& privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName = privateItemName_;
}

inline void ExchangeDESCMORequest::setPrivateItemName (const char* privateItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(privateItemName_);
}

inline void ExchangeDESCMORequest::setPrivateItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemName();
    this->_privateItemName.assign(value, size);
}

inline void ExchangeDESCMORequest::clearPrivateItemXML() {
    if (hasPrivateItemXML()) {
         clear_has_privateItemXML();
        _privateItemXML.clear();
     }
}

inline bool ExchangeDESCMORequest::hasPrivateItemXML () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ExchangeDESCMORequest::getPrivateItemXML () const {
    return _privateItemXML;
}

inline ::std::string& ExchangeDESCMORequest::getPrivateItemXMLMutable () {
    set_has_privateItemXML();
    return _privateItemXML;
}

inline void ExchangeDESCMORequest::setPrivateItemXML (const ::std::string& privateItemXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemXML();
    this->_privateItemXML = privateItemXML_;
}

inline void ExchangeDESCMORequest::setPrivateItemXML (const char* privateItemXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (privateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemXML();
    this->_privateItemXML.assign(privateItemXML_);
}

inline void ExchangeDESCMORequest::setPrivateItemXML (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_privateItemXML();
    this->_privateItemXML.assign(value, size);
}

inline void ExchangeDESCMORequest::clearSignatureXML() {
    if (hasSignatureXML()) {
         clear_has_signatureXML();
        _signatureXML.clear();
     }
}

inline bool ExchangeDESCMORequest::hasSignatureXML () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& ExchangeDESCMORequest::getSignatureXML () const {
    return _signatureXML;
}

inline ::std::string& ExchangeDESCMORequest::getSignatureXMLMutable () {
    set_has_signatureXML();
    return _signatureXML;
}

inline void ExchangeDESCMORequest::setSignatureXML (const ::std::string& signatureXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signatureXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signatureXML();
    this->_signatureXML = signatureXML_;
}

inline void ExchangeDESCMORequest::setSignatureXML (const char* signatureXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (signatureXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signatureXML();
    this->_signatureXML.assign(signatureXML_);
}

inline void ExchangeDESCMORequest::setSignatureXML (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_signatureXML();
    this->_signatureXML.assign(value, size);
}

inline void ExchangeDESCMORequest::set_has_privateItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExchangeDESCMORequest::clear_has_privateItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ExchangeDESCMORequest::set_has_privateItemXML () {
    _has_bits_[0] |= 1u << 1;
}

inline void ExchangeDESCMORequest::clear_has_privateItemXML () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ExchangeDESCMORequest::set_has_signatureXML () {
    _has_bits_[0] |= 1u << 2;
}

inline void ExchangeDESCMORequest::clear_has_signatureXML () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ExchangeDESCMOResponse::ExchangeDESCMOResponse ()  :
    _outPrivateItemXML (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ExchangeDESCMOResponse::ExchangeDESCMOResponse (const ExchangeDESCMOResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _outPrivateItemXML (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ExchangeDESCMOResponse::ExchangeDESCMOResponse (const ::std::string& outPrivateItemXML_, EnItemsStatus status_)  :
    _outPrivateItemXML (outPrivateItemXML_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outPrivateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "ExchangeDESCMOResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ExchangeDESCMOResponse::~ExchangeDESCMOResponse() {
}

inline ExchangeDESCMOResponse& ExchangeDESCMOResponse::operator = (const ExchangeDESCMOResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOutPrivateItemXML()) {
            setOutPrivateItemXML(rhs.getOutPrivateItemXML());
        } else {
            clearOutPrivateItemXML();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ExchangeDESCMOResponse::operator == (const ExchangeDESCMOResponse& rhs) const {
    return (((!hasOutPrivateItemXML() && !rhs.hasOutPrivateItemXML()) || getOutPrivateItemXML() == rhs.getOutPrivateItemXML()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ExchangeDESCMOResponse::operator != (const ExchangeDESCMOResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ExchangeDESCMOResponse::operator < (const ExchangeDESCMOResponse& rhs) const {
    if (hasOutPrivateItemXML() || rhs.hasOutPrivateItemXML()) {
        if (getOutPrivateItemXML() < rhs.getOutPrivateItemXML()) return true;
        if (getOutPrivateItemXML() > rhs.getOutPrivateItemXML()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ExchangeDESCMOResponse::clone() {
    return new ExchangeDESCMOResponse(*this);
}

inline bool ExchangeDESCMOResponse::operator > (const ExchangeDESCMOResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ExchangeDESCMOResponse::clear() {
    clearOutPrivateItemXML();
    clearStatus();
}

inline void ExchangeDESCMOResponse::clearOutPrivateItemXML() {
    if (hasOutPrivateItemXML()) {
         clear_has_outPrivateItemXML();
        _outPrivateItemXML.clear();
     }
}

inline bool ExchangeDESCMOResponse::hasOutPrivateItemXML () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ExchangeDESCMOResponse::getOutPrivateItemXML () const {
    return _outPrivateItemXML;
}

inline ::std::string& ExchangeDESCMOResponse::getOutPrivateItemXMLMutable () {
    set_has_outPrivateItemXML();
    return _outPrivateItemXML;
}

inline void ExchangeDESCMOResponse::setOutPrivateItemXML (const ::std::string& outPrivateItemXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outPrivateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outPrivateItemXML();
    this->_outPrivateItemXML = outPrivateItemXML_;
}

inline void ExchangeDESCMOResponse::setOutPrivateItemXML (const char* outPrivateItemXML_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (outPrivateItemXML_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outPrivateItemXML();
    this->_outPrivateItemXML.assign(outPrivateItemXML_);
}

inline void ExchangeDESCMOResponse::setOutPrivateItemXML (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_outPrivateItemXML();
    this->_outPrivateItemXML.assign(value, size);
}

inline void ExchangeDESCMOResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS;
     }
}

inline bool ExchangeDESCMOResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline EnItemsStatus ExchangeDESCMOResponse::getStatus () const {
    return _status;
}

inline void ExchangeDESCMOResponse::setStatus (EnItemsStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "ExchangeDESCMOResponse");
    }
    set_has_status();
    this->_status = status_;
}

inline void ExchangeDESCMOResponse::set_has_outPrivateItemXML () {
    _has_bits_[0] |= 1u << 0;
}

inline void ExchangeDESCMOResponse::clear_has_outPrivateItemXML () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ExchangeDESCMOResponse::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void ExchangeDESCMOResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdatePublicConfigItemRequest::UpdatePublicConfigItemRequest ()  :
    _publicItemName (),
    _publicItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdatePublicConfigItemRequest::UpdatePublicConfigItemRequest (const UpdatePublicConfigItemRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _publicItemName (),
    _publicItem (),
    _status (::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdatePublicConfigItemRequest::UpdatePublicConfigItemRequest (const ::std::string& publicItemName_, const ::std::vector< ConfigInfo >& publicItem_, EnItemsStatus status_)  :
    _publicItemName (publicItemName_),
    _publicItem (publicItem_),
    _status (status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "UpdatePublicConfigItemRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdatePublicConfigItemRequest::~UpdatePublicConfigItemRequest() {
}

inline UpdatePublicConfigItemRequest& UpdatePublicConfigItemRequest::operator = (const UpdatePublicConfigItemRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPublicItemName()) {
            setPublicItemName(rhs.getPublicItemName());
        } else {
            clearPublicItemName();
        }
        if (rhs.hasPublicItem()) {
            setPublicItem(rhs.getPublicItem());
        } else {
            clearPublicItem();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool UpdatePublicConfigItemRequest::operator == (const UpdatePublicConfigItemRequest& rhs) const {
    return (((!hasPublicItemName() && !rhs.hasPublicItemName()) || getPublicItemName() == rhs.getPublicItemName()) &&
        ((!hasPublicItem() && !rhs.hasPublicItem()) || getPublicItem() == rhs.getPublicItem()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool UpdatePublicConfigItemRequest::operator != (const UpdatePublicConfigItemRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdatePublicConfigItemRequest::operator < (const UpdatePublicConfigItemRequest& rhs) const {
    if (hasPublicItemName() || rhs.hasPublicItemName()) {
        if (getPublicItemName() < rhs.getPublicItemName()) return true;
        if (getPublicItemName() > rhs.getPublicItemName()) return false;
    }
    if (hasPublicItem() || rhs.hasPublicItem()) {
        if (getPublicItem() < rhs.getPublicItem()) return true;
        if (getPublicItem() > rhs.getPublicItem()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdatePublicConfigItemRequest::clone() {
    return new UpdatePublicConfigItemRequest(*this);
}

inline bool UpdatePublicConfigItemRequest::operator > (const UpdatePublicConfigItemRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdatePublicConfigItemRequest::clear() {
    clearPublicItemName();
    clearPublicItem();
    clearStatus();
}

inline void UpdatePublicConfigItemRequest::clearPublicItemName() {
    if (hasPublicItemName()) {
         clear_has_publicItemName();
        _publicItemName.clear();
     }
}

inline bool UpdatePublicConfigItemRequest::hasPublicItemName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UpdatePublicConfigItemRequest::getPublicItemName () const {
    return _publicItemName;
}

inline ::std::string& UpdatePublicConfigItemRequest::getPublicItemNameMutable () {
    set_has_publicItemName();
    return _publicItemName;
}

inline void UpdatePublicConfigItemRequest::setPublicItemName (const ::std::string& publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName = publicItemName_;
}

inline void UpdatePublicConfigItemRequest::setPublicItemName (const char* publicItemName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (publicItemName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(publicItemName_);
}

inline void UpdatePublicConfigItemRequest::setPublicItemName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_publicItemName();
    this->_publicItemName.assign(value, size);
}

inline void UpdatePublicConfigItemRequest::clearPublicItem() {
    if (hasPublicItem()) {
         clear_has_publicItem();
        _publicItem.clear();
     }
}

inline bool UpdatePublicConfigItemRequest::hasPublicItem () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ConfigInfo >& UpdatePublicConfigItemRequest::getPublicItem () const {
    return _publicItem;
}

inline ::std::vector< ConfigInfo >& UpdatePublicConfigItemRequest::getPublicItemMutable () {
    set_has_publicItem();
    return _publicItem;
}

inline void UpdatePublicConfigItemRequest::setPublicItem (const ::std::vector< ConfigInfo >& publicItem_) {
    set_has_publicItem();
    this->_publicItem = publicItem_;
}

inline void UpdatePublicConfigItemRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::de::bosch::cm::ConfigManager::ConfigData::EnItemsStatus__SUCCESS;
     }
}

inline bool UpdatePublicConfigItemRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline EnItemsStatus UpdatePublicConfigItemRequest::getStatus () const {
    return _status;
}

inline void UpdatePublicConfigItemRequest::setStatus (EnItemsStatus status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(EnItemsStatus_IsValid(status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "EnItemsStatus", "status", "UpdatePublicConfigItemRequest");
    }
    set_has_status();
    this->_status = status_;
}

inline void UpdatePublicConfigItemRequest::set_has_publicItemName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdatePublicConfigItemRequest::clear_has_publicItemName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdatePublicConfigItemRequest::set_has_publicItem () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdatePublicConfigItemRequest::clear_has_publicItem () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void UpdatePublicConfigItemRequest::set_has_status () {
    _has_bits_[0] |= 1u << 2;
}

inline void UpdatePublicConfigItemRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace ConfigData
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATA_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
