#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGER_H
#define COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGER_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>

/**
 * If the meaning of "AudioManager" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace AudioManager {

// method IDs
static const uint16 ID_AudioRouteRequest = 0;
static const uint16 ID_SourceAvailability = 1;
static const uint16 ID_MuteState = 2;
static const uint16 ID_SourceActivityResult = 3;

// signal IDs
static const uint16 ID_OnMuteState = 4;
static const uint16 ID_SourceActivity = 5;
static const uint16 ID_OnAllocate = 6;
static const uint16 ID_OnDeAllocate = 7;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AudioRouteRequestRequest;

class AudioRouteRequestResponse;

class SourceAvailabilityRequest;

class MuteStateRequest;

class SourceActivityResultRequest;

class OnMuteStateSignal;

class SourceActivitySignal;

class OnAllocateSignal;

class OnDeAllocateSignal;

// type definitions
/**
 * If the meaning of "AudioRouteRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudioRouteRequestError;

/**
 * If the meaning of "SourceAvailabilityResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SourceAvailabilityResponse;

/**
 * If the meaning of "SourceAvailabilityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceAvailabilityError;

/**
 * If the meaning of "MuteStateResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage MuteStateResponse;

/**
 * If the meaning of "MuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MuteStateError;

/**
 * If the meaning of "SourceActivityResultResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SourceActivityResultResponse;

/**
 * If the meaning of "SourceActivityResultError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceActivityResultError;

/**
 * If the meaning of "OnMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnMuteStateError;

/**
 * If the meaning of "SourceActivityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceActivityError;

/**
 * If the meaning of "OnAllocateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnAllocateError;

/**
 * If the meaning of "OnDeAllocateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnDeAllocateError;


/**
 * If the meaning of "AudioRouteRequestRequest" isn't clear, then there should be a description here.
 */
class AudioRouteRequestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioRouteRequestRequest ();

    /**
     * Copy constructor
     */
    inline  AudioRouteRequestRequest (const AudioRouteRequestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudioRouteRequestRequest (uint8 source_, uint8 state_required_);

    /**
     * Destructor
     */
    inline virtual  ~AudioRouteRequestRequest();

    /**
     * Assignment operator
     */
    inline AudioRouteRequestRequest& operator = (const AudioRouteRequestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioRouteRequestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioRouteRequestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioRouteRequestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioRouteRequestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "state_required"

    static const int kState_required = 1;

    /**
     * Clears the field "state_required".
     *
     * The field will be set to its default value. The hasState_required()
     * method will return false.
     */
    inline void clearState_required();

    /**
     * Checks whether the field "state_required" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState_required()). Otherwise it will return false.
     */
    inline bool hasState_required () const;

    /**
     * Returns the value of the member "state_required".
     *
     * If the meaning of "state_required" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state_required"
     */
    inline uint8 getState_required () const;

    /**
     * Sets the value of the member "state_required".
     *
     * If the meaning of "state_required" isn't clear, then there should be a description here.
     *
     * @param state_required The value which will be set
     */
    inline void setState_required (uint8 state_required_);

    static const AudioRouteRequestRequest &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_state_required ();

    inline void clear_has_state_required ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    uint8 _state_required;

};

/**
 * If the meaning of "AudioRouteRequestResponse" isn't clear, then there should be a description here.
 */
class AudioRouteRequestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioRouteRequestResponse ();

    /**
     * Copy constructor
     */
    inline  AudioRouteRequestResponse (const AudioRouteRequestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudioRouteRequestResponse (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~AudioRouteRequestResponse();

    /**
     * Assignment operator
     */
    inline AudioRouteRequestResponse& operator = (const AudioRouteRequestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioRouteRequestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioRouteRequestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioRouteRequestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioRouteRequestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const AudioRouteRequestResponse &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * If the meaning of "SourceAvailabilityRequest" isn't clear, then there should be a description here.
 */
class SourceAvailabilityRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceAvailabilityRequest ();

    /**
     * Copy constructor
     */
    inline  SourceAvailabilityRequest (const SourceAvailabilityRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SourceAvailabilityRequest (uint8 source_, bool availability_);

    /**
     * Destructor
     */
    inline virtual  ~SourceAvailabilityRequest();

    /**
     * Assignment operator
     */
    inline SourceAvailabilityRequest& operator = (const SourceAvailabilityRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceAvailabilityRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceAvailabilityRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceAvailabilityRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceAvailabilityRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "availability"

    static const int kAvailability = 1;

    /**
     * Clears the field "availability".
     *
     * The field will be set to its default value. The hasAvailability()
     * method will return false.
     */
    inline void clearAvailability();

    /**
     * Checks whether the field "availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvailability()). Otherwise it will return false.
     */
    inline bool hasAvailability () const;

    /**
     * Returns the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @return The value of the field "availability"
     */
    inline bool getAvailability () const;

    /**
     * Sets the value of the member "availability".
     *
     * If the meaning of "availability" isn't clear, then there should be a description here.
     *
     * @param availability The value which will be set
     */
    inline void setAvailability (bool availability_);

    static const SourceAvailabilityRequest &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_availability ();

    inline void clear_has_availability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    bool _availability;

};

/**
 * If the meaning of "MuteStateRequest" isn't clear, then there should be a description here.
 */
class MuteStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStateRequest ();

    /**
     * Copy constructor
     */
    inline  MuteStateRequest (const MuteStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MuteStateRequest (uint8 source_, bool state_required_);

    /**
     * Destructor
     */
    inline virtual  ~MuteStateRequest();

    /**
     * Assignment operator
     */
    inline MuteStateRequest& operator = (const MuteStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "state_required"

    static const int kState_required = 1;

    /**
     * Clears the field "state_required".
     *
     * The field will be set to its default value. The hasState_required()
     * method will return false.
     */
    inline void clearState_required();

    /**
     * Checks whether the field "state_required" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState_required()). Otherwise it will return false.
     */
    inline bool hasState_required () const;

    /**
     * Returns the value of the member "state_required".
     *
     * If the meaning of "state_required" isn't clear, then there should be a description here.
     *
     * @return The value of the field "state_required"
     */
    inline bool getState_required () const;

    /**
     * Sets the value of the member "state_required".
     *
     * If the meaning of "state_required" isn't clear, then there should be a description here.
     *
     * @param state_required The value which will be set
     */
    inline void setState_required (bool state_required_);

    static const MuteStateRequest &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_state_required ();

    inline void clear_has_state_required ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    bool _state_required;

};

/**
 * If the meaning of "SourceActivityResultRequest" isn't clear, then there should be a description here.
 */
class SourceActivityResultRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivityResultRequest ();

    /**
     * Copy constructor
     */
    inline  SourceActivityResultRequest (const SourceActivityResultRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivityResultRequest (uint8 source_, uint16 status_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivityResultRequest();

    /**
     * Assignment operator
     */
    inline SourceActivityResultRequest& operator = (const SourceActivityResultRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivityResultRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivityResultRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivityResultRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivityResultRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    static const SourceActivityResultRequest &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    uint16 _status;

};

/**
 * If the meaning of "OnMuteStateSignal" isn't clear, then there should be a description here.
 */
class OnMuteStateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnMuteStateSignal ();

    /**
     * Copy constructor
     */
    inline  OnMuteStateSignal (const OnMuteStateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnMuteStateSignal (uint8 source_);

    /**
     * Destructor
     */
    inline virtual  ~OnMuteStateSignal();

    /**
     * Assignment operator
     */
    inline OnMuteStateSignal& operator = (const OnMuteStateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnMuteStateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnMuteStateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnMuteStateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnMuteStateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    static const OnMuteStateSignal &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _source;

};

/**
 * If the meaning of "SourceActivitySignal" isn't clear, then there should be a description here.
 */
class SourceActivitySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceActivitySignal ();

    /**
     * Copy constructor
     */
    inline  SourceActivitySignal (const SourceActivitySignal &rhs);

    /**
     * All fields constructor
     */
    inline  SourceActivitySignal (uint8 source_, uint16 status_);

    /**
     * Destructor
     */
    inline virtual  ~SourceActivitySignal();

    /**
     * Assignment operator
     */
    inline SourceActivitySignal& operator = (const SourceActivitySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceActivitySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceActivitySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceActivitySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceActivitySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint16 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint16 status_);

    static const SourceActivitySignal &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    uint16 _status;

};

/**
 * If the meaning of "OnAllocateSignal" isn't clear, then there should be a description here.
 */
class OnAllocateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnAllocateSignal ();

    /**
     * Copy constructor
     */
    inline  OnAllocateSignal (const OnAllocateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnAllocateSignal (uint8 source_);

    /**
     * Destructor
     */
    inline virtual  ~OnAllocateSignal();

    /**
     * Assignment operator
     */
    inline OnAllocateSignal& operator = (const OnAllocateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnAllocateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnAllocateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnAllocateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnAllocateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    static const OnAllocateSignal &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _source;

};

/**
 * If the meaning of "OnDeAllocateSignal" isn't clear, then there should be a description here.
 */
class OnDeAllocateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnDeAllocateSignal ();

    /**
     * Copy constructor
     */
    inline  OnDeAllocateSignal (const OnDeAllocateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  OnDeAllocateSignal (uint8 source_);

    /**
     * Destructor
     */
    inline virtual  ~OnDeAllocateSignal();

    /**
     * Assignment operator
     */
    inline OnDeAllocateSignal& operator = (const OnDeAllocateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnDeAllocateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnDeAllocateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnDeAllocateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnDeAllocateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    static const OnDeAllocateSignal &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _source;

};

inline  AudioRouteRequestRequest::AudioRouteRequestRequest ()  :
    _source (0u),
    _state_required (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioRouteRequestRequest::AudioRouteRequestRequest (const AudioRouteRequestRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u),
    _state_required (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioRouteRequestRequest::AudioRouteRequestRequest (uint8 source_, uint8 state_required_)  :
    _source (source_),
    _state_required (state_required_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudioRouteRequestRequest::~AudioRouteRequestRequest() {
}

inline AudioRouteRequestRequest& AudioRouteRequestRequest::operator = (const AudioRouteRequestRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasState_required()) {
            setState_required(rhs.getState_required());
        } else {
            clearState_required();
        }
    }
    return *this;
}

inline bool AudioRouteRequestRequest::operator == (const AudioRouteRequestRequest& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasState_required() && !rhs.hasState_required()) || getState_required() == rhs.getState_required()));
}

inline bool AudioRouteRequestRequest::operator != (const AudioRouteRequestRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioRouteRequestRequest::operator < (const AudioRouteRequestRequest& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasState_required() || rhs.hasState_required()) {
        if (getState_required() < rhs.getState_required()) return true;
        if (getState_required() > rhs.getState_required()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudioRouteRequestRequest::clone() {
    return new AudioRouteRequestRequest(*this);
}

inline bool AudioRouteRequestRequest::operator > (const AudioRouteRequestRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioRouteRequestRequest::clear() {
    clearSource();
    clearState_required();
}

inline void AudioRouteRequestRequest::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool AudioRouteRequestRequest::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AudioRouteRequestRequest::getSource () const {
    return _source;
}

inline void AudioRouteRequestRequest::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void AudioRouteRequestRequest::clearState_required() {
    if (hasState_required()) {
         clear_has_state_required();
        _state_required = 0u;
     }
}

inline bool AudioRouteRequestRequest::hasState_required () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AudioRouteRequestRequest::getState_required () const {
    return _state_required;
}

inline void AudioRouteRequestRequest::setState_required (uint8 state_required_) {
    set_has_state_required();
    this->_state_required = state_required_;
}

inline void AudioRouteRequestRequest::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudioRouteRequestRequest::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AudioRouteRequestRequest::set_has_state_required () {
    _has_bits_[0] |= 1u << 1;
}

inline void AudioRouteRequestRequest::clear_has_state_required () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AudioRouteRequestResponse::AudioRouteRequestResponse ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AudioRouteRequestResponse::AudioRouteRequestResponse (const AudioRouteRequestResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AudioRouteRequestResponse::AudioRouteRequestResponse (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AudioRouteRequestResponse::~AudioRouteRequestResponse() {
}

inline AudioRouteRequestResponse& AudioRouteRequestResponse::operator = (const AudioRouteRequestResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool AudioRouteRequestResponse::operator == (const AudioRouteRequestResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool AudioRouteRequestResponse::operator != (const AudioRouteRequestResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AudioRouteRequestResponse::operator < (const AudioRouteRequestResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AudioRouteRequestResponse::clone() {
    return new AudioRouteRequestResponse(*this);
}

inline bool AudioRouteRequestResponse::operator > (const AudioRouteRequestResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AudioRouteRequestResponse::clear() {
    clearStatus();
}

inline void AudioRouteRequestResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool AudioRouteRequestResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool AudioRouteRequestResponse::getStatus () const {
    return _status;
}

inline void AudioRouteRequestResponse::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void AudioRouteRequestResponse::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void AudioRouteRequestResponse::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceAvailabilityRequest::SourceAvailabilityRequest ()  :
    _source (0u),
    _availability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceAvailabilityRequest::SourceAvailabilityRequest (const SourceAvailabilityRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u),
    _availability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceAvailabilityRequest::SourceAvailabilityRequest (uint8 source_, bool availability_)  :
    _source (source_),
    _availability (availability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceAvailabilityRequest::~SourceAvailabilityRequest() {
}

inline SourceAvailabilityRequest& SourceAvailabilityRequest::operator = (const SourceAvailabilityRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasAvailability()) {
            setAvailability(rhs.getAvailability());
        } else {
            clearAvailability();
        }
    }
    return *this;
}

inline bool SourceAvailabilityRequest::operator == (const SourceAvailabilityRequest& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasAvailability() && !rhs.hasAvailability()) || getAvailability() == rhs.getAvailability()));
}

inline bool SourceAvailabilityRequest::operator != (const SourceAvailabilityRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceAvailabilityRequest::operator < (const SourceAvailabilityRequest& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasAvailability() || rhs.hasAvailability()) {
        if (getAvailability() < rhs.getAvailability()) return true;
        if (getAvailability() > rhs.getAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceAvailabilityRequest::clone() {
    return new SourceAvailabilityRequest(*this);
}

inline bool SourceAvailabilityRequest::operator > (const SourceAvailabilityRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceAvailabilityRequest::clear() {
    clearSource();
    clearAvailability();
}

inline void SourceAvailabilityRequest::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool SourceAvailabilityRequest::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SourceAvailabilityRequest::getSource () const {
    return _source;
}

inline void SourceAvailabilityRequest::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void SourceAvailabilityRequest::clearAvailability() {
    if (hasAvailability()) {
         clear_has_availability();
        _availability = false;
     }
}

inline bool SourceAvailabilityRequest::hasAvailability () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SourceAvailabilityRequest::getAvailability () const {
    return _availability;
}

inline void SourceAvailabilityRequest::setAvailability (bool availability_) {
    set_has_availability();
    this->_availability = availability_;
}

inline void SourceAvailabilityRequest::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceAvailabilityRequest::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceAvailabilityRequest::set_has_availability () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceAvailabilityRequest::clear_has_availability () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MuteStateRequest::MuteStateRequest ()  :
    _source (0u),
    _state_required (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteStateRequest::MuteStateRequest (const MuteStateRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u),
    _state_required (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteStateRequest::MuteStateRequest (uint8 source_, bool state_required_)  :
    _source (source_),
    _state_required (state_required_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MuteStateRequest::~MuteStateRequest() {
}

inline MuteStateRequest& MuteStateRequest::operator = (const MuteStateRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasState_required()) {
            setState_required(rhs.getState_required());
        } else {
            clearState_required();
        }
    }
    return *this;
}

inline bool MuteStateRequest::operator == (const MuteStateRequest& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasState_required() && !rhs.hasState_required()) || getState_required() == rhs.getState_required()));
}

inline bool MuteStateRequest::operator != (const MuteStateRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteStateRequest::operator < (const MuteStateRequest& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasState_required() || rhs.hasState_required()) {
        if (getState_required() < rhs.getState_required()) return true;
        if (getState_required() > rhs.getState_required()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MuteStateRequest::clone() {
    return new MuteStateRequest(*this);
}

inline bool MuteStateRequest::operator > (const MuteStateRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteStateRequest::clear() {
    clearSource();
    clearState_required();
}

inline void MuteStateRequest::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool MuteStateRequest::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 MuteStateRequest::getSource () const {
    return _source;
}

inline void MuteStateRequest::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void MuteStateRequest::clearState_required() {
    if (hasState_required()) {
         clear_has_state_required();
        _state_required = false;
     }
}

inline bool MuteStateRequest::hasState_required () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool MuteStateRequest::getState_required () const {
    return _state_required;
}

inline void MuteStateRequest::setState_required (bool state_required_) {
    set_has_state_required();
    this->_state_required = state_required_;
}

inline void MuteStateRequest::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void MuteStateRequest::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MuteStateRequest::set_has_state_required () {
    _has_bits_[0] |= 1u << 1;
}

inline void MuteStateRequest::clear_has_state_required () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SourceActivityResultRequest::SourceActivityResultRequest ()  :
    _source (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceActivityResultRequest::SourceActivityResultRequest (const SourceActivityResultRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceActivityResultRequest::SourceActivityResultRequest (uint8 source_, uint16 status_)  :
    _source (source_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceActivityResultRequest::~SourceActivityResultRequest() {
}

inline SourceActivityResultRequest& SourceActivityResultRequest::operator = (const SourceActivityResultRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SourceActivityResultRequest::operator == (const SourceActivityResultRequest& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SourceActivityResultRequest::operator != (const SourceActivityResultRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceActivityResultRequest::operator < (const SourceActivityResultRequest& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceActivityResultRequest::clone() {
    return new SourceActivityResultRequest(*this);
}

inline bool SourceActivityResultRequest::operator > (const SourceActivityResultRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceActivityResultRequest::clear() {
    clearSource();
    clearStatus();
}

inline void SourceActivityResultRequest::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool SourceActivityResultRequest::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SourceActivityResultRequest::getSource () const {
    return _source;
}

inline void SourceActivityResultRequest::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void SourceActivityResultRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool SourceActivityResultRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SourceActivityResultRequest::getStatus () const {
    return _status;
}

inline void SourceActivityResultRequest::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void SourceActivityResultRequest::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceActivityResultRequest::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceActivityResultRequest::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceActivityResultRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnMuteStateSignal::OnMuteStateSignal ()  :
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnMuteStateSignal::OnMuteStateSignal (const OnMuteStateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnMuteStateSignal::OnMuteStateSignal (uint8 source_)  :
    _source (source_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnMuteStateSignal::~OnMuteStateSignal() {
}

inline OnMuteStateSignal& OnMuteStateSignal::operator = (const OnMuteStateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool OnMuteStateSignal::operator == (const OnMuteStateSignal& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool OnMuteStateSignal::operator != (const OnMuteStateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnMuteStateSignal::operator < (const OnMuteStateSignal& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnMuteStateSignal::clone() {
    return new OnMuteStateSignal(*this);
}

inline bool OnMuteStateSignal::operator > (const OnMuteStateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnMuteStateSignal::clear() {
    clearSource();
}

inline void OnMuteStateSignal::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool OnMuteStateSignal::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 OnMuteStateSignal::getSource () const {
    return _source;
}

inline void OnMuteStateSignal::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void OnMuteStateSignal::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnMuteStateSignal::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceActivitySignal::SourceActivitySignal ()  :
    _source (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceActivitySignal::SourceActivitySignal (const SourceActivitySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceActivitySignal::SourceActivitySignal (uint8 source_, uint16 status_)  :
    _source (source_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceActivitySignal::~SourceActivitySignal() {
}

inline SourceActivitySignal& SourceActivitySignal::operator = (const SourceActivitySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SourceActivitySignal::operator == (const SourceActivitySignal& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SourceActivitySignal::operator != (const SourceActivitySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceActivitySignal::operator < (const SourceActivitySignal& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceActivitySignal::clone() {
    return new SourceActivitySignal(*this);
}

inline bool SourceActivitySignal::operator > (const SourceActivitySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceActivitySignal::clear() {
    clearSource();
    clearStatus();
}

inline void SourceActivitySignal::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool SourceActivitySignal::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SourceActivitySignal::getSource () const {
    return _source;
}

inline void SourceActivitySignal::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void SourceActivitySignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool SourceActivitySignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 SourceActivitySignal::getStatus () const {
    return _status;
}

inline void SourceActivitySignal::setStatus (uint16 status_) {
    set_has_status();
    this->_status = status_;
}

inline void SourceActivitySignal::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceActivitySignal::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SourceActivitySignal::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void SourceActivitySignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnAllocateSignal::OnAllocateSignal ()  :
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnAllocateSignal::OnAllocateSignal (const OnAllocateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnAllocateSignal::OnAllocateSignal (uint8 source_)  :
    _source (source_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnAllocateSignal::~OnAllocateSignal() {
}

inline OnAllocateSignal& OnAllocateSignal::operator = (const OnAllocateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool OnAllocateSignal::operator == (const OnAllocateSignal& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool OnAllocateSignal::operator != (const OnAllocateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnAllocateSignal::operator < (const OnAllocateSignal& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnAllocateSignal::clone() {
    return new OnAllocateSignal(*this);
}

inline bool OnAllocateSignal::operator > (const OnAllocateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnAllocateSignal::clear() {
    clearSource();
}

inline void OnAllocateSignal::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool OnAllocateSignal::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 OnAllocateSignal::getSource () const {
    return _source;
}

inline void OnAllocateSignal::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void OnAllocateSignal::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnAllocateSignal::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnDeAllocateSignal::OnDeAllocateSignal ()  :
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnDeAllocateSignal::OnDeAllocateSignal (const OnDeAllocateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _source (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnDeAllocateSignal::OnDeAllocateSignal (uint8 source_)  :
    _source (source_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnDeAllocateSignal::~OnDeAllocateSignal() {
}

inline OnDeAllocateSignal& OnDeAllocateSignal::operator = (const OnDeAllocateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool OnDeAllocateSignal::operator == (const OnDeAllocateSignal& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool OnDeAllocateSignal::operator != (const OnDeAllocateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool OnDeAllocateSignal::operator < (const OnDeAllocateSignal& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnDeAllocateSignal::clone() {
    return new OnDeAllocateSignal(*this);
}

inline bool OnDeAllocateSignal::operator > (const OnDeAllocateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnDeAllocateSignal::clear() {
    clearSource();
}

inline void OnDeAllocateSignal::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool OnDeAllocateSignal::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 OnDeAllocateSignal::getSource () const {
    return _source;
}

inline void OnDeAllocateSignal::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void OnDeAllocateSignal::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnDeAllocateSignal::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace AudioManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
