/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Sds.h"
#include "App/Core/SdsGui.h"
#include "App/Core/SdsHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Sds" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Sds", Info);

/* static */ const char* AppHmi_Sds::sdsGui = "sdsGui";
/* static */ const char* AppHmi_Sds::sdsHall = "sdsHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Sds_enabledASFSignalHandler = false;

void importAppHmi_Sds() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Sds, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(157);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'sdsHmi'

    ::asf::core::ComponentContainerSharedPtr SdsHmi(new ::asf::core::ComponentContainer("sdsHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SdsHmi);

        // Component 'SdsGui sdsGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SdsGui > > sdsGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::SdsGui >);
        ::asf::core::ComponentDescriptionSharedPtr sdsGuiDescription(new ::asf::core::ComponentDescription(1, "sdsGui", /* immediate = */ true, /* threadBridge = */ false, sdsGuiFactory));
        SdsHmi->addComponentDescription(sdsGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& sdsGui_courierMessageReceiverPort = sdsGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)sdsGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& sdsGui_hmiAppCtrlPort = sdsGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)sdsGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& sdsGui_hmiAppCtrlTraceCmdPort = sdsGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)sdsGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& sdsGui_SBServicePort = sdsGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)sdsGui_SBServicePort; // prevent unused variable warning

        // Component 'SdsHall sdsHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SdsHall > > sdsHallFactory(new ::asf::core::ComponentFactory< ::App::Core::SdsHall >);
        ::asf::core::ComponentDescriptionSharedPtr sdsHallDescription(new ::asf::core::ComponentDescription(2, "sdsHall", /* immediate = */ true, /* threadBridge = */ false, sdsHallFactory));
        SdsHmi->addComponentDescription(sdsHallDescription);

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& sdsHall_ConsumerPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)sdsHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& sdsHall_LifecycleControlPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)sdsHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& sdsHall_LifeCycleConsumerPort = sdsHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)sdsHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& sdsHall_courierMessageReceiverPort = sdsHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)sdsHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& sdsHall_spmFiPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)sdsHall_spmFiPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& sdsHall_audioSourceChangePort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)sdsHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'sdsGuiAppPort'

            ::asf::core::RequiredPort& sdsHall_sdsGuiAppPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SdsGuiService", "sdsGuiAppPort"));
            (void)sdsHall_sdsGuiAppPort; // prevent unused variable warning

            // Port 'sdsPopUpPort'

            ::asf::core::RequiredPort& sdsHall_sdsPopUpPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.PopUpService", "sdsPopUpPort"));
            (void)sdsHall_sdsPopUpPort; // prevent unused variable warning

            // Port 'sdsSettingsPort'

            ::asf::core::RequiredPort& sdsHall_sdsSettingsPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SettingsService", "sdsSettingsPort"));
            (void)sdsHall_sdsSettingsPort; // prevent unused variable warning

            // Port 'sdsPhonePort'

            ::asf::core::RequiredPort& sdsHall_sdsPhonePort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SdsPhoneService", "sdsPhonePort"));
            (void)sdsHall_sdsPhonePort; // prevent unused variable warning

            // Port 'sdsFocusPort'

            ::asf::core::RequiredPort& sdsHall_sdsFocusPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("sds_gui_fi.SdsFocusService", "sdsFocusPort"));
            (void)sdsHall_sdsFocusPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& sdsHall_applicationSwitchPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)sdsHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'applicationSwitchServerPort'

            ::asf::core::RequiredPort& sdsHall_applicationSwitchServerPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchServerPort"));
            (void)sdsHall_applicationSwitchServerPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& sdsHall_hmiinfoservicePort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)sdsHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'AppHmiSdsServicePort'

            ::asf::core::ProvidedPort& sdsHall_AppHmiSdsServicePort = sdsHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "AppHmiSdsServicePort", false, false));
            (void)sdsHall_AppHmiSdsServicePort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& sdsHall_vehicleMainFiPort = sdsHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)sdsHall_vehicleMainFiPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsGui_courierMessageReceiverPort, sdsHall_courierMessageReceiverPort);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sdsGuiService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SdsGuiService/SdsAdapter"));
    sdsGuiService.setServiceName("sds_gui_fi.SdsGuiService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_sdsGuiAppPort, sdsGuiService);

    // Expression

    ::asf::dbus::DBusImportedPort& sdsPopUpService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/PopUpService/SdsAdapter"));
    sdsPopUpService.setServiceName("sds_gui_fi.PopUpService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_sdsPopUpPort, sdsPopUpService);

    // Expression

    ::asf::dbus::DBusImportedPort& sdsSettingsService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SettingsService/SdsAdapter"));
    sdsSettingsService.setServiceName("sds_gui_fi.SettingsService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_sdsSettingsPort, sdsSettingsService);

    // Expression

    ::asf::dbus::DBusImportedPort& sdsPhoneService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SdsPhoneService/SdsAdapter"));
    sdsPhoneService.setServiceName("sds_gui_fi.SdsPhoneService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_sdsPhonePort, sdsPhoneService);

    // Expression

    ::asf::dbus::DBusImportedPort& sdsFocusService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_gui_fi/SdsFocusService/SdsAdapter"));
    sdsFocusService.setServiceName("sds_gui_fi.SdsFocusService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_sdsFocusPort, sdsFocusService);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchServer_Import = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchServer_Import.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_applicationSwitchServerPort, applicationSwitchServer_Import);

    // Expression

    dbusSystemConnector_->exportByName (sdsHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Sds"));

    // Expression

    dbusSessionConnector_->exportByName (sdsHall_AppHmiSdsServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/HmiSdsService"));

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsHall_hmiinfoservicePort, hmiinfoserviceImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Sds' version 0.1.0");

    app->start();
}

int executeAppHmi_Sds(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Sds");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Sds", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Sds_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Sds", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Sds");

    app->enableExceptionHandler(true);

    importAppHmi_Sds();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Sds_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Sds(argc, argv);
}

