/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_SPI.h"
#include "App/Core/SPIGui.h"
#include "App/Core/SPIHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_SPI" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_SPI", Info);

/* static */ const char* AppHmi_SPI::spiGui = "spiGui";
/* static */ const char* AppHmi_SPI::spiHall = "spiHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_SPI_enabledASFSignalHandler = false;

void importAppHmi_SPI() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_SPI, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(162);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'spiHmi'

    ::asf::core::ComponentContainerSharedPtr SpiHmi(new ::asf::core::ComponentContainer("spiHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SpiHmi);

        // Component 'SPIGui spiGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SPIGui > > spiGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::SPIGui >);
        ::asf::core::ComponentDescriptionSharedPtr spiGuiDescription(new ::asf::core::ComponentDescription(1, "spiGui", /* immediate = */ true, /* threadBridge = */ false, spiGuiFactory));
        SpiHmi->addComponentDescription(spiGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& spiGui_courierMessageReceiverPort = spiGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)spiGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& spiGui_hmiAppCtrlPort = spiGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)spiGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& spiGui_hmiAppCtrlTraceCmdPort = spiGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)spiGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& spiGui_SBServicePort = spiGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)spiGui_SBServicePort; // prevent unused variable warning

        // Component 'SPIHall spiHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SPIHall > > spiHallFactory(new ::asf::core::ComponentFactory< ::App::Core::SPIHall >);
        ::asf::core::ComponentDescriptionSharedPtr spiHallDescription(new ::asf::core::ComponentDescription(2, "spiHall", /* immediate = */ true, /* threadBridge = */ false, spiHallFactory));
        SpiHmi->addComponentDescription(spiHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& spiHall_spmFiPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)spiHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& spiHall_ConsumerPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)spiHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& spiHall_LifecycleControlPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)spiHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& spiHall_LifeCycleConsumerPort = spiHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)spiHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& spiHall_courierMessageReceiverPort = spiHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)spiHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'midwspiPort'

            ::asf::core::RequiredPort& spiHall_midwspiPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("midw_smartphoneint_fi", "midwspiPort"));
            (void)spiHall_midwspiPort; // prevent unused variable warning

            // Port 'btTelFiPort'

            ::asf::core::RequiredPort& spiHall_btTelFiPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Tel_FI", "btTelFiPort"));
            (void)spiHall_btTelFiPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& spiHall_applicationSwitchPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)spiHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& spiHall_audioSourceChangePort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)spiHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& spiHall_soundPropertiesPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)spiHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'btSetFiPort'

            ::asf::core::RequiredPort& spiHall_btSetFiPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "btSetFiPort"));
            (void)spiHall_btSetFiPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& spiHall_vehicleMainFiPort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)spiHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'hmiDataServicePort'

            ::asf::core::RequiredPort& spiHall_hmiDataServicePort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", "hmiDataServicePort"));
            (void)spiHall_hmiDataServicePort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& spiHall_hmiinfoservicePort = spiHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)spiHall_hmiinfoservicePort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiGui_courierMessageReceiverPort, spiHall_courierMessageReceiverPort);

    // Expression

    ::asf::cca::CcaImportedPort& midwspiImport = ccaConnector_->importByName (285, 1, 0, 2);
    midwspiImport.setServiceName("midw_smartphoneint_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_midwspiPort, midwspiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (spiHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_SPI"));

    // Expression

    ::asf::cca::CcaImportedPort& btTelFiImport = ccaConnector_->importByName (10, 4, 3, 2);
    btTelFiImport.setServiceName("MOST_Tel_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_btTelFiPort, btTelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    btSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_btSetFiPort, btSetFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmidataserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_System"), ::std::string("/bosch/cm/ai/nissan/hmi/hmidataservice"));
    hmidataserviceImport.setServiceName("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_hmiDataServicePort, hmidataserviceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (spiHall_hmiinfoservicePort, hmiinfoserviceImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_SPI' version 0.1.0");

    app->start();
}

int executeAppHmi_SPI(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_SPI");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_SPI", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_SPI_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_SPI", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_SPI");

    app->enableExceptionHandler(true);

    importAppHmi_SPI();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_SPI_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_SPI(argc, argv);
}

