/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Camera.h"
#include "App/Core/CameraGui.h"
#include "App/Core/CameraHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Camera" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Camera", Info);

/* static */ const char* AppHmi_Camera::cameraGui = "cameraGui";
/* static */ const char* AppHmi_Camera::cameraHall = "cameraHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Camera_enabledASFSignalHandler = false;

void importAppHmi_Camera() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Camera, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(158);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'cameraHmi'

    ::asf::core::ComponentContainerSharedPtr CameraHmi(new ::asf::core::ComponentContainer("cameraHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (CameraHmi);

        // Component 'CameraGui cameraGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::CameraGui > > cameraGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::CameraGui >);
        ::asf::core::ComponentDescriptionSharedPtr cameraGuiDescription(new ::asf::core::ComponentDescription(1, "cameraGui", /* immediate = */ true, /* threadBridge = */ false, cameraGuiFactory));
        CameraHmi->addComponentDescription(cameraGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& cameraGui_courierMessageReceiverPort = cameraGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)cameraGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& cameraGui_hmiAppCtrlPort = cameraGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)cameraGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& cameraGui_hmiAppCtrlTraceCmdPort = cameraGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)cameraGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& cameraGui_SBServicePort = cameraGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)cameraGui_SBServicePort; // prevent unused variable warning

        // Component 'CameraHall cameraHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::CameraHall > > cameraHallFactory(new ::asf::core::ComponentFactory< ::App::Core::CameraHall >);
        ::asf::core::ComponentDescriptionSharedPtr cameraHallDescription(new ::asf::core::ComponentDescription(2, "cameraHall", /* immediate = */ true, /* threadBridge = */ false, cameraHallFactory));
        CameraHmi->addComponentDescription(cameraHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& cameraHall_spmFiPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("CFC_SPM_FI", "spmFiPort"));
            (void)cameraHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& cameraHall_ConsumerPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)cameraHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& cameraHall_LifecycleControlPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)cameraHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& cameraHall_LifeCycleConsumerPort = cameraHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)cameraHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& cameraHall_courierMessageReceiverPort = cameraHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)cameraHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'SxmAudioSourceChangePort'

            ::asf::core::RequiredPort& cameraHall_SxmAudioSourceChangePort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "SxmAudioSourceChangePort"));
            (void)cameraHall_SxmAudioSourceChangePort; // prevent unused variable warning

            // Port 'SXMSoundPropertiesPort'

            ::asf::core::RequiredPort& cameraHall_SXMSoundPropertiesPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "SXMSoundPropertiesPort"));
            (void)cameraHall_SXMSoundPropertiesPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& cameraHall_applicationSwitchPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)cameraHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'PluginDbusInterfacePort'

            ::asf::core::RequiredPort& cameraHall_PluginDbusInterfacePort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusInterfacePort"));
            (void)cameraHall_PluginDbusInterfacePort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& cameraHall_vehicleMainFiPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)cameraHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'rvcFiPort'

            ::asf::core::RequiredPort& cameraHall_rvcFiPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("rvc_cca_fi", "rvcFiPort"));
            (void)cameraHall_rvcFiPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& cameraHall_hmiinfoservicePort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)cameraHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'NanoMsgGenericPort'

            ::asf::core::RequiredPort& cameraHall_NanoMsgGenericPort = cameraHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgGenericInterface", "NanoMsgGenericPort"));
            (void)cameraHall_NanoMsgGenericPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraGui_courierMessageReceiverPort, cameraHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("CFC_SPM_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (cameraHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Camera"));

    // Expression

    ::asf::dbus::DBusImportedPort& SxmAudioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    SxmAudioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_SxmAudioSourceChangePort, SxmAudioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& SXMSoundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    SXMSoundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_SXMSoundPropertiesPort, SXMSoundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& pluginDbusImport = dbusSessionConnector_->importByName (::std::string("PluginServer.PluginServer"), ::std::string("/bosch/cm/ai/PluginDbusInterface"));
    pluginDbusImport.setServiceName("bosch.cm.ai.PluginDbusInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_PluginDbusInterfacePort, pluginDbusImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& rvcFiImport = ccaConnector_->importByName (84, 1, 0, 2);
    rvcFiImport.setServiceName("rvc_cca_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_rvcFiPort, rvcFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgGenericImport = dbusSessionConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgGenericInterface"));
    NanoMsgGenericImport.setServiceName("bosch.cm.di.NanoMsgGenericInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (cameraHall_NanoMsgGenericPort, NanoMsgGenericImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Camera' version 0.1.0");

    app->start();
}

int executeAppHmi_Camera(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Camera");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Camera", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Camera_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Camera", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Camera");

    app->enableExceptionHandler(false);

    importAppHmi_Camera();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Camera(argc, argv);
}

