/*****************************************************************************************
*
* \file    dia_IWifiSetups.h
*
* \brief   interface of dia_IWifiSetups
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author stc2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IWifiSetups.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS__
#define __INCLUDED_DIA_INTERFACE_WIFI_SETUPS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_WIFI_SETUPS ((dia::IID) 0x97a6814e)
//------------------------------------------------------------------------------
enum dia_enWifiMode
{
   DIA_ENUM_WIFI_MODE_UNKNOWN = 0,
   DIA_ENUM_WIFI_MODE_OFF_STA,
   DIA_ENUM_WIFI_MODE_AP,
   DIA_ENUM_WIFI_MODE_STA,
   DIA_ENUM_WIFI_MODE_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_enWifiFrequency
{
   DIA_ENUM_WIFI_FREQ_UNKNOWN = 0,
   DIA_ENUM_WIFI_FREQ_5GHZ,
   DIA_ENUM_WIFI_FREQ_2_4GHZ,
   DIA_ENUM_WIFI_FREQ_COUNT = 3
};
struct dia_stWifiSetup
{
public:
   //! default constructor
   dia_stWifiSetup() :
      mMode(DIA_ENUM_WIFI_MODE_UNKNOWN),
      mPoweredOn(false),
      mFrequency(DIA_ENUM_WIFI_FREQ_UNKNOWN),
      mChannel(0),
      mSSID(),
      mConnectedDevices(0)
   {}

   //! class constructor
   dia_stWifiSetup(
      dia_enWifiMode mMode_,
      bool mPoweredOn_,
      dia_enWifiFrequency mFrequency_,
      tU32 mChannel_,
      std::vector<tU8> mSSID_,
      tU32 mConnectedDevices_
   ) :
      mMode(mMode_),
      mPoweredOn(mPoweredOn_),
      mFrequency(mFrequency_),
      mChannel(mChannel_),
      mSSID(mSSID_),
      mConnectedDevices(mConnectedDevices_)
   {}
   dia_enWifiMode mMode;
   bool mPoweredOn;
   dia_enWifiFrequency mFrequency;
   tU32 mChannel;
   std::vector<tU8> mSSID;
   tU32 mConnectedDevices;
};
class dia_IWifiSetups
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_WIFI_SETUPS; }
public:
   //! Request currently active wifi setups (wlan devices).
   virtual tDiaResult GetActiveSetups ( ) = 0;
   //! Request a setup for Wifi (mode is STA or AP)
   virtual tDiaResult prepareSetup (const ::std::string& mode ) = 0;
   //! Unregister for a change of property 'ActiveWiFiSetups'
   virtual tDiaResult deregActiveSetups ( ) = 0;
   //! Register for a change of property 'ActiveWiFiSetups'
   virtual tDiaResult regActiveSetups ( ) = 0;
   //! Deactivate Wifi setup (wifiMode is e.g. STA)
   virtual tDiaResult deActivateSetup (const ::std::string& wifiMode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiSetups( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_SETUPS__ */
