/*****************************************************************************************
*
* \file    dia_IWifiListener.h
*
* \brief   listener of dia_IWifiListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IWifi.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_LISTENER__
#define __INCLUDED_DIA_INTERFACE_WIFI_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_WIFI__
#include "dia_IWifi.h"
#endif

#define IID_WIFI_LISTENER ((dia::IID) 0xd6fadc90)
/**
 *
 *  \class dia_IWifiListener
 *
 */

class dia_IWifiListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_WIFI_LISTENER; }
public:
   //! forwards any errors on the Wifi interface
   virtual void vOnError (const dia_ErrorInfoInterface& errInfo ) = 0;
   //! receives and forwards the current WIFI related information
   virtual void vOnWifiStatus (tU8 status ) = 0;
   //! receives and forwards the link quality and field strength
   virtual void vOnWifiSNR (const tU8 u8SNR ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiListener( void ) {}
};
/**
 *
 *  \class dia_IWifiListenerImpl
 *
 */

class dia_IWifiListenerImpl
   : public dia_IWifiListener
{
public:
   //! forwards any errors on the Wifi interface
   virtual void vOnError (const dia_ErrorInfoInterface& /*errInfo*/ ) {}
   //! receives and forwards the current WIFI related information
   virtual void vOnWifiStatus (tU8 /*status*/ ) {}
   //! receives and forwards the link quality and field strength
   virtual void vOnWifiSNR (const tU8 /*u8SNR*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IWifiNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IWifiNotifier
   : public dia_IWifiListener,
     public dia_Notifier<dia_IWifiListener>
{
public:
   //! forwards any errors on the Wifi interface
   virtual void vOnError (const dia_ErrorInfoInterface& errInfo)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnError(errInfo);
      }
   }
   //! receives and forwards the current WIFI related information
   virtual void vOnWifiStatus (tU8 status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnWifiStatus(status);
      }
   }
   //! receives and forwards the link quality and field strength
   virtual void vOnWifiSNR (const tU8 u8SNR)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnWifiSNR(u8SNR);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_LISTENER__ */
