/*****************************************************************************************
*
* \file    dia_IWifiConnmanListener.h
*
* \brief   listener of dia_IWifiConnmanListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IWifiConnman.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__
#define __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__
#include "dia_IWifiConnman.h"
#endif

#define IID_WIFI_CONNMAN_LISTENER ((dia::IID) 0x9696d5a)
/**
 *
 *  \class dia_IWifiConnmanListener
 *
 */

class dia_IWifiConnmanListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_WIFI_CONNMAN_LISTENER; }
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnWifiStations (const std::vector<dia_stWifiStation>& stationList ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnmanListener( void ) {}
};
/**
 *
 *  \class dia_IWifiConnmanListenerImpl
 *
 */

class dia_IWifiConnmanListenerImpl
   : public dia_IWifiConnmanListener
{
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnWifiStations (const std::vector<dia_stWifiStation>& /*stationList*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnmanListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IWifiConnmanNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IWifiConnmanNotifier
   : public dia_IWifiConnmanListener,
     public dia_Notifier<dia_IWifiConnmanListener>
{
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnWifiStations (const std::vector<dia_stWifiStation>& stationList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->OnWifiStations(stationList);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN_LISTENER__ */
