/*****************************************************************************************
*
* \file    dia_IVideoSourceControl.h
*
* \brief   interface of dia_IVideoSourceControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVideoSourceControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL__
#define __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_VIDEO_SOURCE_CONTROL ((dia::IID) 0x95344464)
//------------------------------------------------------------------------------
enum dia_eVideoSourceID
{
   DIA_EN_VIDEO_SOURCE_ID_UNKNOWN = 0,
   DIA_EN_VIDEO_SOURCE_ID_HMI,
   DIA_EN_VIDEO_SOURCE_ID_RVC,
   DIA_EN_VIDEO_SOURCE_ID_DVD,
   DIA_EN_VIDEO_SOURCE_ID_COUNT = 4
};
class dia_IVideoSourceControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VIDEO_SOURCE_CONTROL; }
public:
   //! activate the remote control of the ECU
   virtual tDiaResult activateVideoSource (dia_eVideoSourceID srcID ) = 0;
   //! retrieve the current remote control state
   virtual dia_eVideoSourceID getActiveVideoSource ( ) = 0;
   //! reset FSM on timeout
   virtual void resetFSMTimeout ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoSourceControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL__ */
