/*****************************************************************************************
*
* \file    dia_IVideoSource.h
*
* \brief   interface of dia_IVideoSource
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVideoSource.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE__
#define __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SYSADAPTER_VIDEO_SOURCE ((dia::IID) 0xae211663)
//------------------------------------------------------------------------------
enum dia_eVideoSource
{
   DIA_EN_VIDEOSRC_UNKNOWN = 0,
   DIA_EN_VIDEOSRC_EXT,
   DIA_EN_VIDEOSRC_INT,
   DIA_EN_VIDEOSRC_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eVideoNorm
{
   DIA_EN_VIDEONORM_UNKNOWN = 0,
   DIA_EN_VIDEONORM_PAL,
   DIA_EN_VIDEONORM_NTSC,
   DIA_EN_VIDEONORM_CVBS1,
   DIA_EN_VIDEONORM_CVBS2,
   DIA_EN_VIDEONORM_CVBS3,
   DIA_EN_VIDEONORM_LVDS,
   DIA_EN_VIDEONORM_HDMI,
   DIA_EN_VIDEONORM_COUNT = 8
};
struct dia_VideoSrcInfo
{
public:
   //! default constructor
   dia_VideoSrcInfo() :
      videoSrc(DIA_EN_VIDEOSRC_UNKNOWN),
      videoNorm(DIA_EN_VIDEONORM_UNKNOWN)
   {}

   //! class constructor
   dia_VideoSrcInfo(
      dia_eVideoSource videoSrc_,
      dia_eVideoNorm videoNorm_
   ) :
      videoSrc(videoSrc_),
      videoNorm(videoNorm_)
   {}
   dia_eVideoSource videoSrc;
   dia_eVideoNorm videoNorm;
};
class dia_IVideoSource
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSADAPTER_VIDEO_SOURCE; }
public:
   //! Set Video Source information
   virtual tDiaResult setVideoSource (const dia_VideoSrcInfo& rVideoInfo ) = 0;
   //! set the rvc control line mode
   virtual tDiaResult setRVCDisplay (const dia_VideoSrcInfo& rVideoInfo ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoSource( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE__ */
