/*****************************************************************************************
*
* \file    dia_IVideoManagerListener.h
*
* \brief   listener of dia_IVideoManagerListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVideoManager.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER_LISTENER__
#define __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER__
#include "dia_IVideoManager.h"
#endif

#define IID_VIDEOMANAGER_LISTENER ((dia::IID) 0xde96aa53)
/**
 *
 *  \class dia_IVideoManagerListener
 *
 */

class dia_IVideoManagerListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VIDEOMANAGER_LISTENER; }
public:
   virtual void vOnConnectionStatusUpdate (dia_eVideoManagerDestinationID destID, dia_eVideoDestinationType destType, dia_eVideoSourceConnectionStatus status ) = 0;
   virtual void vOnConnectionError (tDiaResult errorCode ) = 0;
   virtual void vOnActiveVideoSource (dia_eVideoDestinationType destType, dia_eVideoManagerDestinationID destID ) = 0;
   virtual void vOnActiveVideoSourceError (dia_eVideoDestinationType destType, tDiaResult errorCode ) = 0;
   virtual void vOnDisConnectionAllStatusUpdate ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoManagerListener( void ) {}
};
/**
 *
 *  \class dia_IVideoManagerListenerImpl
 *
 */

class dia_IVideoManagerListenerImpl
   : public dia_IVideoManagerListener
{
public:
   virtual void vOnConnectionStatusUpdate (dia_eVideoManagerDestinationID /*destID*/, dia_eVideoDestinationType /*destType*/, dia_eVideoSourceConnectionStatus /*status*/ ) {}
   virtual void vOnConnectionError (tDiaResult /*errorCode*/ ) {}
   virtual void vOnActiveVideoSource (dia_eVideoDestinationType /*destType*/, dia_eVideoManagerDestinationID /*destID*/ ) {}
   virtual void vOnActiveVideoSourceError (dia_eVideoDestinationType /*destType*/, tDiaResult /*errorCode*/ ) {}
   virtual void vOnDisConnectionAllStatusUpdate ( ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoManagerListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IVideoManagerNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IVideoManagerNotifier
   : public dia_IVideoManagerListener,
     public dia_Notifier<dia_IVideoManagerListener>
{
public:
   virtual void vOnConnectionStatusUpdate (dia_eVideoManagerDestinationID destID, dia_eVideoDestinationType destType, dia_eVideoSourceConnectionStatus status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnConnectionStatusUpdate(destID, destType, status);
      }
   }
   virtual void vOnConnectionError (tDiaResult errorCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnConnectionError(errorCode);
      }
   }
   virtual void vOnActiveVideoSource (dia_eVideoDestinationType destType, dia_eVideoManagerDestinationID destID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnActiveVideoSource(destType, destID);
      }
   }
   virtual void vOnActiveVideoSourceError (dia_eVideoDestinationType destType, tDiaResult errorCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnActiveVideoSourceError(destType, errorCode);
      }
   }
   virtual void vOnDisConnectionAllStatusUpdate ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnDisConnectionAllStatusUpdate();
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER_LISTENER__ */
