/*****************************************************************************************
*
* \file    dia_IVideoManager.h
*
* \brief   interface of dia_IVideoManager
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVideoManager.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER__
#define __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#include "common/interfaces/dia_IVideoSourceControl.h"
#define IID_VIDEOMANAGER ((dia::IID) 0x833650ed)
//------------------------------------------------------------------------------
enum dia_eVideoManagerDestinationID
{
   DIA_EN_VIDEO_DESTINATION_UNKNOWN = 0,
   DIA_EN_VIDEO_DESTINATION_MEDIA,
   DIA_EN_VIDEO_DESTINATION_DVD,
   DIA_EN_VIDEO_DESTINATION_RVC_ON_POPUP,
   DIA_EN_VIDEO_DESTINATION_RVC_ON_HMI,
   DIA_EN_VIDEO_DESTINATION_SPI,
   DIA_EN_VIDEO_DESTINATION_NAVI,
   DIA_EN_VIDEO_DESTINATION_HMI,
   DIA_EN_VIDEO_DESTINATION_COUNT = 8
};
//------------------------------------------------------------------------------
enum dia_eVideoDestinationType
{
   DIA_EN_VIDEO_DESTINATION_TYPE_UNKNOWN = 0,
   DIA_EN_VIDEO_DESTINATION_TYPE_FRONT_DISPLAY,
   DIA_EN_VIDEO_DESTINATION_TYPE_REAR_DISPLAY,
   DIA_EN_VIDEO_DESTINATION_TYPE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eVideoSourceConnectionStatus
{
   DIA_EN_VIDEO_SOURCE_CONNECTION_STATUS_UNKNOWN = 0,
   DIA_EN_VIDEO_SOURCE_CONNECTION_STATUS_CONNECTED,
   DIA_EN_VIDEO_SOURCE_CONNECTION_STATUS_DISCONNECTED,
   DIA_EN_VIDEO_SOURCE_CONNECTION_STATUS_COUNT = 3
};
class dia_IVideoManager
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VIDEOMANAGER; }
public:
   //! disconnect video source
   virtual tDiaResult disconnectVideoSource (dia_eVideoManagerDestinationID destId, dia_eVideoDestinationType destType = DIA_EN_VIDEO_DESTINATION_TYPE_FRONT_DISPLAY ) = 0;
   //! connect video source
   virtual tDiaResult connectVideoSource (dia_eVideoManagerDestinationID destId, dia_eVideoDestinationType destType = DIA_EN_VIDEO_DESTINATION_TYPE_FRONT_DISPLAY ) = 0;
   //! retrieve the video (main) list
   virtual tDiaResult getActiveVideoSource (dia_eVideoDestinationType destType = DIA_EN_VIDEO_DESTINATION_TYPE_FRONT_DISPLAY ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoManager( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_VIDEO_MANAGER__ */
