/*****************************************************************************************
*
* \file    dia_ITunerXM.h
*
* \brief   interface of dia_ITunerXM
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerXM.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERXM__
#define __INCLUDED_DIA_INTERFACE_TUNERXM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define SXM_SW_STRING_PROP_LEN 240
#define UPC_GET_VALUE 1
#define SIGNAL_STATUS_UNKNOWN ((tU8)0xFF)
#define SXM_UPC_BYTE_SIZE 6
#define CHAR_SET_SIZE 2
#define CHAR_SET_NEXT_ELEMENT 1
#define IID_TUNER_XM ((dia::IID) 0xa6b5924e)
//------------------------------------------------------------------------------
enum dia_eAntennaXMStatus
{
   DIA_EN_TUNERXM_ANTENNASTATUS_UNKNOWN = 0,
   DIA_EN_TUNERXM_ANTENNASTATUS_OK,
   DIA_EN_TUNERXM_ANTENNASTATUS_OPEN,
   DIA_EN_TUNERXM_ANTENNASTATUS_SHORT_GROUND,
   DIA_EN_TUNERXM_ANTENNASTATUS_NOT_SUPPORTED,
   DIA_EN_TUNERXM_ANTENNASTATUS_COUNT = 5
};
class dia_ITunerXM
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_XM; }
public:
   //! Function from SH to SA to read the XM channel.
   virtual tDiaResult tunerXM_1_Channel_Get ( ) = 0;
   //! Function from SH to SA to read the XM channel label.
   virtual tDiaResult tunerXM_1_ChannelLabel_Get ( ) = 0;
   //! Function from SH to SA to read the XM signal quality.
   virtual tDiaResult tunerXM_1_SignalQuality_Get ( ) = 0;
   //! Function from SH to SA to read the XM antenna 1 status.
   virtual tDiaResult tunerXM_1_Antenna1Status_Get ( ) = 0;
   //! Function from SH to SA to read the XM UPC code.
   virtual tDiaResult tunerXM_XM_UPC_Get ( ) = 0;
   //! Function from SH to SA to start the SXM software update
   virtual tDiaResult tunerXM_startSWUpdate ( ) = 0;
   //! Function from SH to SA to set DiagTestmodeEnable through SXM
   virtual tDiaResult tunerXM_DiagTestModeEnable_Set (tBool bEnable ) = 0;
   //! Function from SH to SA to read the SXM DiagTestModeData
   virtual tDiaResult tunerXM_DiagTestModeData_Get ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerXM( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNERXM__ */
