/*****************************************************************************************
*
* \file    dia_ITunerMasterControl.h
*
* \brief   interface of dia_ITunerMasterControl
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerMasterControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_MASTER_CONTROL__
#define __INCLUDED_DIA_INTERFACE_TUNER_MASTER_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_TUNER_MASTER_CONTROL ((dia::IID) 0x2335d4b6)
//------------------------------------------------------------------------------
enum dia_eTunerMasterControlPowerSupply
{
   DIA_EN_TUNERMASTERCONTROL_POWER_UNKNOWN = 0,
   DIA_EN_TUNERMASTERCONTROL_POWER_PASSIV,
   DIA_EN_TUNERMASTERCONTROL_POWER_PHANTOM,
   DIA_EN_TUNERMASTERCONTROL_POWER_EXTERNAL_PLUG,
   DIA_EN_TUNERMASTERCONTROL_POWER_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eTunerMasterControlEnableMode
{
   DIA_EN_TUNERMASTERCONTROL_MODE_UNKNOWN = 0,
   DIA_EN_TUNERMASTERCONTROL_MODE_ENABLED,
   DIA_EN_TUNERMASTERCONTROL_MODE_DISABLED,
   DIA_EN_TUNERMASTERCONTROL_MODE_COUNT = 3
};
class dia_ITunerMasterControl
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_MASTER_CONTROL; }
public:
   //! Function from SH to SA to set the power supply of the current tuner station on tuner AMFM.
   virtual tDiaResult tunerAMFM_TunerPowerSupply_Set (dia_eTunerMasterControlPowerSupply powerSupply ) = 0;
   //! Function from SH to SA to set the power supply of the current tuner station on tuner AMFM.
   virtual tDiaResult tunerAMFM_TunerAntenna2PowerSupply_Set (dia_eTunerMasterControlPowerSupply powerSupply ) = 0;
   //! Function from SH to SA to set the power supply of the current tuner station on tuner DAB.
   virtual tDiaResult tunerDAB_TunerPowerSupply_Set (dia_eTunerMasterControlEnableMode powerMode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerMasterControl( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNER_MASTER_CONTROL__ */
