/*****************************************************************************************
*
* \file    dia_ITunerMaster.h
*
* \brief   interface of dia_ITunerMaster
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerMaster.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_MASTER__
#define __INCLUDED_DIA_INTERFACE_TUNER_MASTER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_TUNER_MASTER ((dia::IID) 0x38b43ef5)
//------------------------------------------------------------------------------
enum dia_eTuner
{
   DIA_EN_TUNERMASTER_UNKNOWN = 0,
   DIA_EN_TUNERMASTER_1,
   DIA_EN_TUNERMASTER_2,
   DIA_EN_TUNERMASTER_3,
   DIA_EN_TUNERMASTER_4,
   DIA_EN_TUNERMASTER_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eTunerMasterSource
{
   DIA_EN_TUN_MSTR_SOURCE_UNKNOWN = 0,
   DIA_EN_TUN_MSTR_SOURCE_FM1,
   DIA_EN_TUN_MSTR_SOURCE_FM2,
   DIA_EN_TUN_MSTR_SOURCE_AM,
   DIA_EN_TUN_MSTR_SOURCE_DAB,
   DIA_EN_TUN_MSTR_SOURCE_FM_TA,
   DIA_EN_TUN_MSTR_SOURCE_DAB_TA,
   DIA_EN_TUN_MSTR_SOURCE_DAB_FM_SF,
   DIA_EN_TUN_MSTR_SOURCE_NON_RADIO,
   DIA_EN_TUN_MSTR_SOURCE_PTY31_FM,
   DIA_EN_TUN_MSTR_SOURCE_PTY31_DAB,
   DIA_EN_TUN_MSTR_SOURCE_DAB_OTHER_ANNO,
   DIA_EN_TUN_MSTR_SOURCE_NO_ANNO,
   DIA_EN_TUN_MSTR_SOURCE_NONE,
   DIA_EN_TUN_MSTR_SOURCE_COUNT = 14
};
//------------------------------------------------------------------------------
enum dia_eBand
{
   DIA_EN_TUNERMASTER_BAND_UNKNOWN = 0,
   DIA_EN_TUNERMASTER_BAND_AM,
   DIA_EN_TUNERMASTER_BAND_FM,
   DIA_EN_TUNERMASTER_BAND_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eAntennaStatus
{
   DIA_EN_TUNERMASTER_ANTENNASTATUS_UNKNOWN = 0,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_OK,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_ACROSS,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_BATTERY,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_SHORT_GROUND,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_OPEN_AMPLIFIER,
   DIA_EN_TUNERMASTER_ANTENNASTATUS_COUNT = 8
};
//------------------------------------------------------------------------------
enum dia_eTunerMasterNotification
{
   DIA_EN_TUNERMASTER_NOTIFICATION_UNKNOWN = 0,
   DIA_EN_TUNERMASTER_NOTIFICATION_TRAFFIC_PROGRAM_STATUS,
   DIA_EN_TUNERMASTER_NOTIFICATION_COUNT = 2
};
class dia_ITunerMaster
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_MASTER; }
public:
   //! OPCODE UPREG request
   virtual tDiaResult tunerMaster_attachNotification (dia_eTunerMasterNotification id ) = 0;
   //! OPCODE RELREG answer
   virtual tDiaResult tunerMaster_detachNotification (dia_eTunerMasterNotification id ) = 0;
   //! Function from SH to SA to select the currently active tuner.
   virtual tDiaResult tunerAMFM_ActiveTuner_Get ( ) = 0;
   //! Function from SH to SA to set a tuner to active.
   virtual tDiaResult tunerAMFM_ActiveTuner_Set (dia_eTuner setTunerToActive ) = 0;
   //! Function from SH to SA to set the tuner band (AM/FM).
   virtual tDiaResult tunerAMFM_TunerBand_Set (dia_eBand setBand ) = 0;
   //! Function from SH to SA to read the AM/FM tuner antenna status.
   virtual tDiaResult tunerAMFM_AntennaStatus_Get ( ) = 0;
   //! Function from SH to SA to reads the phantom current of AM/FM1 antenna.
   virtual tDiaResult tunerAMFM_Antenna1Current_Get ( ) = 0;
   //! Function from SH to SA to read the DAB tuner antenna status.
   virtual tDiaResult tunerDAB_AntennaStatus_Get ( ) = 0;
   //! Function from SH to SA to reads the phantom current of DAB antenna.
   virtual tDiaResult tunerDAB_Antenna1Current_Get ( ) = 0;
   //! Function from SH to SA to read the AM/FM tuner antenna2 status.
   virtual tDiaResult tunerAMFM_Antenna2Status_Get ( ) = 0;
   //! Function from SH to SA to reads the phantom current of AM/FM1 antenna.
   virtual tDiaResult tunerAMFM_Antenna2Current_Get ( ) = 0;
   /**
    * get the gnss current
    * gib2hi: TODO: move to separate interface
   */
   virtual tDiaResult getGNSSAntennaCurrent ( ) { return DIA_E_NOT_IMPLEMENTED; }
   /**
    * get the gnss status
    * gib2hi: TODO: move to separate interface
   */
   virtual tDiaResult getGNSSExtendedData ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerMaster( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNER_MASTER__ */
