/*****************************************************************************************
*
* \file    dia_ITunerDAB.h
*
* \brief   interface of dia_ITunerDAB
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerDAB.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERDAB__
#define __INCLUDED_DIA_INTERFACE_TUNERDAB__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_TUNER_DAB ((dia::IID) 0x7d6785b0)
//------------------------------------------------------------------------------
enum dia_eTunerDABNotification
{
   DIA_EN_TUNERDAB_NOTIFICATION_UNKNOWN = 0,
   DIA_EN_TUNERDAB_NOTIFICATION_TUNER_AERIAL_DAB1_STATUS,
   DIA_EN_TUNERDAB_NOTIFICATION_COUNT = 2
};
//------------------------------------------------------------------------------
enum dia_eDABSrvLinkingMode
{
   DIA_EN_TUNERDAB_SRV_LINKING_MODE_UNKNOWN = 0,
   DIA_EN_TUNERDAB_SRV_LINKING_MODE_DAB,
   DIA_EN_TUNERDAB_SRV_LINKING_MODE_FM,
   DIA_EN_TUNERDAB_SRV_LINKING_MODE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eDABAudioCodec
{
   DIA_EN_TUNERDAB_AUDIO_CODEC_UNKNOWN = 0,
   DIA_EN_TUNERDAB_AUDIO_CODEC_MPEG_AUDIO_LAYER_2,
   DIA_EN_TUNERDAB_AUDIO_CODEC_MPEG_4_HE_AAC_V2,
   DIA_EN_TUNERDAB_AUDIO_CODEC_MPEG_4_BSAC,
   DIA_EN_TUNERDAB_AUDIO_CODEC_DMB_Audio_HE_AAC_V2,
   DIA_EN_TUNERDAB_AUDIO_CODEC_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eDABProtectionLevel
{
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_UNKNOWN = 0,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_1A_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_2A_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_3A_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_4A_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_1B_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_2B_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_3B_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_4B_EEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_1_UEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_2_UEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_3_UEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_4_UEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_5_UEP,
   DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_COUNT = 14
};
struct dia_tDABString
{
public:
   //! default constructor
   dia_tDABString() :
      string(0),
      strLen(0)
   {}

   //! class constructor
   dia_tDABString(
      tString string_,
      tU16 strLen_
   ) :
      string(string_),
      strLen(strLen_)
   {}
   tString string;
   tU16 strLen;
};
struct dia_tDABTestModeData
{
public:
   //! default constructor
   dia_tDABTestModeData() :
      m_u32BERofFIC(0),
      m_u32BERofMSC(0),
      m_u32ServiceId(0),
      m_s8FieldStrength(0),
      FMQuality(0),
      serviceLinkingMode(DIA_EN_TUNERDAB_SRV_LINKING_MODE_UNKNOWN),
      extCntryCode(FALSE),
      protLevel(DIA_EN_TUNERDAB_AUDIO_PROT_LEVEL_UNKNOWN),
      transmissionMode(0)
   {}

   //! class constructor
   dia_tDABTestModeData(
      tU32 m_u32BERofFIC_,
      tU32 m_u32BERofMSC_,
      tU32 m_u32ServiceId_,
      tS8 m_s8FieldStrength_,
      tU8 FMQuality_,
      dia_eDABSrvLinkingMode serviceLinkingMode_,
      tBool extCntryCode_,
      dia_eDABProtectionLevel protLevel_,
      tU8 transmissionMode_
   ) :
      m_u32BERofFIC(m_u32BERofFIC_),
      m_u32BERofMSC(m_u32BERofMSC_),
      m_u32ServiceId(m_u32ServiceId_),
      m_s8FieldStrength(m_s8FieldStrength_),
      FMQuality(FMQuality_),
      serviceLinkingMode(serviceLinkingMode_),
      extCntryCode(extCntryCode_),
      protLevel(protLevel_),
      transmissionMode(transmissionMode_)
   {}
   tU32 m_u32BERofFIC;
   tU32 m_u32BERofMSC;
   tU32 m_u32ServiceId;
   tS8 m_s8FieldStrength;
   tU8 FMQuality;
   dia_eDABSrvLinkingMode serviceLinkingMode;
   tBool extCntryCode;
   dia_eDABProtectionLevel protLevel;
   tU8 transmissionMode;
};
struct dia_tDABBGTestModeData
{
public:
   //! default constructor
   dia_tDABBGTestModeData() :
      sync_ofdm_lock(FALSE)
   {}

   //! class constructor
   dia_tDABBGTestModeData(
      tBool sync_ofdm_lock_
   ) :
      sync_ofdm_lock(sync_ofdm_lock_)
   {}
   tBool sync_ofdm_lock;
};
struct dia_tTunerDABStatus
{
public:
   //! default constructor
   dia_tTunerDABStatus() :
      frequency(0),
      freqLabel(),
      ensembleID(0),
      componentID(0),
      DABAudQuality(0),
      DABSigQuality(0),
      signalAvailable(FALSE)
   {}

   //! class constructor
   dia_tTunerDABStatus(
      tU32 frequency_,
      dia_tDABString freqLabel_,
      tU32 ensembleID_,
      tU16 componentID_,
      tU8 DABAudQuality_,
      tU8 DABSigQuality_,
      tBool signalAvailable_
   ) :
      frequency(frequency_),
      freqLabel(freqLabel_),
      ensembleID(ensembleID_),
      componentID(componentID_),
      DABAudQuality(DABAudQuality_),
      DABSigQuality(DABSigQuality_),
      signalAvailable(signalAvailable_)
   {}
   tU32 frequency;
   dia_tDABString freqLabel;
   tU32 ensembleID;
   tU16 componentID;
   tU8 DABAudQuality;
   tU8 DABSigQuality;
   tBool signalAvailable;
};
struct dia_tTunerDABChannelInfo
{
public:
   //! default constructor
   dia_tTunerDABChannelInfo() :
      mute(FALSE),
      progSrvLabel(0),
      srvLabel()
   {}

   //! class constructor
   dia_tTunerDABChannelInfo(
      tBool mute_,
      tU32 progSrvLabel_,
      dia_tDABString srvLabel_
   ) :
      mute(mute_),
      progSrvLabel(progSrvLabel_),
      srvLabel(srvLabel_)
   {}
   tBool mute;
   tU32 progSrvLabel;
   dia_tDABString srvLabel;
};
struct dia_tTunerDABActEnsInfo
{
public:
   //! default constructor
   dia_tTunerDABActEnsInfo() :
      frequency(0),
      ensembleID(0),
      ensembleLabel()
   {}

   //! class constructor
   dia_tTunerDABActEnsInfo(
      tU32 frequency_,
      tU32 ensembleID_,
      dia_tDABString ensembleLabel_
   ) :
      frequency(frequency_),
      ensembleID(ensembleID_),
      ensembleLabel(ensembleLabel_)
   {}
   tU32 frequency;
   tU32 ensembleID;
   dia_tDABString ensembleLabel;
};
struct dia_tTunerDABActCompInfo
{
public:
   //! default constructor
   dia_tTunerDABActCompInfo() :
      serviceCompId(0),
      subChannelId(0),
      subServiceLabel()
   {}

   //! class constructor
   dia_tTunerDABActCompInfo(
      tU8 serviceCompId_,
      tU8 subChannelId_,
      dia_tDABString subServiceLabel_
   ) :
      serviceCompId(serviceCompId_),
      subChannelId(subChannelId_),
      subServiceLabel(subServiceLabel_)
   {}
   tU8 serviceCompId;
   tU8 subChannelId;
   dia_tDABString subServiceLabel;
};
struct dia_tTunerDABActSrvInfo
{
public:
   //! default constructor
   dia_tTunerDABActSrvInfo() :
      dataServiceId(0),
      dataServiceLabel(),
      audioCodec(DIA_EN_TUNERDAB_AUDIO_CODEC_UNKNOWN),
      bitRate(0),
      sampleRate(0),
      audioMode(0)
   {}

   //! class constructor
   dia_tTunerDABActSrvInfo(
      tU32 dataServiceId_,
      dia_tDABString dataServiceLabel_,
      dia_eDABAudioCodec audioCodec_,
      tU16 bitRate_,
      tU16 sampleRate_,
      tU8 audioMode_
   ) :
      dataServiceId(dataServiceId_),
      dataServiceLabel(dataServiceLabel_),
      audioCodec(audioCodec_),
      bitRate(bitRate_),
      sampleRate(sampleRate_),
      audioMode(audioMode_)
   {}
   tU32 dataServiceId;
   dia_tDABString dataServiceLabel;
   dia_eDABAudioCodec audioCodec;
   tU16 bitRate;
   tU16 sampleRate;
   tU8 audioMode;
};
class dia_ITunerDAB
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_DAB; }
public:
   //! OPCODE UPREG request
   virtual tDiaResult tunerDAB_attachNotification (dia_eTunerDABNotification id ) = 0;
   //! OPCODE RELREG answer
   virtual tDiaResult tunerDAB_detachNotification (dia_eTunerDABNotification id ) = 0;
   //! set the mode (active/inactive) of DAB testmode, while active many messages where created which could impact the overall system
   virtual tDiaResult tunerDABTestmode_Set (tBool state ) = 0;
   //! request detailed test mode data from the DAB module
   virtual tDiaResult tunerDABTestModeData_Get ( ) = 0;
   //! request detailed background test mode data from the DAB module
   virtual tDiaResult tunerDABBGTestModeData_Get ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABStatus_Get ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABChannelInfo_Get ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABActiveEnsemleInfo_Get ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABActiveComponentInfo_Get ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDABActiveServiceInfo_Get ( ) = 0;
   //! request detailed tuner status info from EnsemblyFrequency; ServiceID
   virtual tDiaResult tunerDAB_GetStatus ( ) = 0;
   //! request detailed tuner status info from the DAB module
   virtual tDiaResult tunerDAB_TestmodeData_Get ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request field strength information from the DAB module
   virtual tDiaResult tunerDAB_FieldStrength_Get ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerDAB( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_TUNERDAB__ */
